/*
 * Decompiled with CFR 0.152.
 */
package info.bliki.wiki.tags;

import info.bliki.Messages;
import info.bliki.wiki.filter.Encoder;
import info.bliki.wiki.filter.ITextConverter;
import info.bliki.wiki.filter.SectionHeader;
import info.bliki.wiki.model.ITableOfContent;
import info.bliki.wiki.model.IWikiModel;
import info.bliki.wiki.tags.HTMLTag;
import info.bliki.wiki.tags.util.IBodyTag;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class TableOfContentTag
extends HTMLTag
implements IBodyTag,
ITableOfContent {
    private List<Object> fTableOfContent = null;
    private boolean fShowToC = false;
    private boolean fIsTOCIdentifier = false;

    public TableOfContentTag(String name) {
        super(name);
    }

    @Override
    public void renderHTML(ITextConverter converter, Appendable writer, IWikiModel model) throws IOException {
        if (!model.isNoToc() && this.fShowToC && this.fTableOfContent != null && this.fTableOfContent.size() > 0) {
            String contentString = Messages.getString(model.getResourceBundle(), "wiki.tags.toc.content", "Contents");
            writer.append("<table id=\"toc\" class=\"toc\" summary=\"");
            writer.append(contentString);
            writer.append("\">\n<tr>\n<td>\n<div id=\"toctitle\">\n<h2>");
            writer.append(contentString);
            writer.append("</h2>\n</div>");
            this.renderToC(writer, this.fTableOfContent, 0);
            writer.append("</td></tr></table><hr/>\n");
        }
    }

    private void renderToC(Appendable writer, List<Object> toc, int level) throws IOException {
        writer.append("\n<ul>");
        boolean counted = false;
        boolean setLI = false;
        for (Object tocItem : toc) {
            if (tocItem instanceof SectionHeader) {
                if (setLI) {
                    setLI = false;
                    writer.append("\n</li>");
                }
                if (!counted) {
                    ++level;
                    counted = true;
                }
                SectionHeader pair = (SectionHeader)tocItem;
                String head = Encoder.encodeHtml(pair.getFirst());
                String anchor = pair.getSecond();
                writer.append("\n<li class=\"toclevel-").append(Integer.toString(level)).append("\"><a href=\"#").append(anchor).append("\">").append(head).append("</a>");
                setLI = true;
                continue;
            }
            List list = (List)tocItem;
            this.renderToC(writer, list, level);
            if (!setLI) continue;
            setLI = false;
            writer.append("\n</li>");
        }
        if (setLI) {
            writer.append("\n</li>");
        }
        writer.append("\n</ul>");
    }

    @Override
    public boolean isReduceTokenStack() {
        return false;
    }

    public boolean isShowToC() {
        return this.fShowToC;
    }

    @Override
    public void setShowToC(boolean showToC) {
        this.fShowToC = showToC;
    }

    @Override
    public Object clone() {
        TableOfContentTag tocTag = (TableOfContentTag)super.clone();
        tocTag.fShowToC = this.fShowToC;
        tocTag.fIsTOCIdentifier = this.fIsTOCIdentifier;
        tocTag.fTableOfContent = this.fTableOfContent == null ? null : new ArrayList<Object>(this.fTableOfContent);
        return tocTag;
    }

    public List<Object> getTableOfContent() {
        if (this.fTableOfContent == null) {
            this.fTableOfContent = new ArrayList<Object>();
        }
        return this.fTableOfContent;
    }

    public boolean isTOCIdentifier() {
        return this.fIsTOCIdentifier;
    }

    public void setTOCIdentifier(boolean isTOCIdentifier) {
        this.fIsTOCIdentifier = isTOCIdentifier;
    }

    @Override
    public List<SectionHeader> getSectionHeaders() {
        ArrayList<SectionHeader> resultList = new ArrayList<SectionHeader>();
        this.extractSectionHeaders(this.fTableOfContent, resultList);
        return resultList;
    }

    private void extractSectionHeaders(List<Object> toc, List<SectionHeader> resultList) {
        for (Object tocItem : toc) {
            if (tocItem instanceof SectionHeader) {
                SectionHeader header = (SectionHeader)tocItem;
                resultList.add(header);
                continue;
            }
            List list = (List)tocItem;
            this.extractSectionHeaders(list, resultList);
        }
    }
}

