/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.shared.gpx;

import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import net.osmand.shared.gpx.DataItem;
import net.osmand.shared.gpx.GpxDbHelper;
import net.osmand.shared.gpx.GpxDbUtils;
import net.osmand.shared.gpx.GpxDirItem;
import net.osmand.shared.gpx.GpxFile;
import net.osmand.shared.gpx.GpxParameter;
import net.osmand.shared.gpx.GpxSplitType;
import net.osmand.shared.gpx.GpxTrackAnalysis;
import net.osmand.shared.gpx.GradientScaleType;
import net.osmand.shared.io.KFile;
import net.osmand.shared.routing.ColoringType;
import net.osmand.shared.util.PlatformUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0007\n\u0002\u0010$\n\u0002\b\u0002\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\b\u001a\u00020\tJ\b\u0010\n\u001a\u0004\u0018\u00010\u0007J\u0010\u0010\u000b\u001a\u00020\f2\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007J\u000e\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u0000J\b\u0010\u000f\u001a\u00020\fH\u0002J\u000e\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0012J\u0016\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0015J\b\u0010\u0016\u001a\u00020\fH\u0002J$\u0010\u0017\u001a\u0004\u0018\u0001H\u0018\"\n\b\u0000\u0010\u0018\u0018\u0001*\u00020\u00192\u0006\u0010\u0014\u001a\u00020\u0015H\u0086\b\u00a2\u0006\u0002\u0010\u001aJ,\u0010\u0017\u001a\u0004\u0018\u0001H\u0018\"\n\b\u0000\u0010\u0018\u0018\u0001*\u00020\u00192\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0015H\u0086\b\u00a2\u0006\u0002\u0010\u001bJ,\u0010\u0017\u001a\u0004\u0018\u0001H\u0018\"\n\b\u0000\u0010\u0018\u0018\u0001*\u00020\u00192\u0006\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u0015H\u0086\b\u00a2\u0006\u0002\u0010\u001cJ.\u0010\u001d\u001a\u0004\u0018\u0001H\u0018\"\n\b\u0000\u0010\u0018\u0018\u0001*\u00020\u00192\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u001e\u001a\u0004\u0018\u00010\u0019H\u0086\b\u00a2\u0006\u0002\u0010\u001fJ\u0016\u0010 \u001a\u0010\u0012\u0004\u0012\u00020\u0015\u0012\u0006\u0012\u0004\u0018\u00010\u00190!H\u0016R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lnet/osmand/shared/gpx/GpxDataItem;", "Lnet/osmand/shared/gpx/DataItem;", "file", "Lnet/osmand/shared/io/KFile;", "<init>", "(Lnet/osmand/shared/io/KFile;)V", "analysis", "Lnet/osmand/shared/gpx/GpxTrackAnalysis;", "isRegularTrack", "", "getAnalysis", "setAnalysis", "", "copyData", "item", "updateAnalysisParameters", "readGpxParams", "gpxFile", "Lnet/osmand/shared/gpx/GpxFile;", "readGpxAppearanceParameter", "parameter", "Lnet/osmand/shared/gpx/GpxParameter;", "resetSplitParameters", "getAppearanceParameter", "T", "", "(Lnet/osmand/shared/gpx/GpxParameter;)Ljava/lang/Object;", "(Lnet/osmand/shared/io/KFile;Lnet/osmand/shared/gpx/GpxParameter;)Ljava/lang/Object;", "(Lnet/osmand/shared/gpx/GpxDataItem;Lnet/osmand/shared/gpx/GpxParameter;)Ljava/lang/Object;", "castGpxParameter", "value", "(Lnet/osmand/shared/gpx/GpxParameter;Ljava/lang/Object;)Ljava/lang/Object;", "getParameters", "", "Companion", "OsmAnd-shared"})
@SourceDebugExtension(value={"SMAP\nGpxDataItem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GpxDataItem.kt\nnet/osmand/shared/gpx/GpxDataItem\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,212:1\n187#1,3:213\n203#1:216\n191#1,13:217\n203#1:230\n187#1,3:231\n203#1:234\n191#1,13:235\n203#1:248\n203#1:249\n1279#2,2:250\n1293#2,4:252\n*S KotlinDebug\n*F\n+ 1 GpxDataItem.kt\nnet/osmand/shared/gpx/GpxDataItem\n*L\n171#1:213,3\n171#1:216\n171#1:217,13\n175#1:230\n181#1:231,3\n181#1:234\n181#1:235,13\n189#1:248\n196#1:249\n207#1:250,2\n207#1:252,4\n*E\n"})
public final class GpxDataItem
extends DataItem {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private GpxTrackAnalysis analysis;

    public GpxDataItem(@NotNull KFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        super(file);
    }

    public final boolean isRegularTrack() {
        return Companion.isRegularTrack(this.getFile());
    }

    @Nullable
    public final GpxTrackAnalysis getAnalysis() {
        return this.analysis;
    }

    public final void setAnalysis(@Nullable GpxTrackAnalysis analysis) {
        this.analysis = analysis;
        this.updateAnalysisParameters();
    }

    public final void copyData(@NotNull GpxDataItem item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        for (Map.Entry<GpxParameter, Object> entry : item.getMap().entrySet()) {
            GpxParameter parameter = entry.getKey();
            GpxParameter[] gpxParameterArray = new GpxParameter[]{GpxParameter.FILE_NAME, GpxParameter.FILE_DIR, GpxParameter.FILE_LAST_MODIFIED_TIME};
            if (CollectionsKt.listOf((Object[])gpxParameterArray).contains((Object)parameter)) continue;
            this.getMap().put(parameter, entry.getValue());
        }
        this.setAnalysis(item.analysis);
    }

    private final void updateAnalysisParameters() {
        boolean hasAnalysis = this.analysis != null;
        for (GpxParameter gpxParameter : GpxParameter.getEntries()) {
            Object object;
            if (!gpxParameter.getAnalysisParameter()) continue;
            Map<GpxParameter, Object> map = this.getMap();
            if (hasAnalysis) {
                GpxTrackAnalysis gpxTrackAnalysis = this.analysis;
                object = gpxTrackAnalysis != null ? gpxTrackAnalysis.getGpxParameter(gpxParameter) : null;
            } else {
                object = null;
            }
            Object object2 = object;
            map.put(gpxParameter, object2);
        }
    }

    public final void readGpxParams(@NotNull GpxFile gpxFile) {
        Intrinsics.checkNotNullParameter((Object)gpxFile, (String)"gpxFile");
        this.setParameter(GpxParameter.FILE_NAME, this.getFile().name());
        this.setParameter(GpxParameter.FILE_DIR, GpxDbUtils.INSTANCE.getGpxFileDir(this.getFile()));
        this.setParameter(GpxParameter.FILE_LAST_MODIFIED_TIME, this.getFile().lastModified());
        for (GpxParameter parameter : GpxParameter.Companion.getAppearanceParameters()) {
            this.readGpxAppearanceParameter(gpxFile, parameter);
        }
        this.setParameter(GpxParameter.FILE_CREATION_TIME, gpxFile.getMetadata().getTime());
    }

    public final void readGpxAppearanceParameter(@NotNull GpxFile gpxFile, @NotNull GpxParameter parameter) {
        Intrinsics.checkNotNullParameter((Object)gpxFile, (String)"gpxFile");
        Intrinsics.checkNotNullParameter((Object)((Object)parameter), (String)"parameter");
        switch (WhenMappings.$EnumSwitchMapping$0[parameter.ordinal()]) {
            case 1: {
                this.setParameter(GpxParameter.COLOR, gpxFile.getColor(null));
                break;
            }
            case 2: {
                this.setParameter(GpxParameter.WIDTH, gpxFile.getWidth(null));
                break;
            }
            case 3: {
                this.setParameter(GpxParameter.SHOW_ARROWS, gpxFile.isShowArrowsSet() ? Boolean.valueOf(gpxFile.isShowArrows()) : null);
                break;
            }
            case 4: {
                this.setParameter(GpxParameter.SHOW_START_FINISH, gpxFile.isShowStartFinishSet() ? Boolean.valueOf(gpxFile.isShowStartFinish()) : null);
                break;
            }
            case 5: {
                if (gpxFile.isSplitSet()) {
                    GpxSplitType splitType = GpxSplitType.Companion.getSplitTypeByName(gpxFile.getSplitType());
                    this.setParameter(GpxParameter.SPLIT_TYPE, splitType.getType());
                    break;
                }
                this.resetSplitParameters();
                break;
            }
            case 6: {
                if (gpxFile.isSplitSet()) {
                    this.setParameter(GpxParameter.SPLIT_INTERVAL, gpxFile.getSplitInterval());
                    break;
                }
                this.resetSplitParameters();
                break;
            }
            case 7: {
                ColoringType coloringType;
                CharSequence splitType = gpxFile.getColoringType();
                if (!(splitType == null || splitType.length() == 0)) {
                    this.setParameter(GpxParameter.COLORING_TYPE, gpxFile.getColoringType());
                    break;
                }
                splitType = gpxFile.getGradientScaleType();
                if (splitType == null || splitType.length() == 0) break;
                GradientScaleType scaleType = GradientScaleType.Companion.getGradientTypeByName(gpxFile.getGradientScaleType());
                ColoringType coloringType2 = coloringType = ColoringType.Companion.valueOf(scaleType);
                this.setParameter(GpxParameter.COLORING_TYPE, coloringType2 != null ? coloringType2.getName(null) : null);
                break;
            }
            case 8: {
                String string = gpxFile.getGradientColorPalette();
                boolean bl = string != null ? ((CharSequence)string).length() > 0 : false;
                if (!bl) break;
                this.setParameter(GpxParameter.COLOR_PALETTE, gpxFile.getGradientColorPalette());
                break;
            }
            case 9: {
                this.setParameter(GpxParameter.TRACK_VISUALIZATION_TYPE, gpxFile.get3DVisualizationType());
                break;
            }
            case 10: {
                this.setParameter(GpxParameter.TRACK_3D_LINE_POSITION_TYPE, gpxFile.get3DLinePositionType());
                break;
            }
            case 11: {
                this.setParameter(GpxParameter.TRACK_3D_WALL_COLORING_TYPE, gpxFile.get3DWallColoringType());
                break;
            }
            case 12: {
                this.setParameter(GpxParameter.JOIN_SEGMENTS, gpxFile.isJoinSegments());
            }
        }
    }

    private final void resetSplitParameters() {
        this.getMap().remove((Object)GpxParameter.SPLIT_TYPE);
        this.getMap().remove((Object)GpxParameter.SPLIT_INTERVAL);
    }

    public final /* synthetic */ <T> T getAppearanceParameter(GpxParameter parameter) {
        Object object;
        Object value;
        Intrinsics.checkNotNullParameter((Object)((Object)parameter), (String)"parameter");
        boolean $i$f$getAppearanceParameter = false;
        GpxDataItem this_$iv = this;
        boolean $i$f$getAppearanceParameter2 = false;
        Object value$iv = this.getParameter(parameter);
        if (value$iv != null) {
            GpxDataItem this_$iv$iv = this_$iv;
            boolean $i$f$castGpxParameter = false;
            v0 = parameter.getTypeClass().isInstance(value$iv) ? (Object)value$iv : null;
        } else {
            GpxDirItem dirItem$iv;
            KFile dir$iv = this.getFile().getParentFile();
            if (dir$iv != null && (value$iv = (dirItem$iv = GpxDbHelper.INSTANCE.getGpxDirItem(dir$iv)).getParameter(parameter)) != null) {
                GpxDataItem this_$iv$iv = this_$iv;
                boolean $i$f$castGpxParameter = false;
                v0 = parameter.getTypeClass().isInstance(value$iv) ? value$iv : null;
            } else {
                v0 = value = null;
            }
        }
        if (value == null) {
            value = parameter.getDefaultValue();
        }
        this_$iv = this;
        boolean $i$f$castGpxParameter = false;
        if (parameter.getTypeClass().isInstance(value)) {
            Intrinsics.reifiedOperationMarker((int)2, (String)"T");
            object = value;
        } else {
            object = null;
        }
        return (T)object;
    }

    public final /* synthetic */ <T> T getAppearanceParameter(KFile file, GpxParameter parameter) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)((Object)parameter), (String)"parameter");
        boolean $i$f$getAppearanceParameter = false;
        GpxDataItem item = GpxDbHelper.INSTANCE.getItem(file);
        if (item != null) {
            Object v0;
            GpxDataItem this_$iv = this;
            boolean $i$f$getAppearanceParameter2 = false;
            Object value$iv = item.getParameter(parameter);
            if (value$iv != null) {
                GpxDataItem this_$iv$iv = this_$iv;
                boolean $i$f$castGpxParameter = false;
                if (parameter.getTypeClass().isInstance(value$iv)) {
                    Intrinsics.reifiedOperationMarker((int)2, (String)"T");
                    v0 = value$iv;
                } else {
                    v0 = null;
                }
            } else {
                GpxDirItem dirItem$iv;
                KFile dir$iv = item.getFile().getParentFile();
                if (dir$iv != null && (value$iv = (dirItem$iv = GpxDbHelper.INSTANCE.getGpxDirItem(dir$iv)).getParameter(parameter)) != null) {
                    GpxDataItem this_$iv$iv = this_$iv;
                    boolean $i$f$castGpxParameter = false;
                    if (parameter.getTypeClass().isInstance(value$iv)) {
                        Intrinsics.reifiedOperationMarker((int)2, (String)"T");
                        v0 = value$iv;
                    } else {
                        v0 = null;
                    }
                } else {
                    v0 = null;
                }
            }
            return v0;
        }
        return null;
    }

    public final /* synthetic */ <T> T getAppearanceParameter(GpxDataItem item, GpxParameter parameter) {
        GpxDirItem dirItem;
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        Intrinsics.checkNotNullParameter((Object)((Object)parameter), (String)"parameter");
        boolean $i$f$getAppearanceParameter = false;
        Object value = item.getParameter(parameter);
        if (value != null) {
            T t;
            GpxDataItem this_$iv = this;
            boolean $i$f$castGpxParameter = false;
            if (parameter.getTypeClass().isInstance(value)) {
                Intrinsics.reifiedOperationMarker((int)2, (String)"T");
                t = value;
            } else {
                t = null;
            }
            return t;
        }
        KFile dir = item.getFile().getParentFile();
        if (dir != null && (value = (dirItem = GpxDbHelper.INSTANCE.getGpxDirItem(dir)).getParameter(parameter)) != null) {
            T t;
            GpxDataItem this_$iv = this;
            boolean $i$f$castGpxParameter = false;
            if (parameter.getTypeClass().isInstance(value)) {
                Intrinsics.reifiedOperationMarker((int)2, (String)"T");
                t = value;
            } else {
                t = null;
            }
            return t;
        }
        return null;
    }

    public final /* synthetic */ <T> T castGpxParameter(GpxParameter parameter, Object value) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)((Object)parameter), (String)"parameter");
        boolean $i$f$castGpxParameter = false;
        if (parameter.getTypeClass().isInstance(value)) {
            Intrinsics.reifiedOperationMarker((int)2, (String)"T");
            object = value;
        } else {
            object = null;
        }
        return (T)object;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Map<GpxParameter, Object> getParameters() {
        Iterable $this$associateWith$iv = (Iterable)GpxParameter.getEntries();
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            Object object;
            void parameter;
            GpxParameter gpxParameter = (GpxParameter)((Object)element$iv$iv);
            Object t = element$iv$iv;
            Map map = result$iv;
            boolean bl = false;
            if (parameter.getAnalysisParameter()) {
                GpxTrackAnalysis gpxTrackAnalysis = this.analysis;
                object = gpxTrackAnalysis != null ? gpxTrackAnalysis.getGpxParameter((GpxParameter)parameter) : null;
            } else {
                object = this.getParameter((GpxParameter)parameter);
            }
            Object t2 = object;
            map.put(t, t2);
        }
        return result$iv;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lnet/osmand/shared/gpx/GpxDataItem$Companion;", "", "<init>", "()V", "isRegularTrack", "", "file", "Lnet/osmand/shared/io/KFile;", "OsmAnd-shared"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isRegularTrack(@NotNull KFile file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            return StringsKt.startsWith$default((String)file.path(), (String)PlatformUtil.INSTANCE.getOsmAndContext().getGpxDir().path(), (boolean)false, (int)2, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[GpxParameter.values().length];
            try {
                nArray[GpxParameter.COLOR.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GpxParameter.WIDTH.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GpxParameter.SHOW_ARROWS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GpxParameter.SHOW_START_FINISH.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GpxParameter.SPLIT_TYPE.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GpxParameter.SPLIT_INTERVAL.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GpxParameter.COLORING_TYPE.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GpxParameter.COLOR_PALETTE.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GpxParameter.TRACK_VISUALIZATION_TYPE.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GpxParameter.TRACK_3D_LINE_POSITION_TYPE.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GpxParameter.TRACK_3D_WALL_COLORING_TYPE.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GpxParameter.JOIN_SEGMENTS.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

