/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.shared.api;

import java.sql.Blob;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.osmand.shared.api.SQLiteAPI;
import net.osmand.shared.util.Logger;
import net.osmand.shared.util.LoggerFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u0000 \f2\u00020\u0001:\u0002\f\rB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u001a\u0010\n\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u000e"}, d2={"Lnet/osmand/shared/api/SQLiteAPIImpl;", "Lnet/osmand/shared/api/SQLiteAPI;", "<init>", "()V", "getOrCreateDatabase", "Lnet/osmand/shared/api/SQLiteAPI$SQLiteConnection;", "name", "", "readOnly", "", "openByAbsolutePath", "path", "Companion", "SQLiteDatabaseWrapper", "OsmAnd-shared"})
@SourceDebugExtension(value={"SMAP\nSQLiteAPIImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SQLiteAPIImpl.kt\nnet/osmand/shared/api/SQLiteAPIImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,192:1\n1#2:193\n*E\n"})
public final class SQLiteAPIImpl
implements SQLiteAPI {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger log = LoggerFactory.INSTANCE.getLogger("SQLiteAPIImpl");

    @Override
    @Nullable
    public SQLiteAPI.SQLiteConnection getOrCreateDatabase(@NotNull String name, boolean readOnly) {
        SQLiteDatabaseWrapper sQLiteDatabaseWrapper;
        Connection db;
        Connection connection;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        String readOnlyParam = readOnly ? "?mode=ro" : "";
        try {
            connection = DriverManager.getConnection("jdbc:sqlite:" + name + readOnlyParam);
        }
        catch (RuntimeException e) {
            log.error("Failed to get or create database", e);
            connection = null;
        }
        Connection connection2 = db = connection;
        if (connection2 != null) {
            Connection it = connection2;
            boolean bl = false;
            sQLiteDatabaseWrapper = new SQLiteDatabaseWrapper(it);
        } else {
            sQLiteDatabaseWrapper = null;
        }
        return sQLiteDatabaseWrapper;
    }

    @Override
    @Nullable
    public SQLiteAPI.SQLiteConnection openByAbsolutePath(@NotNull String path, boolean readOnly) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return this.getOrCreateDatabase(path, readOnly);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lnet/osmand/shared/api/SQLiteAPIImpl$Companion;", "", "<init>", "()V", "log", "Lnet/osmand/shared/util/Logger;", "OsmAnd-shared"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u0086\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J'\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u000e\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u0013H\u0016\u00a2\u0006\u0002\u0010\u0014J\u0010\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u0011H\u0016J%\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u00112\u000e\u0010\u0017\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00180\u0013H\u0016\u00a2\u0006\u0002\u0010\u0019J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0016\u001a\u00020\u0011H\u0016J\u0010\u0010\u001c\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\u000bH\u0016J\b\u0010\u001e\u001a\u00020\u0007H\u0016J\b\u0010\u001f\u001a\u00020\u0007H\u0016J\b\u0010 \u001a\u00020\rH\u0016J\b\u0010!\u001a\u00020\rH\u0016J\b\u0010\"\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lnet/osmand/shared/api/SQLiteAPIImpl$SQLiteDatabaseWrapper;", "Lnet/osmand/shared/api/SQLiteAPI$SQLiteConnection;", "ds", "Ljava/sql/Connection;", "<init>", "(Lnet/osmand/shared/api/SQLiteAPIImpl;Ljava/sql/Connection;)V", "inTransaction", "", "shouldCommit", "previousAutoCommit", "getVersion", "", "close", "", "rawQuery", "Lnet/osmand/shared/api/SQLiteAPI$SQLiteCursor;", "sql", "", "selectionArgs", "", "(Ljava/lang/String;[Ljava/lang/String;)Lnet/osmand/shared/api/SQLiteAPI$SQLiteCursor;", "execSQL", "query", "objects", "", "(Ljava/lang/String;[Ljava/lang/Object;)V", "compileStatement", "Lnet/osmand/shared/api/SQLiteAPI$SQLiteStatement;", "setVersion", "newVersion", "isReadOnly", "isClosed", "beginTransaction", "setTransactionSuccessful", "endTransaction", "OsmAnd-shared"})
    @SourceDebugExtension(value={"SMAP\nSQLiteAPIImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SQLiteAPIImpl.kt\nnet/osmand/shared/api/SQLiteAPIImpl$SQLiteDatabaseWrapper\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,192:1\n1#2:193\n13411#3,3:194\n*S KotlinDebug\n*F\n+ 1 SQLiteAPIImpl.kt\nnet/osmand/shared/api/SQLiteAPIImpl$SQLiteDatabaseWrapper\n*L\n100#1:194,3\n*E\n"})
    public final class SQLiteDatabaseWrapper
    implements SQLiteAPI.SQLiteConnection {
        @NotNull
        private final Connection ds;
        private boolean inTransaction;
        private boolean shouldCommit;
        private boolean previousAutoCommit;

        public SQLiteDatabaseWrapper(Connection ds) {
            Intrinsics.checkNotNullParameter((Object)ds, (String)"ds");
            this.ds = ds;
            this.previousAutoCommit = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getVersion() {
            AutoCloseable autoCloseable = this.ds.createStatement();
            Throwable throwable = null;
            try {
                Statement stmt = (Statement)autoCloseable;
                boolean bl = false;
                ResultSet resultSet = stmt.executeQuery("PRAGMA user_version");
                if (resultSet.next()) {
                    int n = resultSet.getInt(1);
                    return n;
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
            return 0;
        }

        @Override
        public void close() {
            this.ds.close();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Nullable
        public SQLiteAPI.SQLiteCursor rawQuery(@NotNull String sql, @Nullable String[] selectionArgs) {
            Intrinsics.checkNotNullParameter((Object)sql, (String)"sql");
            AutoCloseable autoCloseable = this.ds.prepareStatement(sql, selectionArgs);
            Throwable throwable = null;
            try {
                SQLiteAPI.SQLiteCursor sQLiteCursor;
                PreparedStatement statement = (PreparedStatement)autoCloseable;
                boolean bl = false;
                AutoCloseable autoCloseable2 = statement.executeQuery();
                Throwable throwable2 = null;
                try {
                    ResultSet cursor = (ResultSet)autoCloseable2;
                    boolean bl2 = false;
                    sQLiteCursor = new SQLiteAPI.SQLiteCursor(cursor){
                        private String[] colNames;
                        final /* synthetic */ ResultSet $cursor;
                        {
                            this.$cursor = $cursor;
                        }

                        public final String[] getColNames() {
                            return this.colNames;
                        }

                        public final void setColNames(String[] stringArray) {
                            this.colNames = stringArray;
                        }

                        public boolean moveToNext() {
                            return this.$cursor.next();
                        }

                        public String[] getColumnNames() {
                            if (this.colNames != null) {
                                Intrinsics.checkNotNull((Object)this.colNames);
                                return this.colNames;
                            }
                            ResultSetMetaData metaData = this.$cursor.getMetaData();
                            int columnCount = metaData.getColumnCount();
                            int n = 0;
                            String[] stringArray = new String[columnCount];
                            while (n < columnCount) {
                                int n2 = n++;
                                stringArray[n2] = "";
                            }
                            String[] res = stringArray;
                            int i = 1;
                            if (i <= columnCount) {
                                while (true) {
                                    String string = metaData.getColumnName(i);
                                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getColumnName(...)");
                                    res[i - 1] = string;
                                    if (i == columnCount) break;
                                    ++i;
                                }
                            }
                            this.colNames = res;
                            return res;
                        }

                        public boolean moveToFirst() {
                            return this.$cursor.first();
                        }

                        public String getString(int ind) {
                            String string = this.$cursor.getString(ind);
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
                            return string;
                        }

                        public void close() {
                            this.$cursor.close();
                        }

                        public boolean isNull(int ind) {
                            this.$cursor.getObject(ind);
                            return this.$cursor.wasNull();
                        }

                        public int getColumnIndex(String columnName) {
                            Intrinsics.checkNotNullParameter((Object)columnName, (String)"columnName");
                            Object[] names = this.getColumnNames();
                            return ArraysKt.indexOf((Object[])names, (Object)columnName);
                        }

                        public double getDouble(int ind) {
                            return this.$cursor.getDouble(ind);
                        }

                        public long getLong(int ind) {
                            return this.$cursor.getLong(ind);
                        }

                        public int getInt(int ind) {
                            return this.$cursor.getInt(ind);
                        }

                        public byte[] getBlob(int ind) {
                            Blob blob = this.$cursor.getBlob(ind);
                            byte[] res = blob.getBytes(1L, (int)blob.length());
                            blob.free();
                            Intrinsics.checkNotNull((Object)res);
                            return res;
                        }
                    };
                }
                catch (Throwable throwable3) {
                    try {
                        try {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        catch (Throwable throwable4) {
                            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable2, throwable2);
                            throw throwable4;
                        }
                    }
                    catch (Throwable throwable5) {
                        throwable = throwable5;
                        throw throwable5;
                    }
                }
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable2, (Throwable)throwable2);
                SQLiteAPI.SQLiteCursor sQLiteCursor2 = sQLiteCursor;
                return sQLiteCursor2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void execSQL(@NotNull String query) {
            Intrinsics.checkNotNullParameter((Object)query, (String)"query");
            AutoCloseable autoCloseable = this.ds.createStatement();
            Throwable throwable = null;
            try {
                Statement stmt = (Statement)autoCloseable;
                boolean bl = false;
                ResultSet resultSet = stmt.executeQuery(query);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        public void execSQL(@NotNull String query, @NotNull Object[] objects) {
            Intrinsics.checkNotNullParameter((Object)query, (String)"query");
            Intrinsics.checkNotNullParameter((Object)objects, (String)"objects");
            AutoCloseable autoCloseable = this.ds.prepareStatement(query);
            Throwable throwable = null;
            try {
                PreparedStatement stmt = (PreparedStatement)autoCloseable;
                boolean bl = false;
                Object[] $this$forEachIndexed$iv = objects;
                boolean $i$f$forEachIndexed = false;
                int index$iv = 0;
                for (Object item$iv : $this$forEachIndexed$iv) {
                    void obj;
                    int n = index$iv++;
                    Object object = item$iv;
                    int index = n;
                    boolean bl2 = false;
                    stmt.setObject(index + 1, obj);
                }
                int n = stmt.executeUpdate();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        public SQLiteAPI.SQLiteStatement compileStatement(@NotNull String query) {
            Intrinsics.checkNotNullParameter((Object)query, (String)"query");
            AutoCloseable autoCloseable = this.ds.prepareStatement(query);
            Throwable throwable = null;
            try {
                PreparedStatement stmt = (PreparedStatement)autoCloseable;
                boolean bl = false;
                SQLiteAPI.SQLiteStatement sQLiteStatement = new SQLiteAPI.SQLiteStatement(stmt){
                    final /* synthetic */ PreparedStatement $stmt;
                    {
                        this.$stmt = $stmt;
                    }

                    public void execute() {
                        this.$stmt.execute();
                    }

                    public void close() {
                        this.$stmt.close();
                    }

                    public void bindString(int i, String value) {
                        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                        this.$stmt.setString(i, value);
                    }

                    public void bindNull(int i) {
                        this.$stmt.setNull(i, 0);
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public long simpleQueryForLong() {
                        AutoCloseable autoCloseable = this.$stmt.executeQuery();
                        Throwable throwable = null;
                        try {
                            ResultSet resultSet = (ResultSet)autoCloseable;
                            boolean bl = false;
                            if (!resultSet.next()) {
                                throw new SQLException("Query did not return any result");
                            }
                            long l = resultSet.getLong(1);
                            return l;
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public String simpleQueryForString() {
                        AutoCloseable autoCloseable = this.$stmt.executeQuery();
                        Throwable throwable = null;
                        try {
                            ResultSet resultSet = (ResultSet)autoCloseable;
                            boolean bl = false;
                            if (!resultSet.next()) {
                                throw new SQLException("Query did not return any result");
                            }
                            String string = resultSet.getString(1);
                            Intrinsics.checkNotNull((Object)string);
                            String string2 = string;
                            return string2;
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                        }
                    }

                    public void bindLong(int i, long value) {
                        this.$stmt.setLong(i, value);
                    }

                    public void bindBlob(int i, byte[] value) {
                        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                        this.$stmt.setBytes(i, value);
                    }

                    public void bindDouble(int i, double value) {
                        this.$stmt.setDouble(i, value);
                    }
                };
                return sQLiteStatement;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setVersion(int newVersion) {
            AutoCloseable autoCloseable = this.ds.createStatement();
            Throwable throwable = null;
            try {
                Statement it = (Statement)autoCloseable;
                boolean bl = false;
                boolean bl2 = it.execute("PRAGMA user_version = " + newVersion);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
        }

        @Override
        public boolean isReadOnly() {
            return this.ds.isReadOnly();
        }

        @Override
        public boolean isClosed() {
            return this.ds.isClosed();
        }

        @Override
        public void beginTransaction() {
            if (this.inTransaction) {
                throw new IllegalStateException("Nested transactions are not supported");
            }
            this.previousAutoCommit = this.ds.getAutoCommit();
            this.ds.setAutoCommit(false);
            this.inTransaction = true;
            this.shouldCommit = false;
        }

        @Override
        public void setTransactionSuccessful() {
            if (!this.inTransaction) {
                throw new IllegalStateException("Not in transaction");
            }
            this.shouldCommit = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void endTransaction() {
            Object object;
            Object object2;
            if (!this.inTransaction) {
                return;
            }
            try {
                if (this.shouldCommit) {
                    this.ds.commit();
                } else {
                    this.ds.rollback();
                }
                this.shouldCommit = false;
                this.inTransaction = false;
                object2 = this;
            }
            catch (SQLException e) {
                try {
                    log.error("Transaction failed (commit=" + this.shouldCommit + ")", e);
                    SQLiteDatabaseWrapper sQLiteDatabaseWrapper = this;
                    try {
                        Object $this$endTransaction_u24lambda_u248 = sQLiteDatabaseWrapper;
                        boolean bl2 = false;
                        ((SQLiteDatabaseWrapper)$this$endTransaction_u24lambda_u248).ds.rollback();
                        $this$endTransaction_u24lambda_u248 = Result.constructor-impl((Object)Unit.INSTANCE);
                        throw e;
                    }
                    catch (Throwable bl2) {
                        Object $this$endTransaction_u24lambda_u248 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl2));
                    }
                    throw e;
                }
                catch (Throwable throwable2) {
                    Object object3;
                    this.shouldCommit = false;
                    this.inTransaction = false;
                    Object object4 = this;
                    try {
                        SQLiteDatabaseWrapper $this$endTransaction_u24lambda_u249 = object4;
                        boolean bl3 = false;
                        $this$endTransaction_u24lambda_u249.ds.setAutoCommit($this$endTransaction_u24lambda_u249.previousAutoCommit);
                        object3 = Result.constructor-impl((Object)Unit.INSTANCE);
                    }
                    catch (Throwable bl3) {
                        object3 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl3));
                    }
                    object4 = object3;
                    Throwable throwable = Result.exceptionOrNull-impl((Object)object4);
                    if (throwable == null) throw throwable2;
                    Object it2 = object3 = throwable;
                    boolean bl4 = false;
                    log.error("Failed to restore autoCommit", (Throwable)it2);
                    throw throwable2;
                }
            }
            try {
                SQLiteDatabaseWrapper $this$endTransaction_u24lambda_u249 = object2;
                boolean bl = false;
                $this$endTransaction_u24lambda_u249.ds.setAutoCommit($this$endTransaction_u24lambda_u249.previousAutoCommit);
                object = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable bl) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object2 = object;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
            if (throwable == null) return;
            Object it = object = throwable;
            boolean bl = false;
            log.error("Failed to restore autoCommit", (Throwable)it);
        }
    }
}

