/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.shared.gpx.organization;

import co.touchlab.stately.collections.ConcurrentMutableMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.osmand.shared.data.Limits;
import net.osmand.shared.gpx.RouteActivityHelper;
import net.osmand.shared.gpx.organization.enums.OrganizeByCategory;
import net.osmand.shared.gpx.organization.enums.OrganizeByType;
import net.osmand.shared.gpx.primitives.RouteActivity;
import net.osmand.shared.units.MeasurementUnit;
import net.osmand.shared.util.DateFormatter;
import net.osmand.shared.util.KAlgorithms;
import net.osmand.shared.util.Localization;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0001J\u0016\u0010\f\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0001J\u0006\u0010\r\u001a\u00020\u000eJ\u0018\u0010\u000f\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0001H\u0002J\u0018\u0010\u0010\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0001H\u0002J\u0018\u0010\u0011\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0001H\u0002J\u0018\u0010\u0012\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0001H\u0002J\u0018\u0010\u0013\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0001H\u0002R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lnet/osmand/shared/gpx/organization/OrganizeTracksResourceMapper;", "", "<init>", "()V", "nameCache", "Lco/touchlab/stately/collections/ConcurrentMutableMap;", "", "iconNameCache", "getName", "type", "Lnet/osmand/shared/gpx/organization/enums/OrganizeByType;", "value", "getIconName", "clearCache", "", "buildNameKey", "buildIconKey", "buildFullKey", "resolveName", "resolveIconName", "OsmAnd-shared"})
@SourceDebugExtension(value={"SMAP\nOrganizeTracksResourceMapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OrganizeTracksResourceMapper.kt\nnet/osmand/shared/gpx/organization/OrganizeTracksResourceMapper\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,92:1\n381#2,7:93\n381#2,7:100\n*S KotlinDebug\n*F\n+ 1 OrganizeTracksResourceMapper.kt\nnet/osmand/shared/gpx/organization/OrganizeTracksResourceMapper\n*L\n19#1:93,7\n24#1:100,7\n*E\n"})
public final class OrganizeTracksResourceMapper {
    @NotNull
    public static final OrganizeTracksResourceMapper INSTANCE = new OrganizeTracksResourceMapper();
    @NotNull
    private static final ConcurrentMutableMap<String, String> nameCache = new ConcurrentMutableMap();
    @NotNull
    private static final ConcurrentMutableMap<String, String> iconNameCache = new ConcurrentMutableMap();

    private OrganizeTracksResourceMapper() {
    }

    @NotNull
    public final String getName(@NotNull OrganizeByType type, @NotNull Object value) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        String key = this.buildNameKey(type, value);
        Map $this$getOrPut$iv = (Map)nameCache;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key);
        if (value$iv == null) {
            boolean bl = false;
            String answer$iv = INSTANCE.resolveName(type, value);
            $this$getOrPut$iv.put(key, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (String)object;
    }

    @NotNull
    public final String getIconName(@NotNull OrganizeByType type, @NotNull Object value) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        String key = this.buildIconKey(type, value);
        Map $this$getOrPut$iv = (Map)iconNameCache;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key);
        if (value$iv == null) {
            boolean bl = false;
            String answer$iv = INSTANCE.resolveIconName(type, value);
            $this$getOrPut$iv.put(key, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (String)object;
    }

    public final void clearCache() {
        nameCache.clear();
        iconNameCache.clear();
    }

    private final String buildNameKey(OrganizeByType type, Object value) {
        return this.buildFullKey(type, value);
    }

    private final String buildIconKey(OrganizeByType type, Object value) {
        if (type == OrganizeByType.ACTIVITY) {
            return this.buildFullKey(type, value);
        }
        return type.name();
    }

    private final String buildFullKey(OrganizeByType type, Object value) {
        return type.name() + "__" + value;
    }

    private final String resolveName(OrganizeByType type, Object value) {
        if (value instanceof Limits) {
            MeasurementUnit<?> displayUnits = type.getDisplayUnits();
            double min = ((Limits)value).getMin().doubleValue();
            double max = ((Limits)value).getMax().doubleValue();
            int from = (int)displayUnits.fromBase(min);
            int to = (int)displayUnits.fromBase(max);
            Object[] objectArray = new Object[]{String.valueOf(from), String.valueOf(to)};
            String formattedRange = Localization.INSTANCE.getString("ltr_or_rtl_combine_via_dash", objectArray);
            objectArray = new Object[]{formattedRange, displayUnits.getSymbol()};
            return Localization.INSTANCE.getString("ltr_or_rtl_combine_via_space", objectArray);
        }
        if (type.getCategory() == OrganizeByCategory.DATE_TIME) {
            String string;
            long date;
            Number number = value instanceof Number ? (Number)((Number)value) : (Number)null;
            long l = date = number != null ? number.longValue() : 0L;
            if (date == 0L) {
                string = Localization.INSTANCE.getString("no_date");
            } else {
                switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
                    case 1: {
                        string = DateFormatter.INSTANCE.formatYear(date);
                        break;
                    }
                    case 2: {
                        string = DateFormatter.INSTANCE.formatMonthAndYear(date);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown OrganizeByType " + type + " of category " + type.getCategory());
                    }
                }
            }
            return string;
        }
        if (type == OrganizeByType.ACTIVITY && value instanceof String) {
            RouteActivity activity = RouteActivityHelper.INSTANCE.findRouteActivity((String)value);
            Object object = activity;
            if (object == null || (object = ((RouteActivity)object).getLabel()) == null) {
                object = Localization.INSTANCE.getString("shared_string_none");
            }
            return object;
        }
        if (KAlgorithms.INSTANCE.isEmpty(value.toString())) {
            return Localization.INSTANCE.getString("shared_string_none");
        }
        return value.toString();
    }

    private final String resolveIconName(OrganizeByType type, Object value) {
        if (value instanceof String && type == OrganizeByType.ACTIVITY) {
            RouteActivity activity = RouteActivityHelper.INSTANCE.findRouteActivity((String)value);
            Object object = activity;
            if (object == null || (object = ((RouteActivity)object).getIconName()) == null) {
                object = "ic_action_activity";
            }
            return object;
        }
        return type.getIconResId();
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[OrganizeByType.values().length];
            try {
                nArray[OrganizeByType.YEAR_OF_CREATION.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OrganizeByType.MONTH_AND_YEAR.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

