/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.triangulate;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.LineSegment;
import com.vividsolutions.jts.triangulate.ConstraintSplitPointFinder;
import com.vividsolutions.jts.triangulate.Segment;
import com.vividsolutions.jts.triangulate.SplitSegment;

public class NonEncroachingSplitPointFinder
implements ConstraintSplitPointFinder {
    public Coordinate findSplitPoint(Segment seg, Coordinate encroachPt) {
        LineSegment lineSeg = seg.getLineSegment();
        double segLen = lineSeg.getLength();
        double midPtLen = segLen / 2.0;
        SplitSegment splitSeg = new SplitSegment(lineSeg);
        Coordinate projPt = NonEncroachingSplitPointFinder.projectedSplitPoint(seg, encroachPt);
        double nonEncroachDiam = projPt.distance(encroachPt) * 2.0 * 0.8;
        double maxSplitLen = nonEncroachDiam;
        if (maxSplitLen > midPtLen) {
            maxSplitLen = midPtLen;
        }
        splitSeg.setMinimumLength(maxSplitLen);
        splitSeg.splitAt(projPt);
        return splitSeg.getSplitPoint();
    }

    public static Coordinate projectedSplitPoint(Segment seg, Coordinate encroachPt) {
        LineSegment lineSeg = seg.getLineSegment();
        Coordinate projPt = lineSeg.project(encroachPt);
        return projPt;
    }
}

