/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import org.luaj.vm2.Globals;
import org.luaj.vm2.Print;
import org.luaj.vm2.Prototype;
import org.luaj.vm2.compiler.DumpState;
import org.luaj.vm2.lib.jse.JsePlatform;

public class luac {
    private static final String version = "Luaj-jse 3.0.1Copyright (C) 2009 luaj.org";
    private static final String usage = "usage: java -cp luaj-jse.jar luac [options] [filenames].\nAvailable options are:\n  -        process stdin\n  -l       list\n  -o name  output to file 'name' (default is \"luac.out\")\n  -p       parse only\n  -s       strip debug information\n  -e       little endian format for numbers\n  -i<n>    number format 'n', (n=0,1 or 4, default=0)\n  -v       show version information\n  -c enc  \tuse the supplied encoding 'enc' for input files\n  --       stop handling options\n";
    private boolean list = false;
    private String output = "luac.out";
    private boolean parseonly = false;
    private boolean stripdebug = false;
    private boolean littleendian = false;
    private int numberformat = 0;
    private boolean versioninfo = false;
    private boolean processing = true;
    private String encoding = null;

    private static void usageExit() {
        System.out.println(usage);
        System.exit(-1);
    }

    public static void main(String[] stringArray) throws IOException {
        new luac(stringArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private luac(String[] stringArray) throws IOException {
        try {
            block20: for (int i = 0; i < stringArray.length; ++i) {
                if (!this.processing || !stringArray[i].startsWith("-") || stringArray[i].length() <= 1) continue;
                switch (stringArray[i].charAt(1)) {
                    case 'l': {
                        this.list = true;
                        continue block20;
                    }
                    case 'o': {
                        if (++i >= stringArray.length) {
                            luac.usageExit();
                        }
                        this.output = stringArray[i];
                        continue block20;
                    }
                    case 'p': {
                        this.parseonly = true;
                        continue block20;
                    }
                    case 's': {
                        this.stripdebug = true;
                        continue block20;
                    }
                    case 'e': {
                        this.littleendian = true;
                        continue block20;
                    }
                    case 'i': {
                        if (stringArray[i].length() <= 2) {
                            luac.usageExit();
                        }
                        this.numberformat = Integer.parseInt(stringArray[i].substring(2));
                        continue block20;
                    }
                    case 'v': {
                        this.versioninfo = true;
                        continue block20;
                    }
                    case 'c': {
                        if (++i >= stringArray.length) {
                            luac.usageExit();
                        }
                        this.encoding = stringArray[i];
                        continue block20;
                    }
                    case '-': {
                        if (stringArray[i].length() > 2) {
                            luac.usageExit();
                        }
                        this.processing = false;
                        continue block20;
                    }
                    default: {
                        luac.usageExit();
                    }
                }
            }
            if (this.versioninfo) {
                System.out.println(version);
            }
            FileOutputStream fileOutputStream = new FileOutputStream(this.output);
            try {
                Globals globals = JsePlatform.standardGlobals();
                this.processing = true;
                block21: for (int i = 0; i < stringArray.length; ++i) {
                    if (!this.processing || !stringArray[i].startsWith("-")) {
                        String string = stringArray[i].substring(0, stringArray[i].length() - 4);
                        this.processScript(globals, new FileInputStream(stringArray[i]), string, fileOutputStream);
                        continue;
                    }
                    if (stringArray[i].length() <= 1) {
                        this.processScript(globals, System.in, "=stdin", fileOutputStream);
                        continue;
                    }
                    switch (stringArray[i].charAt(1)) {
                        case 'c': 
                        case 'o': {
                            ++i;
                            continue block21;
                        }
                        case '-': {
                            this.processing = false;
                        }
                    }
                }
            }
            finally {
                ((OutputStream)fileOutputStream).close();
            }
        }
        catch (IOException iOException) {
            System.err.println(iOException.toString());
            System.exit(-2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processScript(Globals globals, InputStream inputStream, String string, OutputStream outputStream) throws IOException {
        try {
            Prototype prototype;
            inputStream = new BufferedInputStream(inputStream);
            Prototype prototype2 = prototype = this.encoding != null ? globals.compilePrototype(new InputStreamReader(inputStream, this.encoding), string) : globals.compilePrototype(inputStream, string);
            if (this.list) {
                Print.printCode(prototype);
            }
            if (!this.parseonly) {
                DumpState.dump(prototype, outputStream, this.stripdebug, this.numberformat, this.littleendian);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
        finally {
            inputStream.close();
        }
    }
}

