/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.newt.opengl;

import com.jogamp.common.GlueGenVersion;
import com.jogamp.common.util.VersionUtil;
import com.jogamp.common.util.locks.RecursiveLock;
import com.jogamp.nativewindow.AbstractGraphicsConfiguration;
import com.jogamp.nativewindow.CapabilitiesChooser;
import com.jogamp.nativewindow.CapabilitiesImmutable;
import com.jogamp.nativewindow.NativeSurface;
import com.jogamp.nativewindow.NativeWindow;
import com.jogamp.nativewindow.NativeWindowException;
import com.jogamp.nativewindow.SurfaceUpdatedListener;
import com.jogamp.nativewindow.WindowClosingProtocol;
import com.jogamp.nativewindow.util.InsetsImmutable;
import com.jogamp.nativewindow.util.Point;
import com.jogamp.nativewindow.util.Rectangle;
import com.jogamp.newt.Display;
import com.jogamp.newt.MonitorDevice;
import com.jogamp.newt.NewtFactory;
import com.jogamp.newt.Screen;
import com.jogamp.newt.Window;
import com.jogamp.newt.event.GestureHandler;
import com.jogamp.newt.event.KeyListener;
import com.jogamp.newt.event.MouseListener;
import com.jogamp.newt.event.NEWTEvent;
import com.jogamp.newt.event.NEWTEventConsumer;
import com.jogamp.newt.event.WindowAdapter;
import com.jogamp.newt.event.WindowEvent;
import com.jogamp.newt.event.WindowListener;
import com.jogamp.newt.event.WindowUpdateEvent;
import com.jogamp.opengl.FPSCounter;
import com.jogamp.opengl.GL;
import com.jogamp.opengl.GL2ES2;
import com.jogamp.opengl.GLAnimatorControl;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLContext;
import com.jogamp.opengl.GLDrawableFactory;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.JoglVersion;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.List;
import jogamp.newt.WindowImpl;
import jogamp.opengl.GLAutoDrawableBase;
import jogamp.opengl.GLContextImpl;
import jogamp.opengl.GLDrawableImpl;

public class GLWindow
extends GLAutoDrawableBase
implements GLAutoDrawable,
Window,
NEWTEventConsumer,
FPSCounter {
    private final WindowImpl window;
    private GLDrawableFactory factory;

    protected GLWindow(Window window) {
        super(null, null, false);
        this.window = (WindowImpl)window;
        this.window.setWindowDestroyNotifyAction(new Runnable(){

            @Override
            public void run() {
                GLWindow.this.defaultWindowDestroyNotifyOp();
            }
        });
        window.addWindowListener(new WindowAdapter(){

            @Override
            public void windowRepaint(WindowUpdateEvent windowUpdateEvent) {
                GLWindow.this.defaultWindowRepaintOp();
            }

            @Override
            public void windowResized(WindowEvent windowEvent) {
                GLWindow.this.defaultWindowResizedOp(GLWindow.this.getSurfaceWidth(), GLWindow.this.getSurfaceHeight());
            }
        });
        this.window.setLifecycleHook(new GLLifecycleHook());
    }

    @Override
    public final Object getUpstreamWidget() {
        return this.window;
    }

    @Override
    public final RecursiveLock getUpstreamLock() {
        return this.window.getLock();
    }

    public static GLWindow create(GLCapabilitiesImmutable gLCapabilitiesImmutable) {
        return new GLWindow(NewtFactory.createWindow(gLCapabilitiesImmutable));
    }

    public static GLWindow create(Screen screen, GLCapabilitiesImmutable gLCapabilitiesImmutable) {
        return new GLWindow(NewtFactory.createWindow(screen, (CapabilitiesImmutable)gLCapabilitiesImmutable));
    }

    public static GLWindow create(Window window) {
        return new GLWindow(window);
    }

    public static GLWindow create(NativeWindow nativeWindow, GLCapabilitiesImmutable gLCapabilitiesImmutable) {
        return new GLWindow(NewtFactory.createWindow(nativeWindow, (CapabilitiesImmutable)gLCapabilitiesImmutable));
    }

    @Override
    public WindowClosingProtocol.WindowClosingMode getDefaultCloseOperation() {
        return this.window.getDefaultCloseOperation();
    }

    @Override
    public WindowClosingProtocol.WindowClosingMode setDefaultCloseOperation(WindowClosingProtocol.WindowClosingMode windowClosingMode) {
        return this.window.setDefaultCloseOperation(windowClosingMode);
    }

    @Override
    public CapabilitiesChooser setCapabilitiesChooser(CapabilitiesChooser capabilitiesChooser) {
        return this.window.setCapabilitiesChooser(capabilitiesChooser);
    }

    @Override
    public final CapabilitiesImmutable getChosenCapabilities() {
        GLDrawableImpl gLDrawableImpl = this.drawable;
        return null != gLDrawableImpl ? gLDrawableImpl.getChosenGLCapabilities() : this.window.getChosenCapabilities();
    }

    @Override
    public final CapabilitiesImmutable getRequestedCapabilities() {
        return this.window.getRequestedCapabilities();
    }

    @Override
    public final Window getDelegatedWindow() {
        return this.window.getDelegatedWindow();
    }

    @Override
    public final NativeWindow getParent() {
        return this.window.getParent();
    }

    @Override
    public final Screen getScreen() {
        return this.window.getScreen();
    }

    @Override
    public final MonitorDevice getMainMonitor() {
        return this.window.getMainMonitor();
    }

    @Override
    public final void setTitle(String string) {
        this.window.setTitle(string);
    }

    @Override
    public final String getTitle() {
        return this.window.getTitle();
    }

    @Override
    public final boolean isPointerVisible() {
        return this.window.isPointerVisible();
    }

    @Override
    public final void setPointerVisible(boolean bl) {
        this.window.setPointerVisible(bl);
    }

    @Override
    public final Display.PointerIcon getPointerIcon() {
        return this.window.getPointerIcon();
    }

    @Override
    public final void setPointerIcon(Display.PointerIcon pointerIcon) {
        this.window.setPointerIcon(pointerIcon);
    }

    @Override
    public final boolean isPointerConfined() {
        return this.window.isPointerConfined();
    }

    @Override
    public final void confinePointer(boolean bl) {
        this.window.confinePointer(bl);
    }

    @Override
    public final void setUndecorated(boolean bl) {
        this.window.setUndecorated(bl);
    }

    @Override
    public final void warpPointer(int n, int n2) {
        this.window.warpPointer(n, n2);
    }

    @Override
    public final boolean isUndecorated() {
        return this.window.isUndecorated();
    }

    @Override
    public final void setAlwaysOnTop(boolean bl) {
        this.window.setAlwaysOnTop(bl);
    }

    @Override
    public final boolean isAlwaysOnTop() {
        return this.window.isAlwaysOnTop();
    }

    @Override
    public final void setFocusAction(Window.FocusRunnable focusRunnable) {
        this.window.setFocusAction(focusRunnable);
    }

    @Override
    public void setKeyboardFocusHandler(KeyListener keyListener) {
        this.window.setKeyboardFocusHandler(keyListener);
    }

    @Override
    public final void requestFocus() {
        this.window.requestFocus();
    }

    @Override
    public final void requestFocus(boolean bl) {
        this.window.requestFocus(bl);
    }

    @Override
    public boolean hasFocus() {
        return this.window.hasFocus();
    }

    @Override
    public final InsetsImmutable getInsets() {
        return this.window.getInsets();
    }

    @Override
    public final int getX() {
        return this.window.getX();
    }

    @Override
    public final int getY() {
        return this.window.getY();
    }

    @Override
    public final int getWidth() {
        return this.window.getWidth();
    }

    @Override
    public final int getHeight() {
        return this.window.getHeight();
    }

    @Override
    public final Rectangle getBounds() {
        return this.window.getBounds();
    }

    @Override
    public final int getSurfaceWidth() {
        return this.window.getSurfaceWidth();
    }

    @Override
    public final int getSurfaceHeight() {
        return this.window.getSurfaceHeight();
    }

    @Override
    public final int[] convertToWindowUnits(int[] nArray) {
        return this.window.convertToWindowUnits(nArray);
    }

    @Override
    public final int[] convertToPixelUnits(int[] nArray) {
        return this.window.convertToPixelUnits(nArray);
    }

    @Override
    public final boolean setSurfaceScale(float[] fArray) {
        return this.window.setSurfaceScale(fArray);
    }

    @Override
    public final float[] getRequestedSurfaceScale(float[] fArray) {
        return this.window.getRequestedSurfaceScale(fArray);
    }

    @Override
    public final float[] getCurrentSurfaceScale(float[] fArray) {
        return this.window.getCurrentSurfaceScale(fArray);
    }

    @Override
    public final float[] getMinimumSurfaceScale(float[] fArray) {
        return this.window.getMinimumSurfaceScale(fArray);
    }

    @Override
    public final float[] getMaximumSurfaceScale(float[] fArray) {
        return this.window.getMaximumSurfaceScale(fArray);
    }

    @Override
    public final float[] getPixelsPerMM(float[] fArray) {
        return this.window.getPixelsPerMM(fArray);
    }

    @Override
    public final void setPosition(int n, int n2) {
        this.window.setPosition(n, n2);
    }

    @Override
    public void setTopLevelPosition(int n, int n2) {
        this.window.setTopLevelPosition(n, n2);
    }

    @Override
    public final boolean setFullscreen(boolean bl) {
        return this.window.setFullscreen(bl);
    }

    @Override
    public boolean setFullscreen(List<MonitorDevice> list) {
        return this.window.setFullscreen(list);
    }

    @Override
    public final boolean isFullscreen() {
        return this.window.isFullscreen();
    }

    @Override
    public final boolean isVisible() {
        return this.window.isVisible();
    }

    @Override
    public final String toString() {
        return "NEWT-GLWindow[ \n\tHelper: " + this.helper + ", \n\tDrawable: " + this.drawable + ", \n\tContext: " + this.context + ", \n\tWindow: " + this.window + "]";
    }

    @Override
    public final Window.ReparentOperation reparentWindow(NativeWindow nativeWindow, int n, int n2, int n3) {
        return this.window.reparentWindow(nativeWindow, n, n2, n3);
    }

    @Override
    public final boolean removeChild(NativeWindow nativeWindow) {
        return this.window.removeChild(nativeWindow);
    }

    @Override
    public final boolean addChild(NativeWindow nativeWindow) {
        return this.window.addChild(nativeWindow);
    }

    @Override
    public final void destroy() {
        this.window.destroy();
    }

    @Override
    public void setWindowDestroyNotifyAction(Runnable runnable) {
        this.window.setWindowDestroyNotifyAction(runnable);
    }

    @Override
    public final void setVisible(boolean bl) {
        this.window.setVisible(bl);
    }

    @Override
    public void setVisible(boolean bl, boolean bl2) {
        this.window.setVisible(bl, bl2);
    }

    @Override
    public final void setSize(int n, int n2) {
        this.window.setSize(n, n2);
    }

    @Override
    public final void setSurfaceSize(int n, int n2) {
        this.window.setSurfaceSize(n, n2);
    }

    @Override
    public void setTopLevelSize(int n, int n2) {
        this.window.setTopLevelSize(n, n2);
    }

    @Override
    public final boolean isNativeValid() {
        return this.window.isNativeValid();
    }

    @Override
    public Point getLocationOnScreen(Point point) {
        return this.window.getLocationOnScreen(point);
    }

    @Override
    public void display() {
        boolean bl;
        if (!this.isNativeValid() || !this.isVisible()) {
            return;
        }
        if (this.sendDestroy || this.window.hasDeviceChanged() && GLAutoDrawable.SCREEN_CHANGE_ACTION_ENABLED) {
            this.sendDestroy = false;
            this.destroy();
            return;
        }
        RecursiveLock recursiveLock = this.window.getLock();
        recursiveLock.lock();
        try {
            if (null != this.context) {
                this.helper.invokeGL(this.drawable, this.context, this.defaultDisplayAction, this.defaultInitAction);
                bl = true;
            } else {
                bl = false;
            }
        }
        finally {
            recursiveLock.unlock();
        }
        if (!bl && 0 < this.getSurfaceWidth() && 0 < this.getSurfaceHeight()) {
            this.setVisible(true);
        }
    }

    @Override
    public final boolean isGLStatePreservationSupported() {
        return true;
    }

    @Override
    public final GLDrawableFactory getFactory() {
        return this.factory;
    }

    @Override
    public final void swapBuffers() throws GLException {
        this.defaultSwapBuffers();
    }

    @Override
    public boolean consumeEvent(NEWTEvent nEWTEvent) {
        return this.window.consumeEvent(nEWTEvent);
    }

    @Override
    public final void windowRepaint(int n, int n2, int n3, int n4) {
        this.window.windowRepaint(n, n2, n3, n4);
    }

    @Override
    public final void enqueueEvent(boolean bl, NEWTEvent nEWTEvent) {
        this.window.enqueueEvent(bl, nEWTEvent);
    }

    @Override
    public final void runOnEDTIfAvail(boolean bl, Runnable runnable) {
        this.window.runOnEDTIfAvail(bl, runnable);
    }

    @Override
    public void sendWindowEvent(int n) {
        this.window.sendWindowEvent(n);
    }

    @Override
    public final WindowListener getWindowListener(int n) {
        return this.window.getWindowListener(n);
    }

    @Override
    public final WindowListener[] getWindowListeners() {
        return this.window.getWindowListeners();
    }

    @Override
    public final void removeWindowListener(WindowListener windowListener) {
        this.window.removeWindowListener(windowListener);
    }

    @Override
    public final void addWindowListener(WindowListener windowListener) {
        this.window.addWindowListener(windowListener);
    }

    @Override
    public final void addWindowListener(int n, WindowListener windowListener) throws IndexOutOfBoundsException {
        this.window.addWindowListener(n, windowListener);
    }

    @Override
    public final void setKeyboardVisible(boolean bl) {
        this.window.setKeyboardVisible(bl);
    }

    @Override
    public final boolean isKeyboardVisible() {
        return this.window.isKeyboardVisible();
    }

    @Override
    public final void addKeyListener(KeyListener keyListener) {
        this.window.addKeyListener(keyListener);
    }

    @Override
    public final void addKeyListener(int n, KeyListener keyListener) {
        this.window.addKeyListener(n, keyListener);
    }

    @Override
    public final void removeKeyListener(KeyListener keyListener) {
        this.window.removeKeyListener(keyListener);
    }

    @Override
    public final KeyListener getKeyListener(int n) {
        return this.window.getKeyListener(n);
    }

    @Override
    public final KeyListener[] getKeyListeners() {
        return this.window.getKeyListeners();
    }

    @Override
    public final void addMouseListener(MouseListener mouseListener) {
        this.window.addMouseListener(mouseListener);
    }

    @Override
    public final void addMouseListener(int n, MouseListener mouseListener) {
        this.window.addMouseListener(n, mouseListener);
    }

    @Override
    public final void removeMouseListener(MouseListener mouseListener) {
        this.window.removeMouseListener(mouseListener);
    }

    @Override
    public final MouseListener getMouseListener(int n) {
        return this.window.getMouseListener(n);
    }

    @Override
    public final MouseListener[] getMouseListeners() {
        return this.window.getMouseListeners();
    }

    @Override
    public void setDefaultGesturesEnabled(boolean bl) {
        this.window.setDefaultGesturesEnabled(bl);
    }

    @Override
    public boolean areDefaultGesturesEnabled() {
        return this.window.areDefaultGesturesEnabled();
    }

    @Override
    public final void addGestureHandler(GestureHandler gestureHandler) {
        this.window.addGestureHandler(gestureHandler);
    }

    @Override
    public final void addGestureHandler(int n, GestureHandler gestureHandler) {
        this.window.addGestureHandler(n, gestureHandler);
    }

    @Override
    public final void removeGestureHandler(GestureHandler gestureHandler) {
        this.window.removeGestureHandler(gestureHandler);
    }

    @Override
    public final void addGestureListener(GestureHandler.GestureListener gestureListener) {
        this.window.addGestureListener(-1, gestureListener);
    }

    @Override
    public final void addGestureListener(int n, GestureHandler.GestureListener gestureListener) {
        this.window.addGestureListener(n, gestureListener);
    }

    @Override
    public final void removeGestureListener(GestureHandler.GestureListener gestureListener) {
        this.window.removeGestureListener(gestureListener);
    }

    @Override
    public final int lockSurface() throws NativeWindowException, RuntimeException {
        return this.window.lockSurface();
    }

    @Override
    public final void unlockSurface() {
        this.window.unlockSurface();
    }

    @Override
    public final boolean isSurfaceLockedByOtherThread() {
        return this.window.isSurfaceLockedByOtherThread();
    }

    @Override
    public final Thread getSurfaceLockOwner() {
        return this.window.getSurfaceLockOwner();
    }

    @Override
    public final boolean surfaceSwap() {
        return this.window.surfaceSwap();
    }

    @Override
    public final void removeSurfaceUpdatedListener(SurfaceUpdatedListener surfaceUpdatedListener) {
        this.window.removeSurfaceUpdatedListener(surfaceUpdatedListener);
    }

    @Override
    public final void addSurfaceUpdatedListener(SurfaceUpdatedListener surfaceUpdatedListener) {
        this.window.addSurfaceUpdatedListener(surfaceUpdatedListener);
    }

    @Override
    public final void addSurfaceUpdatedListener(int n, SurfaceUpdatedListener surfaceUpdatedListener) throws IndexOutOfBoundsException {
        this.window.addSurfaceUpdatedListener(n, surfaceUpdatedListener);
    }

    @Override
    public final void surfaceUpdated(Object object, NativeSurface nativeSurface, long l) {
        this.window.surfaceUpdated(object, nativeSurface, l);
    }

    @Override
    public final long getWindowHandle() {
        return this.window.getWindowHandle();
    }

    @Override
    public final long getSurfaceHandle() {
        return this.window.getSurfaceHandle();
    }

    @Override
    public final AbstractGraphicsConfiguration getGraphicsConfiguration() {
        return this.window.getGraphicsConfiguration();
    }

    @Override
    public final long getDisplayHandle() {
        return this.window.getDisplayHandle();
    }

    @Override
    public final int getScreenIndex() {
        return this.window.getScreenIndex();
    }

    public static void main(String[] stringArray) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        if (null != stringArray) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].equals("-es2")) {
                    bl = true;
                    continue;
                }
                if (stringArray[i].equals("-es3")) {
                    bl2 = true;
                    continue;
                }
                if (stringArray[i].equals("-gl3")) {
                    bl3 = true;
                    continue;
                }
                if (!stringArray[i].equals("-gl4es3")) continue;
                bl4 = true;
            }
        }
        boolean bl5 = bl;
        boolean bl6 = bl2;
        boolean bl7 = bl3;
        boolean bl8 = bl4;
        System.err.println("forceES2    " + bl5);
        System.err.println("forceES3    " + bl6);
        System.err.println("forceGL3    " + bl7);
        System.err.println("forceGL4ES3 " + bl8);
        System.err.println(VersionUtil.getPlatformInfo());
        System.err.println(GlueGenVersion.getInstance());
        System.err.println((Object)JoglVersion.getInstance());
        System.err.println(JoglVersion.getDefaultOpenGLInfo(null, null, true).toString());
        GLProfile gLProfile = bl8 ? GLProfile.get("GL4ES3") : (bl7 ? GLProfile.get("GL3") : (bl6 ? GLProfile.get("GLES3") : (bl5 ? GLProfile.get("GLES2") : GLProfile.getDefault())));
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        System.err.println("Requesting: " + gLCapabilities);
        final GLWindow gLWindow = GLWindow.create(gLCapabilities);
        gLWindow.setSize(128, 128);
        gLWindow.addGLEventListener(new GLEventListener(){

            @Override
            public void init(GLAutoDrawable gLAutoDrawable) {
                GL2ES2 gL2ES2;
                MonitorDevice monitorDevice = gLWindow.getMainMonitor();
                System.err.println("Main Monitor: " + monitorDevice);
                float[] fArray = monitorDevice.getPixelsPerMM(new float[2]);
                System.err.println("    pixel/mm [" + fArray[0] + ", " + fArray[1] + "]");
                System.err.println("    pixel/in [" + fArray[0] * 25.4f + ", " + fArray[1] * 25.4f + "]");
                GL gL = gLAutoDrawable.getGL();
                System.err.println(JoglVersion.getGLInfo(gL, null));
                System.err.println("Requested: " + gLAutoDrawable.getNativeSurface().getGraphicsConfiguration().getRequestedCapabilities());
                System.err.println("Chosen   : " + gLAutoDrawable.getChosenGLCapabilities());
                System.err.println("GL impl. class " + gL.getClass().getName());
                if (gL.isGL4ES3()) {
                    gL2ES2 = gL.getGL4ES3();
                    System.err.println("GL4ES3 retrieved, impl. class " + gL2ES2.getClass().getName());
                }
                if (gL.isGL3()) {
                    gL2ES2 = gL.getGL3();
                    System.err.println("GL3 retrieved, impl. class " + gL2ES2.getClass().getName());
                }
                if (gL.isGLES3()) {
                    gL2ES2 = gL.getGLES3();
                    System.err.println("GLES3 retrieved, impl. class " + gL2ES2.getClass().getName());
                }
                if (gL.isGLES2()) {
                    gL2ES2 = gL.getGLES2();
                    System.err.println("GLES2 retrieved, impl. class " + gL2ES2.getClass().getName());
                }
            }

            @Override
            public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
            }

            @Override
            public void display(GLAutoDrawable gLAutoDrawable) {
            }

            @Override
            public void dispose(GLAutoDrawable gLAutoDrawable) {
            }
        });
        gLWindow.setVisible(true);
        gLWindow.destroy();
    }

    protected class GLLifecycleHook
    implements WindowImpl.LifecycleHook {
        private GLAnimatorControl savedAnimator = null;

        protected GLLifecycleHook() {
        }

        @Override
        public void preserveGLStateAtDestroy(boolean bl) {
            GLWindow.this.preserveGLStateAtDestroy(bl);
        }

        @Override
        public synchronized void destroyActionPreLock() {
        }

        @Override
        public synchronized void destroyActionInLock() {
            if (Window.DEBUG_IMPLEMENTATION) {
                String string = "GLWindow.destroy() " + WindowImpl.getThreadName() + ", start";
                System.err.println(string);
            }
            GLWindow.this.destroyImplInLock();
            if (Window.DEBUG_IMPLEMENTATION) {
                System.err.println("GLWindow.destroy() " + WindowImpl.getThreadName() + ", fin");
            }
        }

        @Override
        public synchronized void resetCounter() {
            if (Window.DEBUG_IMPLEMENTATION) {
                System.err.println("GLWindow.resetCounter() " + WindowImpl.getThreadName());
            }
            GLWindow.this.resetFPSCounter();
            GLAnimatorControl gLAnimatorControl = GLWindow.this.getAnimator();
            if (null != gLAnimatorControl) {
                gLAnimatorControl.resetFPSCounter();
            }
        }

        @Override
        public synchronized void setVisibleActionPost(boolean bl, boolean bl2) {
            long l;
            if (Window.DEBUG_IMPLEMENTATION) {
                l = System.nanoTime();
                System.err.println("GLWindow.setVisibleActionPost(" + bl + ", " + bl2 + ") " + WindowImpl.getThreadName() + ", start");
            } else {
                l = 0L;
            }
            if (null == GLWindow.this.drawable && bl && 0L != GLWindow.this.window.getWindowHandle() && 0 < GLWindow.this.getSurfaceWidth() * GLWindow.this.getSurfaceHeight()) {
                if (null != GLWindow.this.context) {
                    throw new InternalError("GLWindow.LifecycleHook.setVisiblePost: " + WindowImpl.getThreadName() + " - Null drawable, but valid context - " + GLWindow.this);
                }
                GLContext[] gLContextArray = new GLContext[]{null};
                if (!GLWindow.this.helper.isSharedGLContextPending(gLContextArray)) {
                    Object object = GLWindow.this.window.getWrappedSurface();
                    NativeSurface nativeSurface = null != object ? object : GLWindow.this.window;
                    object = (GLCapabilitiesImmutable)nativeSurface.getGraphicsConfiguration().getChosenCapabilities();
                    if (null == GLWindow.this.factory) {
                        GLWindow.this.factory = GLDrawableFactory.getFactory(object.getGLProfile());
                    }
                    GLWindow.this.drawable = (GLDrawableImpl)GLWindow.this.factory.createGLDrawable(nativeSurface);
                    GLWindow.this.drawable.setRealized(true);
                    if (!GLWindow.this.restoreGLEventListenerState()) {
                        GLWindow.this.context = (GLContextImpl)GLWindow.this.drawable.createContext(gLContextArray[0]);
                        GLWindow.this.context.setContextCreationFlags(GLWindow.this.additionalCtxCreationFlags);
                    }
                }
            }
            if (Window.DEBUG_IMPLEMENTATION) {
                System.err.println("GLWindow.setVisibleActionPost(" + bl + ", " + bl2 + ") " + WindowImpl.getThreadName() + ", fin: dt " + (double)(System.nanoTime() - l) / 1000000.0 + "ms");
            }
        }

        @Override
        public synchronized boolean pauseRenderingAction() {
            this.savedAnimator = GLWindow.this.getAnimator();
            boolean bl = null != this.savedAnimator ? this.savedAnimator.pause() : false;
            return bl;
        }

        @Override
        public synchronized void resumeRenderingAction() {
            if (null != this.savedAnimator && this.savedAnimator.isPaused()) {
                this.savedAnimator.resume();
            }
        }

        @Override
        public void shutdownRenderingAction() {
            final GLAnimatorControl gLAnimatorControl = GLWindow.this.getAnimator();
            if (null != gLAnimatorControl && gLAnimatorControl.isAnimating()) {
                final Thread thread = gLAnimatorControl.getThread();
                if (thread == Thread.currentThread()) {
                    gLAnimatorControl.stop();
                } else {
                    AccessController.doPrivileged(new PrivilegedAction<Object>(){

                        @Override
                        public Object run() {
                            block3: {
                                if (gLAnimatorControl.isAnimating() && null != thread) {
                                    try {
                                        thread.stop();
                                    }
                                    catch (Throwable throwable) {
                                        if (!GLAutoDrawableBase.DEBUG) break block3;
                                        System.err.println("Caught " + throwable.getClass().getName() + ": " + throwable.getMessage());
                                        throwable.printStackTrace();
                                    }
                                }
                            }
                            return null;
                        }
                    });
                }
            }
        }
    }
}

