/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.shared.util;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.osmand.shared.KException;
import net.osmand.shared.api.NetworkAPI;
import net.osmand.shared.api.NetworkAPIImpl;
import net.osmand.shared.api.OsmAndContext;
import net.osmand.shared.api.SQLiteAPI;
import net.osmand.shared.api.SQLiteAPIImpl;
import net.osmand.shared.gpx.GpxTrackAnalysis;
import net.osmand.shared.util.Localization;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0004\u001a\u00020\u0005J\u0006\u0010\f\u001a\u00020\u0005J\u0006\u0010\r\u001a\u00020\u0007J\u0006\u0010\u000e\u001a\u00020\tJ\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\u0012R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lnet/osmand/shared/util/PlatformUtil;", "", "<init>", "()V", "osmAndContext", "Lnet/osmand/shared/api/OsmAndContext;", "sqliteApi", "Lnet/osmand/shared/api/SQLiteAPI;", "networkAPI", "Lnet/osmand/shared/api/NetworkAPI;", "initialize", "", "getOsmAndContext", "getSQLiteAPI", "getNetworkAPI", "getTrackPointsAnalyser", "Lnet/osmand/shared/gpx/GpxTrackAnalysis$TrackPointsAnalyser;", "getKotlinException", "Lnet/osmand/shared/KException;", "e", "Ljava/lang/Exception;", "getJavaException", "OsmAnd-shared"})
public final class PlatformUtil {
    @NotNull
    public static final PlatformUtil INSTANCE = new PlatformUtil();
    private static OsmAndContext osmAndContext;
    private static SQLiteAPI sqliteApi;
    private static NetworkAPI networkAPI;

    private PlatformUtil() {
    }

    public final void initialize(@NotNull OsmAndContext osmAndContext) {
        Intrinsics.checkNotNullParameter((Object)osmAndContext, (String)"osmAndContext");
        PlatformUtil.osmAndContext = osmAndContext;
        sqliteApi = new SQLiteAPIImpl();
        networkAPI = new NetworkAPIImpl();
        Localization.INSTANCE.initialize();
    }

    @NotNull
    public final OsmAndContext getOsmAndContext() {
        OsmAndContext osmAndContext = PlatformUtil.osmAndContext;
        if (osmAndContext == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"osmAndContext");
            osmAndContext = null;
        }
        return osmAndContext;
    }

    @NotNull
    public final SQLiteAPI getSQLiteAPI() {
        SQLiteAPI sQLiteAPI = sqliteApi;
        if (sQLiteAPI == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"sqliteApi");
            sQLiteAPI = null;
        }
        return sQLiteAPI;
    }

    @NotNull
    public final NetworkAPI getNetworkAPI() {
        NetworkAPI networkAPI = PlatformUtil.networkAPI;
        if (networkAPI == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"networkAPI");
            networkAPI = null;
        }
        return networkAPI;
    }

    @Nullable
    public final GpxTrackAnalysis.TrackPointsAnalyser getTrackPointsAnalyser() {
        OsmAndContext osmAndContext = PlatformUtil.osmAndContext;
        if (osmAndContext == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"osmAndContext");
            osmAndContext = null;
        }
        return osmAndContext.getTrackPointsAnalyser();
    }

    @NotNull
    public final KException getKotlinException(@NotNull Exception e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        return new KException(e.getMessage(), e);
    }

    @NotNull
    public final Exception getJavaException(@NotNull KException e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        return new Exception(e.getMessage(), e);
    }
}

