/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.shared.gpx;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.osmand.shared.gpx.primitives.TrkSegment;
import net.osmand.shared.gpx.primitives.WptPt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u001b\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\t\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0011\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B!\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\tB!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\n\u001a\u00020\u0007\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\u0004\u0010\rJ\u0006\u00109\u001a\u00020\u0007J\u0011\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020\u0007H\u0086\u0002J \u0010=\u001a\u00020;2\u0006\u0010>\u001a\u00020;2\u0006\u0010?\u001a\u00020;2\u0006\u0010\u000b\u001a\u00020\fH\u0002J(\u0010@\u001a\u00020\f2\u0006\u0010A\u001a\u00020\f2\u0006\u0010B\u001a\u00020\f2\u0006\u0010C\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\fH\u0002J(\u0010@\u001a\u00020D2\u0006\u0010A\u001a\u00020D2\u0006\u0010B\u001a\u00020D2\u0006\u0010C\u001a\u00020D2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0016\u0010E\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010F\u001a\u00020\fR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0005R\u001a\u0010\u0011\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u0013\"\u0004\b\u001d\u0010\u0015R\u001a\u0010\u001e\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u0018\"\u0004\b \u0010\u001aR\u001a\u0010!\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\u0013\"\u0004\b#\u0010\u0015R\u001a\u0010$\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010\u0013\"\u0004\b&\u0010\u0015R\u001c\u0010'\u001a\u0004\u0018\u00010(X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,R\u001e\u0010-\u001a\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u00102\u001a\u0004\b.\u0010/\"\u0004\b0\u00101R\u001e\u00103\u001a\u0004\u0018\u00010\fX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u00108\u001a\u0004\b4\u00105\"\u0004\b6\u00107\u00a8\u0006G"}, d2={"Lnet/osmand/shared/gpx/SplitSegment;", "", "segment", "Lnet/osmand/shared/gpx/primitives/TrkSegment;", "<init>", "(Lnet/osmand/shared/gpx/primitives/TrkSegment;)V", "startInd", "", "endInd", "(IILnet/osmand/shared/gpx/primitives/TrkSegment;)V", "pointInd", "cf", "", "(Lnet/osmand/shared/gpx/primitives/TrkSegment;ID)V", "getSegment", "()Lnet/osmand/shared/gpx/primitives/TrkSegment;", "setSegment", "startCoeff", "getStartCoeff", "()D", "setStartCoeff", "(D)V", "startPointInd", "getStartPointInd", "()I", "setStartPointInd", "(I)V", "endCoeff", "getEndCoeff", "setEndCoeff", "endPointInd", "getEndPointInd", "setEndPointInd", "metricEnd", "getMetricEnd", "setMetricEnd", "secondaryMetricEnd", "getSecondaryMetricEnd", "setSecondaryMetricEnd", "segmentSlopeType", "Lnet/osmand/shared/gpx/primitives/TrkSegment$SegmentSlopeType;", "getSegmentSlopeType", "()Lnet/osmand/shared/gpx/primitives/TrkSegment$SegmentSlopeType;", "setSegmentSlopeType", "(Lnet/osmand/shared/gpx/primitives/TrkSegment$SegmentSlopeType;)V", "slopeCount", "getSlopeCount", "()Ljava/lang/Integer;", "setSlopeCount", "(Ljava/lang/Integer;)V", "Ljava/lang/Integer;", "slopeValue", "getSlopeValue", "()Ljava/lang/Double;", "setSlopeValue", "(Ljava/lang/Double;)V", "Ljava/lang/Double;", "getNumberOfPoints", "get", "Lnet/osmand/shared/gpx/primitives/WptPt;", "j", "approx", "w1", "w2", "value", "vl", "vl2", "none", "", "setLastPoint", "endCf", "OsmAnd-shared"})
public final class SplitSegment {
    @NotNull
    private TrkSegment segment;
    private double startCoeff;
    private int startPointInd;
    private double endCoeff;
    private int endPointInd;
    private double metricEnd;
    private double secondaryMetricEnd;
    @Nullable
    private TrkSegment.SegmentSlopeType segmentSlopeType;
    @Nullable
    private Integer slopeCount;
    @Nullable
    private Double slopeValue;

    @NotNull
    public final TrkSegment getSegment() {
        return this.segment;
    }

    public final void setSegment(@NotNull TrkSegment trkSegment) {
        Intrinsics.checkNotNullParameter((Object)trkSegment, (String)"<set-?>");
        this.segment = trkSegment;
    }

    public final double getStartCoeff() {
        return this.startCoeff;
    }

    public final void setStartCoeff(double d) {
        this.startCoeff = d;
    }

    public final int getStartPointInd() {
        return this.startPointInd;
    }

    public final void setStartPointInd(int n) {
        this.startPointInd = n;
    }

    public final double getEndCoeff() {
        return this.endCoeff;
    }

    public final void setEndCoeff(double d) {
        this.endCoeff = d;
    }

    public final int getEndPointInd() {
        return this.endPointInd;
    }

    public final void setEndPointInd(int n) {
        this.endPointInd = n;
    }

    public final double getMetricEnd() {
        return this.metricEnd;
    }

    public final void setMetricEnd(double d) {
        this.metricEnd = d;
    }

    public final double getSecondaryMetricEnd() {
        return this.secondaryMetricEnd;
    }

    public final void setSecondaryMetricEnd(double d) {
        this.secondaryMetricEnd = d;
    }

    @Nullable
    public final TrkSegment.SegmentSlopeType getSegmentSlopeType() {
        return this.segmentSlopeType;
    }

    public final void setSegmentSlopeType(@Nullable TrkSegment.SegmentSlopeType segmentSlopeType) {
        this.segmentSlopeType = segmentSlopeType;
    }

    @Nullable
    public final Integer getSlopeCount() {
        return this.slopeCount;
    }

    public final void setSlopeCount(@Nullable Integer n) {
        this.slopeCount = n;
    }

    @Nullable
    public final Double getSlopeValue() {
        return this.slopeValue;
    }

    public final void setSlopeValue(@Nullable Double d) {
        this.slopeValue = d;
    }

    public SplitSegment(@NotNull TrkSegment segment) {
        Intrinsics.checkNotNullParameter((Object)segment, (String)"segment");
        this.startPointInd = 0;
        this.startCoeff = 0.0;
        this.endPointInd = segment.getPoints().size() - 2;
        this.endCoeff = 1.0;
        this.segment = segment;
    }

    public SplitSegment(int startInd, int endInd, @NotNull TrkSegment segment) {
        Intrinsics.checkNotNullParameter((Object)segment, (String)"segment");
        this.startPointInd = startInd;
        this.startCoeff = 0.0;
        this.endPointInd = endInd - 2;
        this.endCoeff = 1.0;
        this.segment = segment;
    }

    public SplitSegment(@NotNull TrkSegment segment, int pointInd, double cf) {
        Intrinsics.checkNotNullParameter((Object)segment, (String)"segment");
        this.segment = segment;
        this.startPointInd = pointInd;
        this.startCoeff = cf;
    }

    public final int getNumberOfPoints() {
        return this.endPointInd - this.startPointInd + 2;
    }

    @NotNull
    public final WptPt get(int j) {
        int ind = j + this.startPointInd;
        return j == 0 ? (this.startCoeff == 0.0 ? this.segment.getPoints().get(ind) : this.approx(this.segment.getPoints().get(ind), this.segment.getPoints().get(ind + 1), this.startCoeff)) : (j == this.getNumberOfPoints() - 1 ? (this.endCoeff == 1.0 ? this.segment.getPoints().get(ind) : this.approx(this.segment.getPoints().get(ind - 1), this.segment.getPoints().get(ind), this.endCoeff)) : this.segment.getPoints().get(ind));
    }

    private final WptPt approx(WptPt w1, WptPt w2, double cf) {
        long time = this.value(w1.getTime(), w2.getTime(), 0L, cf);
        double speed = this.value(w1.getSpeed(), w2.getSpeed(), 0.0, cf);
        double ele = this.value(w1.getEle(), w2.getEle(), 0.0, cf);
        double hdop = this.value(w1.getHdop(), w2.getHdop(), 0.0, cf);
        double lat = this.value(w1.getLat(), w2.getLat(), -360.0, cf);
        double lon = this.value(w1.getLon(), w2.getLon(), -360.0, cf);
        return new WptPt(lat, lon, time, ele, speed, hdop);
    }

    private final double value(double vl, double vl2, double none, double cf) {
        return vl == none || Double.isNaN(vl) ? vl2 : (vl2 == none || Double.isNaN(vl2) ? vl : vl + cf * (vl2 - vl));
    }

    private final long value(long vl, long vl2, long none, double cf) {
        return vl == none ? vl2 : (vl2 == none ? vl : vl + (long)(cf * (double)(vl2 - vl)));
    }

    public final double setLastPoint(int pointInd, double endCf) {
        this.endCoeff = endCf;
        this.endPointInd = pointInd;
        return this.endCoeff;
    }
}

