/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.binary;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.WireFormat;
import gnu.trove.map.hash.TLongObjectHashMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.osmand.PlatformUtil;
import net.osmand.binary.BinaryIndexPart;
import net.osmand.binary.BinaryMapIndexReader;
import net.osmand.binary.OsmandOdb;
import net.osmand.data.QuadRect;
import net.osmand.router.HHRouteDataStructure;
import net.osmand.util.MapUtils;
import org.apache.commons.logging.Log;

public class BinaryHHRouteReaderAdapter {
    protected static final Log LOG = PlatformUtil.getLog(BinaryHHRouteReaderAdapter.class);
    protected CodedInputStream codedIS;
    private final BinaryMapIndexReader map;

    protected BinaryHHRouteReaderAdapter(BinaryMapIndexReader map) {
        this.codedIS = map.codedIS;
        this.map = map;
    }

    protected void skipUnknownField(int t) throws IOException {
        this.map.skipUnknownField(t);
    }

    protected long readInt() throws IOException {
        return this.map.readInt();
    }

    public <T extends HHRouteDataStructure.NetworkDBPoint> TLongObjectHashMap<T> initRegionAndLoadPoints(HHRouteRegion reg, short mapId, Class<T> cl) throws IOException {
        this.codedIS.seek(reg.filePointer);
        long oldLimit = this.codedIS.pushLimitLong(reg.length);
        TLongObjectHashMap mp = new TLongObjectHashMap();
        reg.segments = new ArrayList<HHRouteBlockSegments>();
        block6: while (true) {
            int t = this.codedIS.readTag();
            int tag = WireFormat.getTagFieldNumber(t);
            switch (tag) {
                case 0: {
                    this.codedIS.popLimit(oldLimit);
                    return mp;
                }
                case 4: {
                    long length = this.codedIS.readRawVarint32();
                    long old = this.codedIS.pushLimitLong(length);
                    List<String> st = this.readStringTable();
                    for (String s : st) {
                        int i = s.indexOf(61);
                        if (i <= 0) continue;
                        reg.encodingRules.add(new BinaryMapIndexReader.TagValuePair(s.substring(0, i), s.substring(i + 1), -1));
                    }
                    this.codedIS.popLimit(old);
                    continue block6;
                }
                case 5: {
                    this.readPointBox(reg, cl, mapId, mp, null);
                    continue block6;
                }
                case 6: {
                    reg.segments.add(this.readRegionSegmentHeader());
                    continue block6;
                }
            }
            this.skipUnknownField(t);
        }
    }

    protected List<String> readStringTable() throws IOException {
        ArrayList<String> list = new ArrayList<String>();
        block4: while (true) {
            int t = this.codedIS.readTag();
            int tag = WireFormat.getTagFieldNumber(t);
            switch (tag) {
                case 0: {
                    return list;
                }
                case 1: {
                    list.add(this.codedIS.readString());
                    continue block4;
                }
            }
            this.skipUnknownField(t);
        }
    }

    public void readHHIndex(HHRouteRegion region, boolean fullInit) throws IOException {
        region.profileParams.clear();
        block8: while (true) {
            int t = this.codedIS.readTag();
            int tag = WireFormat.getTagFieldNumber(t);
            switch (tag) {
                case 0: {
                    return;
                }
                case 1: {
                    region.edition = this.codedIS.readInt64();
                    continue block8;
                }
                case 2: {
                    region.profile = this.codedIS.readString();
                    continue block8;
                }
                case 3: {
                    region.profileParams.add(this.codedIS.readString());
                    continue block8;
                }
                case 5: {
                    region.top = this.readPointBox(region, null, (short)0, null, null);
                    continue block8;
                }
                case 6: {
                    this.codedIS.skipRawBytes(this.codedIS.getBytesUntilLimit());
                    continue block8;
                }
            }
            this.skipUnknownField(t);
        }
    }

    private <T extends HHRouteDataStructure.NetworkDBPoint> HHRoutePointsBox readPointBox(HHRouteRegion reg, Class<T> cl, short mapId, TLongObjectHashMap<T> mp, HHRoutePointsBox parent) throws IOException {
        HHRoutePointsBox box = new HHRoutePointsBox();
        box.length = this.readInt();
        box.filePointer = this.codedIS.getTotalBytesRead();
        long oldLimit = this.codedIS.pushLimitLong(box.length);
        block9: while (true) {
            if (mp == null && box.bottom != 0 && box.top != 0 && box.right != 0 && box.left != 0) {
                this.codedIS.skipRawBytes(this.codedIS.getBytesUntilLimit());
            }
            int t = this.codedIS.readTag();
            int tag = WireFormat.getTagFieldNumber(t);
            switch (tag) {
                case 0: {
                    this.codedIS.popLimit(oldLimit);
                    return box;
                }
                case 5: {
                    box.bottom = this.codedIS.readSInt32() + (parent != null ? parent.bottom : 0);
                    continue block9;
                }
                case 4: {
                    box.top = this.codedIS.readSInt32() + (parent != null ? parent.top : 0);
                    continue block9;
                }
                case 3: {
                    box.right = this.codedIS.readSInt32() + (parent != null ? parent.right : 0);
                    continue block9;
                }
                case 2: {
                    box.left = this.codedIS.readSInt32() + (parent != null ? parent.left : 0);
                    continue block9;
                }
                case 6: {
                    if (cl == null) {
                        this.codedIS.skipRawBytes(this.codedIS.getBytesUntilLimit());
                        continue block9;
                    }
                    this.readPointBox(reg, cl, mapId, mp, box);
                    continue block9;
                }
                case 7: {
                    if (cl == null) {
                        this.codedIS.skipRawBytes(this.codedIS.getBytesUntilLimit());
                        continue block9;
                    }
                    this.readPoint(reg, cl, mapId, mp, box.left, box.top);
                    continue block9;
                }
            }
            this.skipUnknownField(t);
        }
    }

    private <T extends HHRouteDataStructure.NetworkDBPoint> T readPoint(HHRouteRegion reg, Class<T> cl, short mapId, TLongObjectHashMap<T> mp, int dx, int dy) throws IOException {
        HHRouteDataStructure.NetworkDBPoint pnt;
        try {
            pnt = (HHRouteDataStructure.NetworkDBPoint)cl.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        pnt.mapId = mapId;
        long size = this.codedIS.readRawVarint32();
        long oldLimit = this.codedIS.pushLimitLong(size);
        int dualIdPoint = -1;
        block16: while (true) {
            int t = this.codedIS.readTag();
            int tag = WireFormat.getTagFieldNumber(t);
            switch (tag) {
                case 0: {
                    this.codedIS.popLimit(oldLimit);
                    mp.put((long)pnt.index, (Object)pnt);
                    if (dualIdPoint >= 0 && mp.contains((long)dualIdPoint)) {
                        pnt.dualPoint = (HHRouteDataStructure.NetworkDBPoint)mp.get((long)dualIdPoint);
                        pnt.dualPoint.dualPoint = pnt;
                        pnt.dualPoint.endX = pnt.startX;
                        pnt.dualPoint.endY = pnt.startY;
                        pnt.endX = pnt.dualPoint.startX;
                        pnt.endY = pnt.dualPoint.startY;
                    }
                    return (T)pnt;
                }
                case 1: {
                    pnt.fileId = this.codedIS.readInt32();
                    continue block16;
                }
                case 2: {
                    pnt.endX = pnt.startX = this.codedIS.readSInt32() + dx;
                    continue block16;
                }
                case 3: {
                    pnt.endY = pnt.startY = this.codedIS.readSInt32() + dy;
                    continue block16;
                }
                case 4: {
                    pnt.index = this.codedIS.readInt32();
                    continue block16;
                }
                case 12: {
                    long sz = this.codedIS.readRawVarint32();
                    long old = this.codedIS.pushLimitLong(sz);
                    while (this.codedIS.getBytesUntilLimit() > 0L) {
                        int tvId = this.codedIS.readInt32();
                        if (tvId >= reg.encodingRules.size()) continue;
                        BinaryMapIndexReader.TagValuePair tagValuePair = reg.encodingRules.get(tvId);
                        if (pnt.tagValues == null) {
                            pnt.tagValues = new ArrayList<BinaryMapIndexReader.TagValuePair>();
                        }
                        pnt.tagValues.add(tagValuePair);
                    }
                    this.codedIS.popLimit(old);
                    continue block16;
                }
                case 5: {
                    pnt.roadId = this.codedIS.readInt64();
                    continue block16;
                }
                case 6: {
                    int v = this.codedIS.readInt32();
                    pnt.start = (short)(v >> 1);
                    pnt.end = (short)(pnt.start + (v % 2 == 1 ? 1 : -1));
                    continue block16;
                }
                case 7: {
                    pnt.clusterId = this.codedIS.readInt32();
                    continue block16;
                }
                case 11: {
                    pnt.incomplete = this.codedIS.readInt32() > 0;
                    continue block16;
                }
                case 8: {
                    dualIdPoint = this.codedIS.readInt32();
                    continue block16;
                }
                case 9: {
                    this.codedIS.readInt32();
                    continue block16;
                }
            }
            this.skipUnknownField(t);
        }
    }

    private HHRouteBlockSegments readRegionSegmentHeader() throws IOException {
        HHRouteBlockSegments block = new HHRouteBlockSegments();
        block.length = this.readInt();
        block.filePointer = this.codedIS.getTotalBytesRead();
        long oldLimit = this.codedIS.pushLimitLong(block.length);
        block8: while (true) {
            int t = this.codedIS.readTag();
            int tag = WireFormat.getTagFieldNumber(t);
            switch (tag) {
                case 0: {
                    this.codedIS.popLimit(oldLimit);
                    return block;
                }
                case 2: {
                    block.idRangeLength = this.codedIS.readInt32();
                    continue block8;
                }
                case 1: {
                    block.idRangeStart = this.codedIS.readInt32();
                    continue block8;
                }
                case 3: {
                    block.profileId = this.codedIS.readInt32();
                    continue block8;
                }
                case 6: {
                    this.codedIS.skipRawBytes(this.codedIS.getBytesUntilLimit());
                    continue block8;
                }
                case 4: {
                    this.codedIS.skipRawBytes(this.codedIS.getBytesUntilLimit());
                    continue block8;
                }
            }
            this.skipUnknownField(t);
        }
    }

    private <T extends HHRouteDataStructure.NetworkDBPoint> int loadNetworkSegmentPoint(HHRouteDataStructure.HHRoutingContext<T> ctx, HHRouteDataStructure.HHRouteRegionPointsCtx<T> reg, HHRouteBlockSegments block, int searchInd, boolean reverse) throws IOException {
        if (block.sublist != null) {
            for (HHRouteBlockSegments s : block.sublist) {
                if (!this.checkId(searchInd, s)) continue;
                return this.loadNetworkSegmentPoint(ctx, reg, s, searchInd, reverse);
            }
            return 0;
        }
        if (this.codedIS.getTotalBytesRead() != block.filePointer) {
            this.codedIS.seek(block.filePointer);
        }
        int loaded = 0;
        long oldLimit = this.codedIS.pushLimitLong(block.length);
        int ind = 0;
        try {
            block13: while (true) {
                int t = this.codedIS.readTag();
                int tag = WireFormat.getTagFieldNumber(t);
                switch (tag) {
                    case 0: {
                        int n = loaded;
                        return n;
                    }
                    case 2: {
                        block.idRangeLength = this.codedIS.readInt32();
                        break;
                    }
                    case 1: {
                        block.idRangeStart = this.codedIS.readInt32();
                        break;
                    }
                    case 3: {
                        block.profileId = this.codedIS.readInt32();
                        break;
                    }
                    case 6: {
                        if (!this.checkId(searchInd, block)) {
                            this.codedIS.skipRawBytes(this.codedIS.getBytesUntilLimit());
                            break;
                        }
                        if (block.sublist == null) {
                            block.sublist = new ArrayList<HHRouteBlockSegments>();
                        }
                        HHRouteBlockSegments child = new HHRouteBlockSegments();
                        child.length = this.readInt();
                        child.filePointer = this.codedIS.getTotalBytesRead();
                        long olLimit = this.codedIS.pushLimitLong(child.length);
                        loaded += this.loadNetworkSegmentPoint(ctx, reg, child, searchInd, reverse);
                        this.codedIS.popLimit(olLimit);
                        block.sublist.add(child);
                        break;
                    }
                    case 4: {
                        if (!this.checkId(searchInd, block)) {
                            this.codedIS.skipRawBytes(this.codedIS.getBytesUntilLimit());
                            break;
                        }
                        int pntFileId = ind++ + block.idRangeStart;
                        T point = reg.getPoint(pntFileId);
                        int len = this.codedIS.readRawVarint32();
                        long olLimit = this.codedIS.pushLimitLong(len);
                        OsmandOdb.OsmAndHHRoutingIndex.HHRoutePointSegments s = this.readSegments();
                        this.codedIS.popLimit(olLimit);
                        if (point == null) continue block13;
                        HHRouteDataStructure.setSegments(ctx, point, s.getSegmentsIn().toByteArray(), s.getSegmentsOut().toByteArray());
                        loaded += ((HHRouteDataStructure.NetworkDBPoint)point).connected(true).size() + ((HHRouteDataStructure.NetworkDBPoint)point).connected(false).size();
                        break;
                    }
                    default: {
                        this.skipUnknownField(t);
                    }
                }
            }
        }
        finally {
            this.codedIS.popLimit(oldLimit);
        }
    }

    private OsmandOdb.OsmAndHHRoutingIndex.HHRoutePointSegments readSegments() throws IOException {
        OsmandOdb.OsmAndHHRoutingIndex.HHRoutePointSegments.Builder bld = OsmandOdb.OsmAndHHRoutingIndex.HHRoutePointSegments.newBuilder();
        while (true) {
            int t = this.codedIS.readTag();
            int tag = WireFormat.getTagFieldNumber(t);
            switch (tag) {
                case 0: {
                    return bld.buildPartial();
                }
                case 2: {
                    bld.setSegmentsIn(this.codedIS.readBytes());
                    break;
                }
                case 3: {
                    bld.setSegmentsOut(this.codedIS.readBytes());
                }
            }
        }
    }

    private <T extends HHRouteDataStructure.NetworkDBPoint> boolean checkId(int id, HHRouteBlockSegments s) {
        return s.idRangeStart <= id && s.idRangeStart + s.idRangeLength > id;
    }

    public <T extends HHRouteDataStructure.NetworkDBPoint> int loadNetworkSegmentPoint(HHRouteDataStructure.HHRoutingContext<T> ctx, HHRouteDataStructure.HHRouteRegionPointsCtx<T> reg, T point, boolean reverse) throws IOException {
        if (point.connected(reverse) != null) {
            return 0;
        }
        HHRouteRegion fileRegion = reg.getFileRegion();
        for (HHRouteBlockSegments s : fileRegion.segments) {
            if (s.profileId != reg.getRoutingProfile() || !this.checkId(point.fileId, s)) continue;
            return this.loadNetworkSegmentPoint(ctx, reg, s, point.fileId, reverse);
        }
        return 0;
    }

    public static class HHRouteRegion
    extends BinaryIndexPart {
        public long edition;
        public String profile;
        public List<String> profileParams = new ArrayList<String>();
        public HHRoutePointsBox top = null;
        public List<BinaryMapIndexReader.TagValuePair> encodingRules = new ArrayList<BinaryMapIndexReader.TagValuePair>();
        public List<HHRouteBlockSegments> segments = null;

        @Override
        public String getPartName() {
            return "Highway routing ";
        }

        @Override
        public String getName() {
            return this.profile;
        }

        @Override
        public int getFieldNumber() {
            return 10;
        }

        public QuadRect getLatLonBbox() {
            if (this.top == null) {
                return new QuadRect();
            }
            return this.top.getLatLonBox();
        }
    }

    public static class HHRoutePointsBox {
        long length;
        long filePointer;
        int left;
        int right;
        int bottom;
        int top;

        public QuadRect getLatLonBox() {
            QuadRect q = new QuadRect();
            q.left = MapUtils.get31LongitudeX(this.left);
            q.right = MapUtils.get31LongitudeX(this.right);
            q.top = MapUtils.get31LatitudeY(this.top);
            q.bottom = MapUtils.get31LatitudeY(this.bottom);
            return q;
        }

        public boolean contains(int x, int y) {
            return x >= this.left && x <= this.right && y >= this.top && y <= this.bottom;
        }
    }

    public static class HHRouteBlockSegments {
        int idRangeStart;
        int idRangeLength;
        int profileId;
        long length;
        long filePointer;
        List<HHRouteBlockSegments> sublist;
    }
}

