/*
 * Decompiled with CFR 0.152.
 */
package info.bliki.wiki.template.expr.ast;

import info.bliki.wiki.template.expr.ast.IntegerNode;
import info.bliki.wiki.template.expr.ast.NumberNode;

public class FractionNode
extends NumberNode {
    protected final IntegerNode fNumerator;
    protected final IntegerNode fDenominator;

    public FractionNode(IntegerNode numerator, IntegerNode denominator) {
        super(null);
        this.fNumerator = numerator;
        this.fDenominator = denominator;
    }

    public IntegerNode getDenominator() {
        return this.fDenominator;
    }

    public IntegerNode getNumerator() {
        return this.fNumerator;
    }

    @Override
    public String toString() {
        StringBuffer buff = new StringBuffer();
        if (this.sign) {
            buff.append("-");
        }
        if (this.fNumerator != null) {
            buff.append(this.fNumerator.toString());
        }
        buff.append("/");
        if (this.fDenominator != null) {
            buff.append(this.fDenominator.toString());
        }
        return buff.toString();
    }

    @Override
    public double doubleValue() {
        double numer = Double.parseDouble(this.fNumerator.toString());
        double denom = Double.parseDouble(this.fDenominator.toString());
        if (this.sign) {
            return -1.0 * numer / denom;
        }
        return numer / denom;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof FractionNode) {
            return this.fNumerator.equals(((FractionNode)obj).fNumerator) && this.fDenominator.equals(((FractionNode)obj).fDenominator) && this.sign == ((FractionNode)obj).sign;
        }
        return false;
    }

    @Override
    public int hashCode() {
        if (this.sign) {
            return this.fNumerator.hashCode() + this.fDenominator.hashCode() * 17;
        }
        return this.fNumerator.hashCode() + this.fDenominator.hashCode();
    }
}

