/*
 * Decompiled with CFR 0.152.
 */
package io.github.cosinekitty.astronomy;

import io.github.cosinekitty.astronomy.Astronomy;
import io.github.cosinekitty.astronomy.DateTime;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\u0018\u0000 ,2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001,B\u0019\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006B\u0011\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0007B9\b\u0016\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\t\u0012\u0006\u0010\f\u001a\u00020\t\u0012\u0006\u0010\r\u001a\u00020\t\u0012\u0006\u0010\u000e\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u000fJ\u0006\u0010\u001c\u001a\u00020\u001dJ\u0006\u0010\u001e\u001a\u00020\u001fJ\b\u0010 \u001a\u00020!H\u0016J\u000e\u0010\"\u001a\u00020\u00002\u0006\u0010#\u001a\u00020\u0003J\r\u0010$\u001a\u00020\u0003H\u0000\u00a2\u0006\u0002\b%J\r\u0010&\u001a\u00020\u0003H\u0000\u00a2\u0006\u0002\b'J\u0011\u0010(\u001a\u00020\t2\u0006\u0010)\u001a\u00020\u0000H\u0096\u0002J\u0006\u0010*\u001a\u00020\u0003J\u0006\u0010+\u001a\u00020\u0003R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011R\u001a\u0010\u0013\u001a\u00020\u0003X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0011\"\u0004\b\u0015\u0010\u0007R\u001a\u0010\u0016\u001a\u00020\u0003X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0011\"\u0004\b\u0018\u0010\u0007R\u001a\u0010\u0019\u001a\u00020\u0003X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u0011\"\u0004\b\u001b\u0010\u0007\u00a8\u0006-"}, d2={"Lio/github/cosinekitty/astronomy/Time;", "", "ut", "", "tt", "<init>", "(DD)V", "(D)V", "year", "", "month", "day", "hour", "minute", "second", "(IIIIID)V", "getUt", "()D", "getTt", "psi", "getPsi$OsmAnd_shared", "setPsi$OsmAnd_shared", "eps", "getEps$OsmAnd_shared", "setEps$OsmAnd_shared", "st", "getSt$OsmAnd_shared", "setSt$OsmAnd_shared", "toDateTime", "Lio/github/cosinekitty/astronomy/DateTime;", "toMillisecondsSince1970", "", "toString", "", "addDays", "days", "julianCenturies", "julianCenturies$OsmAnd_shared", "julianMillennia", "julianMillennia$OsmAnd_shared", "compareTo", "other", "nutationPsi", "nutationEps", "Companion", "OsmAnd-shared"})
public final class Time
implements Comparable<Time> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final double ut;
    private final double tt;
    private double psi;
    private double eps;
    private double st;

    private Time(double ut, double tt) {
        this.ut = ut;
        this.tt = tt;
        this.psi = Double.NaN;
        this.eps = Double.NaN;
        this.st = Double.NaN;
    }

    public final double getUt() {
        return this.ut;
    }

    public final double getTt() {
        return this.tt;
    }

    public final double getPsi$OsmAnd_shared() {
        return this.psi;
    }

    public final void setPsi$OsmAnd_shared(double d) {
        this.psi = d;
    }

    public final double getEps$OsmAnd_shared() {
        return this.eps;
    }

    public final void setEps$OsmAnd_shared(double d) {
        this.eps = d;
    }

    public final double getSt$OsmAnd_shared() {
        return this.st;
    }

    public final void setSt$OsmAnd_shared(double d) {
        this.st = d;
    }

    public Time(double ut) {
        this(ut, Astronomy.terrestrialTime(ut));
    }

    public Time(int year, int month, int day, int hour, int minute, double second) {
        this(Astronomy.access$universalTimeDays(year, month, day, hour, minute, second));
    }

    @NotNull
    public final DateTime toDateTime() {
        return Astronomy.dayValueToDateTime(this.ut);
    }

    public final long toMillisecondsSince1970() {
        return (long)Math.rint((this.ut + 10957.5) * 8.64E7);
    }

    @NotNull
    public String toString() {
        return this.toDateTime().toString();
    }

    @NotNull
    public final Time addDays(double days) {
        return new Time(this.ut + days);
    }

    public final double julianCenturies$OsmAnd_shared() {
        return this.tt / 36525.0;
    }

    public final double julianMillennia$OsmAnd_shared() {
        return this.tt / 365250.0;
    }

    @Override
    public int compareTo(@NotNull Time other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return Double.compare(this.tt, other.tt);
    }

    public final double nutationPsi() {
        return this.psi;
    }

    public final double nutationEps() {
        return this.eps;
    }

    @JvmStatic
    @NotNull
    public static final Time fromTerrestrialTime(double tt) {
        return Companion.fromTerrestrialTime(tt);
    }

    @JvmStatic
    @NotNull
    public static final Time fromMillisecondsSince1970(long millis) {
        return Companion.fromMillisecondsSince1970(millis);
    }

    public /* synthetic */ Time(double ut, double tt, DefaultConstructorMarker $constructor_marker) {
        this(ut, tt);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0007\u00a8\u0006\u000b"}, d2={"Lio/github/cosinekitty/astronomy/Time$Companion;", "", "<init>", "()V", "fromTerrestrialTime", "Lio/github/cosinekitty/astronomy/Time;", "tt", "", "fromMillisecondsSince1970", "millis", "", "OsmAnd-shared"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Time fromTerrestrialTime(double tt) {
            return new Time(Astronomy.universalTime(tt), tt, null);
        }

        @JvmStatic
        @NotNull
        public final Time fromMillisecondsSince1970(long millis) {
            return new Time((double)(millis - 946728000000L) / 8.64E7);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

