/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.gpx;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.osmand.shared.gpx.primitives.Track;
import net.osmand.shared.gpx.primitives.TrkSegment;
import net.osmand.shared.gpx.primitives.WptPt;
import net.osmand.shared.util.KMapUtils;

public class TravelObfGpxTrackOptimizer {
    private static final int MAX_JUMPS_OVER_UNIQUE_POINTS = 5;
    private static final double EDGE_POINTS_MAX_ORTHOGONAL_DISTANCE = 10.0;
    private static final double PRECISION_DUPES = 1.0E-5;
    private static final double PRECISION_EQUAL = 1.0E-5;
    private static final double PRECISION_CLOSE = 5.0E-4;

    public static Track mergeOverlappedSegmentsAtEdges(Track track) {
        HashSet<String> duplicates = new HashSet<String>();
        TravelObfGpxTrackOptimizer.findDisplacedEdgePointsToDeduplicate(track, duplicates);
        ArrayList<TrkSegment> cleanedSegments = new ArrayList<TrkSegment>();
        TravelObfGpxTrackOptimizer.deduplicatePointsFromEdges(track, duplicates, cleanedSegments);
        ArrayList<TrkSegment> joinedSegments = new ArrayList<TrkSegment>();
        TravelObfGpxTrackOptimizer.joinCleanedSegments(cleanedSegments, joinedSegments);
        Track joinedTrack = new Track();
        joinedTrack.setSegments(joinedSegments);
        return joinedTrack;
    }

    private static void findDisplacedEdgePointsToDeduplicate(Track track, Set<String> duplicates) {
        List points;
        HashSet<WptPt> edgePoints = new HashSet<WptPt>();
        for (TrkSegment seg : track.getSegments()) {
            points = seg.getPoints();
            if (points.isEmpty()) continue;
            edgePoints.add((WptPt)points.get(0));
            edgePoints.add((WptPt)points.get(points.size() - 1));
        }
        if (!edgePoints.isEmpty()) {
            for (TrkSegment seg : track.getSegments()) {
                points = seg.getPoints();
                for (int i = 1; i < points.size(); ++i) {
                    WptPt p1 = (WptPt)points.get(i);
                    WptPt p2 = (WptPt)points.get(i - 1);
                    TravelObfGpxTrackOptimizer.searchEdgePointsDuplicates(duplicates, edgePoints, p1, p2);
                }
            }
        }
    }

    private static void searchEdgePointsDuplicates(Set<String> duplicates, Set<WptPt> edgePoints, WptPt p1, WptPt p2) {
        for (WptPt edge : edgePoints) {
            double dist;
            double coeff = KMapUtils.INSTANCE.getProjectionCoeff(edge.getLatitude(), edge.getLongitude(), p1.getLatitude(), p1.getLongitude(), p2.getLatitude(), p2.getLongitude());
            if (!(coeff > 0.0) || !(coeff < 1.0) || !((dist = KMapUtils.INSTANCE.getOrthogonalDistance(edge.getLatitude(), edge.getLongitude(), p1.getLatitude(), p1.getLongitude(), p2.getLatitude(), p2.getLongitude())) > 0.0) || !(dist < 10.0)) continue;
            duplicates.add(TravelObfGpxTrackOptimizer.llKey(edge));
        }
    }

    private static void deduplicatePointsFromEdges(Track track, Set<String> duplicates, List<TrkSegment> cleanedSegments) {
        for (TrkSegment seg : track.getSegments()) {
            TrkSegment clean = new TrkSegment();
            List points = seg.getPoints();
            if (!points.isEmpty()) {
                int fromIndex = 0;
                int toIndex = points.size() - 1;
                TravelObfGpxTrackOptimizer.markDanglingEdgePointsToDeduplicate(points, duplicates);
                fromIndex += TravelObfGpxTrackOptimizer.countDuplicates(true, fromIndex, toIndex, points, duplicates);
                toIndex -= TravelObfGpxTrackOptimizer.countDuplicates(false, fromIndex, toIndex, points, duplicates);
                if (fromIndex < toIndex) {
                    clean.getPoints().addAll(points.subList(fromIndex, toIndex + 1));
                }
                for (int i = 1; i < points.size() - 1; ++i) {
                    String key = TravelObfGpxTrackOptimizer.llKey((WptPt)points.get(i));
                    duplicates.add(key);
                }
            }
            if (clean.getPoints().isEmpty()) continue;
            cleanedSegments.add(clean);
        }
    }

    private static int countDuplicates(boolean forward, int fromIndex, int toIndex, List<WptPt> points, Set<String> duplicates) {
        int dupes = 0;
        int uniques = 0;
        int a = forward ? fromIndex : toIndex;
        int b = forward ? toIndex : fromIndex;
        for (int i = a; i != b; i += forward ? 1 : -1) {
            if (duplicates.contains(TravelObfGpxTrackOptimizer.llKey(points.get(i)))) {
                dupes += uniques + 1;
                uniques = 0;
                continue;
            }
            if (++uniques > 5) break;
        }
        return dupes > 1 ? dupes : 0;
    }

    private static void markDanglingEdgePointsToDeduplicate(List<WptPt> points, Set<String> duplicates) {
        if (points.size() > 1) {
            if (duplicates.contains(TravelObfGpxTrackOptimizer.llKey(points.get(1)))) {
                duplicates.add(TravelObfGpxTrackOptimizer.llKey(points.get(0)));
            }
            if (duplicates.contains(TravelObfGpxTrackOptimizer.llKey(points.get(points.size() - 2)))) {
                duplicates.add(TravelObfGpxTrackOptimizer.llKey(points.get(points.size() - 1)));
            }
        }
    }

    private static void joinCleanedSegments(List<TrkSegment> segmentsToJoin, List<TrkSegment> joinedSegments) {
        boolean[] done = new boolean[segmentsToJoin.size()];
        while (true) {
            ArrayList<WptPt> result = new ArrayList<WptPt>();
            for (int i = 0; i < segmentsToJoin.size(); ++i) {
                boolean stop;
                if (done[i]) continue;
                done[i] = true;
                if (segmentsToJoin.get(i).getPoints().isEmpty()) continue;
                TravelObfGpxTrackOptimizer.addSegmentToResult(result, false, segmentsToJoin.get(i), false);
                do {
                    stop = true;
                    for (int j = 0; j < segmentsToJoin.size(); ++j) {
                        if (done[j] || !TravelObfGpxTrackOptimizer.considerSegmentToJoin(result, segmentsToJoin.get(j))) continue;
                        done[j] = true;
                        stop = false;
                    }
                } while (!stop);
                break;
            }
            if (result.isEmpty()) break;
            TrkSegment joined = new TrkSegment();
            joined.getPoints().addAll(result);
            joinedSegments.add(joined);
        }
    }

    private static void addSegmentToResult(List<WptPt> result, boolean insert, TrkSegment segment, boolean reverse) {
        ArrayList<WptPt> points = new ArrayList<WptPt>();
        for (WptPt wpt : segment.getPoints()) {
            points.add(new WptPt(wpt.getLatitude(), wpt.getLongitude()));
        }
        if (reverse) {
            Collections.reverse(points);
        }
        if (insert) {
            boolean skipTrailingPoint = !result.isEmpty() && !points.isEmpty() && TravelObfGpxTrackOptimizer.equalWptPts((WptPt)points.get(points.size() - 1), result.get(0));
            result.addAll(0, points.subList(0, points.size() - (skipTrailingPoint ? 1 : 0)));
        } else {
            boolean skipLeadingPoint = !result.isEmpty() && !points.isEmpty() && TravelObfGpxTrackOptimizer.equalWptPts((WptPt)points.get(0), result.get(result.size() - 1));
            result.addAll(result.size(), points.subList(skipLeadingPoint ? 1 : 0, points.size()));
        }
    }

    private static boolean considerSegmentToJoin(List<WptPt> result, TrkSegment candidate) {
        boolean avoidClosedLoop;
        if (result.isEmpty()) {
            return false;
        }
        if (candidate.getPoints().isEmpty()) {
            return true;
        }
        WptPt firstPoint = result.get(0);
        WptPt lastPoint = result.get(result.size() - 1);
        WptPt firstCandidate = (WptPt)candidate.getPoints().get(0);
        WptPt lastCandidate = (WptPt)candidate.getPoints().get(candidate.getPoints().size() - 1);
        boolean bl = avoidClosedLoop = result.size() > 1 && TravelObfGpxTrackOptimizer.equalWptPts(firstPoint, lastPoint) || candidate.getPoints().size() > 1 && TravelObfGpxTrackOptimizer.equalWptPts(firstCandidate, lastCandidate);
        if (avoidClosedLoop) {
            return false;
        }
        if (TravelObfGpxTrackOptimizer.closeWptPts(lastPoint, firstCandidate)) {
            TravelObfGpxTrackOptimizer.addSegmentToResult(result, false, candidate, false);
        } else if (TravelObfGpxTrackOptimizer.closeWptPts(lastPoint, lastCandidate)) {
            TravelObfGpxTrackOptimizer.addSegmentToResult(result, false, candidate, true);
        } else if (TravelObfGpxTrackOptimizer.closeWptPts(firstPoint, firstCandidate)) {
            TravelObfGpxTrackOptimizer.addSegmentToResult(result, true, candidate, true);
        } else if (TravelObfGpxTrackOptimizer.closeWptPts(firstPoint, lastCandidate)) {
            TravelObfGpxTrackOptimizer.addSegmentToResult(result, true, candidate, false);
        } else {
            return false;
        }
        return true;
    }

    private static boolean equalWptPts(WptPt p1, WptPt p2) {
        return KMapUtils.INSTANCE.areLatLonEqual(p1.getLatitude(), p1.getLongitude(), p2.getLatitude(), p2.getLongitude(), 1.0E-5);
    }

    private static boolean closeWptPts(WptPt p1, WptPt p2) {
        return KMapUtils.INSTANCE.areLatLonEqual(p1.getLatitude(), p1.getLongitude(), p2.getLatitude(), p2.getLongitude(), 5.0E-4);
    }

    private static String llKey(WptPt edge) {
        return (int)(edge.getLatitude() / 1.0E-5) + "," + (int)(edge.getLongitude() / 1.0E-5);
    }
}

