/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.wiki.wikidata;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.osmand.PlatformUtil;
import org.apache.commons.logging.Log;

public class ArticleMapper
implements JsonDeserializer<Article> {
    private static final long ERROR_BATCH_SIZE = 5000L;
    public static final String LABELS_KEY = "labels";
    public static final String SITELINKS_KEY = "sitelinks";
    public static final String TITLE_KEY = "title";
    public static final String CLAIMS_KEY = "claims";
    public static final String MAINSNAK_KEY = "mainsnak";
    public static final String DATAVALUE_KEY = "datavalue";
    public static final String VALUE_KEY = "value";
    public static final String LATITUDE_KEY = "latitude";
    public static final String LONGITUDE_KEY = "longitude";
    public static final String LANGUAGE_KEY = "language";
    private static int errorCount;
    private static final Log log;
    public static final String[] PROP_IMAGE;
    public static final String PROP_COMMON_CAT = "P373";
    private final String PROP_COMMON_COORDS = "P625";

    public Article deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        Article article;
        block13: {
            article = new Article();
            try {
                JsonArray links;
                JsonElement object;
                JsonObject obj = (JsonObject)json;
                JsonElement oClaims = obj.get(CLAIMS_KEY);
                if (oClaims instanceof JsonObject) {
                    JsonObject ccDataValue;
                    JsonArray propCommonCat;
                    JsonObject coordinatesDataValue;
                    JsonObject claims = obj.getAsJsonObject(CLAIMS_KEY);
                    JsonArray propCoords = claims.getAsJsonArray("P625");
                    if (propCoords != null && (coordinatesDataValue = propCoords.get(0).getAsJsonObject().getAsJsonObject(MAINSNAK_KEY).getAsJsonObject(DATAVALUE_KEY)) != null) {
                        JsonObject coordinates = coordinatesDataValue.getAsJsonObject(VALUE_KEY);
                        double lat = coordinates.getAsJsonPrimitive(LATITUDE_KEY).getAsDouble();
                        double lon = coordinates.getAsJsonPrimitive(LONGITUDE_KEY).getAsDouble();
                        article.setLat(lat);
                        article.setLon(lon);
                    }
                    for (JsonObject property : PROP_IMAGE) {
                        JsonArray propImage = claims.getAsJsonArray((String)property);
                        if (propImage == null) continue;
                        JsonObject imageDataValue = propImage.get(0).getAsJsonObject().getAsJsonObject(MAINSNAK_KEY).getAsJsonObject(DATAVALUE_KEY);
                        if (imageDataValue == null) break;
                        String image = imageDataValue.getAsJsonPrimitive(VALUE_KEY).getAsString();
                        article.setImage(image);
                        article.setImageProp((String)property);
                        break;
                    }
                    if ((propCommonCat = claims.getAsJsonArray(PROP_COMMON_CAT)) != null && (ccDataValue = propCommonCat.get(0).getAsJsonObject().getAsJsonObject(MAINSNAK_KEY).getAsJsonObject(DATAVALUE_KEY)) != null) {
                        String commonCat = ccDataValue.getAsJsonPrimitive(VALUE_KEY).getAsString();
                        article.setCommonCat(commonCat);
                    }
                }
                if ((object = obj.get(SITELINKS_KEY)) instanceof JsonObject) {
                    JsonObject links2 = (JsonObject)object;
                    ArrayList<SiteLink> siteLinks = new ArrayList<SiteLink>();
                    for (Map.Entry entry : links2.entrySet()) {
                        JsonObject jsonObject;
                        JsonPrimitive title;
                        String lang = ((String)entry.getKey()).replace("wiki", "");
                        if ("commons".equals(lang) || (title = (jsonObject = ((JsonElement)entry.getValue()).getAsJsonObject()).getAsJsonPrimitive(TITLE_KEY)) == null) continue;
                        siteLinks.add(new SiteLink(lang, title.getAsString()));
                    }
                    article.setSiteLinks(siteLinks);
                } else if (object instanceof JsonArray && !(links = (JsonArray)object).isEmpty()) {
                    throw new IllegalArgumentException("Unexpected sitelinks array format");
                }
                object = obj.get(LABELS_KEY);
                if (object instanceof JsonObject) {
                    JsonObject labels = (JsonObject)object;
                    LinkedHashMap<String, String> labelMap = new LinkedHashMap<String, String>();
                    for (Map.Entry entry : labels.entrySet()) {
                        JsonObject jsonObject = ((JsonElement)entry.getValue()).getAsJsonObject();
                        JsonPrimitive langPrim = jsonObject.getAsJsonPrimitive(LANGUAGE_KEY);
                        JsonPrimitive valuePrim = jsonObject.getAsJsonPrimitive(VALUE_KEY);
                        if (langPrim == null || valuePrim == null) continue;
                        String lang = langPrim.getAsString();
                        String value = valuePrim.getAsString();
                        if (lang.isEmpty() || value.isEmpty()) continue;
                        labelMap.put(lang, value);
                    }
                    article.setLabels(labelMap);
                }
            }
            catch (Exception e) {
                if ((long)(++errorCount) == 5000L) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
                if ((long)errorCount % 5000L != 0L) break block13;
                log.error((Object)String.format("Error json pages %s (total %d)", json.toString(), errorCount));
            }
        }
        return article;
    }

    static {
        log = PlatformUtil.getLog(ArticleMapper.class);
        PROP_IMAGE = new String[]{"P18", "P180"};
    }

    public static class Article {
        private List<SiteLink> siteLinks = new ArrayList<SiteLink>();
        private double lat;
        private double lon;
        private String image;
        private String imageProp;
        private String commonCat;
        private Map<String, String> labels;

        public List<SiteLink> getSiteLinks() {
            return this.siteLinks;
        }

        public double getLon() {
            return this.lon;
        }

        public double getLat() {
            return this.lat;
        }

        public String getImage() {
            return this.image;
        }

        public String getCommonCat() {
            return this.commonCat;
        }

        public void setLon(double lon) {
            this.lon = lon;
        }

        public void setLat(double lat) {
            this.lat = lat;
        }

        public void setSiteLinks(List<SiteLink> siteLinks) {
            this.siteLinks = siteLinks;
        }

        public void setImage(String img) {
            this.image = img;
        }

        public void setCommonCat(String cc) {
            this.commonCat = cc;
        }

        public String getImageProp() {
            return this.imageProp;
        }

        public void setImageProp(String imageProp) {
            this.imageProp = imageProp;
        }

        public Map<String, String> getLabels() {
            return this.labels;
        }

        public void setLabels(Map<String, String> labels) {
            this.labels = labels;
        }
    }

    record SiteLink(String lang, String title) {
    }
}

