/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.gpx;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.osmand.data.QuadRect;
import net.osmand.gpx.GPXTrackAnalysis;
import net.osmand.gpx.GPXUtilities;
import net.osmand.gpx.SplitSegment;
import net.osmand.util.Algorithms;
import net.osmand.util.MapUtils;

@Deprecated
public class GPXFile
extends GPXUtilities.GPXExtensions {
    public String author;
    public GPXUtilities.Metadata metadata = new GPXUtilities.Metadata();
    public List<GPXUtilities.Track> tracks = new ArrayList<GPXUtilities.Track>();
    public List<GPXUtilities.Route> routes = new ArrayList<GPXUtilities.Route>();
    final List<GPXUtilities.WptPt> points = new ArrayList<GPXUtilities.WptPt>();
    Map<String, GPXUtilities.PointsGroup> pointsGroups = new LinkedHashMap<String, GPXUtilities.PointsGroup>();
    final Map<String, String> networkRouteKeyTags = new LinkedHashMap<String, String>();
    public Exception error = null;
    public String path = "";
    public boolean showCurrentTrack;
    public boolean hasAltitude;
    public long modifiedTime = 0L;
    public long pointsModifiedTime = 0L;
    private GPXUtilities.Track generalTrack;
    private GPXUtilities.TrkSegment generalSegment;

    public GPXFile(String author) {
        this.author = author;
    }

    public GPXFile(String title, String lang, String description) {
        if (description != null) {
            this.metadata.desc = description;
        }
        if (lang != null) {
            this.metadata.getExtensionsToWrite().put("article_lang", lang);
        }
        if (title != null) {
            this.metadata.getExtensionsToWrite().put("article_title", title);
        }
    }

    public boolean hasRoute() {
        return this.getNonEmptyTrkSegments(true).size() > 0;
    }

    public List<GPXUtilities.WptPt> getAllPoints() {
        ArrayList<GPXUtilities.WptPt> total = new ArrayList<GPXUtilities.WptPt>();
        total.addAll(this.getPoints());
        total.addAll(this.getAllSegmentsPoints());
        return total;
    }

    public List<GPXUtilities.WptPt> getPoints() {
        return Collections.unmodifiableList(this.points);
    }

    public List<GPXUtilities.WptPt> getAllSegmentsPoints() {
        ArrayList<GPXUtilities.WptPt> points = new ArrayList<GPXUtilities.WptPt>();
        for (GPXUtilities.Track track : this.tracks) {
            if (track.generalTrack) continue;
            for (GPXUtilities.TrkSegment segment : track.segments) {
                if (segment.generalSegment) continue;
                points.addAll(segment.points);
            }
        }
        return points;
    }

    public boolean isPointsEmpty() {
        return this.points.isEmpty();
    }

    public int getPointsSize() {
        return this.points.size();
    }

    public boolean containsPoint(GPXUtilities.WptPt point) {
        return this.points.contains(point);
    }

    public void clearPoints() {
        this.points.clear();
        this.pointsGroups.clear();
        this.pointsModifiedTime = this.modifiedTime = System.currentTimeMillis();
    }

    public void addParsedPoint(GPXUtilities.WptPt point) {
        this.points.add(point);
    }

    public void addPoint(GPXUtilities.WptPt point) {
        this.points.add(point);
        this.addPointsToGroups(Collections.singleton(point));
        this.pointsModifiedTime = this.modifiedTime = System.currentTimeMillis();
    }

    public void addPoint(int position, GPXUtilities.WptPt point) {
        this.points.add(position, point);
        this.addPointsToGroups(Collections.singleton(point));
        this.pointsModifiedTime = this.modifiedTime = System.currentTimeMillis();
    }

    public void addPoints(Collection<? extends GPXUtilities.WptPt> collection) {
        this.points.addAll(collection);
        this.addPointsToGroups(collection);
        this.pointsModifiedTime = this.modifiedTime = System.currentTimeMillis();
    }

    public void addPointsGroup(GPXUtilities.PointsGroup group) {
        this.points.addAll(group.points);
        this.pointsGroups.put(group.name, group);
        this.pointsModifiedTime = this.modifiedTime = System.currentTimeMillis();
    }

    public void setPointsGroups(Map<String, GPXUtilities.PointsGroup> groups) {
        this.pointsGroups = groups;
    }

    private void addPointsToGroups(Collection<? extends GPXUtilities.WptPt> collection) {
        for (GPXUtilities.WptPt wptPt : collection) {
            GPXUtilities.PointsGroup pointsGroup = this.getOrCreateGroup(wptPt);
            pointsGroup.points.add(wptPt);
        }
    }

    private GPXUtilities.PointsGroup getOrCreateGroup(GPXUtilities.WptPt point) {
        if (point.category == null && this.pointsGroups.containsKey("")) {
            return this.pointsGroups.get("");
        }
        if (this.pointsGroups.containsKey(point.category)) {
            return this.pointsGroups.get(point.category);
        }
        GPXUtilities.PointsGroup pointsGroup = new GPXUtilities.PointsGroup(point);
        this.pointsGroups.put(pointsGroup.name, pointsGroup);
        return pointsGroup;
    }

    public boolean deleteWptPt(GPXUtilities.WptPt point) {
        this.removePointFromGroup(point);
        this.pointsModifiedTime = this.modifiedTime = System.currentTimeMillis();
        return this.points.remove(point);
    }

    public boolean deleteWptPt(String wptName, int index) {
        GPXUtilities.WptPt currentWpt = this.getWptPt(wptName, index);
        if (currentWpt != null) {
            return this.deleteWptPt(currentWpt);
        }
        return false;
    }

    private void removePointFromGroup(GPXUtilities.WptPt point) {
        this.removePointFromGroup(point, point.category);
    }

    private void removePointFromGroup(GPXUtilities.WptPt point, String groupName) {
        GPXUtilities.PointsGroup group = this.pointsGroups.get(groupName);
        if (group != null) {
            group.points.remove(point);
        }
    }

    public void updateWptPt(String wptName, int wptIndex, GPXUtilities.WptPt newWpt, boolean updateTimestamp) {
        GPXUtilities.WptPt currentWpt = this.getWptPt(wptName, wptIndex);
        if (currentWpt != null) {
            this.updateWptPt(currentWpt, newWpt, updateTimestamp);
        } else {
            this.addPoint(newWpt);
        }
    }

    private GPXUtilities.WptPt getWptPt(String wptName, int wptIndex) {
        GPXUtilities.WptPt currentWpt = null;
        if (wptIndex < this.points.size() && wptIndex >= 0) {
            currentWpt = this.points.get(wptIndex);
            if (!currentWpt.name.equals(wptName)) {
                currentWpt = null;
            }
        }
        return currentWpt;
    }

    public void updateWptPt(GPXUtilities.WptPt existingPoint, GPXUtilities.WptPt newWpt, boolean updateTimestamp) {
        int index = this.points.indexOf(existingPoint);
        if (index == -1) {
            return;
        }
        String prevGroupName = existingPoint.category == null ? "" : existingPoint.category;
        long prevTime = existingPoint.time;
        existingPoint.updatePoint(newWpt);
        if (!updateTimestamp) {
            existingPoint.time = prevTime;
        }
        if (Algorithms.stringsEqual(newWpt.category, prevGroupName) || Algorithms.isEmpty(newWpt.category) && Algorithms.isEmpty(prevGroupName)) {
            this.removePointFromGroup(existingPoint, prevGroupName);
            GPXUtilities.PointsGroup pointsGroup = this.getOrCreateGroup(existingPoint);
            pointsGroup.points.add(existingPoint);
        }
        this.pointsModifiedTime = this.modifiedTime = System.currentTimeMillis();
    }

    public void updateWptPt(GPXUtilities.WptPt existingPoint, GPXUtilities.WptPt newWpt) {
        this.updateWptPt(existingPoint, newWpt, true);
    }

    public void updatePointsGroup(String prevGroupName, GPXUtilities.PointsGroup pointsGroup) {
        this.pointsGroups.remove(prevGroupName);
        this.pointsGroups.put(pointsGroup.name, pointsGroup);
        this.modifiedTime = System.currentTimeMillis();
    }

    public boolean isCloudmadeRouteFile() {
        return "cloudmade".equalsIgnoreCase(this.author);
    }

    public boolean hasGeneralTrack() {
        return this.generalTrack != null;
    }

    public void addGeneralTrack() {
        GPXUtilities.Track generalTrack = this.getGeneralTrack();
        if (generalTrack != null && !this.tracks.contains(generalTrack)) {
            this.tracks.add(0, generalTrack);
        }
    }

    public GPXUtilities.Track getGeneralTrack() {
        GPXUtilities.TrkSegment generalSegment = this.getGeneralSegment();
        if (this.generalTrack == null && generalSegment != null) {
            GPXUtilities.Track track = new GPXUtilities.Track();
            track.segments = new ArrayList<GPXUtilities.TrkSegment>();
            track.segments.add(generalSegment);
            this.generalTrack = track;
            track.generalTrack = true;
        }
        return this.generalTrack;
    }

    public GPXUtilities.TrkSegment getGeneralSegment() {
        if (this.generalSegment == null && this.getNonEmptySegmentsCount() > 1) {
            this.buildGeneralSegment();
        }
        return this.generalSegment;
    }

    private void buildGeneralSegment() {
        GPXUtilities.TrkSegment segment = new GPXUtilities.TrkSegment();
        for (GPXUtilities.Track track : this.tracks) {
            for (GPXUtilities.TrkSegment trkSegment : track.segments) {
                if (trkSegment.points.size() <= 0) continue;
                ArrayList<GPXUtilities.WptPt> waypoints = new ArrayList<GPXUtilities.WptPt>(trkSegment.points.size());
                for (GPXUtilities.WptPt wptPt : trkSegment.points) {
                    waypoints.add(new GPXUtilities.WptPt(wptPt));
                }
                ((GPXUtilities.WptPt)waypoints.get((int)0)).firstPoint = true;
                ((GPXUtilities.WptPt)waypoints.get((int)(waypoints.size() - 1))).lastPoint = true;
                segment.points.addAll(waypoints);
            }
        }
        if (segment.points.size() > 0) {
            segment.generalSegment = true;
            this.generalSegment = segment;
        }
    }

    public GPXTrackAnalysis getAnalysis(long fileTimestamp) {
        return this.getAnalysis(fileTimestamp, null, null, null);
    }

    public GPXTrackAnalysis getAnalysis(long fileTimestamp, Double fromDistance, Double toDistance, GPXTrackAnalysis.TrackPointsAnalyser pointsAnalyzer) {
        GPXTrackAnalysis analysis = new GPXTrackAnalysis();
        analysis.name = this.path;
        analysis.setWptPoints(this.points.size());
        analysis.setWptCategoryNames(this.getWaypointCategories());
        List<SplitSegment> segments = this.getSplitSegments(analysis, fromDistance, toDistance);
        analysis.prepareInformation(fileTimestamp, pointsAnalyzer, segments.toArray(new SplitSegment[0]));
        return analysis;
    }

    private List<SplitSegment> getSplitSegments(GPXTrackAnalysis analysis, Double fromDistance, Double toDistance) {
        ArrayList<SplitSegment> splitSegments = new ArrayList<SplitSegment>();
        for (int i = 0; i < this.tracks.size(); ++i) {
            GPXUtilities.Track subtrack = this.tracks.get(i);
            for (GPXUtilities.TrkSegment segment : subtrack.segments) {
                if (segment.generalSegment) continue;
                int totalTracks = analysis.getTotalTracks();
                analysis.setTotalTracks(totalTracks + 1);
                if (segment.points.size() <= 1) continue;
                splitSegments.add(this.createSplitSegment(segment, fromDistance, toDistance));
            }
        }
        return splitSegments;
    }

    private SplitSegment createSplitSegment(GPXUtilities.TrkSegment segment, Double fromDistance, Double toDistance) {
        if (fromDistance != null && toDistance != null) {
            int startInd = this.getPointIndexByDistance(segment.points, fromDistance);
            int endInd = this.getPointIndexByDistance(segment.points, toDistance);
            return new SplitSegment(startInd, endInd, segment);
        }
        return new SplitSegment(segment);
    }

    public int getPointIndexByDistance(List<GPXUtilities.WptPt> points, double distance) {
        int index = 0;
        double minDistanceChange = Double.MAX_VALUE;
        for (int i = 0; i < points.size(); ++i) {
            GPXUtilities.WptPt point = points.get(i);
            double currentDistanceChange = Math.abs(point.distance - distance);
            if (!(currentDistanceChange < minDistanceChange)) continue;
            minDistanceChange = currentDistanceChange;
            index = i;
        }
        return index;
    }

    public boolean containsRoutePoint(GPXUtilities.WptPt point) {
        return this.getRoutePoints().contains(point);
    }

    public List<GPXUtilities.WptPt> getRoutePoints() {
        ArrayList<GPXUtilities.WptPt> points = new ArrayList<GPXUtilities.WptPt>();
        for (int i = 0; i < this.routes.size(); ++i) {
            GPXUtilities.Route rt = this.routes.get(i);
            points.addAll(rt.points);
        }
        return points;
    }

    public List<GPXUtilities.WptPt> getRoutePoints(int routeIndex) {
        ArrayList<GPXUtilities.WptPt> points = new ArrayList<GPXUtilities.WptPt>();
        if (this.routes.size() > routeIndex) {
            GPXUtilities.Route rt = this.routes.get(routeIndex);
            points.addAll(rt.points);
        }
        return points;
    }

    public boolean isAttachedToRoads() {
        List<GPXUtilities.WptPt> points = this.getRoutePoints();
        if (!Algorithms.isEmpty(points)) {
            for (GPXUtilities.WptPt wptPt : points) {
                if (!Algorithms.isEmpty(wptPt.getProfileType())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean hasRtePt() {
        for (GPXUtilities.Route r : this.routes) {
            if (r.points.size() <= 0) continue;
            return true;
        }
        return false;
    }

    public boolean hasWptPt() {
        return this.points.size() > 0;
    }

    public boolean hasTrkPt() {
        for (GPXUtilities.Track t : this.tracks) {
            for (GPXUtilities.TrkSegment ts : t.segments) {
                if (ts.points.size() <= 0) continue;
                return true;
            }
        }
        return false;
    }

    public List<GPXUtilities.TrkSegment> getNonEmptyTrkSegments(boolean routesOnly) {
        ArrayList<GPXUtilities.TrkSegment> segments = new ArrayList<GPXUtilities.TrkSegment>();
        for (GPXUtilities.Track t : this.tracks) {
            for (GPXUtilities.TrkSegment s : t.segments) {
                if (s.generalSegment || s.points.size() <= 0 || routesOnly && !s.hasRoute()) continue;
                segments.add(s);
            }
        }
        return segments;
    }

    public void addTrkSegment(List<GPXUtilities.WptPt> points) {
        this.removeGeneralTrackIfExists();
        GPXUtilities.TrkSegment segment = new GPXUtilities.TrkSegment();
        segment.points.addAll(points);
        if (this.tracks.size() == 0) {
            this.tracks.add(new GPXUtilities.Track());
        }
        GPXUtilities.Track lastTrack = this.tracks.get(this.tracks.size() - 1);
        lastTrack.segments.add(segment);
        this.modifiedTime = System.currentTimeMillis();
    }

    public boolean replaceSegment(GPXUtilities.TrkSegment oldSegment, GPXUtilities.TrkSegment newSegment) {
        this.removeGeneralTrackIfExists();
        for (int i = 0; i < this.tracks.size(); ++i) {
            GPXUtilities.Track currentTrack = this.tracks.get(i);
            for (int j = 0; j < currentTrack.segments.size(); ++j) {
                int segmentIndex = currentTrack.segments.indexOf(oldSegment);
                if (segmentIndex == -1) continue;
                currentTrack.segments.remove(segmentIndex);
                currentTrack.segments.add(segmentIndex, newSegment);
                this.addGeneralTrack();
                this.modifiedTime = System.currentTimeMillis();
                return true;
            }
        }
        this.addGeneralTrack();
        return false;
    }

    public void addRoutePoints(List<GPXUtilities.WptPt> points, boolean addRoute) {
        if (this.routes.size() == 0 || addRoute) {
            GPXUtilities.Route route = new GPXUtilities.Route();
            this.routes.add(route);
        }
        GPXUtilities.Route lastRoute = this.routes.get(this.routes.size() - 1);
        lastRoute.points.addAll(points);
        this.pointsModifiedTime = this.modifiedTime = System.currentTimeMillis();
    }

    public void replaceRoutePoints(List<GPXUtilities.WptPt> points) {
        this.routes.clear();
        this.routes.add(new GPXUtilities.Route());
        GPXUtilities.Route currentRoute = this.routes.get(this.routes.size() - 1);
        currentRoute.points.addAll(points);
        this.pointsModifiedTime = this.modifiedTime = System.currentTimeMillis();
    }

    private void removeGeneralTrackIfExists() {
        if (this.generalTrack != null) {
            this.tracks.remove(this.generalTrack);
            this.generalTrack = null;
            this.generalSegment = null;
        }
    }

    public boolean removeTrkSegment(GPXUtilities.TrkSegment segment) {
        this.removeGeneralTrackIfExists();
        for (int i = 0; i < this.tracks.size(); ++i) {
            GPXUtilities.Track currentTrack = this.tracks.get(i);
            for (int j = 0; j < currentTrack.segments.size(); ++j) {
                if (!currentTrack.segments.remove(segment)) continue;
                this.addGeneralTrack();
                this.modifiedTime = System.currentTimeMillis();
                return true;
            }
        }
        this.addGeneralTrack();
        return false;
    }

    public boolean deleteRtePt(GPXUtilities.WptPt pt) {
        this.pointsModifiedTime = this.modifiedTime = System.currentTimeMillis();
        for (GPXUtilities.Route route : this.routes) {
            if (!route.points.remove(pt)) continue;
            return true;
        }
        return false;
    }

    public List<GPXUtilities.TrkSegment> processRoutePoints() {
        ArrayList<GPXUtilities.TrkSegment> tpoints = new ArrayList<GPXUtilities.TrkSegment>();
        if (this.routes.size() > 0) {
            for (GPXUtilities.Route r : this.routes) {
                int routeColor = r.getColor(this.getColor(0));
                if (r.points.size() <= 0) continue;
                GPXUtilities.TrkSegment sgmt = new GPXUtilities.TrkSegment();
                tpoints.add(sgmt);
                sgmt.points.addAll(r.points);
                sgmt.setColor(routeColor);
            }
        }
        return tpoints;
    }

    public List<GPXUtilities.TrkSegment> proccessPoints() {
        ArrayList<GPXUtilities.TrkSegment> tpoints = new ArrayList<GPXUtilities.TrkSegment>();
        for (GPXUtilities.Track t : this.tracks) {
            int trackColor = t.getColor(this.getColor(0));
            for (GPXUtilities.TrkSegment ts : t.segments) {
                if (ts.generalSegment || ts.points.size() <= 0) continue;
                GPXUtilities.TrkSegment sgmt = new GPXUtilities.TrkSegment();
                tpoints.add(sgmt);
                sgmt.points.addAll(ts.points);
                sgmt.setColor(trackColor);
            }
        }
        return tpoints;
    }

    public GPXUtilities.WptPt getLastPoint() {
        if (this.tracks.size() > 0) {
            GPXUtilities.Track tk = this.tracks.get(this.tracks.size() - 1);
            if (tk.segments.size() > 0) {
                GPXUtilities.TrkSegment ts = tk.segments.get(tk.segments.size() - 1);
                if (ts.points.size() > 0) {
                    return ts.points.get(ts.points.size() - 1);
                }
            }
        }
        return null;
    }

    public GPXUtilities.WptPt findPointToShow() {
        for (GPXUtilities.Track track : this.tracks) {
            for (GPXUtilities.TrkSegment segment : track.segments) {
                if (segment.points.size() <= 0) continue;
                return segment.points.get(0);
            }
        }
        for (GPXUtilities.Route route : this.routes) {
            if (route.points.size() <= 0) continue;
            return route.points.get(0);
        }
        if (this.points.size() > 0) {
            return this.points.get(0);
        }
        return null;
    }

    public boolean isEmpty() {
        for (GPXUtilities.Track t : this.tracks) {
            if (t.segments == null) continue;
            for (GPXUtilities.TrkSegment s : t.segments) {
                boolean tracksEmpty = s.points.isEmpty();
                if (tracksEmpty) continue;
                return false;
            }
        }
        return this.points.isEmpty() && this.routes.isEmpty();
    }

    public List<GPXUtilities.Track> getTracks(boolean includeGeneralTrack) {
        ArrayList<GPXUtilities.Track> tracks = new ArrayList<GPXUtilities.Track>();
        for (GPXUtilities.Track track : this.tracks) {
            if (!includeGeneralTrack && track.generalTrack) continue;
            tracks.add(track);
        }
        return tracks;
    }

    public List<GPXUtilities.TrkSegment> getSegments(boolean includeGeneralTrack) {
        ArrayList<GPXUtilities.TrkSegment> segments = new ArrayList<GPXUtilities.TrkSegment>();
        for (GPXUtilities.Track track : this.tracks) {
            if (!includeGeneralTrack && track.generalTrack) continue;
            segments.addAll(track.segments);
        }
        return segments;
    }

    public int getTracksCount() {
        int count = 0;
        for (GPXUtilities.Track track : this.tracks) {
            if (track.generalTrack) continue;
            ++count;
        }
        return count;
    }

    public int getNonEmptyTracksCount() {
        int count = 0;
        block0: for (GPXUtilities.Track track : this.tracks) {
            for (GPXUtilities.TrkSegment segment : track.segments) {
                if (segment.points.size() <= 0) continue;
                ++count;
                continue block0;
            }
        }
        return count;
    }

    public int getNonEmptySegmentsCount() {
        int count = 0;
        for (GPXUtilities.Track t : this.tracks) {
            for (GPXUtilities.TrkSegment s : t.segments) {
                if (s.points.size() <= 0) continue;
                ++count;
            }
        }
        return count;
    }

    public Set<String> getWaypointCategories() {
        return new HashSet<String>(this.pointsGroups.keySet());
    }

    public Map<String, GPXUtilities.PointsGroup> getPointsGroups() {
        return this.pointsGroups;
    }

    public List<GPXUtilities.Route> getRoutes() {
        return this.routes;
    }

    public GPXUtilities.Route getRouteByName(String name) {
        for (GPXUtilities.Route route : this.getRoutes()) {
            if (!Algorithms.stringsEqual(route.name, name)) continue;
            return route;
        }
        return null;
    }

    public QuadRect getRect() {
        return this.getBounds(0.0, 0.0);
    }

    public QuadRect getBounds(double defaultMissingLat, double defaultMissingLon) {
        QuadRect qr = new QuadRect(defaultMissingLon, defaultMissingLat, defaultMissingLon, defaultMissingLat);
        for (GPXUtilities.Track track : this.tracks) {
            for (GPXUtilities.TrkSegment segment : track.segments) {
                for (GPXUtilities.WptPt p : segment.points) {
                    GPXUtilities.updateQR(qr, p, defaultMissingLat, defaultMissingLon);
                }
            }
        }
        for (GPXUtilities.WptPt p : this.points) {
            GPXUtilities.updateQR(qr, p, defaultMissingLat, defaultMissingLon);
        }
        for (GPXUtilities.Route route : this.routes) {
            for (GPXUtilities.WptPt p : route.points) {
                GPXUtilities.updateQR(qr, p, defaultMissingLat, defaultMissingLon);
            }
        }
        return qr;
    }

    public String getColoringType() {
        if (this.extensions != null) {
            return (String)this.extensions.get("coloring_type");
        }
        return null;
    }

    public String getGradientScaleType() {
        if (this.extensions != null) {
            return (String)this.extensions.get("gradient_scale_type");
        }
        return null;
    }

    public String getGradientColorPalette() {
        if (this.extensions != null) {
            return (String)this.extensions.get("color_palette");
        }
        return null;
    }

    public void setGradientColorPalette(String gradientColorPaletteName) {
        this.getExtensionsToWrite().put("color_palette", gradientColorPaletteName);
    }

    public void setColoringType(String coloringType) {
        this.getExtensionsToWrite().put("coloring_type", coloringType);
    }

    public void removeGradientScaleType() {
        this.getExtensionsToWrite().remove("gradient_scale_type");
    }

    public String getSplitType() {
        if (this.extensions != null) {
            return (String)this.extensions.get("split_type");
        }
        return null;
    }

    public void setSplitType(String gpxSplitType) {
        this.getExtensionsToWrite().put("split_type", gpxSplitType);
    }

    public double getSplitInterval() {
        String splitIntervalStr;
        if (this.extensions != null && !Algorithms.isEmpty(splitIntervalStr = (String)this.extensions.get("split_interval"))) {
            try {
                return Double.parseDouble(splitIntervalStr);
            }
            catch (NumberFormatException e) {
                GPXUtilities.log.error((Object)"Error reading split_interval", (Throwable)e);
            }
        }
        return 0.0;
    }

    public void setSplitInterval(double splitInterval) {
        this.getExtensionsToWrite().put("split_interval", String.valueOf(splitInterval));
    }

    public String getWidth(String defWidth) {
        String widthValue = null;
        if (this.extensions != null) {
            widthValue = (String)this.extensions.get("width");
        }
        return widthValue != null ? widthValue : defWidth;
    }

    public void setWidth(String width) {
        this.getExtensionsToWrite().put("width", width);
    }

    public boolean isShowArrowsSet() {
        return this.extensions != null && this.extensions.containsKey("show_arrows");
    }

    public boolean isShowArrows() {
        String showArrows = null;
        if (this.extensions != null) {
            showArrows = (String)this.extensions.get("show_arrows");
        }
        return Boolean.parseBoolean(showArrows);
    }

    public void setShowArrows(boolean showArrows) {
        this.getExtensionsToWrite().put("show_arrows", String.valueOf(showArrows));
    }

    public String get3DVisualizationType() {
        return this.extensions == null ? null : (String)this.extensions.get("line_3d_visualization_by_type");
    }

    public void set3DVisualizationType(String visualizationType) {
        this.getExtensionsToWrite().put("line_3d_visualization_by_type", String.valueOf(visualizationType));
    }

    public String get3DWallColoringType() {
        return this.extensions == null ? null : (String)this.extensions.get("line_3d_visualization_wall_color_type");
    }

    public void set3DWallColoringType(String trackWallColoringType) {
        this.getExtensionsToWrite().put("line_3d_visualization_wall_color_type", String.valueOf(trackWallColoringType));
    }

    public String get3DLinePositionType() {
        return this.extensions == null ? null : (String)this.extensions.get("line_3d_visualization_position_type");
    }

    public void set3DLinePositionType(String trackLinePositionType) {
        this.getExtensionsToWrite().put("line_3d_visualization_position_type", String.valueOf(trackLinePositionType));
    }

    public void setAdditionalExaggeration(float additionalExaggeration) {
        this.getExtensionsToWrite().put("vertical_exaggeration_scale", String.valueOf(additionalExaggeration));
    }

    public float getAdditionalExaggeration() {
        String exaggeration = this.getExtensionsToRead().get("vertical_exaggeration_scale");
        return Algorithms.parseFloatSilently(exaggeration, 1.0f);
    }

    public void setElevationMeters(float elevation) {
        this.getExtensionsToWrite().put("elevation_meters", String.valueOf(elevation));
    }

    public float getElevationMeters() {
        String elevation = this.getExtensionsToRead().get("elevation_meters");
        return Algorithms.parseFloatSilently(elevation, 1000.0f);
    }

    public boolean isShowStartFinishSet() {
        return this.extensions != null && this.extensions.containsKey("show_start_finish");
    }

    public boolean isShowStartFinish() {
        if (this.extensions != null && this.extensions.containsKey("show_start_finish")) {
            return Boolean.parseBoolean((String)this.extensions.get("show_start_finish"));
        }
        return true;
    }

    public void setShowStartFinish(boolean showStartFinish) {
        this.getExtensionsToWrite().put("show_start_finish", String.valueOf(showStartFinish));
    }

    public void addRouteKeyTags(Map<String, String> routeKey) {
        this.networkRouteKeyTags.putAll(routeKey);
    }

    public Map<String, String> getRouteKeyTags() {
        return this.networkRouteKeyTags;
    }

    public void setRef(String ref) {
        this.getExtensionsToWrite().put("ref", ref);
    }

    public String getRef() {
        if (this.extensions != null) {
            return (String)this.extensions.get("ref");
        }
        return null;
    }

    public String getOuterRadius() {
        QuadRect rect = this.getRect();
        int radius = (int)MapUtils.getDistance(rect.bottom, rect.left, rect.top, rect.right);
        return MapUtils.convertDistToChar(radius, 'A', 5000, 2, 5);
    }

    public String getArticleTitle() {
        return this.metadata.getArticleTitle();
    }

    int getItemsToWriteSize() {
        int size = this.getPointsSize();
        for (GPXUtilities.Route route : this.routes) {
            size += route.points.size();
        }
        for (GPXUtilities.TrkSegment segment : this.getNonEmptyTrkSegments(false)) {
            size += segment.points.size();
        }
        ++size;
        if (this.metadata.author != null) {
            ++size;
        }
        if (this.metadata.copyright != null) {
            ++size;
        }
        if (this.metadata.bounds != null) {
            ++size;
        }
        size += this.getExtensionsToWrite().size();
        return size += this.getExtensionsWriters().size();
    }

    public long getLastPointTime() {
        long time = this.getLastPointTime(this.getAllSegmentsPoints());
        if (time == 0L) {
            time = this.getLastPointTime(this.getRoutePoints());
        }
        if (time == 0L) {
            time = this.getLastPointTime(this.getPoints());
        }
        return time;
    }

    private long getLastPointTime(List<GPXUtilities.WptPt> points) {
        for (int i = points.size() - 1; i >= 0; --i) {
            GPXUtilities.WptPt point = points.get(i);
            if (point.time <= 0L) continue;
            return point.time;
        }
        return 0L;
    }
}

