/*
 * Decompiled with CFR 0.152.
 */
package info.bliki.api;

import info.bliki.api.AbstractXMLParser;
import info.bliki.api.SearchResult;
import java.util.ArrayList;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class XMLSearchParser
extends AbstractXMLParser {
    private static final String SEARCH_TAG = "search";
    private static final String SIZE_ID = "size";
    private static final String SNIPPET_ID = "snippet";
    private static final String SROFFSET_ID = "sroffset";
    private static final String TIMESTAMP_ID = "timestamp";
    private static final String WORDCOUNT_ID = "wordcount";
    private SearchResult fSearchResult;
    private List<SearchResult> searchResultsList = new ArrayList<SearchResult>();
    private String srOffset = "";

    public XMLSearchParser(String xmlText) throws SAXException {
        super(xmlText);
    }

    @Override
    public void endElement(String uri, String name, String qName) {
        try {
            if ("p".equals(qName) && this.fSearchResult != null) {
                this.searchResultsList.add(this.fSearchResult);
            }
            this.fData = null;
            this.fAttributes = null;
        }
        catch (RuntimeException re) {
            re.printStackTrace();
        }
    }

    public List<SearchResult> getSearchResultList() {
        return this.searchResultsList;
    }

    public String getSrOffset() {
        if (this.srOffset == null) {
            return "";
        }
        return this.srOffset;
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) {
        String value;
        this.fAttributes = atts;
        if ("p".equals(qName)) {
            this.fSearchResult = new SearchResult();
            this.fSearchResult.setNs(this.fAttributes.getValue("ns"));
            this.fSearchResult.setTitle(this.fAttributes.getValue("title"));
            this.fSearchResult.setSize(this.fAttributes.getValue(SIZE_ID));
            this.fSearchResult.setSnippet(this.fAttributes.getValue(SNIPPET_ID));
            this.fSearchResult.setTimestamp(this.fAttributes.getValue(TIMESTAMP_ID));
            this.fSearchResult.setWordCount(this.fAttributes.getValue(WORDCOUNT_ID));
        } else if (SEARCH_TAG.equals(qName) && (value = this.fAttributes.getValue(SROFFSET_ID)) != null) {
            this.srOffset = value;
        }
        this.fData = null;
    }
}

