/*
 * Decompiled with CFR 0.152.
 */
package info.bliki.htmlcleaner;

import info.bliki.htmlcleaner.BaseToken;
import info.bliki.htmlcleaner.ContentToken;
import info.bliki.htmlcleaner.TagToken;
import info.bliki.htmlcleaner.XmlSerializer;
import info.bliki.wiki.filter.ITextConverter;
import info.bliki.wiki.filter.PlainTextConvertable;
import info.bliki.wiki.model.IWikiModel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class TagNode
extends TagToken
implements PlainTextConvertable {
    public static final String[] ALLOWED_ATTRIBUTES = new String[]{"title", "align", "lang", "dir", "width", "height", "bgcolor", "clear", "noshade", "cite", "size", "face", "color", "type", "start", "value", "compact", "summary", "width", "border", "frame", "rules", "cellspacing", "cellpadding", "valign", "char", "charoff", "colgroup", "col", "span", "abbr", "axis", "headers", "scope", "rowspan", "colspan", "id", "class", "name", "href", "rel", "alt", "src"};
    protected static final HashSet<String> ALLOWED_ATTRIBUTES_SET = new HashSet();
    private TagNode parent;
    private Map<String, String> attributes = new TreeMap<String, String>();
    private HashMap<String, Object> objectAttributes;
    private List<Object> children = new ArrayList<Object>();
    private List<BaseToken> itemsToMove;
    private transient boolean isFormed;

    public static Set<String> getAllowedAttributes() {
        return ALLOWED_ATTRIBUTES_SET;
    }

    public static boolean addAllowedAttribute(String key) {
        return ALLOWED_ATTRIBUTES_SET.add(key);
    }

    public TagNode() {
    }

    public TagNode(String name) {
        super(name.toLowerCase());
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public Map<String, Object> getObjectAttributes() {
        return this.objectAttributes;
    }

    public List<Object> getChildren() {
        return this.children;
    }

    public TagNode getParent() {
        return this.parent;
    }

    public void setParent(TagNode parent) {
        this.parent = parent;
    }

    @Override
    public boolean addAttribute(String attName, String attValue, boolean checkXSS) {
        if (attName != null && !"".equals(attName.trim()) && attValue != null) {
            boolean checkedAttributes = true;
            String nameLowerCased = attName.toLowerCase();
            String valueLowerCased = attValue.toLowerCase();
            if (checkXSS && !TagNode.getAllowedAttributes().contains(nameLowerCased) && !this.isAllowedAttribute(nameLowerCased)) {
                checkedAttributes = false;
            }
            if (checkedAttributes && valueLowerCased.contains("javascript:")) {
                checkedAttributes = false;
            }
            if (checkedAttributes && attName.equalsIgnoreCase("style")) {
                if (valueLowerCased.contains("expression")) {
                    checkedAttributes = false;
                } else if (valueLowerCased.contains("url")) {
                    checkedAttributes = false;
                } else if (valueLowerCased.contains("tps")) {
                    checkedAttributes = false;
                }
            }
            if (checkedAttributes) {
                this.attributes.put(nameLowerCased, attValue);
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isAllowedAttribute(String attName) {
        return false;
    }

    public void addObjectAttribute(String attName, Object attValue) {
        if (attName != null && attValue != null) {
            if (this.objectAttributes == null) {
                this.objectAttributes = new HashMap(4);
            }
            this.objectAttributes.put(attName, attValue);
        }
    }

    public void addChild(Object child) {
        this.children.add(child);
        if (child instanceof TagNode) {
            TagNode childTagNode = (TagNode)child;
            childTagNode.parent = this;
        }
    }

    public void addChildren(List<?> children) {
        if (children != null) {
            for (Object child : children) {
                this.addChild(child);
            }
        }
    }

    public void addItemForMoving(BaseToken item) {
        if (this.itemsToMove == null) {
            this.itemsToMove = new ArrayList<BaseToken>();
        }
        this.itemsToMove.add(item);
    }

    public List<BaseToken> getItemsToMove() {
        return this.itemsToMove;
    }

    public void setItemsToMove(List<BaseToken> itemsToMove) {
        this.itemsToMove = itemsToMove;
    }

    public boolean isFormed() {
        return this.isFormed;
    }

    public void setFormed() {
        this.isFormed = true;
    }

    @Override
    public void serialize(XmlSerializer xmlSerializer) throws IOException {
        xmlSerializer.serialize(this);
    }

    public TagNode makeCopy() {
        TagNode copy = new TagNode(this.name);
        copy.attributes = this.attributes;
        copy.objectAttributes = this.objectAttributes;
        return copy;
    }

    @Override
    public Object clone() {
        TagNode tt = (TagNode)super.clone();
        tt.parent = this.parent;
        tt.itemsToMove = this.itemsToMove;
        tt.isFormed = this.isFormed;
        tt.children = new ArrayList<Object>(this.children);
        tt.attributes = new TreeMap<String, String>(this.attributes);
        tt.objectAttributes = this.objectAttributes == null ? null : new HashMap<String, Object>(this.objectAttributes);
        return tt;
    }

    @Override
    public String getParents() {
        return null;
    }

    @Override
    public void renderPlainText(ITextConverter converter, Appendable buf, IWikiModel wikiModel) throws IOException {
        List<Object> children = this.getChildren();
        for (Object child : children) {
            if (!(child instanceof PlainTextConvertable)) continue;
            ((PlainTextConvertable)child).renderPlainText(converter, buf, wikiModel);
        }
    }

    public String getBodyString() {
        List<Object> children = this.getChildren();
        if (children.size() > 0) {
            StringBuilder buf = new StringBuilder(children.size() * 16);
            for (Object child : children) {
                if (child instanceof ContentToken) {
                    buf.append(((ContentToken)child).getContent());
                    continue;
                }
                if (!(child instanceof TagNode)) continue;
                buf.append(((TagNode)child).getBodyString());
            }
            return buf.toString();
        }
        return "";
    }

    static {
        Collections.addAll(ALLOWED_ATTRIBUTES_SET, ALLOWED_ATTRIBUTES);
    }
}

