/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.util;

import java.util.ArrayList;
import java.util.List;
import net.osmand.osm.edit.Node;

public class JarvisAlgorithm {
    public static ArrayList<Node> createConvexPolygon(List<Node> points) {
        int q;
        if (points == null) {
            return null;
        }
        int n = points.size();
        if (n < 3) {
            return null;
        }
        ArrayList<Node> next = new ArrayList<Node>();
        int leftMost = 0;
        for (int i = 1; i < n; ++i) {
            if (!(points.get(i).getLatitude() < points.get(leftMost).getLatitude())) continue;
            leftMost = i;
        }
        int p = leftMost;
        next.add(points.get(p));
        int counter = 0;
        do {
            if (counter > points.size()) {
                return null;
            }
            q = (p + 1) % n;
            for (int i = 0; i < n; ++i) {
                if (!JarvisAlgorithm.orientation(points.get(p), points.get(i), points.get(q))) continue;
                q = i;
            }
            next.add(points.get(q));
            ++counter;
        } while ((p = q) != leftMost);
        return next;
    }

    public static List<Node> expandPolygon(List<Node> polygon, int meters) {
        if (polygon == null || polygon.size() < 3) {
            return polygon;
        }
        double radius = (double)meters / 111320.0;
        ArrayList<Node> expanded = new ArrayList<Node>();
        for (Node p : polygon) {
            List<Node> l = JarvisAlgorithm.findPointsAroundPoint(p, radius, 16);
            expanded.addAll(l);
        }
        return JarvisAlgorithm.createConvexPolygon(expanded);
    }

    private static boolean orientation(Node p, Node q, Node r) {
        double val = (q.getLongitude() - p.getLongitude()) * (r.getLatitude() - q.getLatitude()) - (q.getLatitude() - p.getLatitude()) * (r.getLongitude() - q.getLongitude());
        return !(val >= 0.0);
    }

    private static List<Node> findPointsAroundPoint(Node node, double radius, int numPoints) {
        ArrayList<Node> points = new ArrayList<Node>();
        double angleIncrement = Math.PI * 2 / (double)numPoints;
        for (int i = 0; i < numPoints; ++i) {
            double angle = (double)i * angleIncrement;
            double x = node.getLatitude() + radius * Math.cos(angle);
            double y = node.getLongitude() + radius * Math.sin(angle);
            x = JarvisAlgorithm.round(x);
            y = JarvisAlgorithm.round(y);
            points.add(new Node(x, y, node.getId()));
        }
        return points;
    }

    private static double round(double d) {
        return (double)Math.round(d * 100000.0) / 100000.0;
    }
}

