/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.router;

import java.util.HashMap;
import java.util.Map;
import net.osmand.binary.BinaryMapRouteReaderAdapter;
import net.osmand.binary.RouteDataObject;

public class RouteConditionalHelper {
    public static final String RULE_INT_MAX = "RULE_INT_MAX";

    public void resolveAmbiguousConditionalTags(RouteDataObject rdo, Map<String, String> ambiguousConditionalTags) {
        Object key;
        String rule;
        BinaryMapRouteReaderAdapter.RouteTypeRule r;
        HashMap<Object, Integer> existingIntValues = new HashMap<Object, Integer>();
        for (int type : rdo.types) {
            r = rdo.region.quickGetEncodingRule(type);
            if (r == null || r.conditional() || (rule = ambiguousConditionalTags.get(key = r.getTag() + ":conditional")) == null || !RULE_INT_MAX.equals(rule)) continue;
            try {
                Integer newValue = Integer.parseInt(r.getValue());
                Integer oldValue = (Integer)existingIntValues.get(key);
                if (oldValue != null && newValue <= oldValue) continue;
                existingIntValues.put(key, newValue);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        for (int type : rdo.types) {
            r = rdo.region.quickGetEncodingRule(type);
            if (r == null || !r.conditional()) continue;
            key = r.getTag();
            rule = ambiguousConditionalTags.get(key);
            if (rule != null && RULE_INT_MAX.equals(rule)) {
                Integer existingValue = (Integer)existingIntValues.get(key);
                Integer newValue = r.getMaxIntegerConditionalValue();
                if (newValue == null || existingValue != null && newValue <= existingValue) continue;
                this.updateTypesByTagValue(rdo, r.getNonConditionalTag(), newValue.toString());
                continue;
            }
            if (rule == null) continue;
            this.updateTypesByTagValue(rdo, r.getNonConditionalTag(), rule);
        }
    }

    public void processConditionalTags(RouteDataObject rdo, long conditionalTime) {
        int i;
        int sz = rdo.types.length;
        for (i = 0; i < sz; ++i) {
            int vl;
            BinaryMapRouteReaderAdapter.RouteTypeRule r = rdo.region.quickGetEncodingRule(rdo.types[i]);
            if (r == null || !r.conditional() || (vl = r.conditionalValue(conditionalTime)) == 0) continue;
            String nonCondTag = rdo.region.quickGetEncodingRule(vl).getTag();
            this.updateTypesByTagRuleId(rdo, nonCondTag, vl);
        }
        if (rdo.pointTypes != null) {
            for (i = 0; i < rdo.pointTypes.length; ++i) {
                if (rdo.pointTypes[i] == null) continue;
                int[] pTypes = rdo.pointTypes[i];
                int pSz = pTypes.length;
                if (pSz > 0) {
                    for (int j = 0; j < pSz; ++j) {
                        BinaryMapRouteReaderAdapter.RouteTypeRule toReplace;
                        int ks;
                        int vl;
                        BinaryMapRouteReaderAdapter.RouteTypeRule r = rdo.region.quickGetEncodingRule(pTypes[j]);
                        if (r == null || !r.conditional() || (vl = r.conditionalValue(conditionalTime)) == 0) continue;
                        BinaryMapRouteReaderAdapter.RouteTypeRule rtr = rdo.region.quickGetEncodingRule(vl);
                        String nonCondTag = rtr.getTag();
                        for (ks = 0; !(ks >= rdo.pointTypes[i].length || (toReplace = rdo.region.quickGetEncodingRule(rdo.pointTypes[i][ks])) != null && toReplace.getTag().contentEquals(nonCondTag)); ++ks) {
                        }
                        if (ks == pTypes.length) {
                            int[] ntypes = new int[pTypes.length + 1];
                            System.arraycopy(pTypes, 0, ntypes, 0, pTypes.length);
                            pTypes = ntypes;
                        }
                        pTypes[ks] = vl;
                    }
                }
                rdo.pointTypes[i] = pTypes;
            }
        }
    }

    public void updateTypesByTagValue(RouteDataObject rdo, String tag, String value) {
        int ruleId = rdo.region.searchRouteEncodingRule(tag, value);
        if (ruleId > 0) {
            this.updateTypesByTagRuleId(rdo, tag, ruleId);
        } else {
            System.err.printf("updateTypesByTagValue(%s,%s): searchRouteEncodingRule failed\n", tag, value);
        }
    }

    public void updateTypesByTagRuleId(RouteDataObject rdo, String tag, int ruleId) {
        if (ruleId > 0) {
            BinaryMapRouteReaderAdapter.RouteTypeRule toReplace;
            int ks;
            for (ks = 0; !(ks >= rdo.types.length || (toReplace = rdo.region.quickGetEncodingRule(rdo.types[ks])) != null && toReplace.getTag().equals(tag)); ++ks) {
            }
            if (ks == rdo.types.length) {
                int[] ntypes = new int[rdo.types.length + 1];
                System.arraycopy(rdo.types, 0, ntypes, 0, rdo.types.length);
                rdo.types = ntypes;
            }
            rdo.types[ks] = ruleId;
        }
    }
}

