/*
 * Decompiled with CFR 0.152.
 */
package com.atilika.kuromoji.compile;

import com.atilika.kuromoji.compile.Compiler;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ShortBuffer;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;

public class ConnectionCostsCompiler
implements Compiler {
    private static final int SHORT_BYTES = 2;
    private OutputStream output;
    private int cardinality;
    private int bufferSize;
    private ShortBuffer costs;

    public ConnectionCostsCompiler(OutputStream output) {
        this.output = output;
    }

    public void readCosts(InputStream input) throws IOException {
        BufferedReader lineReader = new BufferedReader(new InputStreamReader(input));
        String line = lineReader.readLine();
        String[] cardinalities = line.split("\\s+");
        assert (cardinalities.length == 2);
        int forwardSize = Integer.parseInt(cardinalities[0]);
        int backwardSize = Integer.parseInt(cardinalities[1]);
        assert (forwardSize == backwardSize);
        assert (forwardSize > 0);
        assert (backwardSize > 0);
        this.cardinality = backwardSize;
        this.bufferSize = forwardSize * backwardSize;
        this.costs = ShortBuffer.allocate(this.bufferSize);
        while ((line = lineReader.readLine()) != null) {
            String[] fields = line.split("\\s+");
            assert (fields.length == 3);
            short forwardId = Short.parseShort(fields[0]);
            short backwardId = Short.parseShort(fields[1]);
            short cost = Short.parseShort(fields[2]);
            this.putCost(forwardId, backwardId, cost);
        }
    }

    public void putCost(short forwardId, short backwardId, short cost) {
        this.costs.put(backwardId + forwardId * this.cardinality, cost);
    }

    @Override
    public void compile() throws IOException {
        DataOutputStream dataOutput = new DataOutputStream(new BufferedOutputStream(this.output));
        dataOutput.writeInt(this.cardinality);
        dataOutput.writeInt(this.bufferSize * 2);
        ByteBuffer byteBuffer = ByteBuffer.allocate(this.costs.array().length * 2);
        for (short cost : this.costs.array()) {
            byteBuffer.putShort(cost);
        }
        WritableByteChannel channel = Channels.newChannel(dataOutput);
        byteBuffer.flip();
        channel.write(byteBuffer);
        dataOutput.close();
    }

    public int getCardinality() {
        return this.cardinality;
    }

    public ShortBuffer getCosts() {
        return this.costs;
    }
}

