/*
 * Decompiled with CFR 0.152.
 */
package com.atilika.kuromoji.viterbi;

import com.atilika.kuromoji.dict.ConnectionCosts;
import com.atilika.kuromoji.viterbi.ViterbiLattice;
import com.atilika.kuromoji.viterbi.ViterbiNode;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ViterbiFormatter {
    private static final String BOS_LABEL = "BOS";
    private static final String EOS_LABEL = "EOS";
    private static final String FONT_NAME = "Helvetica";
    private ConnectionCosts costs;
    private Map<String, ViterbiNode> nodeMap;
    private Map<String, String> bestPathMap;
    private boolean foundBOS;

    public ViterbiFormatter(ConnectionCosts costs) {
        this.costs = costs;
        this.nodeMap = new HashMap<String, ViterbiNode>();
        this.bestPathMap = new HashMap<String, String>();
    }

    public String format(ViterbiLattice lattice) {
        return this.format(lattice, null);
    }

    public String format(ViterbiLattice lattice, List<ViterbiNode> bestPath) {
        this.initBestPathMap(bestPath);
        StringBuilder builder = new StringBuilder();
        builder.append(this.formatHeader());
        builder.append(this.formatNodes(lattice));
        builder.append(this.formatTrailer());
        return builder.toString();
    }

    private void initBestPathMap(List<ViterbiNode> bestPath) {
        this.bestPathMap.clear();
        if (bestPath == null) {
            return;
        }
        for (int i = 0; i < bestPath.size() - 1; ++i) {
            ViterbiNode from = bestPath.get(i);
            ViterbiNode to = bestPath.get(i + 1);
            String fromId = this.getNodeId(from);
            String toId = this.getNodeId(to);
            assert (!this.bestPathMap.containsKey(fromId));
            assert (!this.bestPathMap.containsValue(toId));
            this.bestPathMap.put(fromId, toId);
        }
    }

    private String formatNodes(ViterbiLattice lattice) {
        ViterbiNode[][] startsArray = lattice.getStartIndexArr();
        ViterbiNode[][] endsArray = lattice.getEndIndexArr();
        this.nodeMap.clear();
        this.foundBOS = false;
        StringBuilder builder = new StringBuilder();
        for (int i = 1; i < endsArray.length; ++i) {
            if (endsArray[i] == null || startsArray[i] == null) continue;
            for (int j = 0; j < endsArray[i].length; ++j) {
                ViterbiNode to;
                ViterbiNode from = endsArray[i][j];
                if (from == null) continue;
                builder.append(this.formatNodeIfNew(from));
                for (int k = 0; k < startsArray[i].length && (to = startsArray[i][k]) != null; ++k) {
                    builder.append(this.formatNodeIfNew(to));
                    builder.append(this.formatEdge(from, to));
                }
            }
        }
        return builder.toString();
    }

    private String formatNodeIfNew(ViterbiNode node) {
        String nodeId = this.getNodeId(node);
        if (!this.nodeMap.containsKey(nodeId)) {
            this.nodeMap.put(nodeId, node);
            return this.formatNode(node);
        }
        return "";
    }

    private String formatHeader() {
        StringBuilder builder = new StringBuilder();
        builder.append("digraph viterbi {\n");
        builder.append("graph [ fontsize=30 labelloc=\"t\" label=\"\" splines=true overlap=false rankdir = \"LR\" ];\n");
        builder.append("# A2 paper size\n");
        builder.append("size = \"34.4,16.5\";\n");
        builder.append("# try to fill paper\n");
        builder.append("ratio = fill;\n");
        builder.append("edge [ fontname=\"Helvetica\" fontcolor=\"red\" color=\"#606060\" ]\n");
        builder.append("node [ style=\"filled\" fillcolor=\"#e8e8f0\" shape=\"Mrecord\" fontname=\"Helvetica\" ]\n");
        return builder.toString();
    }

    private String formatTrailer() {
        return "}";
    }

    private String formatEdge(ViterbiNode from, ViterbiNode to) {
        if (this.bestPathMap.containsKey(this.getNodeId(from)) && this.bestPathMap.get(this.getNodeId(from)).equals(this.getNodeId(to))) {
            return this.formatEdge(from, to, "color=\"#40e050\" fontcolor=\"#40a050\" penwidth=3 fontsize=20 ");
        }
        return this.formatEdge(from, to, "");
    }

    private String formatEdge(ViterbiNode from, ViterbiNode to, String attributes) {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getNodeId(from));
        builder.append(" -> ");
        builder.append(this.getNodeId(to));
        builder.append(" [ ");
        builder.append("label=\"");
        builder.append(this.getCost(from, to));
        builder.append("\"");
        builder.append(" ");
        builder.append(attributes);
        builder.append(" ");
        builder.append(" ]");
        builder.append("\n");
        return builder.toString();
    }

    private String formatNode(ViterbiNode node) {
        StringBuilder builder = new StringBuilder();
        builder.append("\"");
        builder.append(this.getNodeId(node));
        builder.append("\"");
        builder.append(" [ ");
        builder.append("label=");
        builder.append(this.formatNodeLabel(node));
        if (node.getType() == ViterbiNode.Type.USER) {
            builder.append(" fillcolor=\"#e8f8e8\"");
        } else if (node.getType() == ViterbiNode.Type.UNKNOWN) {
            builder.append(" fillcolor=\"#f8e8f8\"");
        } else if (node.getType() == ViterbiNode.Type.INSERTED) {
            builder.append(" fillcolor=\"#ffe8e8\"");
        }
        builder.append(" ]");
        return builder.toString();
    }

    private String formatNodeLabel(ViterbiNode node) {
        StringBuilder builder = new StringBuilder();
        builder.append("<<table border=\"0\" cellborder=\"0\">");
        builder.append("<tr><td>");
        builder.append(this.getNodeLabel(node));
        builder.append("</td></tr>");
        builder.append("<tr><td>");
        builder.append("<font color=\"blue\">");
        builder.append(node.getWordCost());
        builder.append("</font>");
        builder.append("</td></tr>");
        builder.append("</table>>");
        return builder.toString();
    }

    private String getNodeId(ViterbiNode node) {
        return String.valueOf(node.hashCode());
    }

    private String getNodeLabel(ViterbiNode node) {
        if (node.getType() == ViterbiNode.Type.KNOWN && node.getWordId() == 0) {
            if (this.foundBOS) {
                return EOS_LABEL;
            }
            this.foundBOS = true;
            return BOS_LABEL;
        }
        return node.getSurface();
    }

    private int getCost(ViterbiNode from, ViterbiNode to) {
        return this.costs.get(from.getLeftId(), to.getRightId());
    }
}

