/*
 * Decompiled with CFR 0.152.
 */
package com.atilika.kuromoji;

import com.atilika.kuromoji.dict.Dictionary;
import com.atilika.kuromoji.viterbi.ViterbiNode;

public abstract class TokenBase {
    private static final int META_DATA_SIZE = 4;
    private final Dictionary dictionary;
    private final int wordId;
    private final String surface;
    private final int position;
    private final ViterbiNode.Type type;

    public TokenBase(int wordId, String surface, ViterbiNode.Type type, int position, Dictionary dictionary) {
        this.wordId = wordId;
        this.surface = surface;
        this.type = type;
        this.position = position;
        this.dictionary = dictionary;
    }

    public String getSurface() {
        return this.surface;
    }

    public boolean isKnown() {
        return this.type == ViterbiNode.Type.KNOWN;
    }

    public boolean isUser() {
        return this.type == ViterbiNode.Type.USER;
    }

    public int getPosition() {
        return this.position;
    }

    public String getAllFeatures() {
        return this.dictionary.getAllFeatures(this.wordId);
    }

    public String[] getAllFeaturesArray() {
        return this.dictionary.getAllFeaturesArray(this.wordId);
    }

    public String toString() {
        return "Token{surface='" + this.surface + '\'' + ", position=" + this.position + ", type=" + (Object)((Object)this.type) + ", dictionary=" + this.dictionary + ", wordId=" + this.wordId + '}';
    }

    protected String getFeature(int feature) {
        return this.dictionary.getFeature(this.wordId, feature - 4);
    }
}

