/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.core.jni;

import net.osmand.core.jni.OsmAndCoreJNI;

public class WeatherDataConverter {
    private transient long swigCPtr;
    private transient boolean swigCMemOwn;

    protected WeatherDataConverter(long l, boolean bl) {
        this.swigCMemOwn = bl;
        this.swigCPtr = l;
    }

    protected static long getCPtr(WeatherDataConverter weatherDataConverter) {
        return weatherDataConverter == null ? 0L : weatherDataConverter.swigCPtr;
    }

    protected void swigSetCMemOwn(boolean bl) {
        this.swigCMemOwn = bl;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                OsmAndCoreJNI.delete_WeatherDataConverter(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public WeatherDataConverter() {
        this(OsmAndCoreJNI.new_WeatherDataConverter(), true);
    }

    public static class Precipitation {
        private transient long swigCPtr;
        protected transient boolean swigCMemOwn;

        protected Precipitation(long l, boolean bl) {
            this.swigCMemOwn = bl;
            this.swigCPtr = l;
        }

        protected static long getCPtr(Precipitation precipitation) {
            return precipitation == null ? 0L : precipitation.swigCPtr;
        }

        protected static long swigRelease(Precipitation precipitation) {
            long l = 0L;
            if (precipitation != null) {
                if (!precipitation.swigCMemOwn) {
                    throw new RuntimeException("Cannot release ownership as memory is not owned");
                }
                l = precipitation.swigCPtr;
                precipitation.swigCMemOwn = false;
                precipitation.delete();
            }
            return l;
        }

        protected void finalize() {
            this.delete();
        }

        public synchronized void delete() {
            if (this.swigCPtr != 0L) {
                if (this.swigCMemOwn) {
                    this.swigCMemOwn = false;
                    OsmAndCoreJNI.delete_WeatherDataConverter_Precipitation(this.swigCPtr);
                }
                this.swigCPtr = 0L;
            }
        }

        public Precipitation(Unit unit, double d) {
            this(OsmAndCoreJNI.new_WeatherDataConverter_Precipitation(unit.swigValue(), d), true);
        }

        public Unit getUnit() {
            return Unit.swigToEnum(OsmAndCoreJNI.WeatherDataConverter_Precipitation_unit_get(this.swigCPtr, this));
        }

        public double getValue() {
            return OsmAndCoreJNI.WeatherDataConverter_Precipitation_value_get(this.swigCPtr, this);
        }

        public double toUnit(Unit unit) {
            return OsmAndCoreJNI.WeatherDataConverter_Precipitation_toUnit(this.swigCPtr, this, unit.swigValue());
        }

        public static Unit unitFromString(String string) {
            return Unit.swigToEnum(OsmAndCoreJNI.WeatherDataConverter_Precipitation_unitFromString(string));
        }

        public static enum Unit {
            MM,
            INCHES,
            KG_M2_S;

            private final int swigValue;

            public final int swigValue() {
                return this.swigValue;
            }

            public static Unit swigToEnum(int n) {
                Unit[] unitArray = (Unit[])Unit.class.getEnumConstants();
                if (n < unitArray.length && n >= 0 && unitArray[n].swigValue == n) {
                    return unitArray[n];
                }
                for (Unit unit : unitArray) {
                    if (unit.swigValue != n) continue;
                    return unit;
                }
                throw new IllegalArgumentException("No enum " + String.valueOf(Unit.class) + " with value " + n);
            }

            private Unit() {
                this.swigValue = SwigNext.next++;
            }

            private Unit(int n2) {
                this.swigValue = n2;
                SwigNext.next = n2 + 1;
            }

            private Unit(Unit unit) {
                this.swigValue = unit.swigValue;
                SwigNext.next = this.swigValue + 1;
            }

            private static class SwigNext {
                private static int next = 0;

                private SwigNext() {
                }
            }
        }
    }

    public static class Pressure {
        private transient long swigCPtr;
        protected transient boolean swigCMemOwn;

        protected Pressure(long l, boolean bl) {
            this.swigCMemOwn = bl;
            this.swigCPtr = l;
        }

        protected static long getCPtr(Pressure pressure) {
            return pressure == null ? 0L : pressure.swigCPtr;
        }

        protected static long swigRelease(Pressure pressure) {
            long l = 0L;
            if (pressure != null) {
                if (!pressure.swigCMemOwn) {
                    throw new RuntimeException("Cannot release ownership as memory is not owned");
                }
                l = pressure.swigCPtr;
                pressure.swigCMemOwn = false;
                pressure.delete();
            }
            return l;
        }

        protected void finalize() {
            this.delete();
        }

        public synchronized void delete() {
            if (this.swigCPtr != 0L) {
                if (this.swigCMemOwn) {
                    this.swigCMemOwn = false;
                    OsmAndCoreJNI.delete_WeatherDataConverter_Pressure(this.swigCPtr);
                }
                this.swigCPtr = 0L;
            }
        }

        public Pressure(Unit unit, double d) {
            this(OsmAndCoreJNI.new_WeatherDataConverter_Pressure(unit.swigValue(), d), true);
        }

        public Unit getUnit() {
            return Unit.swigToEnum(OsmAndCoreJNI.WeatherDataConverter_Pressure_unit_get(this.swigCPtr, this));
        }

        public double getValue() {
            return OsmAndCoreJNI.WeatherDataConverter_Pressure_value_get(this.swigCPtr, this);
        }

        public double toUnit(Unit unit) {
            return OsmAndCoreJNI.WeatherDataConverter_Pressure_toUnit(this.swigCPtr, this, unit.swigValue());
        }

        public static Unit unitFromString(String string) {
            return Unit.swigToEnum(OsmAndCoreJNI.WeatherDataConverter_Pressure_unitFromString(string));
        }

        public static enum Unit {
            PASCAL,
            HECTOPASCAL,
            INCHES_HG,
            MM_HG;

            private final int swigValue;

            public final int swigValue() {
                return this.swigValue;
            }

            public static Unit swigToEnum(int n) {
                Unit[] unitArray = (Unit[])Unit.class.getEnumConstants();
                if (n < unitArray.length && n >= 0 && unitArray[n].swigValue == n) {
                    return unitArray[n];
                }
                for (Unit unit : unitArray) {
                    if (unit.swigValue != n) continue;
                    return unit;
                }
                throw new IllegalArgumentException("No enum " + String.valueOf(Unit.class) + " with value " + n);
            }

            private Unit() {
                this.swigValue = SwigNext.next++;
            }

            private Unit(int n2) {
                this.swigValue = n2;
                SwigNext.next = n2 + 1;
            }

            private Unit(Unit unit) {
                this.swigValue = unit.swigValue;
                SwigNext.next = this.swigValue + 1;
            }

            private static class SwigNext {
                private static int next = 0;

                private SwigNext() {
                }
            }
        }
    }

    public static class Speed {
        private transient long swigCPtr;
        protected transient boolean swigCMemOwn;

        protected Speed(long l, boolean bl) {
            this.swigCMemOwn = bl;
            this.swigCPtr = l;
        }

        protected static long getCPtr(Speed speed) {
            return speed == null ? 0L : speed.swigCPtr;
        }

        protected static long swigRelease(Speed speed) {
            long l = 0L;
            if (speed != null) {
                if (!speed.swigCMemOwn) {
                    throw new RuntimeException("Cannot release ownership as memory is not owned");
                }
                l = speed.swigCPtr;
                speed.swigCMemOwn = false;
                speed.delete();
            }
            return l;
        }

        protected void finalize() {
            this.delete();
        }

        public synchronized void delete() {
            if (this.swigCPtr != 0L) {
                if (this.swigCMemOwn) {
                    this.swigCMemOwn = false;
                    OsmAndCoreJNI.delete_WeatherDataConverter_Speed(this.swigCPtr);
                }
                this.swigCPtr = 0L;
            }
        }

        public Speed(Unit unit, double d) {
            this(OsmAndCoreJNI.new_WeatherDataConverter_Speed(unit.swigValue(), d), true);
        }

        public Unit getUnit() {
            return Unit.swigToEnum(OsmAndCoreJNI.WeatherDataConverter_Speed_unit_get(this.swigCPtr, this));
        }

        public double getValue() {
            return OsmAndCoreJNI.WeatherDataConverter_Speed_value_get(this.swigCPtr, this);
        }

        public double toUnit(Unit unit) {
            return OsmAndCoreJNI.WeatherDataConverter_Speed_toUnit(this.swigCPtr, this, unit.swigValue());
        }

        public static Unit unitFromString(String string) {
            return Unit.swigToEnum(OsmAndCoreJNI.WeatherDataConverter_Speed_unitFromString(string));
        }

        public static enum Unit {
            KNOTS,
            METERS_PER_SECOND,
            KILOMETERS_PER_HOUR,
            MILES_PER_HOUR;

            private final int swigValue;

            public final int swigValue() {
                return this.swigValue;
            }

            public static Unit swigToEnum(int n) {
                Unit[] unitArray = (Unit[])Unit.class.getEnumConstants();
                if (n < unitArray.length && n >= 0 && unitArray[n].swigValue == n) {
                    return unitArray[n];
                }
                for (Unit unit : unitArray) {
                    if (unit.swigValue != n) continue;
                    return unit;
                }
                throw new IllegalArgumentException("No enum " + String.valueOf(Unit.class) + " with value " + n);
            }

            private Unit() {
                this.swigValue = SwigNext.next++;
            }

            private Unit(int n2) {
                this.swigValue = n2;
                SwigNext.next = n2 + 1;
            }

            private Unit(Unit unit) {
                this.swigValue = unit.swigValue;
                SwigNext.next = this.swigValue + 1;
            }

            private static class SwigNext {
                private static int next = 0;

                private SwigNext() {
                }
            }
        }
    }

    public static class Temperature {
        private transient long swigCPtr;
        protected transient boolean swigCMemOwn;

        protected Temperature(long l, boolean bl) {
            this.swigCMemOwn = bl;
            this.swigCPtr = l;
        }

        protected static long getCPtr(Temperature temperature) {
            return temperature == null ? 0L : temperature.swigCPtr;
        }

        protected static long swigRelease(Temperature temperature) {
            long l = 0L;
            if (temperature != null) {
                if (!temperature.swigCMemOwn) {
                    throw new RuntimeException("Cannot release ownership as memory is not owned");
                }
                l = temperature.swigCPtr;
                temperature.swigCMemOwn = false;
                temperature.delete();
            }
            return l;
        }

        protected void finalize() {
            this.delete();
        }

        public synchronized void delete() {
            if (this.swigCPtr != 0L) {
                if (this.swigCMemOwn) {
                    this.swigCMemOwn = false;
                    OsmAndCoreJNI.delete_WeatherDataConverter_Temperature(this.swigCPtr);
                }
                this.swigCPtr = 0L;
            }
        }

        public Temperature(Unit unit, double d) {
            this(OsmAndCoreJNI.new_WeatherDataConverter_Temperature(unit.swigValue(), d), true);
        }

        public Unit getUnit() {
            return Unit.swigToEnum(OsmAndCoreJNI.WeatherDataConverter_Temperature_unit_get(this.swigCPtr, this));
        }

        public double getValue() {
            return OsmAndCoreJNI.WeatherDataConverter_Temperature_value_get(this.swigCPtr, this);
        }

        public double toUnit(Unit unit) {
            return OsmAndCoreJNI.WeatherDataConverter_Temperature_toUnit(this.swigCPtr, this, unit.swigValue());
        }

        public static Unit unitFromString(String string) {
            return Unit.swigToEnum(OsmAndCoreJNI.WeatherDataConverter_Temperature_unitFromString(string));
        }

        public static enum Unit {
            C,
            F;

            private final int swigValue;

            public final int swigValue() {
                return this.swigValue;
            }

            public static Unit swigToEnum(int n) {
                Unit[] unitArray = (Unit[])Unit.class.getEnumConstants();
                if (n < unitArray.length && n >= 0 && unitArray[n].swigValue == n) {
                    return unitArray[n];
                }
                for (Unit unit : unitArray) {
                    if (unit.swigValue != n) continue;
                    return unit;
                }
                throw new IllegalArgumentException("No enum " + String.valueOf(Unit.class) + " with value " + n);
            }

            private Unit() {
                this.swigValue = SwigNext.next++;
            }

            private Unit(int n2) {
                this.swigValue = n2;
                SwigNext.next = n2 + 1;
            }

            private Unit(Unit unit) {
                this.swigValue = unit.swigValue;
                SwigNext.next = this.swigValue + 1;
            }

            private static class SwigNext {
                private static int next = 0;

                private SwigNext() {
                }
            }
        }
    }
}

