/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.core.jni;

import net.osmand.core.jni.AreaI;
import net.osmand.core.jni.OsmAndCoreJNI;
import net.osmand.core.jni.PointI;
import net.osmand.core.jni.QVectorPointI;
import net.osmand.core.jni.SWIGTYPE_p_OsmAnd__AreaT_long_long_t;
import net.osmand.core.jni.SWIGTYPE_p_OsmAnd__PointT_long_long_t;

public class TrackArea {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected TrackArea(long l, boolean bl) {
        this.swigCMemOwn = bl;
        this.swigCPtr = l;
    }

    protected static long getCPtr(TrackArea trackArea) {
        return trackArea == null ? 0L : trackArea.swigCPtr;
    }

    protected static long swigRelease(TrackArea trackArea) {
        long l = 0L;
        if (trackArea != null) {
            if (!trackArea.swigCMemOwn) {
                throw new RuntimeException("Cannot release ownership as memory is not owned");
            }
            l = trackArea.swigCPtr;
            trackArea.swigCMemOwn = false;
            trackArea.delete();
        }
        return l;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                OsmAndCoreJNI.delete_TrackArea(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public void setBbox(SWIGTYPE_p_OsmAnd__AreaT_long_long_t sWIGTYPE_p_OsmAnd__AreaT_long_long_t) {
        OsmAndCoreJNI.TrackArea_bbox_set(this.swigCPtr, this, SWIGTYPE_p_OsmAnd__AreaT_long_long_t.getCPtr(sWIGTYPE_p_OsmAnd__AreaT_long_long_t));
    }

    public SWIGTYPE_p_OsmAnd__AreaT_long_long_t getBbox() {
        long l = OsmAndCoreJNI.TrackArea_bbox_get(this.swigCPtr, this);
        return l == 0L ? null : new SWIGTYPE_p_OsmAnd__AreaT_long_long_t(l, false);
    }

    public void setLast(SWIGTYPE_p_OsmAnd__PointT_long_long_t sWIGTYPE_p_OsmAnd__PointT_long_long_t) {
        OsmAndCoreJNI.TrackArea_last_set(this.swigCPtr, this, SWIGTYPE_p_OsmAnd__PointT_long_long_t.getCPtr(sWIGTYPE_p_OsmAnd__PointT_long_long_t));
    }

    public SWIGTYPE_p_OsmAnd__PointT_long_long_t getLast() {
        long l = OsmAndCoreJNI.TrackArea_last_get(this.swigCPtr, this);
        return l == 0L ? null : new SWIGTYPE_p_OsmAnd__PointT_long_long_t(l, false);
    }

    public TrackArea() {
        this(OsmAndCoreJNI.new_TrackArea__SWIG_0(), true);
    }

    public TrackArea(TrackArea trackArea) {
        this(OsmAndCoreJNI.new_TrackArea__SWIG_1(TrackArea.getCPtr(trackArea), trackArea), true);
    }

    public TrackArea(PointI pointI) {
        this(OsmAndCoreJNI.new_TrackArea__SWIG_2(PointI.getCPtr(pointI), pointI), true);
    }

    public void add(PointI pointI) {
        OsmAndCoreJNI.TrackArea_add(this.swigCPtr, this, PointI.getCPtr(pointI), pointI);
    }

    public void update(QVectorPointI qVectorPointI, int n) {
        OsmAndCoreJNI.TrackArea_update__SWIG_0(this.swigCPtr, this, QVectorPointI.getCPtr(qVectorPointI), qVectorPointI, n);
    }

    public void update(QVectorPointI qVectorPointI) {
        OsmAndCoreJNI.TrackArea_update__SWIG_1(this.swigCPtr, this, QVectorPointI.getCPtr(qVectorPointI), qVectorPointI);
    }

    public AreaI normalized() {
        return new AreaI(OsmAndCoreJNI.TrackArea_normalized(this.swigCPtr, this), true);
    }
}

