/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.core.jni;

import net.osmand.core.jni.OsmAndCoreJNI;
import net.osmand.core.jni.ZoomLevel;

public class GridParameters {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected GridParameters(long l, boolean bl) {
        this.swigCMemOwn = bl;
        this.swigCPtr = l;
    }

    protected static long getCPtr(GridParameters gridParameters) {
        return gridParameters == null ? 0L : gridParameters.swigCPtr;
    }

    protected static long swigRelease(GridParameters gridParameters) {
        long l = 0L;
        if (gridParameters != null) {
            if (!gridParameters.swigCMemOwn) {
                throw new RuntimeException("Cannot release ownership as memory is not owned");
            }
            l = gridParameters.swigCPtr;
            gridParameters.swigCMemOwn = false;
            gridParameters.delete();
        }
        return l;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                OsmAndCoreJNI.delete_GridParameters(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public void setFactorX1(float f) {
        OsmAndCoreJNI.GridParameters_factorX1_set(this.swigCPtr, this, f);
    }

    public float getFactorX1() {
        return OsmAndCoreJNI.GridParameters_factorX1_get(this.swigCPtr, this);
    }

    public void setFactorX2(float f) {
        OsmAndCoreJNI.GridParameters_factorX2_set(this.swigCPtr, this, f);
    }

    public float getFactorX2() {
        return OsmAndCoreJNI.GridParameters_factorX2_get(this.swigCPtr, this);
    }

    public void setFactorX3(float f) {
        OsmAndCoreJNI.GridParameters_factorX3_set(this.swigCPtr, this, f);
    }

    public float getFactorX3() {
        return OsmAndCoreJNI.GridParameters_factorX3_get(this.swigCPtr, this);
    }

    public void setOffsetX(float f) {
        OsmAndCoreJNI.GridParameters_offsetX_set(this.swigCPtr, this, f);
    }

    public float getOffsetX() {
        return OsmAndCoreJNI.GridParameters_offsetX_get(this.swigCPtr, this);
    }

    public void setFactorY1(float f) {
        OsmAndCoreJNI.GridParameters_factorY1_set(this.swigCPtr, this, f);
    }

    public float getFactorY1() {
        return OsmAndCoreJNI.GridParameters_factorY1_get(this.swigCPtr, this);
    }

    public void setFactorY2(float f) {
        OsmAndCoreJNI.GridParameters_factorY2_set(this.swigCPtr, this, f);
    }

    public float getFactorY2() {
        return OsmAndCoreJNI.GridParameters_factorY2_get(this.swigCPtr, this);
    }

    public void setFactorY3(float f) {
        OsmAndCoreJNI.GridParameters_factorY3_set(this.swigCPtr, this, f);
    }

    public float getFactorY3() {
        return OsmAndCoreJNI.GridParameters_factorY3_get(this.swigCPtr, this);
    }

    public void setOffsetY(float f) {
        OsmAndCoreJNI.GridParameters_offsetY_set(this.swigCPtr, this, f);
    }

    public float getOffsetY() {
        return OsmAndCoreJNI.GridParameters_offsetY_get(this.swigCPtr, this);
    }

    public void setMinZoom(ZoomLevel zoomLevel) {
        OsmAndCoreJNI.GridParameters_minZoom_set(this.swigCPtr, this, zoomLevel.swigValue());
    }

    public ZoomLevel getMinZoom() {
        return ZoomLevel.swigToEnum(OsmAndCoreJNI.GridParameters_minZoom_get(this.swigCPtr, this));
    }

    public void setMaxZoomForFloat(ZoomLevel zoomLevel) {
        OsmAndCoreJNI.GridParameters_maxZoomForFloat_set(this.swigCPtr, this, zoomLevel.swigValue());
    }

    public ZoomLevel getMaxZoomForFloat() {
        return ZoomLevel.swigToEnum(OsmAndCoreJNI.GridParameters_maxZoomForFloat_get(this.swigCPtr, this));
    }

    public void setMaxZoomForMixed(ZoomLevel zoomLevel) {
        OsmAndCoreJNI.GridParameters_maxZoomForMixed_set(this.swigCPtr, this, zoomLevel.swigValue());
    }

    public ZoomLevel getMaxZoomForMixed() {
        return ZoomLevel.swigToEnum(OsmAndCoreJNI.GridParameters_maxZoomForMixed_get(this.swigCPtr, this));
    }

    public GridParameters() {
        this(OsmAndCoreJNI.new_GridParameters(), true);
    }
}

