/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.math.geom;

import com.jogamp.opengl.math.FloatUtil;
import com.jogamp.opengl.math.Quaternion;
import com.jogamp.opengl.math.Ray;
import com.jogamp.opengl.math.VectorUtil;
import jogamp.graph.geom.plane.AffineTransform;

public class AABBox {
    private static final boolean DEBUG = FloatUtil.DEBUG;
    private final float[] low = new float[3];
    private final float[] high = new float[3];
    private final float[] center = new float[3];

    public AABBox() {
        this.reset();
    }

    public AABBox(AABBox aABBox) {
        this.copy(aABBox);
    }

    public AABBox(float f, float f2, float f3, float f4, float f5, float f6) {
        this.setSize(f, f2, f3, f4, f5, f6);
    }

    public AABBox(float[] fArray, float[] fArray2) {
        this.setSize(fArray, fArray2);
    }

    public final AABBox reset() {
        this.setLow(Float.MAX_VALUE, Float.MAX_VALUE, Float.MAX_VALUE);
        this.setHigh(-3.4028235E38f, -3.4028235E38f, -3.4028235E38f);
        this.center[0] = 0.0f;
        this.center[1] = 0.0f;
        this.center[2] = 0.0f;
        return this;
    }

    public final float[] getHigh() {
        return this.high;
    }

    private final void setHigh(float f, float f2, float f3) {
        this.high[0] = f;
        this.high[1] = f2;
        this.high[2] = f3;
    }

    public final float[] getLow() {
        return this.low;
    }

    private final void setLow(float f, float f2, float f3) {
        this.low[0] = f;
        this.low[1] = f2;
        this.low[2] = f3;
    }

    private final void computeCenter() {
        this.center[0] = (this.high[0] + this.low[0]) / 2.0f;
        this.center[1] = (this.high[1] + this.low[1]) / 2.0f;
        this.center[2] = (this.high[2] + this.low[2]) / 2.0f;
    }

    public final AABBox copy(AABBox aABBox) {
        System.arraycopy(aABBox.low, 0, this.low, 0, 3);
        System.arraycopy(aABBox.high, 0, this.high, 0, 3);
        System.arraycopy(aABBox.center, 0, this.center, 0, 3);
        return this;
    }

    public final AABBox setSize(float[] fArray, float[] fArray2) {
        return this.setSize(fArray[0], fArray[1], fArray[2], fArray2[0], fArray2[1], fArray2[2]);
    }

    public final AABBox setSize(float f, float f2, float f3, float f4, float f5, float f6) {
        this.low[0] = f;
        this.low[1] = f2;
        this.low[2] = f3;
        this.high[0] = f4;
        this.high[1] = f5;
        this.high[2] = f6;
        this.computeCenter();
        return this;
    }

    public final AABBox resize(AABBox aABBox) {
        float[] fArray = aABBox.getLow();
        float[] fArray2 = aABBox.getHigh();
        if (fArray[0] < this.low[0]) {
            this.low[0] = fArray[0];
        }
        if (fArray[1] < this.low[1]) {
            this.low[1] = fArray[1];
        }
        if (fArray[2] < this.low[2]) {
            this.low[2] = fArray[2];
        }
        if (fArray2[0] > this.high[0]) {
            this.high[0] = fArray2[0];
        }
        if (fArray2[1] > this.high[1]) {
            this.high[1] = fArray2[1];
        }
        if (fArray2[2] > this.high[2]) {
            this.high[2] = fArray2[2];
        }
        this.computeCenter();
        return this;
    }

    public final AABBox resize(AABBox aABBox, AffineTransform affineTransform, float[] fArray) {
        float[] fArray2 = aABBox.getLow();
        affineTransform.transform(fArray2, fArray);
        fArray[2] = fArray2[2];
        if (fArray[0] < this.low[0]) {
            this.low[0] = fArray[0];
        }
        if (fArray[1] < this.low[1]) {
            this.low[1] = fArray[1];
        }
        if (fArray[2] < this.low[2]) {
            this.low[2] = fArray[2];
        }
        fArray2 = aABBox.getHigh();
        affineTransform.transform(fArray2, fArray);
        fArray[2] = fArray2[2];
        if (fArray[0] > this.high[0]) {
            this.high[0] = fArray[0];
        }
        if (fArray[1] > this.high[1]) {
            this.high[1] = fArray[1];
        }
        if (fArray[2] > this.high[2]) {
            this.high[2] = fArray[2];
        }
        this.computeCenter();
        return this;
    }

    public final AABBox resize(float f, float f2, float f3) {
        if (f < this.low[0]) {
            this.low[0] = f;
        }
        if (f2 < this.low[1]) {
            this.low[1] = f2;
        }
        if (f3 < this.low[2]) {
            this.low[2] = f3;
        }
        if (f > this.high[0]) {
            this.high[0] = f;
        }
        if (f2 > this.high[1]) {
            this.high[1] = f2;
        }
        if (f3 > this.high[2]) {
            this.high[2] = f3;
        }
        this.computeCenter();
        return this;
    }

    public final AABBox resize(float[] fArray, int n) {
        return this.resize(fArray[0 + n], fArray[1 + n], fArray[2 + n]);
    }

    public final AABBox resize(float[] fArray) {
        return this.resize(fArray[0], fArray[1], fArray[2]);
    }

    public final boolean contains(float f, float f2) {
        if (f < this.low[0] || f > this.high[0]) {
            return false;
        }
        return !(f2 < this.low[1]) && !(f2 > this.high[1]);
    }

    public final boolean contains(float f, float f2, float f3) {
        if (f < this.low[0] || f > this.high[0]) {
            return false;
        }
        if (f2 < this.low[1] || f2 > this.high[1]) {
            return false;
        }
        return !(f3 < this.low[2]) && !(f3 > this.high[2]);
    }

    public final boolean intersects2DRegion(float f, float f2, float f3, float f4) {
        if (f3 <= 0.0f || f4 <= 0.0f) {
            return false;
        }
        float f5 = this.getWidth();
        float f6 = this.getHeight();
        if (f5 <= 0.0f || f6 <= 0.0f) {
            return false;
        }
        float f7 = this.getMinX();
        float f8 = this.getMinY();
        return f + f3 > f7 && f2 + f4 > f8 && f < f7 + f5 && f2 < f8 + f6;
    }

    public final boolean intersectsRay(Ray ray) {
        float f = ray.dir[0];
        float f2 = ray.orig[0] - this.center[0];
        float f3 = this.high[0] - this.center[0];
        if (Math.abs(f2) > f3 && f2 * f >= 0.0f) {
            return false;
        }
        float f4 = ray.dir[1];
        float f5 = ray.orig[1] - this.center[1];
        float f6 = this.high[1] - this.center[1];
        if (Math.abs(f5) > f6 && f5 * f4 >= 0.0f) {
            return false;
        }
        float f7 = ray.dir[2];
        float f8 = ray.orig[2] - this.center[2];
        float f9 = this.high[2] - this.center[2];
        if (Math.abs(f8) > f9 && f8 * f7 >= 0.0f) {
            return false;
        }
        float f10 = Math.abs(f4);
        float f11 = Math.abs(f7);
        float f12 = f4 * f8 - f7 * f5;
        if (Math.abs(f12) > f6 * f11 + f9 * f10) {
            return false;
        }
        float f13 = Math.abs(f);
        f12 = f7 * f2 - f * f8;
        if (Math.abs(f12) > f3 * f11 + f9 * f13) {
            return false;
        }
        f12 = f * f5 - f4 * f2;
        return !(Math.abs(f12) > f3 * f10 + f6 * f13);
    }

    public final float[] getRayIntersection(float[] fArray, Ray ray, float f, boolean bl, float[] fArray2, float[] fArray3, float[] fArray4) {
        block23: {
            int n;
            float[] fArray5;
            float[] fArray6;
            float[] fArray7;
            block22: {
                fArray7 = new float[]{-1.0f, -1.0f, -1.0f};
                fArray6 = ray.orig;
                fArray5 = ray.dir;
                boolean bl2 = true;
                for (n = 0; n < 3; ++n) {
                    if (fArray6[n] < this.low[n]) {
                        fArray[n] = this.low[n];
                        bl2 = false;
                        if (0 == Float.floatToIntBits(fArray5[n])) continue;
                        fArray7[n] = (this.low[n] - fArray6[n]) / fArray5[n];
                        continue;
                    }
                    if (!(fArray6[n] > this.high[n])) continue;
                    fArray[n] = this.high[n];
                    bl2 = false;
                    if (0 == Float.floatToIntBits(fArray5[n])) continue;
                    fArray7[n] = (this.high[n] - fArray6[n]) / fArray5[n];
                }
                if (bl2) {
                    System.arraycopy(fArray6, 0, fArray, 0, 3);
                    return fArray;
                }
                n = 0;
                if (fArray7[1] > fArray7[n]) {
                    n = 1;
                }
                if (fArray7[2] > fArray7[n]) {
                    n = 2;
                }
                if (bl) break block22;
                if (0 != (Float.floatToIntBits(fArray7[n]) & Integer.MIN_VALUE)) {
                    return null;
                }
                switch (n) {
                    case 0: {
                        fArray[1] = fArray6[1] + fArray7[n] * fArray5[1];
                        if (fArray[1] < this.low[1] - f || fArray[1] > this.high[1] + f) {
                            return null;
                        }
                        fArray[2] = fArray6[2] + fArray7[n] * fArray5[2];
                        if (fArray[2] < this.low[2] - f || fArray[2] > this.high[2] + f) {
                            return null;
                        }
                        break block23;
                    }
                    case 1: {
                        fArray[0] = fArray6[0] + fArray7[n] * fArray5[0];
                        if (fArray[0] < this.low[0] - f || fArray[0] > this.high[0] + f) {
                            return null;
                        }
                        fArray[2] = fArray6[2] + fArray7[n] * fArray5[2];
                        if (fArray[2] < this.low[2] - f || fArray[2] > this.high[2] + f) {
                            return null;
                        }
                        break block23;
                    }
                    case 2: {
                        fArray[0] = fArray6[0] + fArray7[n] * fArray5[0];
                        if (fArray[0] < this.low[0] - f || fArray[0] > this.high[0] + f) {
                            return null;
                        }
                        fArray[1] = fArray6[1] + fArray7[n] * fArray5[1];
                        if (fArray[1] < this.low[1] - f || fArray[1] > this.high[1] + f) {
                            return null;
                        }
                        break block23;
                    }
                    default: {
                        throw new InternalError("XXX");
                    }
                }
            }
            switch (n) {
                case 0: {
                    fArray[1] = fArray6[1] + fArray7[n] * fArray5[1];
                    fArray[2] = fArray6[2] + fArray7[n] * fArray5[2];
                    break;
                }
                case 1: {
                    fArray[0] = fArray6[0] + fArray7[n] * fArray5[0];
                    fArray[2] = fArray6[2] + fArray7[n] * fArray5[2];
                    break;
                }
                case 2: {
                    fArray[0] = fArray6[0] + fArray7[n] * fArray5[0];
                    fArray[1] = fArray6[1] + fArray7[n] * fArray5[1];
                    break;
                }
                default: {
                    throw new InternalError("XXX");
                }
            }
        }
        return fArray;
    }

    public final float getSize() {
        return VectorUtil.distVec3(this.low, this.high);
    }

    public final float[] getCenter() {
        return this.center;
    }

    public final AABBox scale(float f, float[] fArray) {
        fArray[0] = this.high[0] - this.center[0];
        fArray[1] = this.high[1] - this.center[1];
        fArray[2] = this.high[2] - this.center[2];
        VectorUtil.scaleVec3(fArray, fArray, f);
        VectorUtil.addVec3(this.high, this.center, fArray);
        fArray[0] = this.low[0] - this.center[0];
        fArray[1] = this.low[1] - this.center[1];
        fArray[2] = this.low[2] - this.center[2];
        VectorUtil.scaleVec3(fArray, fArray, f);
        VectorUtil.addVec3(this.low, this.center, fArray);
        return this;
    }

    public final AABBox translate(float[] fArray) {
        VectorUtil.addVec3(this.low, this.low, fArray);
        VectorUtil.addVec3(this.high, this.high, fArray);
        this.computeCenter();
        return this;
    }

    public final AABBox rotate(Quaternion quaternion) {
        quaternion.rotateVector(this.low, 0, this.low, 0);
        quaternion.rotateVector(this.high, 0, this.high, 0);
        this.computeCenter();
        return this;
    }

    public final float getMinX() {
        return this.low[0];
    }

    public final float getMinY() {
        return this.low[1];
    }

    public final float getMinZ() {
        return this.low[2];
    }

    public final float getMaxX() {
        return this.high[0];
    }

    public final float getMaxY() {
        return this.high[1];
    }

    public final float getMaxZ() {
        return this.high[2];
    }

    public final float getWidth() {
        return this.high[0] - this.low[0];
    }

    public final float getHeight() {
        return this.high[1] - this.low[1];
    }

    public final float getDepth() {
        return this.high[2] - this.low[2];
    }

    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (null == object || !(object instanceof AABBox)) {
            return false;
        }
        AABBox aABBox = (AABBox)object;
        return VectorUtil.isVec2Equal(this.low, 0, aABBox.low, 0, 1.1920929E-7f) && VectorUtil.isVec3Equal(this.high, 0, aABBox.high, 0, 1.1920929E-7f);
    }

    public final int hashCode() {
        throw new InternalError("hashCode not designed");
    }

    public AABBox mapToWindow(AABBox aABBox, float[] fArray, int[] nArray, boolean bl, float[] fArray2, float[] fArray3, float[] fArray4) {
        float f = bl ? this.center[2] : this.getMinZ();
        FloatUtil.mapObjToWinCoords(this.getMinX(), this.getMinY(), f, fArray, nArray, 0, fArray2, 0, fArray3, fArray4);
        aABBox.reset();
        aABBox.resize(fArray2, 0);
        FloatUtil.mapObjToWinCoords(this.getMinX(), this.getMaxY(), f, fArray, nArray, 0, fArray2, 0, fArray3, fArray4);
        aABBox.resize(fArray2, 0);
        FloatUtil.mapObjToWinCoords(this.getMaxX(), this.getMinY(), f, fArray, nArray, 0, fArray2, 0, fArray3, fArray4);
        aABBox.resize(fArray2, 0);
        FloatUtil.mapObjToWinCoords(this.getMaxX(), this.getMaxY(), f, fArray, nArray, 0, fArray2, 0, fArray3, fArray4);
        aABBox.resize(fArray2, 0);
        if (!bl) {
            f = this.getMaxZ();
            FloatUtil.mapObjToWinCoords(this.getMinX(), this.getMinY(), f, fArray, nArray, 0, fArray2, 0, fArray3, fArray4);
            aABBox.resize(fArray2, 0);
            FloatUtil.mapObjToWinCoords(this.getMinX(), this.getMaxY(), f, fArray, nArray, 0, fArray2, 0, fArray3, fArray4);
            aABBox.resize(fArray2, 0);
            FloatUtil.mapObjToWinCoords(this.getMaxX(), this.getMinY(), f, fArray, nArray, 0, fArray2, 0, fArray3, fArray4);
            aABBox.resize(fArray2, 0);
            FloatUtil.mapObjToWinCoords(this.getMaxX(), this.getMaxY(), f, fArray, nArray, 0, fArray2, 0, fArray3, fArray4);
            aABBox.resize(fArray2, 0);
        }
        if (DEBUG) {
            System.err.printf("AABBox.mapToWindow: view[%d, %d], this %s -> %s%n", nArray[0], nArray[1], this.toString(), aABBox.toString());
        }
        return aABBox;
    }

    public final String toString() {
        return "[ dim " + this.getWidth() + " x " + this.getHeight() + " x " + this.getDepth() + ", box " + this.low[0] + " / " + this.low[1] + " / " + this.low[2] + " .. " + this.high[0] + " / " + this.high[1] + " / " + this.high[2] + ", ctr " + this.center[0] + " / " + this.center[1] + " / " + this.center[2] + " ]";
    }
}

