/*
 * Decompiled with CFR 0.152.
 */
package info.bliki.wiki.dump;

import info.bliki.wiki.dump.IArticleFilter;
import info.bliki.wiki.dump.Siteinfo;
import info.bliki.wiki.dump.WikiArticle;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.zip.GZIPInputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class WikiXMLParser
extends DefaultHandler {
    private static final String WIKIPEDIA_SITEINFO = "siteinfo";
    private static final String WIKIPEDIA_TITLE = "title";
    private static final String WIKIPEDIA_TEXT = "text";
    private static final String WIKIPEDIA_PAGE = "page";
    private static final String WIKIPEDIA_REVISION = "revision";
    private static final String WIKIPEDIA_NAMESPACE = "namespace";
    private static final String WIKIPEDIA_TIMESTAMP = "timestamp";
    private static final String WIKIPEDIA_ID = "id";
    private Siteinfo fSiteinfo = null;
    private String fNamespaceKey = null;
    private WikiArticle fArticle;
    private boolean fRevision;
    private StringBuilder fData;
    private XMLReader fXMLReader;
    private Reader fReader;
    private IArticleFilter fArticleFilter;

    public WikiXMLParser(File filename, IArticleFilter filter) throws IOException, SAXException {
        this(WikiXMLParser.getReader(filename), filter);
    }

    public WikiXMLParser(InputStream inputStream, IArticleFilter filter) throws SAXException {
        this.fArticleFilter = filter;
        this.fXMLReader = XMLReaderFactory.createXMLReader();
        this.fXMLReader.setContentHandler(this);
        this.fXMLReader.setErrorHandler(this);
        this.fReader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
    }

    public WikiXMLParser(Reader reader, IArticleFilter filter) throws SAXException {
        this.fArticleFilter = filter;
        this.fXMLReader = XMLReaderFactory.createXMLReader();
        this.fXMLReader.setContentHandler(this);
        this.fXMLReader.setErrorHandler(this);
        this.fReader = reader;
    }

    public static Reader getReader(File wikiDumpFilename) throws IOException {
        InputStream inputStream = new FileInputStream(wikiDumpFilename);
        if (wikiDumpFilename.getName().endsWith(".gz")) {
            inputStream = new GZIPInputStream(inputStream);
        } else if (wikiDumpFilename.getName().endsWith(".bz2")) {
            inputStream = new BZip2CompressorInputStream(inputStream, true);
        }
        return new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
    }

    private String getString() {
        if (this.fData == null) {
            return null;
        }
        String s = this.fData.toString();
        this.fData = null;
        return s;
    }

    @Override
    public void startDocument() {
    }

    @Override
    public void endDocument() {
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) {
        this.fData = null;
        if (WIKIPEDIA_SITEINFO.equals(qName)) {
            this.fSiteinfo = new Siteinfo();
            return;
        }
        if (this.fArticle == null) {
            this.fNamespaceKey = null;
            if (this.fSiteinfo != null && WIKIPEDIA_NAMESPACE.equals(qName)) {
                this.fNamespaceKey = atts.getValue("key");
                return;
            }
        }
        if (WIKIPEDIA_PAGE.equals(qName)) {
            this.fArticle = new WikiArticle();
            this.fRevision = false;
        }
        if (WIKIPEDIA_REVISION.equals(qName)) {
            this.fRevision = true;
        }
    }

    @Override
    public void endElement(String uri, String name, String qName) throws SAXException {
        try {
            if (this.fArticle == null) {
                if (this.fSiteinfo != null) {
                    if (WIKIPEDIA_NAMESPACE.equals(qName) && this.fNamespaceKey != null) {
                        this.fSiteinfo.addNamespace(this.fNamespaceKey, this.getString());
                    } else if ("sitename".equals(qName)) {
                        this.fSiteinfo.setSitename(this.getString());
                    } else if ("base".equals(qName)) {
                        this.fSiteinfo.setBase(this.getString());
                    } else if ("generator".equals(qName)) {
                        this.fSiteinfo.setGenerator(this.getString());
                    } else if ("case".equals(qName)) {
                        this.fSiteinfo.setCharacterCase(this.getString());
                    }
                }
            } else if (!WIKIPEDIA_PAGE.equals(qName)) {
                if (WIKIPEDIA_TEXT.equals(qName)) {
                    this.fArticle.setText(this.getString());
                    try {
                        this.fArticleFilter.process(this.fArticle, this.fSiteinfo);
                    }
                    catch (IOException e) {
                        throw new SAXException(e);
                    }
                } else if (WIKIPEDIA_TITLE.equals(qName)) {
                    this.fArticle.setTitle(this.getString(), this.fSiteinfo);
                } else if (WIKIPEDIA_TIMESTAMP.equals(qName)) {
                    this.fArticle.setTimeStamp(this.getString());
                } else if (!this.fRevision && WIKIPEDIA_ID.equals(qName)) {
                    this.fArticle.setId(this.getString());
                } else if (this.fRevision && WIKIPEDIA_ID.equals(qName)) {
                    this.fArticle.setRevisionId(this.getString());
                }
            }
            this.fData = null;
        }
        catch (RuntimeException re) {
            re.printStackTrace();
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.fData == null) {
            this.fData = new StringBuilder(length);
        }
        this.fData.append(ch, start, length);
    }

    public void parse() throws IOException, SAXException {
        this.fXMLReader.parse(new InputSource(this.fReader));
    }
}

