/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.wiki;

import com.google.gson.Gson;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.zip.GZIPInputStream;
import net.osmand.PlatformUtil;
import net.osmand.data.Amenity;
import net.osmand.data.LatLon;
import net.osmand.impl.ConsoleProgressImplementation;
import net.osmand.map.OsmandRegions;
import net.osmand.obf.preparation.DBDialect;
import net.osmand.obf.preparation.OsmDbAccessor;
import net.osmand.obf.preparation.OsmDbAccessorContext;
import net.osmand.obf.preparation.OsmDbCreator;
import net.osmand.osm.MapPoiTypes;
import net.osmand.osm.MapRenderingTypesEncoder;
import net.osmand.osm.edit.Entity;
import net.osmand.osm.edit.EntityParser;
import net.osmand.osm.edit.Node;
import net.osmand.osm.edit.OsmMapUtils;
import net.osmand.osm.edit.Relation;
import net.osmand.osm.edit.Way;
import net.osmand.osm.io.IOsmStorageFilter;
import net.osmand.osm.io.OsmBaseStorage;
import net.osmand.osm.io.OsmBaseStoragePbf;
import net.osmand.util.Algorithms;
import net.osmand.wiki.WikiDatabasePreparation;
import net.osmand.wiki.wikidata.WikiDataHandler;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.logging.Log;
import org.xmlpull.v1.XmlPullParserException;

public class OsmCoordinatesByTag {
    DBDialect osmDBdialect = DBDialect.SQLITE;
    private static final Log log = PlatformUtil.getLog(OsmCoordinatesByTag.class);
    private final Set<String> filterExactTags;
    private final String[] filterStartsWithTags;
    private final Map<String, OsmLatLonId> coordinates = new HashMap<String, OsmLatLonId>();
    private int registeredNodes = 0;
    private int registeredWays = 0;
    private int registeredRelations = 0;
    private Gson gson = new Gson();
    private MapRenderingTypesEncoder renderingTypes;
    private MapPoiTypes poiTypes;

    public OsmCoordinatesByTag(String[] filterExactTags, String[] filterStartsWithTags) {
        this.filterExactTags = new TreeSet<String>(Arrays.asList(filterExactTags));
        this.filterStartsWithTags = filterStartsWithTags;
        this.renderingTypes = new MapRenderingTypesEncoder("basemap");
        this.poiTypes = MapPoiTypes.getDefault();
    }

    public OsmCoordinatesByTag parse(File folderWithSql) throws SQLException {
        File[] listFiles = folderWithSql.listFiles();
        if (listFiles != null) {
            for (File f : listFiles) {
                if (!f.getName().startsWith("osm_wiki_") || f.getName().endsWith(".db")) continue;
                boolean parseRelations = f.getName().contains("multi");
                try {
                    this.parseOSMCoordinates(f, null, parseRelations);
                }
                catch (IOException | InterruptedException | SQLException | XmlPullParserException e) {
                    throw new IllegalArgumentException("Error parsing " + f.getName() + " file", e);
                }
            }
        } else {
            log.error((Object)"osm_wiki_*.gz files is absent");
        }
        return this;
    }

    public static void main(String[] args) throws IOException, SQLException, XmlPullParserException, InterruptedException {
        StringBuilder sb;
        File osmGz = new File("/Users/victorshcherb/Desktop/");
        OsmCoordinatesByTag otag = new OsmCoordinatesByTag(new String[]{"wikipedia", "wikidata"}, new String[]{"wikipedia:"}).parse(osmGz);
        for (Map.Entry<String, OsmLatLonId> e : otag.coordinates.entrySet()) {
            System.out.println(e.getValue().toString(e.getKey()) + " " + e.getValue().lat + " " + e.getValue().lon);
        }
        File wikidataDb = new File(osmGz, "wikidata_osm.sqlitedb");
        OsmandRegions or = new OsmandRegions();
        or.prepareFile();
        WikiDataHandler wdh = new WikiDataHandler(null, null, wikidataDb, otag, or, 0L);
        long testwid = 2051638L;
        if (testwid > 0L) {
            URL url = new URL("https://www.wikidata.org/w/api.php?action=wbgetentities&ids=Q2051638&format=json&props=labels");
            sb = Algorithms.readFromInputStream((InputStream)url.openStream());
        } else {
            sb = Algorithms.readFromInputStream((InputStream)OsmCoordinatesByTag.class.getResourceAsStream("/Q" + testwid + ".json"));
        }
        wdh.processJsonPage(testwid, sb.toString());
        wdh.finish();
        WikiDatabasePreparation.createOSMWikidataTable(wikidataDb, otag);
    }

    private static String combineTagValue(String tag, String value) {
        return tag + "___" + value;
    }

    public OsmLatLonId getCoordinates(String tag, String value) {
        return this.coordinates.get(OsmCoordinatesByTag.combineTagValue(tag, value));
    }

    private boolean checkIfTagsSuitable(Entity entity) {
        for (String t : entity.getTagKeySet()) {
            if (!this.checkTagSuitable(t)) continue;
            return true;
        }
        return false;
    }

    private boolean checkTagSuitable(String tag) {
        if (this.filterExactTags.contains(tag)) {
            return true;
        }
        for (String fl : this.filterStartsWithTags) {
            if (!tag.startsWith(fl)) continue;
            return true;
        }
        return false;
    }

    private void registerEntity(Entity entity) {
        LatLon center = OsmMapUtils.getCenter((Entity)entity);
        if (center == null) {
            return;
        }
        List alist = new ArrayList();
        for (String t : entity.getTagKeySet()) {
            OsmLatLonId oldValue;
            if (!this.checkTagSuitable(t)) continue;
            if (entity instanceof Node) {
                ++this.registeredNodes;
            } else if (entity instanceof Way) {
                ++this.registeredWays;
            } else if (entity instanceof Relation) {
                ++this.registeredRelations;
            }
            String key = OsmCoordinatesByTag.combineTagValue(t, entity.getTag(t));
            OsmLatLonId osmLatLonId = new OsmLatLonId();
            osmLatLonId.lat = center.getLatitude();
            osmLatLonId.lon = center.getLongitude();
            osmLatLonId.id = entity.getId();
            osmLatLonId.type = Entity.EntityType.valueOf((Entity)entity).ordinal();
            Map<String, String> etags = this.renderingTypes.transformTags(entity.getTags(), Entity.EntityType.valueOf((Entity)entity), MapRenderingTypesEncoder.EntityConvertApplyType.POI);
            Map<String, String> wikiCommonsTags = this.getWikiCommonsTag(etags);
            osmLatLonId.wikiCommonsImg = wikiCommonsTags.get("img");
            osmLatLonId.wikiCommonsCat = wikiCommonsTags.get("cat");
            osmLatLonId.tagsJson = this.gson.toJson(etags);
            alist.clear();
            alist = EntityParser.parseAmenities((MapPoiTypes)this.poiTypes, (Entity)entity, etags, alist);
            if (alist.size() > 0) {
                osmLatLonId.amenity = (Amenity)alist.get(0);
            }
            osmLatLonId.next = oldValue = this.coordinates.put(key, osmLatLonId);
        }
    }

    private Map<String, String> getWikiCommonsTag(Map<String, String> etags) {
        HashMap<String, String> tags = new HashMap<String, String>();
        String wikiCommonsTag = etags.get("wikimedia_commons");
        if (wikiCommonsTag == null) {
            return Collections.emptyMap();
        }
        if (wikiCommonsTag.startsWith("File:")) {
            tags.put("img", wikiCommonsTag.substring("File:".length()));
        }
        if (wikiCommonsTag.startsWith("Category:")) {
            tags.put("cat", wikiCommonsTag.substring("Category:".length()));
        }
        return tags;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parseOSMCoordinates(File readFile, ConsoleProgressImplementation progress, final boolean parseRelations) throws IOException, SQLException, XmlPullParserException, InterruptedException {
        if (progress == null) {
            progress = new ConsoleProgressImplementation();
        }
        File dbFile = new File(readFile.getParentFile(), readFile.getName() + ".db");
        OsmDbAccessor accessor = new OsmDbAccessor();
        final boolean[] hasRelations = new boolean[]{false};
        progress.setGeneralProgress("Start reading " + readFile.getName() + "... ");
        try {
            FilterInputStream stream;
            if (this.osmDBdialect.databaseFileExists(dbFile)) {
                this.osmDBdialect.removeDatabase(dbFile);
            }
            boolean pbfFile = false;
            BufferedInputStream streamFile = stream = new BufferedInputStream(new FileInputStream(readFile), 32768);
            if (readFile.getName().endsWith(".bz2")) {
                stream = new BZip2CompressorInputStream((InputStream)stream);
            } else if (readFile.getName().endsWith(".gz")) {
                stream = new GZIPInputStream(stream);
            } else if (readFile.getName().endsWith(".pbf")) {
                pbfFile = true;
            }
            OsmBaseStoragePbf storage = pbfFile ? new OsmBaseStoragePbf() : new OsmBaseStorage();
            storage.getFilters().add(new IOsmStorageFilter(){

                public boolean acceptEntityToLoad(OsmBaseStorage storage, Entity.EntityId entityId, Entity entity) {
                    if (entityId.getType() == Entity.EntityType.NODE && OsmCoordinatesByTag.this.checkIfTagsSuitable(entity)) {
                        OsmCoordinatesByTag.this.registerEntity(entity);
                    }
                    if (OsmCoordinatesByTag.this.checkIfTagsSuitable(entity)) {
                        return true;
                    }
                    if (entityId.getType() == Entity.EntityType.RELATION) {
                        hasRelations[0] = true;
                    }
                    if (parseRelations) {
                        return true;
                    }
                    return entityId.getType() == Entity.EntityType.NODE;
                }
            });
            Connection dbConn = this.osmDBdialect.getDatabaseConnection(dbFile.getAbsolutePath(), log);
            accessor.setDbConn(dbConn, this.osmDBdialect);
            OsmDbCreator dbCreator = new OsmDbCreator(false);
            dbCreator.initDatabase(this.osmDBdialect, dbConn, true, null);
            storage.getFilters().add(dbCreator);
            progress.startTask("Reading osm file " + readFile.getName(), -1);
            if (pbfFile) {
                storage.parseOSMPbf(stream, progress, false);
            } else {
                storage.parseOSM(stream, progress, streamFile, false);
            }
            dbCreator.finishLoading();
            this.osmDBdialect.commitDatabase(accessor.getDbConn());
            accessor.initDatabase();
            if (!hasRelations[0] || parseRelations) {
                progress.startTask("Iterate over ways", -1);
                accessor.iterateOverEntities(progress, Entity.EntityType.WAY, new OsmDbAccessor.OsmDbVisitor(){

                    @Override
                    public void iterateEntity(Entity e, OsmDbAccessorContext ctx) throws SQLException {
                        ctx.loadEntityWay((Way)e);
                        if (OsmCoordinatesByTag.this.checkIfTagsSuitable(e)) {
                            OsmCoordinatesByTag.this.registerEntity(e);
                        }
                    }
                });
                progress.finishTask();
                if (parseRelations) {
                    progress.startTask("Iterate over relations", -1);
                    accessor.iterateOverEntities(progress, Entity.EntityType.RELATION, new OsmDbAccessor.OsmDbVisitor(){

                        @Override
                        public void iterateEntity(Entity e, OsmDbAccessorContext ctx) throws SQLException {
                            ctx.loadEntityRelation((Relation)e);
                            if (OsmCoordinatesByTag.this.checkIfTagsSuitable(e)) {
                                OsmCoordinatesByTag.this.registerEntity(e);
                            }
                        }
                    });
                    progress.finishTask();
                }
            }
        }
        finally {
            if (accessor.getDbConn() != null) {
                this.osmDBdialect.closeDatabase(accessor.getDbConn());
            }
            this.osmDBdialect.removeDatabase(dbFile);
        }
        if (hasRelations[0] && !parseRelations) {
            this.parseOSMCoordinates(readFile, progress, true);
        }
        System.out.printf("Total %d registered (%d nodes, %d ways, %d relations)%n", this.coordinates.size(), this.registeredNodes, this.registeredWays, this.registeredRelations);
        OsmCoordinatesByTag.printMemoryConsumption("");
    }

    private static void printMemoryConsumption(String string) {
        Runtime runtime = Runtime.getRuntime();
        runtime.runFinalization();
        runtime.gc();
        Thread.yield();
        long usedMem1 = runtime.totalMemory() - runtime.freeMemory();
        float mb = 1048576.0f;
        log.warn((Object)(string + (float)usedMem1 / mb));
    }

    public void closeConnection() throws SQLException {
    }

    public static class OsmLatLonId {
        public double lat;
        public double lon;
        public long id;
        public int type;
        public long wikidataId;
        public String wikiCommonsImg;
        public String wikiCommonsCat;
        public String tagsJson;
        public OsmLatLonId next;
        public Amenity amenity;

        public String toString(String key) {
            OsmLatLonId ol = this;
            return String.format("osmid=%d %d wikidataid=%d key=%s amenity(%s)", ol.type, ol.id, ol.wikidataId, key, ol.amenity);
        }

        public String toString() {
            return this.toString("");
        }
    }
}

