/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.util;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import net.osmand.map.OsmandRegions;
import net.osmand.map.WorldRegion;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MapsCollection {
    private static final Log log = LogFactory.getLog(MapsCollection.class);
    private final OsmandRegions osmandRegions;
    private final boolean filterDuplicates;
    private final List<File> allFiles = new ArrayList<File>();
    private List<File> filesToUse;

    public MapsCollection(boolean filterDuplicates) throws IOException {
        this.filterDuplicates = filterDuplicates;
        if (filterDuplicates) {
            this.osmandRegions = new OsmandRegions();
            this.osmandRegions.prepareFile();
        } else {
            this.osmandRegions = null;
        }
    }

    public void add(File obf) {
        this.allFiles.add(obf);
    }

    public List<File> getFilesToUse() throws IOException {
        if (this.filesToUse != null) {
            return this.filesToUse;
        }
        this.filesToUse = new ArrayList<File>();
        if (!this.filterDuplicates) {
            this.filesToUse.addAll(this.allFiles);
            return this.filesToUse;
        }
        TreeSet<String> allDwNames = new TreeSet<String>();
        for (File file : this.allFiles) {
            allDwNames.add(this.getDownloadNameByFileName(file.getName()));
        }
        for (File file : this.allFiles) {
            String dwName = this.getDownloadNameByFileName(file.getName());
            WorldRegion wr = this.osmandRegions.getRegionDataByDownloadName(dwName);
            if (wr != null && wr.getSuperregion() != null && wr.getSuperregion().getRegionDownloadName() != null && allDwNames.contains(wr.getSuperregion().getRegionDownloadName())) {
                log.debug((Object)("SKIP initializing cause bigger map is present: " + file.getName()));
                continue;
            }
            this.filesToUse.add(file);
        }
        return this.filesToUse;
    }

    private String getDownloadNameByFileName(String fileName) {
        String dwName = fileName.substring(0, fileName.indexOf(46)).toLowerCase();
        if (dwName.endsWith("_2")) {
            dwName = dwName.substring(0, dwName.length() - 2);
        }
        return dwName;
    }
}

