/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.osmand.util.Algorithms;
import net.osmand.util.CountryOcbfGeneration;
import org.xmlpull.v1.XmlPullParserException;

public class GenerateExtractScript {
    private static final String PLANET_CONST = "planet";
    private static final int MAXIMUM_OSMIUM_SPLIT = 20;

    public static void main(String[] args) throws IOException, XmlPullParserException {
        String location = "/Users/victorshcherb/osmand/temp/osmconvert/";
        if (args.length > 0) {
            location = args[0];
        }
        String repo = "/Users/victorshcherb/osmand/repos/";
        if (args.length > 1) {
            repo = args[1];
        }
        new GenerateExtractScript().process(location, repo);
    }

    private void process(String location, String repo) throws IOException, XmlPullParserException {
        File regionFolder;
        CountryOcbfGeneration ocbfGeneration = new CountryOcbfGeneration();
        CountryOcbfGeneration.CountryRegion regionStructure = ocbfGeneration.parseRegionStructureFromRepo(repo);
        Map<String, File> polygons = ocbfGeneration.getPolygons(repo);
        ArrayList<CountryOcbfGeneration.CountryRegion> parentRegions = new ArrayList<CountryOcbfGeneration.CountryRegion>();
        parentRegions.addAll(regionStructure.getChildren());
        TreeMap existingParentRegions = new TreeMap();
        TreeMap<String, Integer> regionsDepths = new TreeMap<String, Integer>();
        existingParentRegions.put(PLANET_CONST, new ArrayList());
        regionsDepths.put(PLANET_CONST, 0);
        while (!parentRegions.isEmpty()) {
            ArrayList<CountryOcbfGeneration.CountryRegion> children = new ArrayList<CountryOcbfGeneration.CountryRegion>();
            for (CountryOcbfGeneration.CountryRegion reg : parentRegions) {
                regionFolder = new File(location, reg.getDownloadName());
                String boundary = reg.boundary;
                if (boundary == null && !Algorithms.isEmpty((CharSequence)reg.getSinglePolyExtract())) {
                    boundary = reg.name;
                }
                children.addAll(reg.getChildren());
                if (reg.getDownloadName().equals(reg.getParent().getDownloadName())) continue;
                if (existingParentRegions.containsKey(reg.getDownloadName())) {
                    throw new IllegalStateException("Already processed " + reg.getDownloadName());
                }
                String parentExtract = null;
                if (!Algorithms.isEmpty((CharSequence)reg.getSinglePolyExtract())) {
                    parentExtract = reg.getSinglePolyExtract();
                } else if (!(reg.getParent() == null || reg.getParent().boundary == null && Algorithms.isEmpty((CharSequence)reg.getParent().getSinglePolyExtract()))) {
                    parentExtract = reg.getParent().getDownloadName();
                }
                File polygonFile = null;
                if (boundary != null) {
                    polygonFile = this.getPolygonFile(polygons, reg, regionFolder, boundary, reg.getDownloadName());
                }
                if (polygonFile == null) {
                    System.err.println("WARN: Boundary doesn't exist " + reg.getDownloadName());
                    continue;
                }
                if (Algorithms.isEmpty((CharSequence)parentExtract) || !existingParentRegions.containsKey(parentExtract)) {
                    System.err.println("WARN: Parent Boundary doesn't exist " + reg.getDownloadName() + " from " + parentExtract);
                    continue;
                }
                ((List)existingParentRegions.get(parentExtract)).add(reg.getDownloadName());
                existingParentRegions.put(reg.getDownloadName(), new ArrayList());
                int depth = (Integer)regionsDepths.get(parentExtract) + 1;
                regionsDepths.put(reg.getDownloadName(), depth);
                System.out.println(reg.getDownloadName() + " - extract from " + parentExtract + " " + depth);
                this.writeToFile(regionFolder, ".depth", "" + depth);
                if (reg.hasMapFiles()) {
                    this.writeToFile(regionFolder, ".map", "1");
                } else {
                    new File(regionFolder, ".map").delete();
                }
                this.writeToFile(regionFolder, ".parent", parentExtract);
            }
            parentRegions = children;
        }
        for (String parentRegion : existingParentRegions.keySet()) {
            List children = (List)existingParentRegions.get(parentRegion);
            regionFolder = parentRegion.equals(PLANET_CONST) ? new File(location) : new File(location, parentRegion);
            for (int k = 0; k < 10; ++k) {
                new File(regionFolder, this.getExtractFileByIndex(k)).delete();
            }
            if (children.size() <= 0) continue;
            int indExtract = 0;
            ArrayList<String> sublist = new ArrayList<String>();
            int buckets = children.size() / 20 + (children.size() % 20 == 0 ? 0 : 1);
            int optimalSize = children.size() / buckets + (children.size() % buckets == 0 ? 0 : 1);
            for (String c : children) {
                sublist.add(c);
                if (sublist.size() != optimalSize) continue;
                this.generateOsmiumExtract(location, parentRegion, sublist, regionFolder, indExtract++);
                sublist.clear();
            }
            if (sublist.size() <= 0) continue;
            this.generateOsmiumExtract(location, parentRegion, sublist, regionFolder, indExtract++);
        }
    }

    private String getExtractFileByIndex(int ind) {
        if (ind == 0) {
            return "extract.json";
        }
        return "extract_" + (ind + 1) + ".json";
    }

    private void generateOsmiumExtract(String location, String parentRegion, List<String> children, File regionFolder, int ind) throws IOException {
        String extractFile = this.getExtractFileByIndex(ind);
        StringBuilder bld = new StringBuilder();
        for (String child : children) {
            if (bld.length() == 0) {
                bld.append("{").append("\n");
                bld.append("\n  ").append(String.format(" \"directory\": \"%s\", ", location));
                bld.append("\n  ").append(String.format(" \"extracts\": [ \n", location));
            } else {
                bld.append(",").append("\n");
            }
            bld.append("     {");
            bld.append("\n        ").append(String.format("\"output\": \"%s\", ", child + "/" + child + ".pbf"));
            bld.append("\n        ").append(String.format("\"polygon\": { \"file_name\" : \"%s\" } ", new File(location).getAbsolutePath() + "/" + child + "/" + child + ".poly"));
            bld.append("\n     }");
        }
        bld.append("\n]}");
        System.out.println("Extract " + children.size() + " files from " + parentRegion + " " + extractFile);
        this.writeToFile(regionFolder, extractFile, bld.toString());
    }

    private void writeToFile(File countryFolder, String fn, String cont) throws IOException {
        File fl = new File(countryFolder, fn);
        FileOutputStream fous = new FileOutputStream(fl);
        if (cont != null) {
            fous.write(cont.getBytes());
        }
        fous.close();
    }

    private File getPolygonFile(Map<String, File> polygons, CountryOcbfGeneration.CountryRegion reg, File countryFolder, String boundary, String regFile) throws IOException {
        File file = polygons.get(boundary);
        if (file != null) {
            File polygonFile = new File(countryFolder, regFile + ".poly");
            countryFolder.mkdirs();
            if (!polygonFile.exists() || polygonFile.length() != file.length()) {
                Algorithms.fileCopy((File)file, (File)polygonFile);
            }
            return polygonFile;
        }
        return null;
    }
}

