/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.obf.preparation;

import gnu.trove.list.array.TIntArrayList;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.osmand.binary.MapZooms;
import net.osmand.data.TransportRoute;
import net.osmand.obf.preparation.IndexCreationContext;
import net.osmand.obf.preparation.IndexCreatorSettings;
import net.osmand.obf.preparation.IndexHeightData;
import net.osmand.obf.preparation.IndexTransportCreator;
import net.osmand.obf.preparation.OsmDbAccessorContext;
import net.osmand.osm.MapRenderingTypesEncoder;
import net.osmand.osm.OsmRouteType;
import net.osmand.osm.edit.Entity;
import net.osmand.osm.edit.OSMSettings;
import net.osmand.osm.edit.Relation;
import net.osmand.osm.edit.Way;
import net.osmand.util.MapAlgorithms;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IndexRouteRelationCreatorV1 {
    private static final Log log = LogFactory.getLog(IndexRouteRelationCreatorV1.class);
    public static long GENERATE_OBJ_ID = -1048576L;
    public static final double DIST_STEP = 25.0;
    public static final int MAX_GRAPH_SKIP_POINTS_BITS = 3;
    protected final Log logMapDataWarn;
    private final Map<String, Integer> indexRouteRelationTypes = new TreeMap<String, Integer>();
    private final MapRenderingTypesEncoder renderingTypes;
    private final MapZooms mapZooms;
    private final IndexCreatorSettings settings;

    public IndexRouteRelationCreatorV1(Log logMapDataWarn, MapZooms mapZooms, MapRenderingTypesEncoder renderingTypes, IndexCreatorSettings settings) {
        this.logMapDataWarn = logMapDataWarn;
        this.mapZooms = mapZooms;
        this.settings = settings;
        this.renderingTypes = renderingTypes;
    }

    public void iterateRelation(Entity e, OsmDbAccessorContext ctx, IndexCreationContext icc) throws SQLException {
        if (e instanceof Relation) {
            long ts = System.currentTimeMillis();
            this.processRouteRelation((Relation)e, ctx, icc);
            long tm = (System.currentTimeMillis() - ts) / 1000L;
            if (tm > 15L) {
                log.warn((Object)String.format("Route relation %d took %d seconds to process", e.getId(), tm));
            }
        }
    }

    public void iterateMainEntity(Entity e, OsmDbAccessorContext ctx, IndexCreationContext icc) throws SQLException {
    }

    private void processRouteRelation(Relation e, OsmDbAccessorContext ctx, IndexCreationContext icc) throws SQLException {
        boolean infra;
        Map<String, String> tags = this.renderingTypes.transformTags(e.getTags(), Entity.EntityType.RELATION, MapRenderingTypesEncoder.EntityConvertApplyType.MAP);
        String rt = tags.get(OSMSettings.OSMTagKey.ROUTE.name());
        boolean publicTransport = IndexTransportCreator.acceptedPublicTransportRoute(rt);
        boolean road = "road".equals(rt);
        boolean railway = "railway".equals(rt);
        boolean bl = infra = "power".equals(rt) || "pipeline".equals(rt);
        if (!(rt == null || publicTransport || road || railway || infra)) {
            ctx.loadEntityRelation(e);
            ArrayList<Way> ways = new ArrayList<Way>();
            List ms = e.getMembers();
            tags = new LinkedHashMap<String, String>(tags);
            OsmRouteType activityType = OsmRouteType.getTypeFromOSMTags(tags);
            for (Relation.RelationMember rm : ms) {
                if (!(rm.getEntity() instanceof Way)) continue;
                Way w = (Way)rm.getEntity();
                Way newWay = new Way(GENERATE_OBJ_ID--, w.getNodes());
                newWay.replaceTags(tags);
                ways.add(newWay);
            }
            TransportRoute.mergeRouteWays(ways);
            for (Way w : ways) {
                this.addRouteRelationTags(e, w, tags, activityType, icc);
                if (this.settings.addRegionTag) {
                    icc.calcRegionTag((Entity)e, true);
                }
                w.replaceTags(tags);
                for (int level = 0; level < this.mapZooms.size(); ++level) {
                    icc.getIndexMapCreator().processMainEntity((Entity)w, w.getId(), w.getId(), level, tags, icc);
                }
                if (!this.settings.indexPOI) continue;
                icc.getIndexPoiCreator().iterateEntityInternal((Entity)w, ctx, icc);
            }
            String routeKey = activityType == null ? rt : activityType.getName();
            Integer c = this.indexRouteRelationTypes.get(routeKey);
            this.indexRouteRelationTypes.put(rt, (c == null ? 0 : c) + 1);
        }
    }

    private void addRouteRelationTags(Relation e, Way w, Map<String, String> tags, OsmRouteType activityType, IndexCreationContext icc) {
        if (tags.get("color") != null) {
            tags.put("colour", tags.get("color"));
        }
        if (activityType != null) {
            String ref = tags.get("ref");
            if (ref == null) {
                ref = String.valueOf(e.getId() % 1000L);
            }
            tags.put("ref", ref);
            int l = Math.max(1, Math.min(6, ref.length()));
            tags.put("gpx_bg", activityType.getColor() + "_hexagon_" + l + "_road_shield");
            if (tags.get("colour") == null) {
                tags.put("colour", activityType.getColor());
            }
            tags.put("route_activity_type", activityType.getName().toLowerCase());
        }
        if (icc.getIndexHeightData() != null) {
            IndexHeightData.WayGeneralStats wg = icc.getIndexHeightData().calculateWayGeneralStats(w, 25.0);
            if (tags.get("distance") == null && wg.dist > 0.0) {
                tags.put("distance", String.valueOf((int)wg.dist));
            }
            if (wg.eleCount > 0) {
                tags.put("start_ele", String.valueOf((int)wg.startEle));
                tags.put("diff_ele_up", String.valueOf((int)wg.up));
                tags.put("diff_ele_down", String.valueOf((int)wg.down));
                tags.put("ele_graph", MapAlgorithms.encodeIntHeightArrayGraph((int)wg.step, (TIntArrayList)wg.altIncs, (int)3));
            }
        }
        tags.put("route", "segment");
        tags.put("route_type", "other");
        tags.put("route_id", "O-" + e.getId());
    }

    public void closeAllStatements() {
        if (this.indexRouteRelationTypes.size() > 0) {
            ArrayList<String> lst = new ArrayList<String>(this.indexRouteRelationTypes.keySet());
            Collections.sort(lst, new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    Integer i1 = IndexRouteRelationCreatorV1.this.indexRouteRelationTypes.get(o1);
                    Integer i2 = IndexRouteRelationCreatorV1.this.indexRouteRelationTypes.get(o2);
                    if (i1 == null) {
                        return -1;
                    }
                    if (i2 == null) {
                        return -1;
                    }
                    return -Integer.compare(i1, i2);
                }
            });
            log.info((Object)"Indexed route relation types: ");
            for (String tp : lst) {
                log.info((Object)String.format("%s - %d", tp, this.indexRouteRelationTypes.get(tp)));
            }
        }
    }
}

