/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.obf.preparation;

import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import rtree.Element;
import rtree.Node;
import rtree.Pack;
import rtree.RTree;
import rtree.RTreeException;

public class AbstractIndexPartCreator {
    private static final Log log = LogFactory.getLog(AbstractIndexPartCreator.class);
    protected int BATCH_SIZE = 1000;
    protected Map<PreparedStatement, Integer> pStatements = new LinkedHashMap<PreparedStatement, Integer>();

    public PreparedStatement createPrepareStatement(Connection mapConnection, String string) throws SQLException {
        PreparedStatement prepareStatement = mapConnection.prepareStatement(string);
        this.pStatements.put(prepareStatement, 0);
        return prepareStatement;
    }

    protected void closePreparedStatements(PreparedStatement ... preparedStatements) throws SQLException {
        for (PreparedStatement p : preparedStatements) {
            if (p == null) continue;
            p.executeBatch();
            p.close();
            this.pStatements.remove(p);
        }
    }

    protected void closeAllPreparedStatements() throws SQLException {
        for (PreparedStatement p : this.pStatements.keySet()) {
            if (this.pStatements.get(p) > 0) {
                p.executeBatch();
            }
            p.close();
        }
    }

    protected boolean executePendingPreparedStatements() throws SQLException {
        boolean exec = false;
        for (PreparedStatement p : this.pStatements.keySet()) {
            if (this.pStatements.get(p) <= 0) continue;
            p.executeBatch();
            this.pStatements.put(p, 0);
            exec = true;
        }
        return exec;
    }

    protected void addBatch(PreparedStatement p) throws SQLException {
        this.addBatch(p, this.BATCH_SIZE, true);
    }

    protected void addBatch(PreparedStatement p, boolean commit) throws SQLException {
        this.addBatch(p, this.BATCH_SIZE, commit);
    }

    protected void addBatch(PreparedStatement p, int batchSize, boolean commit) throws SQLException {
        p.addBatch();
        if (this.pStatements.get(p) >= batchSize) {
            p.executeBatch();
            if (commit) {
                p.getConnection().commit();
            }
            this.pStatements.put(p, 0);
        } else {
            this.pStatements.put(p, this.pStatements.get(p) + 1);
        }
    }

    protected static boolean nodeIsLastSubTree(RTree tree, long ptr) throws RTreeException {
        Node parent = tree.getReadNode(ptr);
        Element[] e = parent.getAllElements();
        for (int i = 0; i < parent.getTotalElements(); ++i) {
            if (e[i].getElementType() == 1) continue;
            return false;
        }
        return true;
    }

    public static RTree packRtreeFile(RTree tree, String nonPackFileName, String packFileName) throws IOException {
        try {
            long rootIndex;
            tree.flush();
            File file = new File(packFileName);
            if (file.exists()) {
                file.delete();
            }
            if (!AbstractIndexPartCreator.nodeIsLastSubTree(tree, rootIndex = tree.getFileHdr().getRootIndex())) {
                new Pack().packTree(tree, packFileName);
                tree.getFileHdr().getFile().close();
                file = new File(nonPackFileName);
                file.delete();
                return new RTree(packFileName);
            }
        }
        catch (RTreeException e) {
            log.error((Object)"Error flushing", (Throwable)e);
            throw new IOException(e);
        }
        return tree;
    }
}

