/*
 * Decompiled with CFR 0.152.
 */
package net.osmand;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import net.osmand.util.MapUtils;

public class RenderableObject {
    private long id;
    private String type;
    private List<List<Integer>> points;
    private List<TypeValue> types;
    private List<TypeValue> additionalTypes;
    private String mainIcon;
    private List<String> additionalIcons;
    private String shield;
    private int iconOrder;
    private float iconSize;
    private int iconX;
    private int iconY;
    private String text;
    private int textSize;
    private int textOnPath;
    private int textColor;
    private int textShadow;
    private int textShadowColor;
    private boolean bold;
    private boolean italic;
    private String shieldRes;
    private String shieldResIcon;

    public static RenderableObject fromJson(String json) {
        return (RenderableObject)new Gson().fromJson(json, RenderableObject.class);
    }

    public static JsonObject createGeoJson(List<RenderableObject> renderableObjects) {
        JsonArray featuresArray = new JsonArray();
        for (RenderableObject obj : renderableObjects) {
            JsonObject featureObject = RenderableObject.getJsonObject(obj);
            JsonObject geometryObject = RenderableObject.getGeometryObject(obj);
            featureObject.add("geometry", (JsonElement)geometryObject);
            featuresArray.add((JsonElement)featureObject);
        }
        JsonObject geoJson = new JsonObject();
        geoJson.addProperty("type", "FeatureCollection");
        geoJson.add("features", (JsonElement)featuresArray);
        return geoJson;
    }

    private static JsonObject getGeometryObject(RenderableObject obj) {
        JsonObject geometryObject = new JsonObject();
        String geometryType = obj.type;
        geometryObject.addProperty("type", geometryType);
        if (!obj.points.isEmpty()) {
            JsonArray coordinatesArray = new JsonArray();
            for (List<Integer> point : obj.points) {
                if (point.size() < 2) continue;
                double lat = MapUtils.get31LatitudeY((int)point.get(1));
                double lon = MapUtils.get31LongitudeX((int)point.get(0));
                JsonArray pointArray = new JsonArray();
                pointArray.add((Number)lat);
                pointArray.add((Number)lon);
                coordinatesArray.add((JsonElement)pointArray);
            }
            geometryObject.add("coordinates", (JsonElement)coordinatesArray);
        }
        return geometryObject;
    }

    private static JsonObject getJsonObject(RenderableObject obj) {
        JsonObject typeObject;
        JsonObject featureObject = RenderableObject.getProperties(obj);
        if (obj.types != null && !obj.types.isEmpty()) {
            JsonArray typesArray = new JsonArray();
            for (TypeValue typeValue : obj.types) {
                typeObject = new JsonObject();
                typeObject.addProperty("tag", typeValue.tag);
                typeObject.addProperty("value", typeValue.value);
                typesArray.add((JsonElement)typeObject);
            }
            featureObject.add("types", (JsonElement)typesArray);
        }
        if (obj.additionalTypes != null && !obj.additionalTypes.isEmpty()) {
            JsonArray additionalTypesArray = new JsonArray();
            for (TypeValue typeValue : obj.additionalTypes) {
                typeObject = new JsonObject();
                typeObject.addProperty("tag", typeValue.tag);
                typeObject.addProperty("value", typeValue.value);
                additionalTypesArray.add((JsonElement)typeObject);
            }
            featureObject.add("additionalTypes", (JsonElement)additionalTypesArray);
        }
        if (obj.additionalIcons != null && !obj.additionalIcons.isEmpty()) {
            JsonArray additionalIconsArray = new JsonArray();
            for (String additionalIcon : obj.additionalIcons) {
                additionalIconsArray.add(additionalIcon);
            }
            featureObject.add("additionalIcons", (JsonElement)additionalIconsArray);
        }
        return featureObject;
    }

    private static JsonObject getProperties(RenderableObject obj) {
        JsonObject featureObject = new JsonObject();
        featureObject.addProperty("id", (Number)obj.id);
        featureObject.addProperty("type", obj.type);
        featureObject.addProperty("mainIcon", obj.mainIcon);
        featureObject.addProperty("shield", obj.shield);
        featureObject.addProperty("iconOrder", (Number)obj.iconOrder);
        featureObject.addProperty("iconSize", (Number)Float.valueOf(obj.iconSize));
        featureObject.addProperty("iconX", (Number)MapUtils.get31LongitudeX((int)obj.iconX));
        featureObject.addProperty("iconY", (Number)MapUtils.get31LatitudeY((int)obj.iconY));
        featureObject.addProperty("text", obj.text);
        featureObject.addProperty("textSize", (Number)obj.textSize);
        featureObject.addProperty("textOnPath", (Number)obj.textOnPath);
        featureObject.addProperty("textColor", (Number)obj.textColor);
        featureObject.addProperty("textShadow", (Number)obj.textShadow);
        featureObject.addProperty("textShadowColor", (Number)obj.textShadowColor);
        featureObject.addProperty("bold", Boolean.valueOf(obj.bold));
        featureObject.addProperty("italic", Boolean.valueOf(obj.italic));
        featureObject.addProperty("shieldRes", obj.shieldRes);
        featureObject.addProperty("shieldResIcon", obj.shieldResIcon);
        return featureObject;
    }

    public static class TypeValue {
        public String tag;
        public String value;
    }
}

