/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.osmand.MapCreatorVersion;
import net.osmand.map.ITileSource;
import net.osmand.map.MapTileDownloader;
import net.osmand.swing.ExceptionHandler;
import net.osmand.swing.MapPanel;
import net.osmand.swing.MapPanelSelector;
import net.osmand.swing.Messages;
import net.osmand.swing.ProgressDialog;
import net.osmand.util.MapUtils;

public class TileBundleDownloadDialog
extends JDialog {
    private static final long serialVersionUID = -4862884032977071296L;
    private JLabel label;
    private ITileSource map;
    private MapPanelSelector.MapSelectionArea selectionArea;
    private int zoom;
    private JSpinner startSpinner;
    private JSpinner endSpinner;
    private JButton downloadButton;
    private JButton cancelButton;
    private JButton specifyFolder;
    private File tilesLocation;

    public TileBundleDownloadDialog(Component parent, MapPanel panel) {
        super(JOptionPane.getFrameForComponent(parent), true);
        this.map = panel.getMap();
        panel.getLatitude();
        this.selectionArea = panel.getSelectionArea();
        this.zoom = panel.getZoom();
        this.tilesLocation = panel.getTilesLocation();
        this.setTitle(Messages.getString("TileBundleDownloadDialog.DOWNLOAD.BUNDLE.TILES"));
        this.initDialog();
    }

    public void showDialog() {
        this.setSize(550, 150);
        double x = this.getParent().getBounds().getCenterX();
        double y = this.getParent().getBounds().getCenterY();
        this.setLocation((int)x - this.getWidth() / 2, (int)y - this.getHeight() / 2);
        this.setVisible(true);
    }

    protected SpinnerNumberModel getSpinnerModel(int minimum, int maximum) {
        SpinnerNumberModel model = new SpinnerNumberModel();
        model.setStepSize(1);
        model.setValue(this.zoom);
        model.setMaximum(Integer.valueOf(maximum));
        model.setMinimum(Integer.valueOf(minimum));
        return model;
    }

    private void initDialog() {
        JPanel pane = new JPanel(new BorderLayout());
        pane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.add(pane);
        this.label = new JLabel();
        pane.add((Component)this.label, "Center");
        JPanel zoomControls = new JPanel();
        zoomControls.setLayout(new BoxLayout(zoomControls, 0));
        JLabel lab = new JLabel(Messages.getString("TileBundleDownloadDialog.START.ZOOM.LEVEL"));
        zoomControls.add(lab);
        this.startSpinner = new JSpinner(this.getSpinnerModel(this.map.getMinimumZoomSupported(), this.zoom));
        zoomControls.add(this.startSpinner);
        this.startSpinner.setMaximumSize(new Dimension(15, this.startSpinner.getMaximumSize().height));
        zoomControls.add(Box.createHorizontalStrut(15));
        lab = new JLabel(Messages.getString("TileBundleDownloadDialog.END.ZOOM.LEVEL"));
        zoomControls.add(lab);
        this.endSpinner = new JSpinner(this.getSpinnerModel(this.zoom, this.map.getMaximumZoomSupported()));
        zoomControls.add(this.endSpinner);
        this.endSpinner.setMaximumSize(new Dimension(15, this.endSpinner.getMaximumSize().height));
        zoomControls.add(Box.createHorizontalGlue());
        pane.add((Component)zoomControls, "North");
        JPanel buttonControls = new JPanel();
        buttonControls.setLayout(new BoxLayout(buttonControls, 0));
        buttonControls.add(Box.createHorizontalGlue());
        this.specifyFolder = new JButton(Messages.getString("TileBundleDownloadDialog.SPECIFY.FOLDER"));
        buttonControls.add(this.specifyFolder);
        buttonControls.add(Box.createHorizontalStrut(3));
        this.downloadButton = new JButton(Messages.getString("TileBundleDownloadDialog.DOWNLOAD.TILES"));
        buttonControls.add(this.downloadButton);
        buttonControls.add(Box.createHorizontalStrut(3));
        this.cancelButton = new JButton(Messages.getString("TileBundleDownloadDialog.CANCEL"));
        buttonControls.add(this.cancelButton);
        pane.add((Component)buttonControls, "South");
        this.updateLabel();
        this.addListeners();
    }

    private void addListeners() {
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TileBundleDownloadDialog.this.setVisible(false);
            }
        });
        this.startSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ((SpinnerNumberModel)TileBundleDownloadDialog.this.endSpinner.getModel()).setMinimum((Integer)TileBundleDownloadDialog.this.startSpinner.getValue());
                TileBundleDownloadDialog.this.updateLabel();
            }
        });
        this.endSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ((SpinnerNumberModel)TileBundleDownloadDialog.this.startSpinner.getModel()).setMaximum((Integer)TileBundleDownloadDialog.this.endSpinner.getValue());
                TileBundleDownloadDialog.this.updateLabel();
            }
        });
        this.downloadButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TileBundleDownloadDialog.this.downloadTiles();
            }
        });
        this.specifyFolder.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser fc = new JFileChooser();
                fc.setDialogTitle(Messages.getString("TileBundleDownloadDialog.CHOOSE.DIRECTORY"));
                fc.setFileSelectionMode(1);
                if (TileBundleDownloadDialog.this.tilesLocation != null) {
                    fc.setCurrentDirectory(TileBundleDownloadDialog.this.tilesLocation);
                }
                if (fc.showOpenDialog(TileBundleDownloadDialog.this) == 0 && fc.getSelectedFile() != null && fc.getSelectedFile().isDirectory()) {
                    TileBundleDownloadDialog.this.tilesLocation = fc.getSelectedFile();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downloadTiles() {
        this.setVisible(false);
        final ProgressDialog progressDialog = new ProgressDialog((Component)this, Messages.getString("TileBundleDownloadDialog.DOWNLOADING.TILES"));
        int numberTiles = 0;
        final int startZoom = (Integer)this.startSpinner.getValue();
        final int endZoom = (Integer)this.endSpinner.getValue();
        for (int zoom = startZoom; zoom <= endZoom; ++zoom) {
            int x1 = (int)MapUtils.getTileNumberX((float)zoom, (double)this.selectionArea.getLon1());
            int x2 = (int)MapUtils.getTileNumberX((float)zoom, (double)this.selectionArea.getLon2());
            int y1 = (int)MapUtils.getTileNumberY((float)zoom, (double)this.selectionArea.getLat1());
            int y2 = (int)MapUtils.getTileNumberY((float)zoom, (double)this.selectionArea.getLat2());
            numberTiles += (x2 - x1 + 1) * (y2 - y1 + 1);
        }
        final int number = numberTiles;
        final MapTileDownloader instance = MapTileDownloader.getInstance((String)MapCreatorVersion.APP_MAP_CREATOR_VERSION);
        progressDialog.setRunnable(new Runnable(){

            @Override
            public void run() {
                progressDialog.startTask(Messages.getString("TileBundleDownloadDialog.LOADING"), number);
                for (int zoom = startZoom; zoom <= endZoom; ++zoom) {
                    int x1 = (int)MapUtils.getTileNumberX((float)zoom, (double)TileBundleDownloadDialog.this.selectionArea.getLon1());
                    int x2 = (int)MapUtils.getTileNumberX((float)zoom, (double)TileBundleDownloadDialog.this.selectionArea.getLon2());
                    int y1 = (int)MapUtils.getTileNumberY((float)zoom, (double)TileBundleDownloadDialog.this.selectionArea.getLat1());
                    int y2 = (int)MapUtils.getTileNumberY((float)zoom, (double)TileBundleDownloadDialog.this.selectionArea.getLat2());
                    for (int x = x1; x <= x2; ++x) {
                        for (int y = y1; y <= y2; ++y) {
                            String file = TileBundleDownloadDialog.this.getFileForImage(x, y, zoom, TileBundleDownloadDialog.this.map.getTileFormat());
                            if (new File(TileBundleDownloadDialog.this.tilesLocation, file).exists()) {
                                progressDialog.progress(1);
                                continue;
                            }
                            MapTileDownloader.DownloadRequest req = new MapTileDownloader.DownloadRequest(TileBundleDownloadDialog.this.map.getUrlToLoad(x, y, zoom), new File(TileBundleDownloadDialog.this.tilesLocation, file), null, x, y, zoom);
                            instance.requestToDownload(req);
                        }
                    }
                    while (instance.isSomethingBeingDownloaded()) {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException e) {
                            throw new IllegalArgumentException(e);
                        }
                    }
                }
            }
        });
        ArrayList previousCallbacks = new ArrayList(instance.getDownloaderCallbacks());
        instance.getDownloaderCallbacks().clear();
        instance.addDownloaderCallback(new MapTileDownloader.IMapDownloaderCallback(){

            public void tileDownloaded(MapTileDownloader.DownloadRequest request) {
                progressDialog.progress(1);
            }
        });
        try {
            progressDialog.run();
            instance.refuseAllPreviousRequests();
        }
        catch (InvocationTargetException e) {
            ExceptionHandler.handle(e.getCause());
        }
        catch (InterruptedException e) {
            ExceptionHandler.handle(e);
        }
        finally {
            instance.getDownloaderCallbacks().clear();
            instance.getDownloaderCallbacks().addAll(previousCallbacks);
        }
    }

    public String getFileForImage(int x, int y, int zoom, String ext) {
        return this.map.getName() + "/" + zoom + "/" + x + "/" + y + ext + ".tile";
    }

    protected void updateLabel() {
        int numberTiles = 0;
        for (int zoom = ((Integer)this.startSpinner.getValue()).intValue(); zoom <= (Integer)this.endSpinner.getValue(); ++zoom) {
            int x1 = (int)MapUtils.getTileNumberX((float)zoom, (double)this.selectionArea.getLon1());
            int x2 = (int)MapUtils.getTileNumberX((float)zoom, (double)this.selectionArea.getLon2());
            int y1 = (int)MapUtils.getTileNumberY((float)zoom, (double)this.selectionArea.getLat1());
            int y2 = (int)MapUtils.getTileNumberY((float)zoom, (double)this.selectionArea.getLat2());
            numberTiles += (x2 - x1 + 1) * (y2 - y1 + 1);
        }
        String text = MessageFormat.format(Messages.getString("TileBundleDownloadDialog.REQUEST.DOWNLOAD"), numberTiles, this.map.getName(), (double)numberTiles * 12.0 / 1000.0);
        this.label.setText(text);
    }
}

