/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import net.osmand.NativeLibrary;
import net.osmand.PlatformUtil;
import net.osmand.binary.BinaryMapIndexReader;
import net.osmand.data.DataTileManager;
import net.osmand.data.LatLon;
import net.osmand.osm.edit.Entity;
import net.osmand.osm.edit.Node;
import net.osmand.osm.edit.OSMSettings;
import net.osmand.osm.edit.Way;
import net.osmand.router.GeneralRouter;
import net.osmand.router.NativeTransportRoutingResult;
import net.osmand.router.RoutingConfiguration;
import net.osmand.router.TransportRoutePlanner;
import net.osmand.router.TransportRouteResult;
import net.osmand.router.TransportRoutingConfiguration;
import net.osmand.router.TransportRoutingContext;
import net.osmand.swing.DataExtractionSettings;
import net.osmand.swing.ExceptionHandler;
import net.osmand.swing.MapPanel;
import net.osmand.swing.MapPanelLayer;
import net.osmand.swing.NativeSwingRendering;
import net.osmand.swing.OsmExtractionUI;
import net.osmand.util.MapUtils;
import org.apache.commons.logging.Log;

public class MapTransportLayer
implements MapPanelLayer {
    private static final Log log = PlatformUtil.getLog(MapTransportLayer.class);
    private static final boolean DRAW_WALK_SEGMENTS = false;
    private MapPanel map;
    private JButton prevRoute;
    private JButton infoButton;
    private JButton nextRoute;
    private LatLon start;
    private LatLon end;
    private List<TransportRouteResult> results = new ArrayList<TransportRouteResult>();
    private int currentRoute = 0;

    @Override
    public void destroyLayer() {
    }

    @Override
    public void initLayer(MapPanel map) {
        this.map = map;
        JPanel btnPanel = new JPanel();
        btnPanel.setLayout(new BoxLayout(btnPanel, 2));
        btnPanel.setOpaque(false);
        this.prevRoute = new JButton("<<");
        this.prevRoute.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (MapTransportLayer.this.currentRoute >= 0) {
                    --MapTransportLayer.this.currentRoute;
                    MapTransportLayer.this.redrawRoute();
                }
            }
        });
        this.prevRoute.setVisible(false);
        this.prevRoute.setAlignmentY(0.0f);
        btnPanel.add(this.prevRoute);
        this.nextRoute = new JButton(">>");
        this.nextRoute.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (MapTransportLayer.this.currentRoute < MapTransportLayer.this.results.size() - 1) {
                    ++MapTransportLayer.this.currentRoute;
                    MapTransportLayer.this.redrawRoute();
                }
            }
        });
        this.nextRoute.setVisible(false);
        this.nextRoute.setAlignmentY(0.0f);
        btnPanel.add(this.nextRoute);
        this.infoButton = new JButton("Info about route");
        this.infoButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        });
        this.infoButton.setVisible(false);
        this.infoButton.setAlignmentY(0.0f);
        btnPanel.add(this.infoButton);
        map.add((Component)btnPanel, 0);
        btnPanel.add(Box.createHorizontalGlue());
    }

    @Override
    public void fillPopupMenuWithActions(JPopupMenu menu) {
        AbstractAction transportRoute = new AbstractAction("Calculate route"){
            private static final long serialVersionUID = 5071561074552411238L;

            @Override
            public void actionPerformed(ActionEvent e) {
                MapTransportLayer.this.calcRoute(false);
            }
        };
        AbstractAction transportRouteSchedule = new AbstractAction("Calculate route by schedule"){
            private static final long serialVersionUID = 5071561074552411238L;

            @Override
            public void actionPerformed(ActionEvent e) {
                MapTransportLayer.this.calcRoute(true);
            }
        };
        JMenu jmenu = new JMenu("Public Transport");
        jmenu.add(transportRoute);
        jmenu.add(transportRouteSchedule);
        menu.add(jmenu);
    }

    private void redrawRoute() {
        ArrayList<Way> ways = new ArrayList<Way>();
        TransportRouteResult r = null;
        if (this.results.size() > this.currentRoute && this.currentRoute >= 0) {
            r = this.results.get(this.currentRoute);
        }
        this.calculateResult(ways, r);
        DataTileManager points = new DataTileManager(11);
        int ind = -1;
        for (Way w : ways) {
            Way wl = new Way((long)ind--);
            Node node = w.getFirstNode();
            wl.addNode(node);
            long tile = points.evaluateTile(node.getLatitude(), node.getLongitude());
            for (int i = 1; i < w.getNodes().size(); ++i) {
                Node nnode = (Node)w.getNodes().get(i);
                long ntile = points.evaluateTile(nnode.getLatitude(), nnode.getLongitude());
                wl.addNode(nnode);
                if (tile == ntile) continue;
                points.registerObject(wl.getFirstNode().getLatitude(), wl.getFirstNode().getLongitude(), (Object)wl);
                tile = ntile;
                wl = new Way((long)ind--);
                wl.addNode(nnode);
            }
            if (wl.getNodes().size() <= 0) continue;
            points.registerObject(wl.getFirstNode().getLatitude(), wl.getFirstNode().getLongitude(), (Object)wl);
        }
        this.map.setPoints((DataTileManager<Entity>)points);
        this.nextRoute.setVisible(r != null);
        this.infoButton.setVisible(r != null);
        if (r != null) {
            Object refs = "";
            List alternativeRoutes = r.getAlternativeRoutes();
            for (int i = 0; i < r.getSegments().size(); ++i) {
                TransportRoutePlanner.TransportRouteResultSegment res = (TransportRoutePlanner.TransportRouteResultSegment)r.getSegments().get(i);
                LinkedHashSet<String> segmentRefs = new LinkedHashSet<String>();
                segmentRefs.add(res.route.getRef());
                for (TransportRouteResult alt : alternativeRoutes) {
                    TransportRoutePlanner.TransportRouteResultSegment altSeg = (TransportRoutePlanner.TransportRouteResultSegment)alt.getSegments().get(i);
                    segmentRefs.add(altSeg.route.getRef());
                }
                if (i > 0) {
                    refs = (String)refs + ", ";
                }
                refs = segmentRefs.size() > 1 ? (String)refs + ((Object)segmentRefs).toString() : (String)refs + res.route.getRef();
            }
            this.infoButton.setText(String.format("%d. %.1f min (T %.1f min, W %.1f min): %s", this.currentRoute + 1, r.getRouteTime() / 60.0, r.getTravelTime() / 60.0, r.getWalkTime() / 60.0, refs));
        }
        this.prevRoute.setVisible(r != null);
        this.map.prepareImage();
    }

    private void calcRoute(final boolean schedule) {
        new Thread(){

            @Override
            public void run() {
                MapTransportLayer.this.start = DataExtractionSettings.getSettings().getStartLocation();
                MapTransportLayer.this.end = DataExtractionSettings.getSettings().getEndLocation();
                MapTransportLayer.this.buildRoute(schedule);
                MapTransportLayer.this.redrawRoute();
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void buildRoute(boolean schedule) {
        long time = System.currentTimeMillis();
        if (this.start != null && this.end != null) {
            try {
                BinaryMapIndexReader[] files = DataExtractionSettings.getSettings().getObfReaders();
                if (files.length == 0) {
                    JOptionPane.showMessageDialog(OsmExtractionUI.MAIN_APP.getFrame(), "Please specify obf file in settings", "Obf file not found", 0);
                    return;
                }
                System.out.println("Transport route from " + String.valueOf(this.start) + " to " + String.valueOf(this.end));
                RoutingConfiguration.Builder builder = DataExtractionSettings.getSettings().getRoutingConfig();
                String m = DataExtractionSettings.getSettings().getRouteMode();
                String[] props = m.split("\\,");
                LinkedHashMap<String, String> paramsR = new LinkedHashMap<String, String>();
                for (String p : props) {
                    if (p.contains("=")) {
                        paramsR.put(p.split("=")[0], p.split("=")[1]);
                        continue;
                    }
                    paramsR.put(p, "true");
                }
                GeneralRouter prouter = builder.getRouter("public_transport");
                TransportRoutingConfiguration cfg = new TransportRoutingConfiguration(prouter, paramsR);
                cfg.useSchedule = schedule;
                TransportRoutePlanner planner = new TransportRoutePlanner();
                TransportRoutingContext ctx = new TransportRoutingContext(cfg, (NativeLibrary)(DataExtractionSettings.getSettings().useNativeRouting() ? NativeSwingRendering.getDefaultFromSettings() : null), files);
                if (ctx.library != null) {
                    NativeTransportRoutingResult[] nativeRes = ctx.library.runNativePTRouting(MapUtils.get31TileNumberX((double)this.start.getLongitude()), MapUtils.get31TileNumberY((double)this.start.getLatitude()), MapUtils.get31TileNumberX((double)this.end.getLongitude()), MapUtils.get31TileNumberY((double)this.end.getLatitude()), cfg, ctx.calculationProgress);
                    if (nativeRes.length > 0) {
                        this.results = TransportRoutePlanner.convertToTransportRoutingResult((NativeTransportRoutingResult[])nativeRes, (TransportRoutingConfiguration)cfg);
                    } else {
                        System.out.println("No luck, empty result from Native");
                    }
                } else {
                    this.startProgressThread(ctx);
                    this.results = planner.buildRoute(ctx, this.start, this.end);
                }
                this.currentRoute = 0;
                this.throwExceptionIfRouteNotFound(ctx, this.results);
            }
            catch (Exception e) {
                ExceptionHandler.handle(e);
            }
            finally {
                this.infoButton.setVisible(false);
                this.prevRoute.setVisible(false);
                this.nextRoute.setVisible(false);
                if (this.map.getPoints() != null) {
                    this.map.getPoints().clear();
                }
            }
            System.out.println("Finding self routes " + this.results.size() + " " + (System.currentTimeMillis() - time) + " ms");
        }
    }

    private void throwExceptionIfRouteNotFound(TransportRoutingContext ctx, List<TransportRouteResult> res) {
        if (res.isEmpty()) {
            throw new IllegalArgumentException("There is no public transport route for selected start/stop.");
        }
    }

    private void startProgressThread(final TransportRoutingContext ctx) {
        new Thread(){

            @Override
            public void run() {
                while (ctx.calculationProgress != null && !ctx.calculationProgress.isCancelled) {
                    float p = Math.max(ctx.calculationProgress.distanceFromBegin, ctx.calculationProgress.distanceFromEnd);
                    float all = 1.25f * ctx.calculationProgress.totalEstimatedDistance;
                    if (all > 0.0f) {
                        int n = (int)(p * p / (all * all) * 100.0f);
                    }
                    try {
                        7.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
        }.start();
    }

    private void calculateResult(List<Way> res, TransportRouteResult r) {
        if (r != null) {
            LatLon p = this.start;
            for (TransportRoutePlanner.TransportRouteResultSegment s : r.getSegments()) {
                LatLon floc = s.getStart().getLocation();
                res.addAll(s.getGeometry());
                p = s.getEnd().getLocation();
            }
        }
    }

    private void addWalk(List<Way> res, LatLon s, LatLon e) {
        double dist = MapUtils.getDistance((LatLon)s, (LatLon)e);
        if (dist > 50.0) {
            Way way = new Way(-1L);
            way.putTag(OSMSettings.OSMTagKey.NAME.getValue(), String.format("Walk %.1f m", dist));
            way.addNode(new Node(s.getLatitude(), s.getLongitude(), -1L));
            way.addNode(new Node(e.getLatitude(), e.getLongitude(), -1L));
            res.add(way);
        }
    }

    private void redraw() {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    MapTransportLayer.this.map.prepareImage();
                }
            });
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void prepareToDraw() {
    }

    @Override
    public void paintLayer(Graphics2D g) {
        TransportRouteResult r = null;
        if (this.results.size() > this.currentRoute && this.currentRoute >= 0) {
            r = this.results.get(this.currentRoute);
        }
        if (r != null) {
            int y;
            int x;
            LatLon l;
            g.setColor(Color.blue);
            int rad = 10;
            for (TransportRoutePlanner.TransportRouteResultSegment s : r.getSegments()) {
                l = s.getStart().getLocation();
                x = this.map.getMapXForPoint(l.getLongitude());
                y = this.map.getMapYForPoint(l.getLatitude());
                g.drawOval(x, y, rad, rad);
                g.fillOval(x, y, rad, rad);
            }
            rad = 9;
            g.setColor(Color.red);
            for (TransportRoutePlanner.TransportRouteResultSegment s : r.getSegments()) {
                l = s.getEnd().getLocation();
                x = this.map.getMapXForPoint(l.getLongitude());
                y = this.map.getMapYForPoint(l.getLatitude());
                g.drawOval(x, y, rad, rad);
                g.fillOval(x, y, rad, rad);
            }
        }
    }

    @Override
    public void applySettings() {
    }
}

