/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.osm.oauth;

import com.github.scribejava.core.builder.ServiceBuilderOAuth20;
import com.github.scribejava.core.builder.api.DefaultApi20;
import com.github.scribejava.core.httpclient.HttpClient;
import com.github.scribejava.core.httpclient.HttpClientConfig;
import com.github.scribejava.core.oauth.OAuth20Service;
import com.github.scribejava.core.utils.Preconditions;
import java.io.OutputStream;

public class ServiceBuilder
implements ServiceBuilderOAuth20 {
    private String callback;
    private String apiKey;
    private String apiSecret;
    private String scope;
    private OutputStream debugStream;
    private String responseType = "code";
    private String userAgent;
    private HttpClientConfig httpClientConfig;
    private HttpClient httpClient;

    public ServiceBuilder(String apiKey) {
        this.apiKey(apiKey);
    }

    public ServiceBuilder callback(String callback) {
        this.callback = callback;
        return this;
    }

    public final ServiceBuilder apiKey(String apiKey) {
        Preconditions.checkEmptyString((String)apiKey, (String)"Invalid Api key");
        this.apiKey = apiKey;
        return this;
    }

    public ServiceBuilder apiSecret(String apiSecret) {
        Preconditions.checkEmptyString((String)apiSecret, (String)"Invalid Api secret");
        this.apiSecret = apiSecret;
        return this;
    }

    private ServiceBuilder setScope(String scope) {
        Preconditions.checkEmptyString((String)scope, (String)"Invalid OAuth scope");
        this.scope = scope;
        return this;
    }

    public ServiceBuilderOAuth20 defaultScope(String defaultScope) {
        return this.setScope(defaultScope);
    }

    public ServiceBuilder debugStream(OutputStream debugStream) {
        Preconditions.checkNotNull((Object)debugStream, (String)"debug stream can't be null");
        this.debugStream = debugStream;
        return this;
    }

    public ServiceBuilderOAuth20 responseType(String responseType) {
        Preconditions.checkEmptyString((String)responseType, (String)"Invalid OAuth responseType");
        this.responseType = responseType;
        return this;
    }

    public ServiceBuilder httpClientConfig(HttpClientConfig httpClientConfig) {
        Preconditions.checkNotNull((Object)httpClientConfig, (String)"httpClientConfig can't be null");
        this.httpClientConfig = httpClientConfig;
        return this;
    }

    public ServiceBuilder httpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
        return this;
    }

    public ServiceBuilder userAgent(String userAgent) {
        this.userAgent = userAgent;
        return this;
    }

    public ServiceBuilder debug() {
        return this.debugStream(System.out);
    }

    public OAuth20Service build(DefaultApi20 api) {
        return api.createService(this.apiKey, this.apiSecret, this.callback, this.scope, this.responseType, this.debugStream, this.userAgent, this.httpClientConfig, this.httpClient);
    }
}

