/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.osm.edit;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.osmand.binary.ObfConstants;
import net.osmand.data.Amenity;
import net.osmand.data.Building;
import net.osmand.data.City;
import net.osmand.data.LatLon;
import net.osmand.data.MapObject;
import net.osmand.data.TransportRoute;
import net.osmand.data.TransportStop;
import net.osmand.osm.MapPoiTypes;
import net.osmand.osm.MapRenderingTypes;
import net.osmand.osm.edit.Entity;
import net.osmand.osm.edit.Node;
import net.osmand.osm.edit.OSMSettings;
import net.osmand.osm.edit.OsmMapUtils;
import net.osmand.osm.edit.Relation;
import net.osmand.osm.edit.Way;
import net.osmand.util.Algorithms;

public class EntityParser {
    public static void parseMapObject(MapObject mo, Entity e, Map<String, String> tags) {
        mo.setId(e.getId());
        if (e.getId() > 0L) {
            mo.setId(ObfConstants.createMapObjectIdFromOsmAndEntity(e));
        }
        if (mo.getName().length() == 0) {
            mo.setName(tags.get(OSMSettings.OSMTagKey.NAME.getValue()));
        }
        if (mo.getEnName(false).length() == 0) {
            mo.setEnName(tags.get(OSMSettings.OSMTagKey.NAME_EN.getValue()));
        }
        if (tags.get(OSMSettings.OSMTagKey.SHORT_NAME.getValue()) != null) {
            mo.setName("short", tags.get(OSMSettings.OSMTagKey.SHORT_NAME.getValue()));
        }
        for (Map.Entry<String, String> entry : tags.entrySet()) {
            String lang;
            String ts = entry.getKey();
            if (!ts.startsWith("name:") || ts.equals(OSMSettings.OSMTagKey.NAME_EN.getValue()) || !MapRenderingTypes.langsSet.contains(lang = ts.substring("name:".length()))) continue;
            mo.setName(lang, entry.getValue());
        }
        if (mo.getName().length() == 0) {
            mo.setName(mo.getEnName(false));
        }
        if (mo.getName().length() == 0 && tags.containsKey(OSMSettings.OSMTagKey.LOCK_NAME.getValue())) {
            mo.setName(tags.get(OSMSettings.OSMTagKey.LOCK_NAME.getValue()));
        }
        if (mo.getLocation() == null) {
            LatLon l = null;
            if (mo instanceof Building) {
                l = EntityParser.findOnlyOneEntrance(e);
            }
            if (l == null) {
                l = OsmMapUtils.getCenter(e);
            }
            if (l != null) {
                mo.setLocation(l.getLatitude(), l.getLongitude());
            }
        }
        if (mo.getName().length() == 0) {
            EntityParser.setNameFromRef(mo, tags);
        }
        if (mo.getName().length() == 0) {
            EntityParser.setNameFromBrand(mo, tags);
        }
    }

    private static LatLon findOnlyOneEntrance(Entity e) {
        if (e instanceof Node) {
            return e.getLatLon();
        }
        List<Node> nodes = null;
        if (e instanceof Way) {
            nodes = ((Way)e).getNodes();
        } else if (e instanceof Relation) {
            nodes = new ArrayList<Node>();
            for (Relation.RelationMember member : ((Relation)e).getMembers(null)) {
                if (!(member.getEntity() instanceof Way)) continue;
                nodes.addAll(((Way)member.getEntity()).getNodes());
            }
        }
        if (nodes != null) {
            int entrancesCount = 0;
            Node mainEntrance = null;
            Node lastEntrance = null;
            for (Node node : nodes) {
                String entrance = node.getTag(OSMSettings.OSMTagKey.ENTRANCE.getValue());
                if (entrance == null || "no".equals(entrance)) continue;
                if ("main".equals(entrance)) {
                    if (mainEntrance != null) {
                        return null;
                    }
                    mainEntrance = node;
                }
                ++entrancesCount;
                lastEntrance = node;
            }
            if (mainEntrance != null) {
                return mainEntrance.getLatLon();
            }
            if (entrancesCount == 1) {
                return lastEntrance.getLatLon();
            }
        }
        return null;
    }

    private static void setNameFromRef(MapObject mo, Map<String, String> tags) {
        String ref = tags.get(OSMSettings.OSMTagKey.REF.getValue());
        if (ref != null) {
            mo.setName(ref);
        }
    }

    private static void setNameFromBrand(MapObject mo, Map<String, String> tags) {
        String ref = tags.get(OSMSettings.OSMTagKey.BRAND.getValue());
        if (ref != null) {
            mo.setName(ref);
        }
    }

    private static String getWikipediaURL(Map<String, String> tagValues) {
        Object wikiUrl = tagValues.get(OSMSettings.OSMTagKey.WIKIPEDIA.getValue());
        if (wikiUrl != null && !((String)wikiUrl).startsWith("http://")) {
            int i = ((String)wikiUrl).indexOf(58);
            wikiUrl = i == -1 ? "http://en.wikipedia.org/wiki/" + (String)wikiUrl : "http://" + ((String)wikiUrl).substring(0, i) + ".wikipedia.org/wiki/" + ((String)wikiUrl).substring(i + 1);
        }
        return wikiUrl;
    }

    public static List<Amenity> parseAmenities(MapPoiTypes poiTypes, Entity entity, Map<String, String> tags, List<Amenity> amenitiesList) {
        amenitiesList.clear();
        boolean relation = entity instanceof Relation;
        boolean purerelation = relation && !"multipolygon".equals(tags.get("type")) && !"boundary".equals(tags.get("type"));
        Collection<Map<String, String>> it = MapRenderingTypes.splitTagsIntoDifferentObjects(tags);
        for (Map<String, String> ts : it) {
            for (Map.Entry<String, String> e : ts.entrySet()) {
                String value = e.getValue();
                String key = e.getKey();
                if (value.indexOf(59) != -1) {
                    String[] vls = value.split(";");
                    LinkedHashMap<String, Amenity> multiAmenitiesByType = new LinkedHashMap<String, Amenity>();
                    for (String v : vls) {
                        Amenity am = poiTypes.parseAmenity(key, v = v.trim(), purerelation, ts);
                        if (am == null) continue;
                        String type = am.getType().getKeyName();
                        Amenity multiAmenity = (Amenity)multiAmenitiesByType.get(type);
                        if (multiAmenity != null) {
                            multiAmenity.setSubType(multiAmenity.getSubType() + ";" + am.getSubType());
                            continue;
                        }
                        multiAmenitiesByType.put(type, am);
                    }
                    for (Amenity am : multiAmenitiesByType.values()) {
                        EntityParser.addAmenity(entity, amenitiesList, ts, am);
                    }
                    continue;
                }
                Amenity am = poiTypes.parseAmenity(key, value, purerelation, ts);
                EntityParser.addAmenity(entity, amenitiesList, ts, am);
            }
        }
        return amenitiesList;
    }

    private static void addAmenity(Entity entity, List<Amenity> amenitiesList, Map<String, String> ts, Amenity am) {
        if (am != null && EntityParser.checkAmenitiesToAdd(am, amenitiesList)) {
            EntityParser.parseMapObject(am, entity, ts);
            EntityParser.setWikipediaUrl(am, ts);
            amenitiesList.add(am);
        }
    }

    private static void setWikipediaUrl(Amenity am, Map<String, String> ts) {
        String wbs = EntityParser.getWikipediaURL(ts);
        if (wbs != null) {
            am.setAdditionalInfo("wikipedia", wbs);
        }
    }

    private static boolean checkAmenitiesToAdd(Amenity a, List<Amenity> amenitiesList) {
        for (Amenity b : amenitiesList) {
            if (b.getType() != a.getType() || !Algorithms.objectEquals(a.getSubType(), b.getSubType())) continue;
            return false;
        }
        return !"no".equals(a.getSubType());
    }

    public static Building parseBuilding(Entity e) {
        Building b = new Building();
        EntityParser.parseMapObject(b, e, e.getTags());
        String p = e.getTag(OSMSettings.OSMTagKey.ADDR_POSTCODE.getValue());
        if (p == null) {
            p = e.getTag(OSMSettings.OSMTagKey.POSTAL_CODE.getValue());
        }
        b.setPostcode(p);
        if (e instanceof Way) {
            List<Node> nodes = ((Way)e).getNodes();
            for (int i = 0; i < nodes.size(); ++i) {
                Node node = nodes.get(i);
                if (node == null || !"yes".equals(node.getTag(OSMSettings.OSMTagKey.ENTRANCE)) || Algorithms.isEmpty(node.getTag(OSMSettings.OSMTagKey.REF))) continue;
                b.addEntrance(node.getTag(OSMSettings.OSMTagKey.REF), node.getLatLon());
            }
        }
        return b;
    }

    public static City parseCity(Entity el) {
        return EntityParser.parseCity(el, null);
    }

    public static City parseCity(Entity el, City.CityType t) {
        if (t == null) {
            t = City.CityType.valueFromEntity(el);
        }
        if (t == null) {
            return null;
        }
        City c = new City(t);
        EntityParser.parseMapObject(c, el, el.getTags());
        String isin = el.getTag(OSMSettings.OSMTagKey.IS_IN.getValue());
        if (isin != null) {
            c.setIsin(isin);
        }
        return c;
    }

    public static TransportRoute parserRoute(Relation r, String ref) {
        TransportRoute rt = new TransportRoute();
        EntityParser.parseMapObject(rt, r, r.getTags());
        rt.setRef(ref);
        return rt;
    }

    public static TransportStop parseTransportStop(Entity e) {
        TransportStop st = new TransportStop();
        EntityParser.parseMapObject(st, e, e.getTags());
        return st;
    }
}

