/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.binary;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.osmand.PlatformUtil;
import net.osmand.ResultMatcher;
import net.osmand.binary.BinaryMapIndexReader;
import net.osmand.binary.BinaryMapRouteReaderAdapter;
import net.osmand.binary.ObfConstants;
import net.osmand.binary.RouteDataObject;
import net.osmand.data.QuadRect;
import net.osmand.shared.gpx.primitives.WptPt;
import net.osmand.util.MapUtils;
import org.apache.commons.logging.Log;

public class HeightDataLoader {
    public static final int ZOOM_TO_LOAD_TILES = 15;
    public static final int ZOOM_TO_LOAD_TILES_SHIFT_L = 16;
    public static final int ZOOM_TO_LOAD_TILES_SHIFT_R = 16;
    private static final Log log = PlatformUtil.getLog(HeightDataLoader.class);
    private final Map<BinaryMapRouteReaderAdapter.RouteSubregion, List<RouteDataObject>> loadedSubregions = new HashMap<BinaryMapRouteReaderAdapter.RouteSubregion, List<RouteDataObject>>();
    private final Map<BinaryMapIndexReader, List<BinaryMapRouteReaderAdapter.RouteSubregion>> readers = new LinkedHashMap<BinaryMapIndexReader, List<BinaryMapRouteReaderAdapter.RouteSubregion>>();

    public HeightDataLoader(BinaryMapIndexReader[] readers) {
        for (BinaryMapIndexReader r : readers) {
            ArrayList<BinaryMapRouteReaderAdapter.RouteSubregion> subregions = new ArrayList<BinaryMapRouteReaderAdapter.RouteSubregion>();
            for (BinaryMapRouteReaderAdapter.RouteRegion rInd : r.getRoutingIndexes()) {
                List<BinaryMapRouteReaderAdapter.RouteSubregion> subregs = rInd.getSubregions();
                for (BinaryMapRouteReaderAdapter.RouteSubregion rs : subregs) {
                    subregions.add(new BinaryMapRouteReaderAdapter.RouteSubregion(rs));
                }
            }
            this.readers.put(r, subregions);
        }
    }

    public List<WptPt> loadHeightDataAsWaypoints(final long osmId, QuadRect bbox31, final Cancellable canceller) {
        final HashMap<Long, RouteDataObject> results = new HashMap<Long, RouteDataObject>();
        ResultMatcher<RouteDataObject> matcher = new ResultMatcher<RouteDataObject>(){

            @Override
            public boolean publish(RouteDataObject routeDataObject) {
                return routeDataObject != null && ObfConstants.getOsmObjectId(routeDataObject) == osmId;
            }

            @Override
            public boolean isCancelled() {
                return results.containsKey(osmId) || canceller != null && canceller.isCancelled();
            }
        };
        try {
            this.loadRouteDataObjects(bbox31, results, matcher);
        }
        catch (IOException e) {
            log.error((Object)e);
        }
        RouteDataObject found = (RouteDataObject)results.get(osmId);
        if (found != null && found.getPointsLength() > 0) {
            ArrayList<WptPt> waypoints = new ArrayList<WptPt>();
            float[] heightArray = found.calculateHeightArray();
            for (int i = 0; i < found.getPointsLength(); ++i) {
                WptPt point = new WptPt();
                point.setLat(MapUtils.get31LatitudeY(found.getPoint31YTile(i)));
                point.setLon(MapUtils.get31LongitudeX(found.getPoint31XTile(i)));
                if (heightArray != null && heightArray.length > i * 2 + 1) {
                    point.setEle((double)heightArray[i * 2 + 1]);
                }
                waypoints.add(point);
            }
            return waypoints;
        }
        return null;
    }

    private boolean loadRouteDataObjects(QuadRect bbox31, Map<Long, RouteDataObject> results, ResultMatcher<RouteDataObject> matcher) throws IOException {
        int loaded = 0;
        int left = (int)bbox31.left >> 16;
        int top = (int)bbox31.top >> 16;
        int right = (int)bbox31.right >> 16;
        int bottom = (int)bbox31.bottom >> 16;
        for (int x = left; x <= right; ++x) {
            for (int y = top; y <= bottom; ++y) {
                if (matcher != null && matcher.isCancelled()) {
                    return loaded > 0;
                }
                loaded += this.loadRouteDataObjects(x, y, results, matcher);
            }
        }
        return loaded > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int loadRouteDataObjects(int x, int y, Map<Long, RouteDataObject> results, ResultMatcher<RouteDataObject> matcher) throws IOException {
        int loaded = 0;
        HashSet<Long> deletedIds = new HashSet<Long>();
        HashMap<Long, BinaryMapRouteReaderAdapter.RouteRegion> usedIds = new HashMap<Long, BinaryMapRouteReaderAdapter.RouteRegion>();
        BinaryMapIndexReader.SearchRequest<RouteDataObject> req = BinaryMapIndexReader.buildSearchRouteRequest(x << 16, x + 1 << 16, y << 16, y + 1 << 16, null);
        for (Map.Entry<BinaryMapIndexReader, List<BinaryMapRouteReaderAdapter.RouteSubregion>> readerSubregions : this.readers.entrySet()) {
            BinaryMapIndexReader reader;
            req.clearSearchResults();
            BinaryMapIndexReader binaryMapIndexReader = reader = readerSubregions.getKey();
            synchronized (binaryMapIndexReader) {
                List<BinaryMapRouteReaderAdapter.RouteSubregion> routeSubregions = readerSubregions.getValue();
                List<BinaryMapRouteReaderAdapter.RouteSubregion> subregions = reader.searchRouteIndexTree(req, routeSubregions);
                for (BinaryMapRouteReaderAdapter.RouteSubregion sub : subregions) {
                    List<RouteDataObject> objects = this.loadedSubregions.get(sub);
                    if (objects == null) {
                        objects = reader.loadRouteIndexData(sub);
                        this.loadedSubregions.put(sub, objects);
                    }
                    for (RouteDataObject obj : objects) {
                        if (matcher != null && matcher.isCancelled()) {
                            return loaded;
                        }
                        if (matcher != null && !matcher.publish(obj) || deletedIds.contains(obj.id)) continue;
                        if (obj.isRoadDeleted()) {
                            deletedIds.add(obj.id);
                            continue;
                        }
                        if (usedIds.containsKey(obj.id) && usedIds.get(obj.id) != obj.region) continue;
                        loaded += results.put(ObfConstants.getOsmObjectId(obj), obj) == null ? 1 : 0;
                        usedIds.put(obj.id, obj.region);
                    }
                }
            }
        }
        return loaded;
    }

    public static interface Cancellable {
        public boolean isCancelled();
    }

    public static interface CancellableCallback<T> {
        public boolean callback(T var1, Cancellable var2);
    }
}

