/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.filter.internal;

import java.lang.reflect.Method;
import org.xwiki.filter.FilterDescriptor;
import org.xwiki.filter.FilterElementDescriptor;
import org.xwiki.filter.FilterElementParameterDescriptor;
import org.xwiki.filter.FilterEventParameters;
import org.xwiki.filter.FilterException;
import org.xwiki.filter.UnknownFilter;

public final class FilterUtils {
    private FilterUtils() {
    }

    public static boolean sendEvent(Method event, FilterElementDescriptor elementDescriptor, Object filter, FilterEventParameters parameters) throws FilterException {
        FilterElementParameterDescriptor<?>[] parameterDescriptors = elementDescriptor.getParameters();
        Object[] arguments = new Object[parameterDescriptors.length];
        for (FilterElementParameterDescriptor<?> parameterDescriptor : parameterDescriptors) {
            Object value = parameterDescriptor.getName() != null && parameters.containsKey(parameterDescriptor.getName()) ? parameters.get(parameterDescriptor.getName()) : (parameters.containsKey(String.valueOf(parameterDescriptor.getIndex())) ? parameters.get(String.valueOf(parameterDescriptor.getIndex())) : parameterDescriptor.getDefaultValue());
            arguments[parameterDescriptor.getIndex()] = value;
        }
        try {
            event.invoke(filter, arguments);
        }
        catch (Exception e) {
            throw new FilterException(String.format("Failed to send event [%s] with parameters [%s] to filter [%s]", event, parameters, filter), e);
        }
        return true;
    }

    public static boolean sendBeginEvent(Object filter, FilterDescriptor descriptor, String id, FilterEventParameters parameters) throws FilterException {
        FilterElementDescriptor elementDescriptor = descriptor.getElement(id);
        if (elementDescriptor != null && elementDescriptor.getBeginMethod() != null) {
            FilterUtils.sendEvent(elementDescriptor.getBeginMethod(), elementDescriptor, filter, parameters);
        } else if (filter instanceof UnknownFilter) {
            ((UnknownFilter)filter).beginUnknwon(id, parameters);
        } else {
            return false;
        }
        return true;
    }

    public static boolean sendEndEvent(Object filter, FilterDescriptor descriptor, String id, FilterEventParameters parameters) throws FilterException {
        FilterElementDescriptor elementDescriptor = descriptor.getElement(id);
        if (elementDescriptor != null && elementDescriptor.getEndMethod() != null) {
            FilterUtils.sendEvent(elementDescriptor.getEndMethod(), elementDescriptor, filter, parameters);
        } else if (filter instanceof UnknownFilter) {
            ((UnknownFilter)filter).endUnknwon(id, parameters);
        } else {
            return false;
        }
        return true;
    }

    public static boolean sendOnEvent(Object filter, FilterDescriptor descriptor, String id, FilterEventParameters parameters) throws FilterException {
        FilterElementDescriptor elementDescriptor = descriptor.getElement(id);
        if (elementDescriptor != null && elementDescriptor.getOnMethod() != null) {
            FilterUtils.sendEvent(elementDescriptor.getOnMethod(), elementDescriptor, filter, parameters);
        } else if (filter instanceof UnknownFilter) {
            ((UnknownFilter)filter).onUnknwon(id, parameters);
        } else {
            return false;
        }
        return true;
    }
}

