/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.shared.obd;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.osmand.shared.obd.OBDDataField;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u000b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\u0012"}, d2={"Lnet/osmand/shared/obd/OBDUtils;", "", "<init>", "()V", "parseRpmResponse", "Lnet/osmand/shared/obd/OBDDataField;", "response", "", "parseEngineRuntime", "parseSpeedResponse", "parseTempResponse", "parseFuelPressureResponse", "parsePercentResponse", "parseBatteryVoltageResponse", "parseAltBatteryVoltageResponse", "parseFuelTypeResponse", "parseVINResponse", "parseFuelConsumptionRateResponse", "OsmAnd-shared"})
@SourceDebugExtension(value={"SMAP\nOBDUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OBDUtils.kt\nnet/osmand/shared/obd/OBDUtils\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,68:1\n11132#2:69\n11467#2,3:70\n*S KotlinDebug\n*F\n+ 1 OBDUtils.kt\nnet/osmand/shared/obd/OBDUtils\n*L\n45#1:69\n45#1:70,3\n*E\n"})
public final class OBDUtils {
    @NotNull
    public static final OBDUtils INSTANCE = new OBDUtils();

    private OBDUtils() {
    }

    @NotNull
    public final OBDDataField<Object> parseRpmResponse(@NotNull int[] response) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        int result = (response[0] * 256 + response[1]) / 4;
        return new OBDDataField<Object>(result);
    }

    @NotNull
    public final OBDDataField<Object> parseEngineRuntime(@NotNull int[] response) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        int result = 256 * response[0] + response[1];
        return new OBDDataField<Object>(result);
    }

    @NotNull
    public final OBDDataField<Object> parseSpeedResponse(@NotNull int[] response) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        return !(response.length == 0) ? new OBDDataField<Integer>(response[0]) : new OBDDataField<Integer>(0);
    }

    @NotNull
    public final OBDDataField<Object> parseTempResponse(@NotNull int[] response) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        int result = response[0] - 40;
        return new OBDDataField<Object>(result);
    }

    @NotNull
    public final OBDDataField<Object> parseFuelPressureResponse(@NotNull int[] response) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        int result = response[0] * 3;
        return new OBDDataField<Object>(result);
    }

    @NotNull
    public final OBDDataField<Object> parsePercentResponse(@NotNull int[] response) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        float result = (float)response[0] * 0.39215687f;
        return new OBDDataField<Object>(Float.valueOf(result));
    }

    @NotNull
    public final OBDDataField<Object> parseBatteryVoltageResponse(@NotNull int[] response) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        float result = (float)(response[0] * 256 + response[1]) / (float)1000;
        return new OBDDataField<Object>(Float.valueOf(result));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final OBDDataField<Object> parseAltBatteryVoltageResponse(@NotNull int[] response) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        int[] $this$map$iv = response;
        boolean $i$f$map = false;
        int[] nArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var11_11 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((byte)it);
        }
        byte[] byteArray = CollectionsKt.toByteArray((Collection)((List)destination$iv$iv));
        String strValue = StringsKt.decodeToString((byte[])byteArray);
        String string = strValue.substring(0, strValue.length() - 1);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        strValue = string;
        float fValue = Float.parseFloat(strValue) / 10.0f;
        return new OBDDataField<Object>(Float.valueOf(fValue));
    }

    @NotNull
    public final OBDDataField<Object> parseFuelTypeResponse(@NotNull int[] response) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        return new OBDDataField<Object>(response[0]);
    }

    @NotNull
    public final OBDDataField<Object> parseVINResponse(@NotNull int[] response) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        StringBuilder vin = new StringBuilder();
        int n = response.length;
        for (int i = 1; i < n; ++i) {
            vin.append((char)response[i]);
        }
        return new OBDDataField<Object>(vin);
    }

    @NotNull
    public final OBDDataField<Object> parseFuelConsumptionRateResponse(@NotNull int[] response) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        double result = (double)(response[0] * 256 + response[1]) / 20.0;
        return new OBDDataField<Object>(result);
    }
}

