/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.shared.io;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.osmand.shared.extensions.FileExtensionsKt;
import net.osmand.shared.io.KFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\n\u001a\u00020\u000bJ\u0006\u0010\f\u001a\u00020\rJ\u0006\u0010\u000e\u001a\u00020\rJ\u0006\u0010\u000f\u001a\u00020\u0010J\u0006\u0010\u0011\u001a\u00020\u0010J\u000e\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0013J\u000e\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u0003J\u000e\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lnet/osmand/shared/io/NativeFile;", "", "file", "Lnet/osmand/shared/io/KFile;", "<init>", "(Lnet/osmand/shared/io/KFile;)V", "getFile", "()Lnet/osmand/shared/io/KFile;", "jFile", "Ljava/io/File;", "absolutePath", "", "isDirectory", "", "exists", "length", "", "lastModified", "listFiles", "", "renameTo", "toFile", "toFilePath", "OsmAnd-shared"})
@SourceDebugExtension(value={"SMAP\nNativeFile.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NativeFile.kt\nnet/osmand/shared/io/NativeFile\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,26:1\n11102#2:27\n11437#2,3:28\n*S KotlinDebug\n*F\n+ 1 NativeFile.kt\nnet/osmand/shared/io/NativeFile\n*L\n21#1:27\n21#1:28,3\n*E\n"})
public final class NativeFile {
    @NotNull
    private final KFile file;
    @NotNull
    private File jFile;

    public NativeFile(@NotNull KFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.file = file;
        this.jFile = new File(this.file.path());
    }

    @NotNull
    public final KFile getFile() {
        return this.file;
    }

    @NotNull
    public final String absolutePath() {
        String string = this.jFile.getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
        return string;
    }

    public final boolean isDirectory() {
        return this.jFile.isDirectory();
    }

    public final boolean exists() {
        return this.jFile.exists();
    }

    public final long length() {
        return this.jFile.length();
    }

    public final long lastModified() {
        return this.jFile.lastModified();
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final List<KFile> listFiles() {
        List list;
        File[] fileArray = this.jFile.listFiles();
        if (fileArray != null) {
            void $this$mapTo$iv$iv;
            File[] $this$map$iv = fileArray;
            boolean $i$f$map = false;
            File[] fileArray2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            int n = ((void)$this$mapTo$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                void it;
                void item$iv$iv;
                void var9_9 = item$iv$iv = $this$mapTo$iv$iv[i];
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                collection.add(FileExtensionsKt.kFile((File)it));
            }
            list = (List)destination$iv$iv;
        } else {
            list = null;
        }
        return list;
    }

    public final boolean renameTo(@NotNull KFile toFile) {
        Intrinsics.checkNotNullParameter((Object)toFile, (String)"toFile");
        return this.jFile.renameTo(FileExtensionsKt.jFile(toFile));
    }

    public final boolean renameTo(@NotNull String toFilePath) {
        Intrinsics.checkNotNullParameter((Object)toFilePath, (String)"toFilePath");
        return this.jFile.renameTo(new File(toFilePath));
    }
}

