/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.shared.gpx;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArrayDeque;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import kotlinx.datetime.Instant;
import kotlinx.datetime.LocalDateTime;
import kotlinx.datetime.TimeZone;
import kotlinx.datetime.TimeZoneKt;
import kotlinx.datetime.format.DateTimeComponents;
import kotlinx.datetime.format.DateTimeFormat;
import kotlinx.datetime.format.DateTimeFormatBuilder;
import kotlinx.datetime.format.UnicodeKt;
import net.osmand.shared.KException;
import net.osmand.shared.data.KQuadRect;
import net.osmand.shared.extensions.ClockExtensionsKt;
import net.osmand.shared.gpx.GpxFile;
import net.osmand.shared.gpx.GpxFormatter;
import net.osmand.shared.gpx.GpxTrackAnalysis;
import net.osmand.shared.gpx.SplitSegment;
import net.osmand.shared.gpx.primitives.Author;
import net.osmand.shared.gpx.primitives.Bounds;
import net.osmand.shared.gpx.primitives.Copyright;
import net.osmand.shared.gpx.primitives.GpxExtensions;
import net.osmand.shared.gpx.primitives.Link;
import net.osmand.shared.gpx.primitives.Metadata;
import net.osmand.shared.gpx.primitives.Route;
import net.osmand.shared.gpx.primitives.Track;
import net.osmand.shared.gpx.primitives.TrkSegment;
import net.osmand.shared.gpx.primitives.WptPt;
import net.osmand.shared.io.KFile;
import net.osmand.shared.util.IProgress;
import net.osmand.shared.util.KAlgorithms;
import net.osmand.shared.util.KMapUtils;
import net.osmand.shared.util.Logger;
import net.osmand.shared.util.LoggerFactory;
import net.osmand.shared.util.StringBundle;
import net.osmand.shared.util.StringBundleWriter;
import net.osmand.shared.util.StringBundleXmlReader;
import net.osmand.shared.util.StringBundleXmlWriter;
import net.osmand.shared.xml.XmlParserException;
import net.osmand.shared.xml.XmlPullParser;
import net.osmand.shared.xml.XmlSerializer;
import okio.Buffer;
import okio.Okio;
import okio.Sink;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@kotlin.Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0090\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u001b\n\u0002\u0010\f\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u000e\u00ac\u0001\u00ad\u0001\u00ae\u0001\u00af\u0001\u00b0\u0001\u00b1\u0001\u00b2\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J!\u00102\u001a\u0004\u0018\u00010'2\b\u00103\u001a\u0004\u0018\u00010\t2\b\u00104\u001a\u0004\u0018\u00010'\u00a2\u0006\u0002\u00105J\u0017\u00102\u001a\u0004\u0018\u00010'2\b\u00103\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u00106J\u001a\u00107\u001a\b\u0012\u0004\u0012\u000209082\f\u0010:\u001a\b\u0012\u0004\u0012\u00020;08J$\u00107\u001a\b\u0012\u0004\u0012\u000209082\f\u0010:\u001a\b\u0012\u0004\u0012\u00020;082\b\u0010<\u001a\u0004\u0018\u00010=J\u0014\u0010>\u001a\u00020?2\f\u0010@\u001a\b\u0012\u0004\u0012\u00020A08J\u0014\u0010B\u001a\u00020?2\f\u0010C\u001a\b\u0012\u0004\u0012\u00020D08J$\u0010E\u001a\u00020F2\u0006\u0010G\u001a\u00020?2\f\u0010@\u001a\b\u0012\u0004\u0012\u00020A082\u0006\u0010H\u001a\u00020'J\u0014\u0010I\u001a\u00020'2\f\u0010C\u001a\b\u0012\u0004\u0012\u00020D08J&\u0010J\u001a\u00020F2\u0006\u0010K\u001a\u00020?2\u0006\u0010L\u001a\u00020A2\u0006\u0010M\u001a\u0002012\u0006\u0010N\u001a\u000201J\u000e\u0010O\u001a\u00020\t2\u0006\u0010P\u001a\u00020QJ\u0018\u0010R\u001a\u0004\u0018\u00010S2\u0006\u0010T\u001a\u00020U2\u0006\u0010P\u001a\u00020QJ.\u0010V\u001a\u0004\u0018\u00010S2\b\u0010T\u001a\u0004\u0018\u00010U2\b\u0010W\u001a\u0004\u0018\u00010X2\u0006\u0010P\u001a\u00020Q2\b\u0010Y\u001a\u0004\u0018\u00010ZJ\u0010\u0010[\u001a\u00020F2\u0006\u0010P\u001a\u00020QH\u0002J\u0010\u0010\\\u001a\u00020F2\u0006\u0010P\u001a\u00020QH\u0002J\"\u0010]\u001a\u00020F2\u0006\u0010^\u001a\u00020_2\u0006\u0010T\u001a\u00020Q2\b\u0010Y\u001a\u0004\u0018\u00010ZH\u0002J\u001a\u0010`\u001a\u00020F2\u0006\u0010^\u001a\u00020_2\b\u0010a\u001a\u0004\u0018\u00010bH\u0002J\"\u0010c\u001a\u00020F2\u0006\u0010^\u001a\u00020_2\u0006\u0010T\u001a\u00020Q2\b\u0010Y\u001a\u0004\u0018\u00010ZH\u0002J\"\u0010d\u001a\u00020F2\u0006\u0010^\u001a\u00020_2\u0006\u0010T\u001a\u00020Q2\b\u0010Y\u001a\u0004\u0018\u00010ZH\u0002J\"\u0010e\u001a\u00020F2\u0006\u0010^\u001a\u00020_2\u0006\u0010T\u001a\u00020Q2\b\u0010Y\u001a\u0004\u0018\u00010ZH\u0002J\u0010\u0010f\u001a\u00020F2\u0006\u0010g\u001a\u00020DH\u0002J\u0014\u0010h\u001a\u0004\u0018\u00010\t2\b\u0010i\u001a\u0004\u0018\u00010\tH\u0002J*\u0010j\u001a\u00020F2\u0006\u0010^\u001a\u00020_2\u0006\u0010k\u001a\u00020\t2\u0006\u0010l\u001a\u00020\t2\b\u0010m\u001a\u0004\u0018\u00010\tH\u0002J \u0010n\u001a\u00020F2\u0006\u0010^\u001a\u00020_2\u0006\u0010k\u001a\u00020\t2\b\u0010m\u001a\u0004\u0018\u00010\tJ\"\u0010o\u001a\u00020F2\u0006\u0010^\u001a\u00020_2\u0006\u0010L\u001a\u00020p2\b\u0010Y\u001a\u0004\u0018\u00010ZH\u0002J8\u0010o\u001a\u00020F2\u0006\u0010^\u001a\u00020_2\u0014\u0010q\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t\u0018\u00010.2\u0006\u0010L\u001a\u00020p2\b\u0010Y\u001a\u0004\u0018\u00010ZH\u0002J*\u0010r\u001a\u00020F2\u0006\u0010^\u001a\u00020_2\u0006\u0010L\u001a\u00020A2\b\u0010Y\u001a\u0004\u0018\u00010Z2\u0006\u0010T\u001a\u00020QH\u0002J*\u0010s\u001a\u00020F2\u0006\u0010t\u001a\u00020A2\u0012\u0010q\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0.2\u0006\u0010u\u001a\u00020\tJ$\u0010v\u001a\u00020w2\u0012\u0010q\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0.2\u0006\u0010x\u001a\u00020+H\u0002J$\u0010y\u001a\u00020w2\u0012\u0010q\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0.2\u0006\u0010x\u001a\u00020+H\u0002J,\u0010z\u001a\u00020F2\u0006\u0010^\u001a\u00020_2\u0012\u0010q\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0.2\u0006\u0010x\u001a\u00020+H\u0002J\u0018\u0010{\u001a\u00020\t2\u0006\u0010|\u001a\u00020\t2\u0006\u0010m\u001a\u00020\tH\u0002J\u0018\u0010}\u001a\u00020F2\u0006\u0010^\u001a\u00020_2\u0006\u0010~\u001a\u00020\u007fH\u0002J\u001b\u0010\u0080\u0001\u001a\u00020F2\u0006\u0010^\u001a\u00020_2\b\u0010\u0081\u0001\u001a\u00030\u0082\u0001H\u0002J\u001b\u0010\u0083\u0001\u001a\u00020F2\u0006\u0010^\u001a\u00020_2\b\u0010\u0084\u0001\u001a\u00030\u0085\u0001H\u0002J\u001b\u0010\u0086\u0001\u001a\u0004\u0018\u00010\t2\b\u0010\u0087\u0001\u001a\u00030\u0088\u00012\u0006\u0010|\u001a\u00020\tJ%\u0010\u0089\u0001\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0.2\b\u0010\u0087\u0001\u001a\u00030\u0088\u00012\u0006\u0010|\u001a\u00020\tJ\u0011\u0010\u008a\u0001\u001a\u00020\t2\b\u0010\u008b\u0001\u001a\u00030\u008c\u0001J\u0011\u0010\u008d\u0001\u001a\u00030\u008c\u00012\u0007\u0010\u008e\u0001\u001a\u00020\tJ\u0012\u0010\u008f\u0001\u001a\u00030\u008c\u00012\b\u0010P\u001a\u0004\u0018\u00010QJ\u0011\u0010\u0090\u0001\u001a\n\u0012\u0005\u0012\u00030\u0092\u00010\u0091\u0001H\u0002J\u000f\u0010\u0093\u0001\u001a\u00020Q2\u0006\u0010T\u001a\u00020UJ$\u0010\u0093\u0001\u001a\u00020Q2\u0006\u0010T\u001a\u00020U2\n\u0010\u0094\u0001\u001a\u0005\u0018\u00010\u0095\u00012\u0007\u0010\u0096\u0001\u001a\u00020+J\u0011\u0010\u0093\u0001\u001a\u00020Q2\b\u0010\u0097\u0001\u001a\u00030\u0098\u0001J2\u0010\u0093\u0001\u001a\u00020Q2\b\u0010T\u001a\u0004\u0018\u00010U2\n\u0010\u0097\u0001\u001a\u0005\u0018\u00010\u0098\u00012\n\u0010\u0094\u0001\u001a\u0005\u0018\u00010\u0095\u00012\u0007\u0010\u0096\u0001\u001a\u00020+J\u0011\u0010\u0099\u0001\u001a\u00020\t2\u0006\u0010k\u001a\u00020\tH\u0002J\u001f\u0010\u009a\u0001\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0.2\b\u0010\u0087\u0001\u001a\u00030\u0088\u0001H\u0002J5\u0010\u009b\u0001\u001a\u000f\u0012\u0004\u0012\u00020\t\u0012\u0005\u0012\u00030\u009c\u00010.2\u000e\u0010\u009d\u0001\u001a\t\u0012\u0005\u0012\u00030\u009c\u0001082\r\u0010\u009e\u0001\u001a\b\u0012\u0004\u0012\u00020A08H\u0002J\u0013\u0010\u009f\u0001\u001a\u00020A2\b\u0010\u0087\u0001\u001a\u00030\u0088\u0001H\u0002J\u0014\u0010\u00a0\u0001\u001a\u00030\u00a1\u00012\b\u0010\u0087\u0001\u001a\u00030\u0088\u0001H\u0002J\u0014\u0010\u00a2\u0001\u001a\u00030\u00a3\u00012\b\u0010\u0087\u0001\u001a\u00030\u0088\u0001H\u0002J\u0014\u0010\u00a4\u0001\u001a\u00030\u0085\u00012\b\u0010\u0087\u0001\u001a\u00030\u0088\u0001H\u0002J\u001b\u0010\u00a5\u0001\u001a\u00020F2\u0007\u0010\u00a6\u0001\u001a\u00020Q2\t\u0010\u00a7\u0001\u001a\u0004\u0018\u00010QJ\u0019\u0010\u00a8\u0001\u001a\u00020A2\u0007\u0010\u00a9\u0001\u001a\u00020A2\u0007\u0010\u00aa\u0001\u001a\u00020AJ\u0015\u0010\u00ab\u0001\u001a\u00020F2\f\u0010@\u001a\b\u0012\u0004\u0012\u00020A08R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020%X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020'X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020'X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020'X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020+X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010-\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0.X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010/\u001a\u00020'X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u00100\u001a\u000201X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u00b3\u0001"}, d2={"Lnet/osmand/shared/gpx/GpxUtilities;", "", "<init>", "()V", "log", "Lnet/osmand/shared/util/Logger;", "getLog", "()Lnet/osmand/shared/util/Logger;", "ICON_NAME_EXTENSION", "", "BACKGROUND_TYPE_EXTENSION", "COLOR_NAME_EXTENSION", "LINE_WIDTH_EXTENSION", "PROFILE_TYPE_EXTENSION", "ADDRESS_EXTENSION", "HIDDEN_EXTENSION", "PINNED_EXTENSION", "POINT_TYPE_EXTENSION", "GPXTPX_PREFIX", "OSMAND_EXTENSIONS_PREFIX", "OSM_PREFIX", "AMENITY_PREFIX", "ORIGIN_EXTENSION", "AMENITY_ORIGIN_EXTENSION", "ACTIVITY_TYPE", "GAP_PROFILE_TYPE", "TRKPT_INDEX_EXTENSION", "DEFAULT_ICON_NAME", "POINT_ELEVATION", "POINT_SPEED", "POINT_BEARING", "MIN_ELEVATION", "MAX_ELEVATION", "AVG_ELEVATION", "DIFF_ELEVATION_UP", "DIFF_ELEVATION_DOWN", "TRAVEL_GPX_CONVERT_FIRST_LETTER", "", "TRAVEL_GPX_CONVERT_FIRST_DIST", "", "TRAVEL_GPX_CONVERT_MULT_1", "TRAVEL_GPX_CONVERT_MULT_2", "oneOffLogParseTimeErrors", "", "GPX_TIME_FORMATTER", "SUPPORTED_EXTENSION_TAGS", "", "RADIUS_DIVIDER", "PRIME_MERIDIAN", "", "parseColor", "colorString", "defColor", "(Ljava/lang/String;Ljava/lang/Integer;)Ljava/lang/Integer;", "(Ljava/lang/String;)Ljava/lang/Integer;", "convert", "", "Lnet/osmand/shared/gpx/GpxTrackAnalysis;", "splitSegments", "Lnet/osmand/shared/gpx/SplitSegment;", "pointsAnalyser", "Lnet/osmand/shared/gpx/GpxTrackAnalysis$TrackPointsAnalyser;", "calculateBounds", "Lnet/osmand/shared/data/KQuadRect;", "pts", "Lnet/osmand/shared/gpx/primitives/WptPt;", "calculateTrackBounds", "segments", "Lnet/osmand/shared/gpx/primitives/TrkSegment;", "updateBounds", "", "trackBounds", "startIndex", "calculateTrackPoints", "updateQR", "q", "p", "defLat", "defLon", "asString", "gpxFile", "Lnet/osmand/shared/gpx/GpxFile;", "writeGpxFile", "Lnet/osmand/shared/KException;", "file", "Lnet/osmand/shared/io/KFile;", "writeGpx", "stream", "Lokio/Sink;", "progress", "Lnet/osmand/shared/util/IProgress;", "assignNetworkRouteExtensionWriter", "assignPointsGroupsExtensionWriter", "writeMetadata", "serializer", "Lnet/osmand/shared/xml/XmlSerializer;", "writeNotNullLink", "link", "Lnet/osmand/shared/gpx/primitives/Link;", "writePoints", "writeRoutes", "writeTracks", "assignRouteExtensionWriter", "segment", "getFilename", "path", "writeNotNullTextWithAttribute", "tag", "attribute", "value", "writeNotNullText", "writeExtensions", "Lnet/osmand/shared/gpx/primitives/GpxExtensions;", "extensions", "writeWpt", "assignExtensionWriter", "wptPt", "regularExtensionsKey", "createExtensionsWriter", "Lnet/osmand/shared/gpx/GpxUtilities$GpxExtensionsWriter;", "addOsmandPrefix", "createGpxTpxExtensionsWriter", "writeExtensionsWithPrefix", "getOsmandTagKey", "key", "writeAuthor", "author", "Lnet/osmand/shared/gpx/primitives/Author;", "writeCopyright", "copyright", "Lnet/osmand/shared/gpx/primitives/Copyright;", "writeBounds", "bounds", "Lnet/osmand/shared/gpx/primitives/Bounds;", "readText", "parser", "Lnet/osmand/shared/xml/XmlPullParser;", "readTextMap", "formatTime", "time", "", "parseTime", "iso8601text", "getCreationTime", "getTimeFormatter", "Lkotlinx/datetime/format/DateTimeFormat;", "Lkotlinx/datetime/LocalDateTime;", "loadGpxFile", "extensionsReader", "Lnet/osmand/shared/gpx/GpxUtilities$GpxExtensionsReader;", "addGeneralTrack", "source", "Lokio/Source;", "getExtensionsSupportedTag", "parseRouteKeyAttributes", "mergePointsGroups", "Lnet/osmand/shared/gpx/GpxUtilities$PointsGroup;", "groups", "points", "parseWptAttributes", "parseRouteSegmentAttributes", "Lnet/osmand/shared/gpx/GpxUtilities$RouteSegment;", "parseRouteTypeAttributes", "Lnet/osmand/shared/gpx/GpxUtilities$RouteType;", "parseBoundsAttributes", "mergeGpxFileInto", "to", "from", "projectionOnPrimeMeridian", "previous", "next", "interpolateEmptyElevationWpts", "TimePatterns", "GpxColor", "GpxExtensionsWriter", "GpxExtensionsReader", "RouteSegment", "RouteType", "PointsGroup", "OsmAnd-shared"})
@SourceDebugExtension(value={"SMAP\nGpxUtilities.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GpxUtilities.kt\nnet/osmand/shared/gpx/GpxUtilities\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,1724:1\n1#2:1725\n37#3,2:1726\n37#3,2:1728\n*S KotlinDebug\n*F\n+ 1 GpxUtilities.kt\nnet/osmand/shared/gpx/GpxUtilities\n*L\n1291#1:1726,2\n1293#1:1728,2\n*E\n"})
public final class GpxUtilities {
    @NotNull
    public static final GpxUtilities INSTANCE = new GpxUtilities();
    @NotNull
    private static final Logger log = LoggerFactory.INSTANCE.getLogger("GpxUtilities");
    @NotNull
    public static final String ICON_NAME_EXTENSION = "icon";
    @NotNull
    public static final String BACKGROUND_TYPE_EXTENSION = "background";
    @NotNull
    public static final String COLOR_NAME_EXTENSION = "color";
    @NotNull
    public static final String LINE_WIDTH_EXTENSION = "width";
    @NotNull
    public static final String PROFILE_TYPE_EXTENSION = "profile";
    @NotNull
    public static final String ADDRESS_EXTENSION = "address";
    @NotNull
    public static final String HIDDEN_EXTENSION = "hidden";
    @NotNull
    public static final String PINNED_EXTENSION = "pinned";
    @NotNull
    public static final String POINT_TYPE_EXTENSION = "point_type";
    @NotNull
    public static final String GPXTPX_PREFIX = "gpxtpx:";
    @NotNull
    public static final String OSMAND_EXTENSIONS_PREFIX = "osmand:";
    @NotNull
    public static final String OSM_PREFIX = "osm_tag_";
    @NotNull
    public static final String AMENITY_PREFIX = "amenity_";
    @NotNull
    public static final String ORIGIN_EXTENSION = "origin";
    @NotNull
    public static final String AMENITY_ORIGIN_EXTENSION = "amenity_origin";
    @NotNull
    public static final String ACTIVITY_TYPE = "osmand:activity";
    @NotNull
    public static final String GAP_PROFILE_TYPE = "gap";
    @NotNull
    public static final String TRKPT_INDEX_EXTENSION = "trkpt_idx";
    @NotNull
    public static final String DEFAULT_ICON_NAME = "special_star";
    @NotNull
    public static final String POINT_ELEVATION = "ele";
    @NotNull
    public static final String POINT_SPEED = "speed";
    @NotNull
    public static final String POINT_BEARING = "bearing";
    @NotNull
    public static final String MIN_ELEVATION = "min_ele";
    @NotNull
    public static final String MAX_ELEVATION = "max_ele";
    @NotNull
    public static final String AVG_ELEVATION = "avg_ele";
    @NotNull
    public static final String DIFF_ELEVATION_UP = "diff_ele_up";
    @NotNull
    public static final String DIFF_ELEVATION_DOWN = "diff_ele_down";
    public static final char TRAVEL_GPX_CONVERT_FIRST_LETTER = 'A';
    public static final int TRAVEL_GPX_CONVERT_FIRST_DIST = 5000;
    public static final int TRAVEL_GPX_CONVERT_MULT_1 = 2;
    public static final int TRAVEL_GPX_CONVERT_MULT_2 = 5;
    private static boolean oneOffLogParseTimeErrors = true;
    @NotNull
    private static final String GPX_TIME_FORMATTER = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    @NotNull
    private static final Map<String, String> SUPPORTED_EXTENSION_TAGS;
    public static final int RADIUS_DIVIDER = 5000;
    public static final double PRIME_MERIDIAN = 179.999991234;

    private GpxUtilities() {
    }

    @NotNull
    public final Logger getLog() {
        return log;
    }

    @Nullable
    public final Integer parseColor(@Nullable String colorString, @Nullable Integer defColor) {
        Integer color = this.parseColor(colorString);
        Integer n = color;
        if (n == null) {
            n = defColor;
        }
        return n;
    }

    @Nullable
    public final Integer parseColor(@Nullable String colorString) {
        if (!KAlgorithms.INSTANCE.isEmpty(colorString)) {
            String string = colorString;
            Intrinsics.checkNotNull((Object)string);
            if (string.charAt(0) == '#') {
                Integer n;
                try {
                    n = KAlgorithms.INSTANCE.parseColor(colorString);
                }
                catch (IllegalArgumentException e) {
                    log.error("Error parse color", e);
                    n = null;
                }
                return n;
            }
            GpxColor gpxColor = GpxColor.Companion.getColorFromName(colorString);
            if (gpxColor != null) {
                return gpxColor.getColor();
            }
            try {
                return Integer.parseInt(colorString);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    @NotNull
    public final List<GpxTrackAnalysis> convert(@NotNull List<SplitSegment> splitSegments) {
        Intrinsics.checkNotNullParameter(splitSegments, (String)"splitSegments");
        return this.convert(splitSegments, null);
    }

    @NotNull
    public final List<GpxTrackAnalysis> convert(@NotNull List<SplitSegment> splitSegments, @Nullable GpxTrackAnalysis.TrackPointsAnalyser pointsAnalyser) {
        Intrinsics.checkNotNullParameter(splitSegments, (String)"splitSegments");
        List list = new ArrayList();
        for (SplitSegment segment : splitSegments) {
            GpxTrackAnalysis analysis = new GpxTrackAnalysis();
            SplitSegment[] splitSegmentArray = new SplitSegment[]{segment};
            analysis.prepareInformation(0L, pointsAnalyser, splitSegmentArray);
            if (segment.getSegmentSlopeType() != null && segment.getSlopeCount() != null && segment.getSlopeValue() != null) {
                analysis.setSegmentSlopeType(segment.getSegmentSlopeType());
                analysis.setSlopeCount(segment.getSlopeCount());
                analysis.setSlopeValue(segment.getSlopeValue());
            }
            list.add(analysis);
        }
        return list;
    }

    @NotNull
    public final KQuadRect calculateBounds(@NotNull List<WptPt> pts) {
        Intrinsics.checkNotNullParameter(pts, (String)"pts");
        KQuadRect trackBounds = new KQuadRect(Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
        this.updateBounds(trackBounds, pts, 0);
        return trackBounds;
    }

    @NotNull
    public final KQuadRect calculateTrackBounds(@NotNull List<TrkSegment> segments) {
        Intrinsics.checkNotNullParameter(segments, (String)"segments");
        KQuadRect trackBounds = new KQuadRect(Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
        boolean updated = false;
        for (TrkSegment segment : segments) {
            if (!(!((Collection)segment.getPoints()).isEmpty())) continue;
            this.updateBounds(trackBounds, segment.getPoints(), 0);
            updated = true;
        }
        return updated ? trackBounds : new KQuadRect();
    }

    public final void updateBounds(@NotNull KQuadRect trackBounds, @NotNull List<WptPt> pts, int startIndex) {
        Intrinsics.checkNotNullParameter((Object)trackBounds, (String)"trackBounds");
        Intrinsics.checkNotNullParameter(pts, (String)"pts");
        int n = pts.size();
        for (int i = startIndex; i < n; ++i) {
            WptPt pt = pts.get(i);
            trackBounds.setRight(Math.max(trackBounds.getRight(), pt.getLon()));
            trackBounds.setLeft(Math.min(trackBounds.getLeft(), pt.getLon()));
            trackBounds.setTop(Math.max(trackBounds.getTop(), pt.getLat()));
            trackBounds.setBottom(Math.min(trackBounds.getBottom(), pt.getLat()));
        }
    }

    /*
     * WARNING - void declaration
     */
    public final int calculateTrackPoints(@NotNull List<TrkSegment> segments) {
        Intrinsics.checkNotNullParameter(segments, (String)"segments");
        Iterable iterable = segments;
        int n = 0;
        for (Object t : iterable) {
            void it;
            TrkSegment trkSegment = (TrkSegment)t;
            int n2 = n;
            boolean bl = false;
            int n3 = it.getPoints().size();
            n = n2 + n3;
        }
        return n;
    }

    public final void updateQR(@NotNull KQuadRect q, @NotNull WptPt p, double defLat, double defLon) {
        Intrinsics.checkNotNullParameter((Object)q, (String)"q");
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        if (q.getLeft() == defLon && q.getTop() == defLat && q.getRight() == defLon && q.getBottom() == defLat) {
            q.setLeft(p.getLongitude());
            q.setRight(p.getLongitude());
            q.setTop(p.getLatitude());
            q.setBottom(p.getLatitude());
        } else {
            q.setLeft(Math.min(q.getLeft(), p.getLongitude()));
            q.setRight(Math.max(q.getRight(), p.getLongitude()));
            q.setTop(Math.max(q.getTop(), p.getLatitude()));
            q.setBottom(Math.min(q.getBottom(), p.getLatitude()));
        }
    }

    @NotNull
    public final String asString(@NotNull GpxFile gpxFile) {
        Intrinsics.checkNotNullParameter((Object)gpxFile, (String)"gpxFile");
        Buffer writer2 = new Buffer();
        this.writeGpx(null, (Sink)writer2, gpxFile, null);
        return writer2.toString();
    }

    @Nullable
    public final KException writeGpxFile(@NotNull KFile file, @NotNull GpxFile gpxFile) {
        KException kException;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)gpxFile, (String)"gpxFile");
        try {
            KFile kFile = file.getParentFile();
            if (kFile != null) {
                kFile.createDirectories();
            }
            if (KAlgorithms.INSTANCE.isEmpty(gpxFile.getPath())) {
                gpxFile.setPath(file.isAbsolute() ? file.path() : file.absolutePath());
            }
            kException = this.writeGpx(file, null, gpxFile, null);
        }
        catch (KException e) {
            log.error("Failed to write gpx '" + file + ".path()'", e);
            kException = e;
        }
        return kException;
    }

    @Nullable
    public final KException writeGpx(@Nullable KFile file, @Nullable Sink stream, @NotNull GpxFile gpxFile, @Nullable IProgress progress) {
        KException kException;
        Intrinsics.checkNotNullParameter((Object)gpxFile, (String)"gpxFile");
        IProgress iProgress = progress;
        if (iProgress != null) {
            iProgress.startWork(gpxFile.getItemsToWriteSize());
        }
        try {
            XmlSerializer serializer2 = new XmlSerializer();
            if (file != null) {
                serializer2.setOutput(file);
            } else if (stream != null) {
                serializer2.setOutput((Sink)Okio.buffer((Sink)stream));
            } else {
                throw new KException("Output file or stream is not defined");
            }
            serializer2.setFeature("http://xmlpull.org/v1/doc/features.html#indent-output", true);
            serializer2.startDocument("UTF-8", true);
            serializer2.startTag(null, "gpx");
            serializer2.attribute(null, "version", "1.1");
            String author = gpxFile.getAuthor();
            if (author != null) {
                serializer2.attribute(null, "creator", author);
            }
            serializer2.attribute(null, "xmlns", "http://www.topografix.com/GPX/1/1");
            serializer2.attribute(null, "xmlns:osmand", "https://osmand.net/docs/technical/osmand-file-formats/osmand-gpx");
            serializer2.attribute(null, "xmlns:gpxtpx", "https://www8.garmin.com/xmlschemas/TrackPointExtensionv1.xsd");
            serializer2.attribute(null, "xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            serializer2.attribute(null, "xsi:schemaLocation", "http://www.topografix.com/GPX/1/1 https://www.topografix.com/GPX/1/1/gpx.xsd");
            this.assignPointsGroupsExtensionWriter(gpxFile);
            this.assignNetworkRouteExtensionWriter(gpxFile);
            this.writeMetadata(serializer2, gpxFile, progress);
            this.writePoints(serializer2, gpxFile, progress);
            this.writeRoutes(serializer2, gpxFile, progress);
            this.writeTracks(serializer2, gpxFile, progress);
            this.writeExtensions(serializer2, gpxFile, progress);
            serializer2.endTag(null, "gpx");
            serializer2.endDocument();
            serializer2.close();
            kException = null;
        }
        catch (Exception e) {
            log.error("Failed to write gpx", e);
            kException = new KException(e.getMessage(), e);
        }
        return kException;
    }

    private final void assignNetworkRouteExtensionWriter(GpxFile gpxFile) {
        if (!KAlgorithms.INSTANCE.isEmpty(gpxFile.getNetworkRouteKeyTags())) {
            gpxFile.setExtensionsWriter("network_route", new GpxExtensionsWriter(gpxFile){
                final /* synthetic */ GpxFile $gpxFile;
                {
                    this.$gpxFile = $gpxFile;
                }

                public void writeExtensions(XmlSerializer serializer2) {
                    Intrinsics.checkNotNullParameter((Object)serializer2, (String)"serializer");
                    StringBundle bundle = new StringBundle();
                    StringBundle tagsBundle = new StringBundle();
                    tagsBundle.putString("type", this.$gpxFile.getNetworkRouteKeyTags().get("type"));
                    for (Map.Entry<String, String> entry : this.$gpxFile.getNetworkRouteKeyTags().entrySet()) {
                        String key = entry.getKey();
                        String value = entry.getValue();
                        String attributeToXml = StringsKt.replace$default((String)key, (String)":", (String)"_-_", (boolean)false, (int)4, null);
                        tagsBundle.putString(attributeToXml, value);
                    }
                    List routeKeyBundle = new ArrayList<E>();
                    routeKeyBundle.add(tagsBundle);
                    bundle.putBundleList("network_route", "osmand:route_key", routeKeyBundle);
                    StringBundleWriter bundleWriter = new StringBundleXmlWriter(bundle, serializer2);
                    bundleWriter.writeBundle();
                }
            });
        } else {
            gpxFile.removeExtensionsWriter("network_route");
        }
    }

    private final void assignPointsGroupsExtensionWriter(GpxFile gpxFile) {
        if (!KAlgorithms.INSTANCE.isEmpty(gpxFile.getPointsGroups())) {
            gpxFile.setExtensionsWriter("points_groups", new GpxExtensionsWriter(gpxFile){
                final /* synthetic */ GpxFile $gpxFile;
                {
                    this.$gpxFile = $gpxFile;
                }

                public void writeExtensions(XmlSerializer serializer2) {
                    Intrinsics.checkNotNullParameter((Object)serializer2, (String)"serializer");
                    StringBundle bundle = new StringBundle();
                    List categoriesBundle = new ArrayList<E>();
                    for (PointsGroup group : this.$gpxFile.getPointsGroups().values()) {
                        categoriesBundle.add(group.toStringBundle());
                    }
                    bundle.putBundleList("points_groups", "group", categoriesBundle);
                    StringBundleXmlWriter bundleWriter = new StringBundleXmlWriter(bundle, serializer2);
                    bundleWriter.writeBundle();
                }
            });
        } else {
            gpxFile.removeExtensionsWriter("points_groups");
        }
    }

    private final void writeMetadata(XmlSerializer serializer2, GpxFile file, IProgress progress) {
        Copyright copyright;
        String defName = file.getMetadata().getName();
        String trackName = !KAlgorithms.INSTANCE.isEmpty(defName) ? defName : this.getFilename(file.getPath());
        serializer2.startTag(null, "metadata");
        this.writeNotNullText(serializer2, "name", trackName);
        this.writeNotNullText(serializer2, "desc", file.getMetadata().getDesc());
        Author author = file.getMetadata().getAuthor();
        if (author != null) {
            serializer2.startTag(null, "author");
            this.writeAuthor(serializer2, author);
            serializer2.endTag(null, "author");
        }
        if ((copyright = file.getMetadata().getCopyright()) != null) {
            serializer2.startTag(null, "copyright");
            this.writeCopyright(serializer2, copyright);
            serializer2.endTag(null, "copyright");
        }
        this.writeNotNullLink(serializer2, file.getMetadata().getLink());
        if (file.getMetadata().getTime() != 0L) {
            this.writeNotNullText(serializer2, "time", this.formatTime(file.getMetadata().getTime()));
        }
        this.writeNotNullText(serializer2, "keywords", file.getMetadata().getKeywords());
        Bounds bounds = file.getMetadata().getBounds();
        if (bounds != null) {
            this.writeBounds(serializer2, bounds);
        }
        this.writeExtensions(serializer2, file.getMetadata(), null);
        IProgress iProgress = progress;
        if (iProgress != null) {
            iProgress.progress(1);
        }
        serializer2.endTag(null, "metadata");
    }

    private final void writeNotNullLink(XmlSerializer serializer2, Link link) {
        if (link != null) {
            serializer2.startTag(null, "link");
            if (link.getHref() != null) {
                String string = link.getHref();
                Intrinsics.checkNotNull((Object)string);
                serializer2.attribute(null, "href", string);
            }
            this.writeNotNullText(serializer2, "text", link.getText());
            serializer2.endTag(null, "link");
        }
    }

    private final void writePoints(XmlSerializer serializer2, GpxFile file, IProgress progress) {
        for (WptPt l : file.getPointsList()) {
            serializer2.startTag(null, "wpt");
            this.writeWpt(serializer2, l, progress, file);
            serializer2.endTag(null, "wpt");
        }
    }

    private final void writeRoutes(XmlSerializer serializer2, GpxFile file, IProgress progress) {
        for (Route route : file.getRoutes()) {
            serializer2.startTag(null, "rte");
            this.writeNotNullText(serializer2, "name", route.getName());
            this.writeNotNullText(serializer2, "desc", route.getDesc());
            for (WptPt p : route.getPoints()) {
                serializer2.startTag(null, "rtept");
                this.writeWpt(serializer2, p, progress, file);
                serializer2.endTag(null, "rtept");
            }
            this.writeExtensions(serializer2, route, null);
            serializer2.endTag(null, "rte");
        }
    }

    private final void writeTracks(XmlSerializer serializer2, GpxFile file, IProgress progress) {
        for (Track track : file.getTracks()) {
            if (track.getGeneralTrack()) continue;
            serializer2.startTag(null, "trk");
            this.writeNotNullText(serializer2, "name", track.getName());
            this.writeNotNullText(serializer2, "desc", track.getDesc());
            this.writeExtensions(serializer2, track, null);
            for (TrkSegment segment : track.getSegments()) {
                serializer2.startTag(null, "trkseg");
                this.writeNotNullText(serializer2, "name", segment.getName());
                for (WptPt p : segment.getPoints()) {
                    serializer2.startTag(null, "trkpt");
                    this.writeWpt(serializer2, p, progress, file);
                    serializer2.endTag(null, "trkpt");
                }
                this.assignRouteExtensionWriter(segment);
                this.writeExtensions(serializer2, segment, null);
                serializer2.endTag(null, "trkseg");
            }
            serializer2.endTag(null, "trk");
        }
    }

    private final void assignRouteExtensionWriter(TrkSegment segment) {
        if (segment.hasRoute() && segment.getExtensionsWriter("route") == null) {
            segment.setExtensionsWriter("route", new GpxExtensionsWriter(segment){
                final /* synthetic */ TrkSegment $segment;
                {
                    this.$segment = $segment;
                }

                public void writeExtensions(XmlSerializer serializer2) {
                    Intrinsics.checkNotNullParameter((Object)serializer2, (String)"serializer");
                    StringBundle bundle = new StringBundle();
                    List segmentsBundle = new ArrayList<E>();
                    for (RouteSegment routeSegment : this.$segment.getRouteSegments()) {
                        segmentsBundle.add(routeSegment.toStringBundle());
                    }
                    bundle.putBundleList("route", "segment", segmentsBundle);
                    List typesBundle = new ArrayList<E>();
                    for (RouteType routeType : this.$segment.getRouteTypes()) {
                        typesBundle.add(routeType.toStringBundle());
                    }
                    bundle.putBundleList("types", "type", typesBundle);
                    StringBundleXmlWriter stringBundleXmlWriter = new StringBundleXmlWriter(bundle, serializer2);
                    stringBundleXmlWriter.writeBundle();
                }
            });
        }
    }

    private final String getFilename(String path) {
        String newPath = path;
        if (newPath != null) {
            int i = StringsKt.lastIndexOf$default((CharSequence)newPath, (char)'/', (int)0, (boolean)false, (int)6, null);
            if (i > 0) {
                String string = newPath.substring(i + 1);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                newPath = string;
            }
            if ((i = StringsKt.lastIndexOf$default((CharSequence)newPath, (char)'.', (int)0, (boolean)false, (int)6, null)) > 0) {
                String string = newPath.substring(0, i);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                newPath = string;
            }
            if (StringsKt.contains$default((CharSequence)newPath, (CharSequence)"_-_", (boolean)false, (int)2, null)) {
                newPath = StringsKt.replace$default((String)newPath, (String)"_-_", (String)":", (boolean)false, (int)4, null);
            }
        }
        return newPath;
    }

    private final void writeNotNullTextWithAttribute(XmlSerializer serializer2, String tag, String attribute, String value) {
        if (value != null) {
            serializer2.startTag(null, tag);
            serializer2.attribute(null, attribute, value);
            serializer2.endTag(null, tag);
        }
    }

    public final void writeNotNullText(@NotNull XmlSerializer serializer2, @NotNull String tag, @Nullable String value) {
        Intrinsics.checkNotNullParameter((Object)serializer2, (String)"serializer");
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        if (value != null) {
            serializer2.startTag(null, tag);
            serializer2.text(value);
            serializer2.endTag(null, tag);
        }
    }

    private final void writeExtensions(XmlSerializer serializer2, GpxExtensions p, IProgress progress) {
        this.writeExtensions(serializer2, p.getExtensionsToRead(), p, progress);
    }

    private final void writeExtensions(XmlSerializer serializer2, Map<String, String> extensions, GpxExtensions p, IProgress progress) {
        block5: {
            boolean hasExtensionWriters;
            Map<String, GpxExtensionsWriter> extensionsWriters = p.getExtensionsWritersToWrite();
            Map<String, String> map = extensions;
            boolean hasExtensions = !(map == null || map.isEmpty());
            boolean bl = hasExtensionWriters = !KAlgorithms.INSTANCE.isEmpty(extensionsWriters);
            if (!hasExtensions && !hasExtensionWriters) break block5;
            serializer2.startTag(null, "extensions");
            if (hasExtensions) {
                Map<String, String> map2 = extensions;
                Intrinsics.checkNotNull(map2);
                for (Map.Entry entry : map2.entrySet()) {
                    String key = (String)entry.getKey();
                    String value = (String)entry.getValue();
                    this.writeNotNullText(serializer2, this.getOsmandTagKey(key, value), value);
                }
            }
            if (hasExtensionWriters) {
                for (GpxExtensionsWriter gpxExtensionsWriter : extensionsWriters.values()) {
                    gpxExtensionsWriter.writeExtensions(serializer2);
                }
            }
            serializer2.endTag(null, "extensions");
            IProgress iProgress = progress;
            if (iProgress != null) {
                iProgress.progress(1);
            }
        }
    }

    private final void writeWpt(XmlSerializer serializer2, WptPt p, IProgress progress, GpxFile file) {
        block12: {
            serializer2.attribute(null, "lat", GpxFormatter.INSTANCE.formatLatLon(p.getLat()));
            serializer2.attribute(null, "lon", GpxFormatter.INSTANCE.formatLatLon(p.getLon()));
            if (!Double.isNaN(p.getEle())) {
                this.writeNotNullText(serializer2, POINT_ELEVATION, GpxFormatter.INSTANCE.formatDecimal(p.getEle()));
            }
            if (p.getTime() != 0L) {
                this.writeNotNullText(serializer2, "time", this.formatTime(p.getTime()));
            }
            this.writeNotNullText(serializer2, "name", p.getName());
            this.writeNotNullText(serializer2, "cmt", p.getComment());
            this.writeNotNullText(serializer2, "desc", p.getDesc());
            this.writeNotNullLink(serializer2, p.getLink());
            this.writeNotNullText(serializer2, "type", p.getCategory());
            if (!Double.isNaN(p.getHdop())) {
                this.writeNotNullText(serializer2, "hdop", GpxFormatter.INSTANCE.formatDecimal(p.getHdop()));
            }
            if (p.getSpeed() > 0.0) {
                p.getExtensionsToWrite().put(POINT_SPEED, GpxFormatter.INSTANCE.formatDecimal(p.getSpeed()));
            }
            if (!Float.isNaN(p.getHeading())) {
                p.getExtensionsToWrite().put("heading", String.valueOf((float)Math.rint(p.getHeading())));
            }
            Map extensions = MapsKt.toMutableMap(p.getExtensionsToRead());
            if (!Intrinsics.areEqual((Object)serializer2.getName(), (Object)"rtept")) {
                extensions.remove(PROFILE_TYPE_EXTENSION);
                extensions.remove(TRKPT_INDEX_EXTENSION);
            } else {
                String profile = (String)extensions.get(PROFILE_TYPE_EXTENSION);
                if (Intrinsics.areEqual((Object)GAP_PROFILE_TYPE, (Object)profile)) {
                    extensions.remove(PROFILE_TYPE_EXTENSION);
                }
            }
            if (p.getCategory() != null && file.getPointsGroups().get(p.getCategory()) != null) {
                PointsGroup pointsGroup = file.getPointsGroups().get(p.getCategory());
                Intrinsics.checkNotNull((Object)pointsGroup);
                PointsGroup pointsGroup2 = pointsGroup;
                if (p.getColor() == pointsGroup2.getColor()) {
                    extensions.remove(COLOR_NAME_EXTENSION);
                }
                if (Intrinsics.areEqual((Object)p.getIconName(), (Object)pointsGroup2.getIconName())) {
                    extensions.remove(ICON_NAME_EXTENSION);
                }
                if (Intrinsics.areEqual((Object)p.getBackgroundType(), (Object)pointsGroup2.getBackgroundType())) {
                    extensions.remove(BACKGROUND_TYPE_EXTENSION);
                }
            }
            this.assignExtensionWriter(p, extensions, "extensions");
            this.writeExtensions(serializer2, null, p, null);
            IProgress iProgress = progress;
            if (iProgress == null) break block12;
            iProgress.progress(1);
        }
    }

    public final void assignExtensionWriter(@NotNull WptPt wptPt, @NotNull Map<String, String> extensions, @NotNull String regularExtensionsKey) {
        Intrinsics.checkNotNullParameter((Object)wptPt, (String)"wptPt");
        Intrinsics.checkNotNullParameter(extensions, (String)"extensions");
        Intrinsics.checkNotNullParameter((Object)regularExtensionsKey, (String)"regularExtensionsKey");
        HashMap regularExtensions = new HashMap();
        HashMap gpxtpxExtensions = new HashMap();
        for (Map.Entry<String, String> entry : extensions.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (StringsKt.startsWith$default((String)key, (String)GPXTPX_PREFIX, (boolean)false, (int)2, null)) {
                ((Map)gpxtpxExtensions).put(key, value);
            } else {
                ((Map)regularExtensions).put(key, value);
            }
            wptPt.getDeferredExtensionsToWrite().put(key, value);
        }
        if (!((Map)regularExtensions).isEmpty()) {
            wptPt.setExtensionsWriter(regularExtensionsKey, this.createExtensionsWriter(regularExtensions, true));
        }
        if (!((Map)gpxtpxExtensions).isEmpty()) {
            wptPt.setExtensionsWriter("gpxtpx:TrackPointExtension", this.createGpxTpxExtensionsWriter(gpxtpxExtensions, false));
        }
    }

    private final GpxExtensionsWriter createExtensionsWriter(Map<String, String> extensions, boolean addOsmandPrefix) {
        return new GpxExtensionsWriter(extensions, addOsmandPrefix){
            final /* synthetic */ Map<String, String> $extensions;
            final /* synthetic */ boolean $addOsmandPrefix;
            {
                this.$extensions = $extensions;
                this.$addOsmandPrefix = $addOsmandPrefix;
            }

            public void writeExtensions(XmlSerializer serializer2) {
                Intrinsics.checkNotNullParameter((Object)serializer2, (String)"serializer");
                GpxUtilities.access$writeExtensionsWithPrefix(GpxUtilities.INSTANCE, serializer2, this.$extensions, this.$addOsmandPrefix);
            }
        };
    }

    private final GpxExtensionsWriter createGpxTpxExtensionsWriter(Map<String, String> extensions, boolean addOsmandPrefix) {
        return new GpxExtensionsWriter(extensions, addOsmandPrefix){
            final /* synthetic */ Map<String, String> $extensions;
            final /* synthetic */ boolean $addOsmandPrefix;
            {
                this.$extensions = $extensions;
                this.$addOsmandPrefix = $addOsmandPrefix;
            }

            public void writeExtensions(XmlSerializer serializer2) {
                Intrinsics.checkNotNullParameter((Object)serializer2, (String)"serializer");
                try {
                    serializer2.startTag(null, "gpxtpx:TrackPointExtension");
                    GpxUtilities.access$writeExtensionsWithPrefix(GpxUtilities.INSTANCE, serializer2, this.$extensions, this.$addOsmandPrefix);
                    serializer2.endTag(null, "gpxtpx:TrackPointExtension");
                }
                catch (IOException e) {
                    GpxUtilities.INSTANCE.getLog().error("Error create GpxTpxExtensions", e);
                }
            }
        };
    }

    private final void writeExtensionsWithPrefix(XmlSerializer serializer2, Map<String, String> extensions, boolean addOsmandPrefix) {
        for (Map.Entry<String, String> entry : extensions.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            try {
                this.writeNotNullText(serializer2, addOsmandPrefix ? this.getOsmandTagKey(key, value) : key, value);
            }
            catch (IOException e) {
                log.error("Error write ExtensionsWithPrefix", e);
            }
        }
    }

    private final String getOsmandTagKey(String key, String value) {
        String newKey = key;
        if (StringsKt.startsWith$default((String)newKey, (String)OSMAND_EXTENSIONS_PREFIX, (boolean)false, (int)2, null)) {
            newKey = StringsKt.replace$default((String)newKey, (String)OSMAND_EXTENSIONS_PREFIX, (String)"", (boolean)false, (int)4, null);
        }
        newKey = StringsKt.replace$default((String)newKey, (String)":", (String)"_-_", (boolean)false, (int)4, null);
        return OSMAND_EXTENSIONS_PREFIX + newKey;
    }

    private final void writeAuthor(XmlSerializer serializer2, Author author) {
        this.writeNotNullText(serializer2, "name", author.getName());
        if (author.getEmail() != null) {
            String string = author.getEmail();
            Intrinsics.checkNotNull((Object)string);
            if (StringsKt.contains$default((CharSequence)string, (CharSequence)"@", (boolean)false, (int)2, null)) {
                String string2 = author.getEmail();
                Intrinsics.checkNotNull((Object)string2);
                String[] stringArray = new String[]{"@"};
                List idAndDomain = StringsKt.split$default((CharSequence)string2, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
                if (idAndDomain.size() == 2 && ((CharSequence)idAndDomain.get(0)).length() > 0 && ((CharSequence)idAndDomain.get(1)).length() > 0) {
                    serializer2.startTag(null, "email");
                    serializer2.attribute(null, "id", (String)idAndDomain.get(0));
                    serializer2.attribute(null, "domain", (String)idAndDomain.get(1));
                    serializer2.endTag(null, "email");
                }
            }
        }
        this.writeNotNullLink(serializer2, author.getLink());
    }

    private final void writeCopyright(XmlSerializer serializer2, Copyright copyright) {
        String author = copyright.getAuthor();
        if (author != null) {
            serializer2.attribute(null, "author", author);
        }
        this.writeNotNullText(serializer2, "year", copyright.getYear());
        this.writeNotNullText(serializer2, "license", copyright.getLicense());
    }

    private final void writeBounds(XmlSerializer serializer2, Bounds bounds) {
        serializer2.startTag(null, "bounds");
        serializer2.attribute(null, "minlat", GpxFormatter.INSTANCE.formatLatLon(bounds.getMinlat()));
        serializer2.attribute(null, "minlon", GpxFormatter.INSTANCE.formatLatLon(bounds.getMinlon()));
        serializer2.attribute(null, "maxlat", GpxFormatter.INSTANCE.formatLatLon(bounds.getMaxlat()));
        serializer2.attribute(null, "maxlon", GpxFormatter.INSTANCE.formatLatLon(bounds.getMaxlon()));
        serializer2.endTag(null, "bounds");
    }

    @Nullable
    public final String readText(@NotNull XmlPullParser parser, @NotNull String key) throws XmlParserException, IOException {
        Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        int tok = 0;
        StringBuilder text = null;
        while (true) {
            int n;
            int it = n = parser.next();
            boolean bl = false;
            tok = it;
            if (n == 1 || tok == 3 && Intrinsics.areEqual((Object)parser.getName(), (Object)key)) break;
            if (tok != 4) continue;
            if (text == null) {
                text = new StringBuilder();
            }
            text.append(parser.getText());
        }
        StringBuilder stringBuilder = text;
        return stringBuilder != null ? stringBuilder.toString() : null;
    }

    @NotNull
    public final Map<String, String> readTextMap(@NotNull XmlPullParser parser, @NotNull String key) throws XmlParserException, IOException {
        Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        int tok = 0;
        StringBuilder text = null;
        Map result = new HashMap();
        while (true) {
            int n;
            int it = n = parser.next();
            boolean bl = false;
            tok = it;
            if (n == 1) break;
            if (tok == 3) {
                String tag = parser.getName();
                if (tag != null && text != null) {
                    String string = text.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                    if (((CharSequence)((Object)StringsKt.trim((CharSequence)string)).toString()).length() > 0) {
                        result.put(tag, text.toString());
                    }
                }
                if (Intrinsics.areEqual((Object)tag, (Object)key)) break;
                text = null;
                continue;
            }
            if (tok == 2) {
                text = null;
                continue;
            }
            if (tok != 4) continue;
            if (text == null) {
                text = new StringBuilder();
            }
            text.append(parser.getText());
        }
        return result;
    }

    @NotNull
    public final String formatTime(long time) {
        DateTimeFormat<LocalDateTime> format = this.getTimeFormatter();
        return format.format((Object)TimeZoneKt.toLocalDateTime((Instant)Instant.Companion.fromEpochMilliseconds(time), (TimeZone)((TimeZone)TimeZone.Companion.getUTC())));
    }

    public final long parseTime(@NotNull String iso8601text) {
        Intrinsics.checkNotNullParameter((Object)iso8601text, (String)"iso8601text");
        double milliseconds = 0.0;
        Object noFractionalSeconds = iso8601text;
        int isIndex = StringsKt.indexOf$default((CharSequence)((CharSequence)noFractionalSeconds), (char)'.', (int)0, (boolean)false, (int)6, null);
        if (isIndex > 0) {
            int esIndex;
            for (esIndex = isIndex + 1; esIndex < ((String)noFractionalSeconds).length() && Character.isDigit(((String)noFractionalSeconds).charAt(esIndex)); ++esIndex) {
            }
            String string = ((String)noFractionalSeconds).substring(isIndex, esIndex);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            milliseconds = Double.parseDouble("0" + string);
            String string2 = ((String)noFractionalSeconds).substring(0, isIndex);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            String string3 = ((String)noFractionalSeconds).substring(esIndex);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            noFractionalSeconds = string2 + string3;
        }
        String rfc3339 = StringsKt.replaceFirst$default((String)((Object)StringsKt.trim((CharSequence)((CharSequence)noFractionalSeconds))).toString(), (char)' ', (char)'T', (boolean)false, (int)4, null);
        for (DateTimeFormat<DateTimeComponents> fmt : TimePatterns.Companion.getFormats()) {
            try {
                return ((DateTimeComponents)fmt.parse((CharSequence)rfc3339)).toInstantUsingOffset().toEpochMilliseconds() + (long)(milliseconds * (double)1000);
            }
            catch (Exception exception) {
            }
        }
        if (oneOffLogParseTimeErrors) {
            oneOffLogParseTimeErrors = false;
            Logger.error$default(log, "Failed to parse date: '" + iso8601text + "'", null, 2, null);
        }
        return 0L;
    }

    public final long getCreationTime(@Nullable GpxFile gpxFile) {
        long time = 0L;
        if (gpxFile != null) {
            long l = time = gpxFile.getMetadata().getTime() > 0L ? gpxFile.getMetadata().getTime() : gpxFile.getLastPointTime();
            if (time == 0L) {
                time = gpxFile.getModifiedTime();
            }
        }
        if (time == 0L) {
            time = ClockExtensionsKt.currentTimeMillis();
        }
        return time;
    }

    private final DateTimeFormat<LocalDateTime> getTimeFormatter() {
        return LocalDateTime.Companion.Format(GpxUtilities::getTimeFormatter$lambda$3);
    }

    @NotNull
    public final GpxFile loadGpxFile(@NotNull KFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return this.loadGpxFile(file, null, true);
    }

    @NotNull
    public final GpxFile loadGpxFile(@NotNull KFile file, @Nullable GpxExtensionsReader extensionsReader, boolean addGeneralTrack) {
        GpxFile gpxFile;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        try {
            GpxFile gpxFile2 = this.loadGpxFile(file, null, extensionsReader, addGeneralTrack);
            gpxFile2.setPath(file.absolutePath());
            gpxFile2.setModifiedTime(file.lastModified());
            gpxFile2.setPointsModifiedTime(gpxFile2.getModifiedTime());
            if (gpxFile2.getError() != null) {
                String string = gpxFile2.getPath();
                KException kException = gpxFile2.getError();
                Intrinsics.checkNotNull((Object)kException);
                log.info("Error reading gpx " + string + ": " + kException.getMessage());
            }
            gpxFile = gpxFile2;
        }
        catch (IOException e) {
            GpxFile gpxFile3 = new GpxFile(null);
            gpxFile3.setPath(file.absolutePath());
            log.error("Error reading gpx " + gpxFile3.getPath(), e);
            gpxFile3.setError(new KException(e.getMessage(), e));
            gpxFile = gpxFile3;
        }
        return gpxFile;
    }

    @NotNull
    public final GpxFile loadGpxFile(@NotNull Source source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        return this.loadGpxFile(null, source, null, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public final GpxFile loadGpxFile(@Nullable KFile file, @Nullable Source source, @Nullable GpxExtensionsReader extensionsReader, boolean addGeneralTrack) {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"trk", (Object)0)};
        Map insideTagDepth = MapsKt.mutableMapOf((Pair[])pairArray);
        oneOffLogParseTimeErrors = true;
        GpxFile gpxFile = new GpxFile(null);
        gpxFile.getMetadata().setTime(0L);
        XmlPullParser parser = null;
        try {
            parser = new XmlPullParser();
            if (file != null) {
                parser.setInput(file, "UTF-8");
            } else {
                if (source == null) throw new KException("Input file or source is not defined");
                parser.setInput((Source)Okio.buffer((Source)source), "UTF-8");
            }
            Track routeTrack = new Track();
            TrkSegment routeTrackSegment = new TrkSegment();
            routeTrack.getSegments().add(routeTrackSegment);
            ArrayDeque parserState = new ArrayDeque();
            TrkSegment firstSegment = null;
            boolean extensionReadMode = false;
            boolean routePointExtension = false;
            List routeSegments = new ArrayList();
            List routeTypes = new ArrayList();
            List pointsGroups = new ArrayList();
            boolean routeExtension = false;
            boolean typesExtension = false;
            boolean pointsGroupsExtension = false;
            boolean networkRoute = false;
            parserState.add((Object)gpxFile);
            int tok = 0;
            while (true) {
                Object object;
                block192: {
                    Iterator it2;
                    GpxExtensions parse;
                    block193: {
                        block189: {
                            int it2;
                            block190: {
                                block199: {
                                    GpxExtensions gpxExtensions;
                                    String tag;
                                    block206: {
                                        block205: {
                                            block204: {
                                                block203: {
                                                    block202: {
                                                        Object values;
                                                        block201: {
                                                            block200: {
                                                                block194: {
                                                                    block195: {
                                                                        block197: {
                                                                            block196: {
                                                                                block198: {
                                                                                    block191: {
                                                                                        String tagName;
                                                                                        int n;
                                                                                        int it3 = n = parser.next();
                                                                                        boolean bl = false;
                                                                                        tok = it3;
                                                                                        if (n == 1) break block189;
                                                                                        if (tok != 2) break block190;
                                                                                        parse = (GpxExtensions)parserState.lastOrNull();
                                                                                        String string = parser.getName();
                                                                                        if (string == null) {
                                                                                            string = "";
                                                                                        }
                                                                                        tag = string;
                                                                                        Integer n2 = (Integer)insideTagDepth.get(tag);
                                                                                        if (n2 != null) {
                                                                                            it2 = ((Number)n2).intValue();
                                                                                            boolean bl2 = false;
                                                                                            insideTagDepth.put(tag, it2 + 1);
                                                                                            v2 = Unit.INSTANCE;
                                                                                        } else {
                                                                                            v2 = null;
                                                                                        }
                                                                                        if (!extensionReadMode || parse == null || routePointExtension) break block191;
                                                                                        Intrinsics.checkNotNullExpressionValue((Object)tag.toLowerCase(Locale.ROOT), (String)"toLowerCase(...)");
                                                                                        if (routeExtension && Intrinsics.areEqual((Object)tagName, (Object)"segment")) {
                                                                                            RouteSegment segment = this.parseRouteSegmentAttributes(parser);
                                                                                            object = routeSegments.add(segment);
                                                                                            continue;
                                                                                        }
                                                                                        if (typesExtension && Intrinsics.areEqual((Object)tagName, (Object)"type")) {
                                                                                            RouteType type = this.parseRouteTypeAttributes(parser);
                                                                                            object = routeTypes.add(type);
                                                                                            continue;
                                                                                        }
                                                                                        if (pointsGroupsExtension && Intrinsics.areEqual((Object)tagName, (Object)"group")) {
                                                                                            PointsGroup pointsGroup = PointsGroup.Companion.parsePointsGroupAttributes(parser);
                                                                                            object = pointsGroups.add(pointsGroup);
                                                                                            continue;
                                                                                        }
                                                                                        if (networkRoute && Intrinsics.areEqual((Object)tagName, (Object)"route_key")) {
                                                                                            gpxFile.getNetworkRouteKeyTags().putAll(this.parseRouteKeyAttributes(parser));
                                                                                            object = Unit.INSTANCE;
                                                                                            continue;
                                                                                        }
                                                                                        if (Intrinsics.areEqual((Object)tagName, (Object)"routepointextension")) {
                                                                                            routePointExtension = true;
                                                                                            if (parse instanceof WptPt) {
                                                                                                ((WptPt)parse).getExtensionsToWrite().put("offset", String.valueOf(routeTrackSegment.getPoints().size()));
                                                                                            }
                                                                                            object = Unit.INSTANCE;
                                                                                            continue;
                                                                                        }
                                                                                        if (Intrinsics.areEqual((Object)tagName, (Object)"route")) {
                                                                                            Object v = insideTagDepth.get("trk");
                                                                                            Intrinsics.checkNotNull(v);
                                                                                            if (((Number)v).intValue() > 0) {
                                                                                                routeExtension = true;
                                                                                                object = Unit.INSTANCE;
                                                                                                continue;
                                                                                            }
                                                                                        }
                                                                                        if (Intrinsics.areEqual((Object)tagName, (Object)"types")) {
                                                                                            Object v = insideTagDepth.get("trk");
                                                                                            Intrinsics.checkNotNull(v);
                                                                                            if (((Number)v).intValue() > 0) {
                                                                                                typesExtension = true;
                                                                                                object = Unit.INSTANCE;
                                                                                                continue;
                                                                                            }
                                                                                        }
                                                                                        if (Intrinsics.areEqual((Object)tagName, (Object)"points_groups")) {
                                                                                            pointsGroupsExtension = true;
                                                                                            object = Unit.INSTANCE;
                                                                                            continue;
                                                                                        }
                                                                                        if (Intrinsics.areEqual((Object)tagName, (Object)"network_route")) {
                                                                                            networkRoute = true;
                                                                                            object = Unit.INSTANCE;
                                                                                            continue;
                                                                                        }
                                                                                        if (extensionsReader != null && extensionsReader.readExtensions(gpxFile, parser) || !(!(values = this.readTextMap(parser, tag)).isEmpty())) break block192;
                                                                                        it2 = values.entrySet().iterator();
                                                                                        break block193;
                                                                                    }
                                                                                    if (parse != null && Intrinsics.areEqual((Object)tag, (Object)"extensions")) {
                                                                                        extensionReadMode = true;
                                                                                        object = Unit.INSTANCE;
                                                                                        continue;
                                                                                    }
                                                                                    if (routePointExtension) {
                                                                                        if (Intrinsics.areEqual((Object)tag, (Object)"rpt")) {
                                                                                            WptPt wptPt = this.parseWptAttributes(parser);
                                                                                            routeTrackSegment.getPoints().add(wptPt);
                                                                                            parserState.add((Object)wptPt);
                                                                                        }
                                                                                        object = Unit.INSTANCE;
                                                                                        continue;
                                                                                    }
                                                                                    gpxExtensions = parse;
                                                                                    if (!(gpxExtensions instanceof GpxFile)) break block194;
                                                                                    values = tag;
                                                                                    switch (((String)values).hashCode()) {
                                                                                        case -450004177: {
                                                                                            if (((String)values).equals("metadata")) break;
                                                                                            break block195;
                                                                                        }
                                                                                        case 113251: {
                                                                                            if (((String)values).equals("rte")) break block196;
                                                                                            break block195;
                                                                                        }
                                                                                        case 117947: {
                                                                                            if (((String)values).equals("wpt")) break block197;
                                                                                            break block195;
                                                                                        }
                                                                                        case 115117: {
                                                                                            if (((String)values).equals("trk")) break block198;
                                                                                            break block195;
                                                                                        }
                                                                                        case 102575: {
                                                                                            if (((String)values).equals("gpx")) {
                                                                                                ((GpxFile)parse).setAuthor(parser.getAttributeValue("", "creator"));
                                                                                            }
                                                                                            break block195;
                                                                                        }
                                                                                    }
                                                                                    Metadata metadata = new Metadata();
                                                                                    ((GpxFile)parse).setMetadata(metadata);
                                                                                    parserState.add((Object)metadata);
                                                                                    break block199;
                                                                                }
                                                                                Track track = new Track();
                                                                                ((GpxFile)parse).getTracks().add(track);
                                                                                parserState.add((Object)track);
                                                                                break block199;
                                                                            }
                                                                            Route route = new Route();
                                                                            ((GpxFile)parse).getRoutes().add(route);
                                                                            parserState.add((Object)route);
                                                                            break block199;
                                                                        }
                                                                        WptPt wptPt = this.parseWptAttributes(parser);
                                                                        ((GpxFile)parse).addParsedPoint(wptPt);
                                                                        parserState.add((Object)wptPt);
                                                                    }
                                                                    break block199;
                                                                }
                                                                if (!(gpxExtensions instanceof Metadata)) break block200;
                                                                switch (tag) {
                                                                    case "name": {
                                                                        ((Metadata)parse).setName(this.readText(parser, "name"));
                                                                        break;
                                                                    }
                                                                    case "desc": {
                                                                        ((Metadata)parse).setDesc(this.readText(parser, "desc"));
                                                                        break;
                                                                    }
                                                                    case "author": {
                                                                        Author author = new Author();
                                                                        author.setName(parser.getText());
                                                                        ((Metadata)parse).setAuthor(author);
                                                                        parserState.add((Object)author);
                                                                        break;
                                                                    }
                                                                    case "copyright": {
                                                                        Copyright copyright = new Copyright();
                                                                        copyright.setLicense(parser.getText());
                                                                        copyright.setAuthor(parser.getAttributeValue("", "author"));
                                                                        ((Metadata)parse).setCopyright(copyright);
                                                                        parserState.add((Object)copyright);
                                                                        break;
                                                                    }
                                                                    case "link": {
                                                                        Link link = new Link(parser.getAttributeValue("", "href"));
                                                                        ((Metadata)parse).setLink(link);
                                                                        parserState.add((Object)link);
                                                                        break;
                                                                    }
                                                                    case "time": {
                                                                        String text = this.readText(parser, "time");
                                                                        Metadata metadata = (Metadata)parse;
                                                                        String string = text;
                                                                        Intrinsics.checkNotNull((Object)string);
                                                                        metadata.setTime(this.parseTime(string));
                                                                        break;
                                                                    }
                                                                    case "keywords": {
                                                                        ((Metadata)parse).setKeywords(this.readText(parser, "keywords"));
                                                                        break;
                                                                    }
                                                                    case "bounds": {
                                                                        Bounds bounds = this.parseBoundsAttributes(parser);
                                                                        ((Metadata)parse).setBounds(bounds);
                                                                        parserState.add((Object)bounds);
                                                                    }
                                                                }
                                                                break block199;
                                                            }
                                                            if (!(gpxExtensions instanceof Author)) break block201;
                                                            switch (tag) {
                                                                case "name": {
                                                                    ((Author)parse).setName(this.readText(parser, "name"));
                                                                    break;
                                                                }
                                                                case "email": {
                                                                    String id = parser.getAttributeValue("", "id");
                                                                    String domain = parser.getAttributeValue("", "domain");
                                                                    if (KAlgorithms.INSTANCE.isEmpty(id) || KAlgorithms.INSTANCE.isEmpty(domain)) break;
                                                                    ((Author)parse).setEmail(id + "@" + domain);
                                                                    break;
                                                                }
                                                                case "link": {
                                                                    Link link = new Link(parser.getAttributeValue("", "href"));
                                                                    ((Author)parse).setLink(link);
                                                                    parserState.add((Object)link);
                                                                }
                                                            }
                                                            break block199;
                                                        }
                                                        if (!(gpxExtensions instanceof Copyright)) break block202;
                                                        values = tag;
                                                        if (Intrinsics.areEqual((Object)values, (Object)"year")) {
                                                            ((Copyright)parse).setYear(this.readText(parser, "year"));
                                                            break block199;
                                                        } else if (Intrinsics.areEqual((Object)values, (Object)"license")) {
                                                            ((Copyright)parse).setLicense(this.readText(parser, "license"));
                                                        }
                                                        break block199;
                                                    }
                                                    if (!(gpxExtensions instanceof Link)) break block203;
                                                    if (Intrinsics.areEqual((Object)tag, (Object)"text")) {
                                                        ((Link)parse).setText(this.readText(parser, "text"));
                                                    }
                                                    break block199;
                                                }
                                                if (!(gpxExtensions instanceof Route)) break block204;
                                                switch (tag) {
                                                    case "name": {
                                                        ((Route)parse).setName(this.readText(parser, "name"));
                                                        break;
                                                    }
                                                    case "desc": {
                                                        ((Route)parse).setDesc(this.readText(parser, "desc"));
                                                        break;
                                                    }
                                                    case "rtept": {
                                                        WptPt wptPt = this.parseWptAttributes(parser);
                                                        ((Route)parse).getPoints().add(wptPt);
                                                        parserState.add((Object)wptPt);
                                                    }
                                                }
                                                break block199;
                                            }
                                            if (!(gpxExtensions instanceof Track)) break block205;
                                            switch (tag) {
                                                case "name": {
                                                    ((Track)parse).setName(this.readText(parser, "name"));
                                                    break;
                                                }
                                                case "desc": {
                                                    ((Track)parse).setDesc(this.readText(parser, "desc"));
                                                    break;
                                                }
                                                case "trkseg": {
                                                    TrkSegment trkSeg = new TrkSegment();
                                                    ((Track)parse).getSegments().add(trkSeg);
                                                    parserState.add((Object)trkSeg);
                                                    break;
                                                }
                                                case "rpt": 
                                                case "trkpt": {
                                                    WptPt wptPt = this.parseWptAttributes(parser);
                                                    if (((Track)parse).getSegments().isEmpty()) {
                                                        ((Track)parse).getSegments().add(new TrkSegment());
                                                    }
                                                    ((TrkSegment)CollectionsKt.last(((Track)parse).getSegments())).getPoints().add(wptPt);
                                                    parserState.add((Object)wptPt);
                                                }
                                            }
                                            break block199;
                                        }
                                        if (!(gpxExtensions instanceof TrkSegment)) break block206;
                                        block74 : switch (tag) {
                                            case "name": {
                                                ((TrkSegment)parse).setName(this.readText(parser, "name"));
                                                break;
                                            }
                                            case "rpt": 
                                            case "trkpt": {
                                                WptPt wptPt = this.parseWptAttributes(parser);
                                                ((TrkSegment)parse).getPoints().add(wptPt);
                                                parserState.add((Object)wptPt);
                                                break;
                                            }
                                            case "csvattributes": {
                                                IntRange intRange;
                                                String[] stringArray;
                                                String[] value;
                                                String segmentPoints = this.readText(parser, "csvattributes");
                                                Object object2 = segmentPoints;
                                                if (object2 != null && (object2 = StringsKt.split$default((CharSequence)((CharSequence)object2), (String[])(value = new String[]{"\n"}), (boolean)false, (int)0, (int)6, null)) != null) {
                                                    Collection $this$toTypedArray$iv = (Collection)object2;
                                                    boolean $i$f$toTypedArray = false;
                                                    Collection thisCollection$iv = $this$toTypedArray$iv;
                                                    stringArray = thisCollection$iv.toArray(new String[0]);
                                                } else {
                                                    stringArray = null;
                                                }
                                                String[] pointsArr = stringArray;
                                                Intrinsics.checkNotNull((Object)(pointsArr != null ? ArraysKt.getIndices(pointsArr) : null));
                                                intRange = intRange;
                                                int i = intRange.getFirst();
                                                int n = intRange.getLast();
                                                if (i > n) break;
                                                while (true) {
                                                    String[] e = new String[]{","};
                                                    Collection $this$toTypedArray$iv = StringsKt.split$default((CharSequence)((CharSequence)pointsArr[i]), (String[])e, (boolean)false, (int)0, (int)6, null);
                                                    boolean $i$f$toTypedArray = false;
                                                    Collection thisCollection$iv = $this$toTypedArray$iv;
                                                    String[] pointAttrs = thisCollection$iv.toArray(new String[0]);
                                                    try {
                                                        if (pointAttrs.length > 1) {
                                                            WptPt wptPt = new WptPt();
                                                            wptPt.setLon(Double.parseDouble(pointAttrs[0]));
                                                            wptPt.setLat(Double.parseDouble(pointAttrs[1]));
                                                            ((TrkSegment)parse).getPoints().add(wptPt);
                                                            if (pointAttrs.length > 2) {
                                                                wptPt.setEle(Double.parseDouble(pointAttrs[2]));
                                                            }
                                                        }
                                                    }
                                                    catch (NumberFormatException numberFormatException) {
                                                        // empty catch block
                                                    }
                                                    if (i == n) break block74;
                                                    ++i;
                                                }
                                            }
                                        }
                                        break block199;
                                    }
                                    if (gpxExtensions instanceof WptPt) {
                                        switch (tag) {
                                            case "name": {
                                                ((WptPt)parse).setName(this.readText(parser, "name"));
                                                break;
                                            }
                                            case "desc": {
                                                ((WptPt)parse).setDesc(this.readText(parser, "desc"));
                                                break;
                                            }
                                            case "cmt": {
                                                ((WptPt)parse).setComment(this.readText(parser, "cmt"));
                                                break;
                                            }
                                            case "speed": {
                                                try {
                                                    String value = this.readText(parser, POINT_SPEED);
                                                    CharSequence pointsArr = value;
                                                    if (pointsArr == null || pointsArr.length() == 0) break;
                                                    ((WptPt)parse).setSpeed(Double.parseDouble(value));
                                                    ((WptPt)parse).getExtensionsToWrite().put(POINT_SPEED, value);
                                                }
                                                catch (NumberFormatException value) {}
                                                break;
                                            }
                                            case "link": {
                                                Link link = new Link(parser.getAttributeValue("", "href"));
                                                ((WptPt)parse).setLink(link);
                                                parserState.add((Object)link);
                                                break;
                                            }
                                            case "category": {
                                                ((WptPt)parse).setCategory(this.readText(parser, "category"));
                                                break;
                                            }
                                            case "type": {
                                                if (((WptPt)parse).getCategory() != null) break;
                                                ((WptPt)parse).setCategory(this.readText(parser, "type"));
                                                break;
                                            }
                                            case "ele": {
                                                String text = this.readText(parser, POINT_ELEVATION);
                                                if (text == null) break;
                                                try {
                                                    ((WptPt)parse).setEle(Double.parseDouble(text));
                                                }
                                                catch (NumberFormatException pointsArr) {}
                                                break;
                                            }
                                            case "hdop": {
                                                String text = this.readText(parser, "hdop");
                                                if (text == null) break;
                                                try {
                                                    ((WptPt)parse).setHdop(Double.parseDouble(text));
                                                }
                                                catch (NumberFormatException pointsArr) {}
                                                break;
                                            }
                                            case "time": {
                                                String text = this.readText(parser, "time");
                                                WptPt wptPt = (WptPt)parse;
                                                String string = text;
                                                Intrinsics.checkNotNull((Object)string);
                                                wptPt.setTime(this.parseTime(string));
                                                break;
                                            }
                                        }
                                    }
                                }
                                object = Unit.INSTANCE;
                                continue;
                            }
                            if (tok != 3) continue;
                            GpxExtensions parse2 = (GpxExtensions)parserState.lastOrNull();
                            String string = parser.getName();
                            if (string == null) {
                                string = "";
                            }
                            String tag = string;
                            Integer n = (Integer)insideTagDepth.get(tag);
                            if (n != null) {
                                it2 = ((Number)n).intValue();
                                boolean bl = false;
                                insideTagDepth.put(tag, it2 - 1);
                                v14 = Unit.INSTANCE;
                            } else {
                                v14 = null;
                            }
                            if (StringsKt.equals((String)tag, (String)"routepointextension", (boolean)true)) {
                                routePointExtension = false;
                            }
                            if (parse2 != null && Intrinsics.areEqual((Object)tag, (Object)"extensions")) {
                                extensionReadMode = false;
                            }
                            if (extensionReadMode && Intrinsics.areEqual((Object)tag, (Object)"route")) {
                                routeExtension = false;
                                continue;
                            }
                            if (extensionReadMode && Intrinsics.areEqual((Object)tag, (Object)"types")) {
                                typesExtension = false;
                                continue;
                            }
                            if (extensionReadMode && Intrinsics.areEqual((Object)tag, (Object)"network_route")) {
                                networkRoute = false;
                                continue;
                            }
                            switch (tag) {
                                case "metadata": {
                                    Object object3 = parserState.removeLast();
                                    Intrinsics.checkNotNull((Object)object3, (String)"null cannot be cast to non-null type net.osmand.shared.gpx.primitives.Metadata");
                                    GpxExtensions pop = (Metadata)object3;
                                    ((Metadata)pop).readDescription();
                                    break;
                                }
                                case "author": {
                                    if (!(parse2 instanceof Author)) break;
                                    parserState.removeLast();
                                    break;
                                }
                                case "copyright": {
                                    if (!(parse2 instanceof Copyright)) break;
                                    parserState.removeLast();
                                    break;
                                }
                                case "link": {
                                    if (!(parse2 instanceof Link)) break;
                                    parserState.removeLast();
                                    break;
                                }
                                case "bounds": {
                                    if (!(parse2 instanceof Bounds)) break;
                                    parserState.removeLast();
                                    break;
                                }
                                case "trkpt": {
                                    GpxExtensions pop = (GpxExtensions)parserState.removeLast();
                                    break;
                                }
                                case "wpt": {
                                    GpxExtensions pop = (GpxExtensions)parserState.removeLast();
                                    break;
                                }
                                case "rtept": {
                                    GpxExtensions pop = (GpxExtensions)parserState.removeLast();
                                    break;
                                }
                                case "trk": {
                                    GpxExtensions pop = (GpxExtensions)parserState.removeLast();
                                    break;
                                }
                                case "rte": {
                                    GpxExtensions pop = (GpxExtensions)parserState.removeLast();
                                    break;
                                }
                                case "trkseg": {
                                    GpxExtensions pop = (GpxExtensions)parserState.removeLast();
                                    if (!(pop instanceof TrkSegment)) break;
                                    ((TrkSegment)pop).setRouteSegments(routeSegments);
                                    ((TrkSegment)pop).setRouteTypes(routeTypes);
                                    routeSegments = new ArrayList();
                                    routeTypes = new ArrayList();
                                    if (firstSegment != null) break;
                                    firstSegment = (TrkSegment)pop;
                                    break;
                                }
                                case "rpt": {
                                    GpxExtensions gpxExtensions = (GpxExtensions)parserState.removeLast();
                                    break;
                                }
                            }
                            continue;
                        }
                        if (!((Collection)routeTrackSegment.getPoints()).isEmpty()) {
                            gpxFile.getTracks().add(routeTrack);
                        }
                        if (!((Collection)routeSegments).isEmpty() && !((Collection)routeTypes).isEmpty() && firstSegment != null) {
                            firstSegment.setRouteSegments(routeSegments);
                            firstSegment.setRouteTypes(routeTypes);
                        }
                        if (!((Collection)pointsGroups).isEmpty() || !gpxFile.isPointsEmpty()) {
                            gpxFile.getPointsGroups().putAll(this.mergePointsGroups(pointsGroups, gpxFile.getPointsList()));
                        }
                        if (addGeneralTrack) {
                            gpxFile.addGeneralTrack();
                        }
                        if (gpxFile.getMetadata().getTime() == 0L) {
                            gpxFile.getMetadata().setTime(this.getCreationTime(gpxFile));
                        }
                        parser.close();
                        return gpxFile;
                    }
                    while (it2.hasNext()) {
                        Map.Entry bl2 = it2.next();
                        String t = (String)bl2.getKey();
                        String value = (String)bl2.getValue();
                        String string = t.toLowerCase(Locale.ROOT);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
                        String supportedTag = this.getExtensionsSupportedTag(string);
                        parse.getExtensionsToWrite().put(supportedTag, value);
                        if (!(parse instanceof WptPt)) continue;
                        String string2 = t;
                        if (Intrinsics.areEqual((Object)string2, (Object)POINT_SPEED)) {
                            try {
                                ((WptPt)parse).setSpeed(Double.parseDouble(value));
                            }
                            catch (NumberFormatException e) {
                                System.out.println((Object)e.getMessage());
                            }
                            continue;
                        }
                        if (!Intrinsics.areEqual((Object)string2, (Object)POINT_BEARING)) continue;
                        try {
                            ((WptPt)parse).setBearing(Float.parseFloat(value));
                        }
                        catch (NumberFormatException e) {}
                    }
                }
                object = Unit.INSTANCE;
            }
        }
        catch (Exception e) {
            Unit unit;
            XmlPullParser xmlPullParser;
            try {
                gpxFile.setError(new KException(e.getMessage(), e));
                xmlPullParser = parser;
            }
            catch (Throwable throwable) {
                Unit unit2;
                XmlPullParser xmlPullParser2 = parser;
                if (xmlPullParser2 != null) {
                    xmlPullParser2.close();
                    unit2 = Unit.INSTANCE;
                    throw throwable;
                }
                unit2 = null;
                throw throwable;
            }
            if (xmlPullParser != null) {
                xmlPullParser.close();
                unit = Unit.INSTANCE;
                return gpxFile;
            }
            unit = null;
            return gpxFile;
        }
    }

    private final String getExtensionsSupportedTag(String tag) {
        String supportedTag = SUPPORTED_EXTENSION_TAGS.get(tag);
        String string = supportedTag;
        if (string == null) {
            string = StringsKt.replace$default((String)tag, (String)"_-_", (String)":", (boolean)false, (int)4, null);
        }
        return string;
    }

    private final Map<String, String> parseRouteKeyAttributes(XmlPullParser parser) {
        Map networkRouteKeyTags = new LinkedHashMap();
        StringBundleXmlReader reader2 = new StringBundleXmlReader(parser);
        reader2.readBundle();
        StringBundle bundle = reader2.getBundle();
        if (!bundle.isEmpty()) {
            for (StringBundle.Item<?> item : bundle.getMap().values()) {
                if (item.getType() != StringBundle.ItemType.STRING) continue;
                String attributeFromXml = StringsKt.replace$default((String)item.getName(), (String)"_-_", (String)":", (boolean)false, (int)4, null);
                Map map = networkRouteKeyTags;
                Object obj = item.getValue();
                Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type kotlin.String");
                String string = (String)obj;
                map.put(attributeFromXml, string);
            }
        }
        return networkRouteKeyTags;
    }

    private final Map<String, PointsGroup> mergePointsGroups(List<PointsGroup> groups, List<WptPt> points) {
        Map pointsGroups = new LinkedHashMap();
        for (PointsGroup category : groups) {
            pointsGroups.put(category.getName(), category);
        }
        for (WptPt point : points) {
            String categoryName;
            PointsGroup pointsGroup;
            String string = point.getCategory();
            if (string == null) {
                string = "";
            }
            if ((pointsGroup = (PointsGroup)pointsGroups.get(categoryName = string)) == null) {
                pointsGroup = new PointsGroup(point);
                pointsGroups.put(categoryName, pointsGroup);
            }
            int color = point.getColor();
            if (pointsGroup.getColor() == 0 && color != 0) {
                pointsGroup.setColor(color);
            } else if (pointsGroup.getColor() != 0 && color == 0) {
                point.setColor(pointsGroup.getColor());
            }
            String iconName = point.getIconName();
            if (KAlgorithms.INSTANCE.isEmpty(pointsGroup.getIconName()) && !KAlgorithms.INSTANCE.isEmpty(iconName)) {
                pointsGroup.setIconName(iconName);
            } else if (!KAlgorithms.INSTANCE.isEmpty(pointsGroup.getIconName()) && KAlgorithms.INSTANCE.isEmpty(iconName)) {
                point.setIconName(pointsGroup.getIconName());
            }
            String backgroundType = point.getBackgroundType();
            if (KAlgorithms.INSTANCE.isEmpty(pointsGroup.getBackgroundType()) && !KAlgorithms.INSTANCE.isEmpty(backgroundType)) {
                pointsGroup.setBackgroundType(backgroundType);
            } else if (!KAlgorithms.INSTANCE.isEmpty(pointsGroup.getBackgroundType()) && KAlgorithms.INSTANCE.isEmpty(backgroundType)) {
                point.setBackgroundType(pointsGroup.getBackgroundType());
            }
            pointsGroup.getPoints().add(point);
        }
        return pointsGroups;
    }

    private final WptPt parseWptAttributes(XmlPullParser parser) {
        WptPt wpt = new WptPt();
        try {
            String latStr = parser.getAttributeValue("", "lat");
            String lonStr = parser.getAttributeValue("", "lon");
            CharSequence charSequence = latStr;
            if (!(charSequence == null || charSequence.length() == 0) && !((charSequence = (CharSequence)lonStr) == null || charSequence.length() == 0)) {
                wpt.setLat(Double.parseDouble(latStr));
                wpt.setLon(Double.parseDouble(lonStr));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return wpt;
    }

    private final RouteSegment parseRouteSegmentAttributes(XmlPullParser parser) {
        RouteSegment segment = new RouteSegment();
        segment.setId(parser.getAttributeValue("", "id"));
        segment.setLength(parser.getAttributeValue("", "length"));
        segment.setStartTrackPointIndex(parser.getAttributeValue("", "startTrkptIdx"));
        segment.setSegmentTime(parser.getAttributeValue("", "segmentTime"));
        segment.setSpeed(parser.getAttributeValue("", POINT_SPEED));
        segment.setTurnType(parser.getAttributeValue("", "turnType"));
        segment.setTurnLanes(parser.getAttributeValue("", "turnLanes"));
        segment.setTurnAngle(parser.getAttributeValue("", "turnAngle"));
        segment.setSkipTurn(parser.getAttributeValue("", "skipTurn"));
        segment.setTypes(parser.getAttributeValue("", "types"));
        segment.setPointTypes(parser.getAttributeValue("", "pointTypes"));
        segment.setNames(parser.getAttributeValue("", "names"));
        return segment;
    }

    private final RouteType parseRouteTypeAttributes(XmlPullParser parser) {
        RouteType type = new RouteType();
        type.setTag(parser.getAttributeValue("", "t"));
        type.setValue(parser.getAttributeValue("", "v"));
        return type;
    }

    private final Bounds parseBoundsAttributes(XmlPullParser parser) {
        Bounds bounds = new Bounds();
        try {
            String minlat = parser.getAttributeValue("", "minlat");
            String minlon = parser.getAttributeValue("", "minlon");
            String maxlat = parser.getAttributeValue("", "maxlat");
            String maxlon = parser.getAttributeValue("", "maxlon");
            if (minlat == null) {
                minlat = parser.getAttributeValue("", "minLat");
            }
            if (minlon == null) {
                minlon = parser.getAttributeValue("", "minLon");
            }
            if (maxlat == null) {
                maxlat = parser.getAttributeValue("", "maxLat");
            }
            if (maxlon == null) {
                maxlon = parser.getAttributeValue("", "maxLon");
            }
            if (minlat != null) {
                bounds.setMinlat(Double.parseDouble(minlat));
            }
            if (minlon != null) {
                bounds.setMinlon(Double.parseDouble(minlon));
            }
            if (maxlat != null) {
                bounds.setMaxlat(Double.parseDouble(maxlat));
            }
            if (maxlon != null) {
                bounds.setMaxlon(Double.parseDouble(maxlon));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return bounds;
    }

    public final void mergeGpxFileInto(@NotNull GpxFile to, @Nullable GpxFile from) {
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        if (from == null) {
            return;
        }
        if (from.getShowCurrentTrack()) {
            to.setShowCurrentTrack(true);
        }
        if (!from.isPointsEmpty()) {
            to.addPoints((Collection<WptPt>)from.getPointsList());
        }
        to.getTracks().addAll((Collection<Track>)from.getTracks());
        to.getRoutes().addAll((Collection<Route>)from.getRoutes());
        if (from.getError() != null) {
            to.setError(from.getError());
        }
    }

    @NotNull
    public final WptPt projectionOnPrimeMeridian(@NotNull WptPt previous, @NotNull WptPt next) {
        Intrinsics.checkNotNullParameter((Object)previous, (String)"previous");
        Intrinsics.checkNotNullParameter((Object)next, (String)"next");
        double lat = KMapUtils.INSTANCE.getProjection(0.0, 0.0, previous.getLat(), previous.getLon(), next.getLat(), next.getLon()).getLatitude();
        double lon = previous.getLon() < 0.0 ? -179.999991234 : 179.999991234;
        double projectionCoeff = KMapUtils.INSTANCE.getProjectionCoeff(0.0, 0.0, previous.getLat(), previous.getLon(), next.getLat(), next.getLon());
        long time = (long)((double)previous.getTime() + (double)(next.getTime() - previous.getTime()) * projectionCoeff);
        double ele = Double.isNaN(previous.getEle()) && Double.isNaN(next.getEle()) ? Double.NaN : previous.getEle() + (next.getEle() - previous.getEle()) * projectionCoeff;
        double speed = previous.getSpeed() + (next.getSpeed() - previous.getSpeed()) * projectionCoeff;
        return new WptPt(lat, lon, time, ele, speed, Double.NaN);
    }

    public final void interpolateEmptyElevationWpts(@NotNull List<WptPt> pts) {
        int processedPoints;
        Intrinsics.checkNotNullParameter(pts, (String)"pts");
        for (int i = 0; i < pts.size(); i += processedPoints > 0 ? processedPoints : 1) {
            int j;
            processedPoints = 0;
            if (!Double.isNaN(pts.get(i).getEle())) continue;
            int startIndex = i;
            int prevValidIndex = -1;
            int nextValidIndex = -1;
            double prevValidElevation = Double.NaN;
            double nextValidElevation = Double.NaN;
            for (j = startIndex - 1; -1 < j; --j) {
                double ele = pts.get(j).getEle();
                if (Double.isNaN(ele)) continue;
                prevValidElevation = ele;
                prevValidIndex = j;
                break;
            }
            int n = pts.size();
            for (j = startIndex + 1; j < n; ++j) {
                double ele = pts.get(j).getEle();
                if (Double.isNaN(ele)) continue;
                nextValidElevation = ele;
                nextValidIndex = j;
                break;
            }
            if (prevValidIndex == -1 && nextValidIndex == -1) {
                return;
            }
            if (prevValidIndex == -1 || nextValidIndex == -1) {
                WptPt pt;
                n = pts.size();
                for (j = startIndex; j < n && Double.isNaN((pt = pts.get(j)).getEle()); ++j) {
                    pt.setEle(startIndex == 0 ? nextValidElevation : prevValidElevation);
                    ++processedPoints;
                }
                continue;
            }
            double totalDistance = 0.0;
            double[] distanceArray = new double[nextValidIndex - prevValidIndex];
            int n2 = nextValidIndex;
            for (int j2 = prevValidIndex; j2 < n2; ++j2) {
                double distance;
                WptPt thisPt = pts.get(j2);
                WptPt nextPt = pts.get(j2 + 1);
                distanceArray[j2 - prevValidIndex] = distance = KMapUtils.INSTANCE.getDistance(thisPt.getLat(), thisPt.getLon(), nextPt.getLat(), nextPt.getLon());
                totalDistance += distance;
            }
            double deltaElevation = pts.get(nextValidIndex).getEle() - pts.get(prevValidIndex).getEle();
            for (int j3 = startIndex; totalDistance > 0.0 && j3 < nextValidIndex; ++j3) {
                double currentDistance = distanceArray[j3 - startIndex];
                double increaseElevation = deltaElevation * (currentDistance / totalDistance);
                pts.get(j3).setEle(pts.get(j3 - 1).getEle() + increaseElevation);
                ++processedPoints;
            }
        }
    }

    private static final Unit getTimeFormatter$lambda$3(DateTimeFormatBuilder.WithDateTime $this$Format) {
        Intrinsics.checkNotNullParameter((Object)$this$Format, (String)"$this$Format");
        UnicodeKt.byUnicodePattern((DateTimeFormatBuilder)((DateTimeFormatBuilder)$this$Format), (String)GPX_TIME_FORMATTER);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ void access$writeExtensionsWithPrefix(GpxUtilities $this, XmlSerializer serializer2, Map extensions, boolean addOsmandPrefix) {
        $this.writeExtensionsWithPrefix(serializer2, extensions, addOsmandPrefix);
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"heartrate", (Object)"gpxtpx:hr"), TuplesKt.to((Object)"osmand:hr", (Object)"gpxtpx:hr"), TuplesKt.to((Object)"hr", (Object)"gpxtpx:hr"), TuplesKt.to((Object)"speed_sensor", (Object)"osmand:speed_sensor"), TuplesKt.to((Object)"cad", (Object)"gpxtpx:cad"), TuplesKt.to((Object)"cadence", (Object)"gpxtpx:cad"), TuplesKt.to((Object)"temp", (Object)"gpxtpx:wtemp"), TuplesKt.to((Object)"wtemp", (Object)"gpxtpx:wtemp"), TuplesKt.to((Object)"atemp", (Object)"gpxtpx:atemp"), TuplesKt.to((Object)"activity", (Object)ACTIVITY_TYPE)};
        SUPPORTED_EXTENSION_TAGS = MapsKt.mapOf((Pair[])pairArray);
    }

    @kotlin.Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\b\n\u0002\b\u001e\b\u0086\u0081\u0002\u0018\u0000  2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001 B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014j\u0002\b\u0015j\u0002\b\u0016j\u0002\b\u0017j\u0002\b\u0018j\u0002\b\u0019j\u0002\b\u001aj\u0002\b\u001bj\u0002\b\u001cj\u0002\b\u001dj\u0002\b\u001ej\u0002\b\u001f\u00a8\u0006!"}, d2={"Lnet/osmand/shared/gpx/GpxUtilities$GpxColor;", "", "color", "", "<init>", "(Ljava/lang/String;II)V", "getColor", "()I", "BLACK", "DARKGRAY", "GRAY", "LIGHTGRAY", "WHITE", "RED", "GREEN", "DARKGREEN", "BLUE", "YELLOW", "CYAN", "MAGENTA", "AQUA", "FUCHSIA", "DARKGREY", "GREY", "LIGHTGREY", "LIME", "MAROON", "NAVY", "OLIVE", "PURPLE", "SILVER", "TEAL", "Companion", "OsmAnd-shared"})
    public static final class GpxColor
    extends Enum<GpxColor> {
        @NotNull
        public static final Companion Companion;
        private final int color;
        public static final /* enum */ GpxColor BLACK;
        public static final /* enum */ GpxColor DARKGRAY;
        public static final /* enum */ GpxColor GRAY;
        public static final /* enum */ GpxColor LIGHTGRAY;
        public static final /* enum */ GpxColor WHITE;
        public static final /* enum */ GpxColor RED;
        public static final /* enum */ GpxColor GREEN;
        public static final /* enum */ GpxColor DARKGREEN;
        public static final /* enum */ GpxColor BLUE;
        public static final /* enum */ GpxColor YELLOW;
        public static final /* enum */ GpxColor CYAN;
        public static final /* enum */ GpxColor MAGENTA;
        public static final /* enum */ GpxColor AQUA;
        public static final /* enum */ GpxColor FUCHSIA;
        public static final /* enum */ GpxColor DARKGREY;
        public static final /* enum */ GpxColor GREY;
        public static final /* enum */ GpxColor LIGHTGREY;
        public static final /* enum */ GpxColor LIME;
        public static final /* enum */ GpxColor MAROON;
        public static final /* enum */ GpxColor NAVY;
        public static final /* enum */ GpxColor OLIVE;
        public static final /* enum */ GpxColor PURPLE;
        public static final /* enum */ GpxColor SILVER;
        public static final /* enum */ GpxColor TEAL;
        private static final /* synthetic */ GpxColor[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private GpxColor(int color) {
            this.color = color;
        }

        public final int getColor() {
            return this.color;
        }

        public static GpxColor[] values() {
            return (GpxColor[])$VALUES.clone();
        }

        public static GpxColor valueOf(String value) {
            return Enum.valueOf(GpxColor.class, value);
        }

        @NotNull
        public static EnumEntries<GpxColor> getEntries() {
            return $ENTRIES;
        }

        static {
            BLACK = new GpxColor(-16777216);
            DARKGRAY = new GpxColor(-12303292);
            GRAY = new GpxColor(-7829368);
            LIGHTGRAY = new GpxColor(-3355444);
            WHITE = new GpxColor(-1);
            RED = new GpxColor(-65536);
            GREEN = new GpxColor(-16711936);
            DARKGREEN = new GpxColor(-16751616);
            BLUE = new GpxColor(-16776961);
            YELLOW = new GpxColor(-256);
            CYAN = new GpxColor(-16711681);
            MAGENTA = new GpxColor(-65281);
            AQUA = new GpxColor(-16711681);
            FUCHSIA = new GpxColor(-65281);
            DARKGREY = new GpxColor(-12303292);
            GREY = new GpxColor(-7829368);
            LIGHTGREY = new GpxColor(-3355444);
            LIME = new GpxColor(-16711936);
            MAROON = new GpxColor(-8388608);
            NAVY = new GpxColor(-16777088);
            OLIVE = new GpxColor(-8355840);
            PURPLE = new GpxColor(-8388480);
            SILVER = new GpxColor(-4144960);
            TEAL = new GpxColor(-16744320);
            $VALUES = gpxColorArray = new GpxColor[]{GpxColor.BLACK, GpxColor.DARKGRAY, GpxColor.GRAY, GpxColor.LIGHTGRAY, GpxColor.WHITE, GpxColor.RED, GpxColor.GREEN, GpxColor.DARKGREEN, GpxColor.BLUE, GpxColor.YELLOW, GpxColor.CYAN, GpxColor.MAGENTA, GpxColor.AQUA, GpxColor.FUCHSIA, GpxColor.DARKGREY, GpxColor.GREY, GpxColor.LIGHTGREY, GpxColor.LIME, GpxColor.MAROON, GpxColor.NAVY, GpxColor.OLIVE, GpxColor.PURPLE, GpxColor.SILVER, GpxColor.TEAL};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            Companion = new Companion(null);
        }

        @kotlin.Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lnet/osmand/shared/gpx/GpxUtilities$GpxColor$Companion;", "", "<init>", "()V", "getColorFromName", "Lnet/osmand/shared/gpx/GpxUtilities$GpxColor;", "name", "", "OsmAnd-shared"})
        @SourceDebugExtension(value={"SMAP\nGpxUtilities.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GpxUtilities.kt\nnet/osmand/shared/gpx/GpxUtilities$GpxColor$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,1724:1\n295#2,2:1725\n*S KotlinDebug\n*F\n+ 1 GpxUtilities.kt\nnet/osmand/shared/gpx/GpxUtilities$GpxColor$Companion\n*L\n157#1:1725,2\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            @Nullable
            public final GpxColor getColorFromName(@NotNull String name) {
                Object v0;
                block1: {
                    Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                    Iterable $this$firstOrNull$iv = (Iterable)GpxColor.getEntries();
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        GpxColor it = (GpxColor)((Object)element$iv);
                        boolean bl = false;
                        if (!StringsKt.equals((String)it.name(), (String)name, (boolean)true)) continue;
                        v0 = element$iv;
                        break block1;
                    }
                    v0 = null;
                }
                return v0;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @kotlin.Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\b\u00c0\u0006\u0001"}, d2={"Lnet/osmand/shared/gpx/GpxUtilities$GpxExtensionsReader;", "", "readExtensions", "", "res", "Lnet/osmand/shared/gpx/GpxFile;", "parser", "Lnet/osmand/shared/xml/XmlPullParser;", "OsmAnd-shared"})
    public static interface GpxExtensionsReader {
        public boolean readExtensions(@NotNull GpxFile var1, @NotNull XmlPullParser var2) throws IOException, XmlParserException;
    }

    @kotlin.Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0006\u00c0\u0006\u0001"}, d2={"Lnet/osmand/shared/gpx/GpxUtilities$GpxExtensionsWriter;", "", "writeExtensions", "", "serializer", "Lnet/osmand/shared/xml/XmlSerializer;", "OsmAnd-shared"})
    public static interface GpxExtensionsWriter {
        public void writeExtensions(@NotNull XmlSerializer var1);
    }

    @kotlin.Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010!\n\u0002\b\u0018\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 32\u00020\u0001:\u00013B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B-\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\u0004\u0010\nB5\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\u0004\u0010\rB\u0011\b\u0016\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0004\u0010\u0010J\u0006\u0010,\u001a\u00020\fJ\r\u0010-\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0002\u0010(J\b\u0010.\u001a\u00020\tH\u0016J\u0013\u0010/\u001a\u00020\f2\b\u00100\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\u0006\u00101\u001a\u000202R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0005R\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0012\"\u0004\b\u0015\u0010\u0005R\u001c\u0010\u0007\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0012\"\u0004\b\u0017\u0010\u0005R \u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\u001e\u0010&\u001a\u0004\u0018\u00010\fX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010+\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*\u00a8\u00064"}, d2={"Lnet/osmand/shared/gpx/GpxUtilities$PointsGroup;", "", "name", "", "<init>", "(Ljava/lang/String;)V", "iconName", "backgroundType", "color", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;I)V", "hidden", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;IZ)V", "point", "Lnet/osmand/shared/gpx/primitives/WptPt;", "(Lnet/osmand/shared/gpx/primitives/WptPt;)V", "getName", "()Ljava/lang/String;", "setName", "getIconName", "setIconName", "getBackgroundType", "setBackgroundType", "points", "", "getPoints", "()Ljava/util/List;", "setPoints", "(Ljava/util/List;)V", "getColor", "()I", "setColor", "(I)V", "getHidden", "()Z", "setHidden", "(Z)V", "pinned", "getPinned", "()Ljava/lang/Boolean;", "setPinned", "(Ljava/lang/Boolean;)V", "Ljava/lang/Boolean;", "isHidden", "isPinned", "hashCode", "equals", "other", "toStringBundle", "Lnet/osmand/shared/util/StringBundle;", "Companion", "OsmAnd-shared"})
    public static final class PointsGroup {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private String name;
        @Nullable
        private String iconName;
        @Nullable
        private String backgroundType;
        @NotNull
        private List<WptPt> points;
        private int color;
        private boolean hidden;
        @Nullable
        private Boolean pinned;
        @NotNull
        public static final String OBF_POINTS_GROUPS_DELIMITER = "~~~";
        @NotNull
        public static final String OBF_POINTS_GROUPS_PREFIX = "points_groups_";
        @NotNull
        public static final String OBF_POINTS_GROUPS_NAMES = "points_groups_names";
        @NotNull
        public static final String OBF_POINTS_GROUPS_ICONS = "points_groups_icons";
        @NotNull
        public static final String OBF_POINTS_GROUPS_COLORS = "points_groups_colors";
        @NotNull
        public static final String OBF_POINTS_GROUPS_BACKGROUNDS = "points_groups_backgrounds";
        @NotNull
        public static final String OBF_POINTS_GROUPS_EMPTY_NAME_STUB = ".";
        @NotNull
        public static final String OBF_POINTS_GROUPS_CATEGORY = "points_groups_category";

        public PointsGroup(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.name = name;
            this.points = new ArrayList();
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        public final void setName(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.name = string;
        }

        @Nullable
        public final String getIconName() {
            return this.iconName;
        }

        public final void setIconName(@Nullable String string) {
            this.iconName = string;
        }

        @Nullable
        public final String getBackgroundType() {
            return this.backgroundType;
        }

        public final void setBackgroundType(@Nullable String string) {
            this.backgroundType = string;
        }

        @NotNull
        public final List<WptPt> getPoints() {
            return this.points;
        }

        public final void setPoints(@NotNull List<WptPt> list) {
            Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
            this.points = list;
        }

        public final int getColor() {
            return this.color;
        }

        public final void setColor(int n) {
            this.color = n;
        }

        public final boolean getHidden() {
            return this.hidden;
        }

        public final void setHidden(boolean bl) {
            this.hidden = bl;
        }

        @Nullable
        public final Boolean getPinned() {
            return this.pinned;
        }

        public final void setPinned(@Nullable Boolean bl) {
            this.pinned = bl;
        }

        public PointsGroup(@NotNull String name, @Nullable String iconName, @Nullable String backgroundType, int color) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this(name);
            this.iconName = iconName;
            this.backgroundType = backgroundType;
            this.color = color;
        }

        public PointsGroup(@NotNull String name, @Nullable String iconName, @Nullable String backgroundType, int color, boolean hidden) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this(name);
            this.iconName = iconName;
            this.backgroundType = backgroundType;
            this.color = color;
            this.hidden = hidden;
        }

        public PointsGroup(@NotNull WptPt point) {
            Intrinsics.checkNotNullParameter((Object)point, (String)"point");
            String string = point.getCategory();
            if (string == null) {
                string = "";
            }
            this(string);
            this.color = point.getColor();
            this.iconName = point.getIconName();
            this.backgroundType = point.getBackgroundType();
            this.hidden = point.isHidden();
        }

        public final boolean isHidden() {
            return this.hidden;
        }

        @Nullable
        public final Boolean isPinned() {
            return this.pinned;
        }

        public int hashCode() {
            Object[] objectArray = new Object[]{this.name, this.iconName, this.backgroundType, this.color, this.points, this.hidden, this.pinned};
            return KAlgorithms.INSTANCE.hash(objectArray);
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || !(other instanceof PointsGroup)) {
                return false;
            }
            return this.color == ((PointsGroup)other).color && this.hidden == ((PointsGroup)other).hidden && Intrinsics.areEqual((Object)this.pinned, (Object)((PointsGroup)other).pinned) && Intrinsics.areEqual((Object)this.name, (Object)((PointsGroup)other).name) && Intrinsics.areEqual((Object)this.iconName, (Object)((PointsGroup)other).iconName) && Intrinsics.areEqual((Object)this.backgroundType, (Object)((PointsGroup)other).backgroundType) && Intrinsics.areEqual(this.points, ((PointsGroup)other).points);
        }

        @NotNull
        public final StringBundle toStringBundle() {
            StringBundle bundle = new StringBundle();
            bundle.putString("name", this.name);
            if (this.color != 0) {
                bundle.putString(GpxUtilities.COLOR_NAME_EXTENSION, KAlgorithms.INSTANCE.colorToString(this.color));
            }
            if (!KAlgorithms.INSTANCE.isEmpty(this.iconName)) {
                bundle.putString(GpxUtilities.ICON_NAME_EXTENSION, this.iconName);
            }
            if (!KAlgorithms.INSTANCE.isEmpty(this.backgroundType)) {
                bundle.putString(GpxUtilities.BACKGROUND_TYPE_EXTENSION, this.backgroundType);
            }
            if (this.isHidden()) {
                bundle.putBoolean(GpxUtilities.HIDDEN_EXTENSION, true);
            }
            if (this.pinned != null) {
                bundle.putBoolean(GpxUtilities.PINNED_EXTENSION, Intrinsics.areEqual((Object)this.isPinned(), (Object)true));
            }
            return bundle;
        }

        @kotlin.Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lnet/osmand/shared/gpx/GpxUtilities$PointsGroup$Companion;", "", "<init>", "()V", "OBF_POINTS_GROUPS_DELIMITER", "", "OBF_POINTS_GROUPS_PREFIX", "OBF_POINTS_GROUPS_NAMES", "OBF_POINTS_GROUPS_ICONS", "OBF_POINTS_GROUPS_COLORS", "OBF_POINTS_GROUPS_BACKGROUNDS", "OBF_POINTS_GROUPS_EMPTY_NAME_STUB", "OBF_POINTS_GROUPS_CATEGORY", "parsePointsGroupAttributes", "Lnet/osmand/shared/gpx/GpxUtilities$PointsGroup;", "parser", "Lnet/osmand/shared/xml/XmlPullParser;", "OsmAnd-shared"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final PointsGroup parsePointsGroupAttributes(@NotNull XmlPullParser parser) {
                Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
                String name = parser.getAttributeValue("", "name");
                String string = name;
                if (string == null) {
                    string = "";
                }
                PointsGroup category = new PointsGroup(string);
                Integer n = INSTANCE.parseColor(parser.getAttributeValue("", GpxUtilities.COLOR_NAME_EXTENSION), 0);
                Intrinsics.checkNotNull((Object)n);
                category.setColor(n);
                category.setIconName(parser.getAttributeValue("", GpxUtilities.ICON_NAME_EXTENSION));
                category.setBackgroundType(parser.getAttributeValue("", GpxUtilities.BACKGROUND_TYPE_EXTENSION));
                category.setHidden(Boolean.parseBoolean(parser.getAttributeValue("", GpxUtilities.HIDDEN_EXTENSION)));
                String string2 = parser.getAttributeValue("", GpxUtilities.PINNED_EXTENSION);
                category.setPinned(string2 != null ? Boolean.valueOf(Boolean.parseBoolean(string2)) : null);
                return category;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @kotlin.Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b&\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 -2\u00020\u0001:\u0001-B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010+\u001a\u00020,R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001c\u0010\n\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0004\b\f\u0010\tR\u001c\u0010\r\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u0007\"\u0004\b\u000f\u0010\tR\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0007\"\u0004\b\u0012\u0010\tR\u001c\u0010\u0013\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0007\"\u0004\b\u0015\u0010\tR\u001c\u0010\u0016\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0007\"\u0004\b\u0018\u0010\tR\u001c\u0010\u0019\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u0007\"\u0004\b\u001b\u0010\tR\u001c\u0010\u001c\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u0007\"\u0004\b\u001e\u0010\tR\u001c\u0010\u001f\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\u0007\"\u0004\b!\u0010\tR\u001c\u0010\"\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u0007\"\u0004\b$\u0010\tR\u001c\u0010%\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010\u0007\"\u0004\b'\u0010\tR\u001c\u0010(\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010\u0007\"\u0004\b*\u0010\t\u00a8\u0006."}, d2={"Lnet/osmand/shared/gpx/GpxUtilities$RouteSegment;", "", "<init>", "()V", "id", "", "getId", "()Ljava/lang/String;", "setId", "(Ljava/lang/String;)V", "length", "getLength", "setLength", "startTrackPointIndex", "getStartTrackPointIndex", "setStartTrackPointIndex", "segmentTime", "getSegmentTime", "setSegmentTime", "speed", "getSpeed", "setSpeed", "turnType", "getTurnType", "setTurnType", "turnLanes", "getTurnLanes", "setTurnLanes", "turnAngle", "getTurnAngle", "setTurnAngle", "skipTurn", "getSkipTurn", "setSkipTurn", "types", "getTypes", "setTypes", "pointTypes", "getPointTypes", "setPointTypes", "names", "getNames", "setNames", "toStringBundle", "Lnet/osmand/shared/util/StringBundle;", "Companion", "OsmAnd-shared"})
    public static final class RouteSegment {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @Nullable
        private String id;
        @Nullable
        private String length;
        @Nullable
        private String startTrackPointIndex;
        @Nullable
        private String segmentTime;
        @Nullable
        private String speed;
        @Nullable
        private String turnType;
        @Nullable
        private String turnLanes;
        @Nullable
        private String turnAngle;
        @Nullable
        private String skipTurn;
        @Nullable
        private String types;
        @Nullable
        private String pointTypes;
        @Nullable
        private String names;
        @NotNull
        public static final String START_TRKPT_IDX_ATTR = "startTrkptIdx";

        @Nullable
        public final String getId() {
            return this.id;
        }

        public final void setId(@Nullable String string) {
            this.id = string;
        }

        @Nullable
        public final String getLength() {
            return this.length;
        }

        public final void setLength(@Nullable String string) {
            this.length = string;
        }

        @Nullable
        public final String getStartTrackPointIndex() {
            return this.startTrackPointIndex;
        }

        public final void setStartTrackPointIndex(@Nullable String string) {
            this.startTrackPointIndex = string;
        }

        @Nullable
        public final String getSegmentTime() {
            return this.segmentTime;
        }

        public final void setSegmentTime(@Nullable String string) {
            this.segmentTime = string;
        }

        @Nullable
        public final String getSpeed() {
            return this.speed;
        }

        public final void setSpeed(@Nullable String string) {
            this.speed = string;
        }

        @Nullable
        public final String getTurnType() {
            return this.turnType;
        }

        public final void setTurnType(@Nullable String string) {
            this.turnType = string;
        }

        @Nullable
        public final String getTurnLanes() {
            return this.turnLanes;
        }

        public final void setTurnLanes(@Nullable String string) {
            this.turnLanes = string;
        }

        @Nullable
        public final String getTurnAngle() {
            return this.turnAngle;
        }

        public final void setTurnAngle(@Nullable String string) {
            this.turnAngle = string;
        }

        @Nullable
        public final String getSkipTurn() {
            return this.skipTurn;
        }

        public final void setSkipTurn(@Nullable String string) {
            this.skipTurn = string;
        }

        @Nullable
        public final String getTypes() {
            return this.types;
        }

        public final void setTypes(@Nullable String string) {
            this.types = string;
        }

        @Nullable
        public final String getPointTypes() {
            return this.pointTypes;
        }

        public final void setPointTypes(@Nullable String string) {
            this.pointTypes = string;
        }

        @Nullable
        public final String getNames() {
            return this.names;
        }

        public final void setNames(@Nullable String string) {
            this.names = string;
        }

        @NotNull
        public final StringBundle toStringBundle() {
            StringBundle bundle = new StringBundle();
            bundle.putString("id", this.id);
            bundle.putString("length", this.length);
            bundle.putString(START_TRKPT_IDX_ATTR, this.startTrackPointIndex);
            bundle.putString("segmentTime", this.segmentTime);
            bundle.putString(GpxUtilities.POINT_SPEED, this.speed);
            bundle.putString("turnType", this.turnType);
            bundle.putString("turnLanes", this.turnLanes);
            bundle.putString("turnAngle", this.turnAngle);
            bundle.putString("skipTurn", this.skipTurn);
            bundle.putString("types", this.types);
            bundle.putString("pointTypes", this.pointTypes);
            bundle.putString("names", this.names);
            return bundle;
        }

        @kotlin.Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lnet/osmand/shared/gpx/GpxUtilities$RouteSegment$Companion;", "", "<init>", "()V", "START_TRKPT_IDX_ATTR", "", "fromStringBundle", "Lnet/osmand/shared/gpx/GpxUtilities$RouteSegment;", "bundle", "Lnet/osmand/shared/util/StringBundle;", "OsmAnd-shared"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final RouteSegment fromStringBundle(@NotNull StringBundle bundle) {
                Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
                RouteSegment s = new RouteSegment();
                s.setId(bundle.getString("id", null));
                s.setLength(bundle.getString("length", null));
                s.setStartTrackPointIndex(bundle.getString(RouteSegment.START_TRKPT_IDX_ATTR, null));
                s.setSegmentTime(bundle.getString("segmentTime", null));
                s.setSpeed(bundle.getString(GpxUtilities.POINT_SPEED, null));
                s.setTurnType(bundle.getString("turnType", null));
                s.setTurnLanes(bundle.getString("turnLanes", null));
                s.setTurnAngle(bundle.getString("turnAngle", null));
                s.setSkipTurn(bundle.getString("skipTurn", null));
                s.setTypes(bundle.getString("types", null));
                s.setPointTypes(bundle.getString("pointTypes", null));
                s.setNames(bundle.getString("names", null));
                return s;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @kotlin.Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\r\u001a\u00020\u000eR\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001c\u0010\n\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0004\b\f\u0010\t\u00a8\u0006\u0010"}, d2={"Lnet/osmand/shared/gpx/GpxUtilities$RouteType;", "", "<init>", "()V", "tag", "", "getTag", "()Ljava/lang/String;", "setTag", "(Ljava/lang/String;)V", "value", "getValue", "setValue", "toStringBundle", "Lnet/osmand/shared/util/StringBundle;", "Companion", "OsmAnd-shared"})
    public static final class RouteType {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @Nullable
        private String tag;
        @Nullable
        private String value;

        @Nullable
        public final String getTag() {
            return this.tag;
        }

        public final void setTag(@Nullable String string) {
            this.tag = string;
        }

        @Nullable
        public final String getValue() {
            return this.value;
        }

        public final void setValue(@Nullable String string) {
            this.value = string;
        }

        @NotNull
        public final StringBundle toStringBundle() {
            StringBundle bundle = new StringBundle();
            bundle.putString("t", this.tag);
            bundle.putString("v", this.value);
            return bundle;
        }

        @kotlin.Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lnet/osmand/shared/gpx/GpxUtilities$RouteType$Companion;", "", "<init>", "()V", "fromStringBundle", "Lnet/osmand/shared/gpx/GpxUtilities$RouteType;", "bundle", "Lnet/osmand/shared/util/StringBundle;", "OsmAnd-shared"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final RouteType fromStringBundle(@NotNull StringBundle bundle) {
                Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
                RouteType t = new RouteType();
                t.setTag(bundle.getString("t", null));
                t.setValue(bundle.getString("v", null));
                return t;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @kotlin.Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u0000 \u00042\u00020\u0001:\u0001\u0004B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Lnet/osmand/shared/gpx/GpxUtilities$TimePatterns;", "", "<init>", "()V", "Companion", "OsmAnd-shared"})
    public static final class TimePatterns {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private static final List<DateTimeFormat<DateTimeComponents>> formats = new ArrayList();

        private static final Unit _init_$lambda$0(String $pattern, DateTimeFormatBuilder.WithDateTimeComponents $this$Format) {
            Intrinsics.checkNotNullParameter((Object)$pattern, (String)"$pattern");
            Intrinsics.checkNotNullParameter((Object)$this$Format, (String)"$this$Format");
            UnicodeKt.byUnicodePattern((DateTimeFormatBuilder)((DateTimeFormatBuilder)$this$Format), (String)$pattern);
            return Unit.INSTANCE;
        }

        static {
            String[] stringArray = new String[]{"yyyy-MM-dd'T'HH:mm:ssXXXXX", "yyyy-MM-dd'T'HH:mm:ss", "yyyy-MM-dd'T'HH:mmXXXXX", "yyyy-MM-dd'T'HH:mm", "yyyy-MM-dd'T'HH:mm:ssXXXXX'Z'", "yyyy-MM-dd'T'HH:mm:ssXXXX"};
            List patterns = CollectionsKt.listOf((Object[])stringArray);
            for (String pattern : patterns) {
                formats.add((DateTimeFormat<DateTimeComponents>)DateTimeComponents.Companion.Format(arg_0 -> TimePatterns._init_$lambda$0(pattern, arg_0)));
            }
        }

        @kotlin.Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001d\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lnet/osmand/shared/gpx/GpxUtilities$TimePatterns$Companion;", "", "<init>", "()V", "formats", "", "Lkotlinx/datetime/format/DateTimeFormat;", "Lkotlinx/datetime/format/DateTimeComponents;", "getFormats", "()Ljava/util/List;", "OsmAnd-shared"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final List<DateTimeFormat<DateTimeComponents>> getFormats() {
                return formats;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

