/*
 * Decompiled with CFR 0.152.
 */
package io.github.cosinekitty.astronomy;

import io.github.cosinekitty.astronomy.Astronomy;
import io.github.cosinekitty.astronomy.BodyState;
import io.github.cosinekitty.astronomy.Time;
import io.github.cosinekitty.astronomy.Vector;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u001b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fB!\b\u0016\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u000e\u0012\u0006\u0010\u0010\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\u0011B\u0019\b\u0010\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0010\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\u0014J\u0006\u0010\u001e\u001a\u00020\u000eJ\u0006\u0010\u001f\u001a\u00020\u000eJ\u0011\u0010 \u001a\u00020\u00002\u0006\u0010!\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010\"\u001a\u00020\u00002\u0006\u0010!\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010#\u001a\u00020\u00002\u0006\u0010$\u001a\u00020\u0003H\u0086\u0002J\t\u0010%\u001a\u00020\u0000H\u0086\u0002J\t\u0010&\u001a\u00020\u0003H\u00c6\u0003J\t\u0010'\u001a\u00020\u0003H\u00c6\u0003J\t\u0010(\u001a\u00020\u0003H\u00c6\u0003J\t\u0010)\u001a\u00020\u0003H\u00c6\u0003J\t\u0010*\u001a\u00020\u0003H\u00c6\u0003J\t\u0010+\u001a\u00020\u0003H\u00c6\u0003J\t\u0010,\u001a\u00020\nH\u00c6\u0003JO\u0010-\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\u00032\b\b\u0002\u0010\b\u001a\u00020\u00032\b\b\u0002\u0010\t\u001a\u00020\nH\u00c6\u0001J\u0013\u0010.\u001a\u00020/2\b\u0010!\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u00100\u001a\u000201H\u00d6\u0001J\t\u00102\u001a\u000203H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0016R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0016R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0016R\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0016R\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0016R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001d\u00a8\u00064"}, d2={"Lio/github/cosinekitty/astronomy/StateVector;", "", "x", "", "y", "z", "vx", "vy", "vz", "t", "Lio/github/cosinekitty/astronomy/Time;", "<init>", "(DDDDDDLio/github/cosinekitty/astronomy/Time;)V", "pos", "Lio/github/cosinekitty/astronomy/Vector;", "vel", "time", "(Lio/github/cosinekitty/astronomy/Vector;Lio/github/cosinekitty/astronomy/Vector;Lio/github/cosinekitty/astronomy/Time;)V", "state", "Lio/github/cosinekitty/astronomy/BodyState;", "(Lio/github/cosinekitty/astronomy/BodyState;Lio/github/cosinekitty/astronomy/Time;)V", "getX", "()D", "getY", "getZ", "getVx", "getVy", "getVz", "getT", "()Lio/github/cosinekitty/astronomy/Time;", "position", "velocity", "plus", "other", "minus", "div", "denom", "unaryMinus", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "equals", "", "hashCode", "", "toString", "", "OsmAnd-shared"})
public final class StateVector {
    private final double x;
    private final double y;
    private final double z;
    private final double vx;
    private final double vy;
    private final double vz;
    @NotNull
    private final Time t;

    public StateVector(double x, double y, double z, double vx, double vy, double vz, @NotNull Time t) {
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        this.x = x;
        this.y = y;
        this.z = z;
        this.vx = vx;
        this.vy = vy;
        this.vz = vz;
        this.t = t;
    }

    public final double getX() {
        return this.x;
    }

    public final double getY() {
        return this.y;
    }

    public final double getZ() {
        return this.z;
    }

    public final double getVx() {
        return this.vx;
    }

    public final double getVy() {
        return this.vy;
    }

    public final double getVz() {
        return this.vz;
    }

    @NotNull
    public final Time getT() {
        return this.t;
    }

    public StateVector(@NotNull Vector pos, @NotNull Vector vel, @NotNull Time time) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)vel, (String)"vel");
        Intrinsics.checkNotNullParameter((Object)time, (String)"time");
        this(pos.getX(), pos.getY(), pos.getZ(), vel.getX(), vel.getY(), vel.getZ(), time);
    }

    public StateVector(@NotNull BodyState state, @NotNull Time time) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)time, (String)"time");
        this(state.getR().getX(), state.getR().getY(), state.getR().getZ(), state.getV().getX(), state.getV().getY(), state.getV().getZ(), time);
    }

    @NotNull
    public final Vector position() {
        return new Vector(this.x, this.y, this.z, this.t);
    }

    @NotNull
    public final Vector velocity() {
        return new Vector(this.vx, this.vy, this.vz, this.t);
    }

    @NotNull
    public final StateVector plus(@NotNull StateVector other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return new StateVector(this.x + other.x, this.y + other.y, this.z + other.z, this.vx + other.vx, this.vy + other.vy, this.vz + other.vz, Astronomy.verifyIdenticalTimes(this.t, other.t));
    }

    @NotNull
    public final StateVector minus(@NotNull StateVector other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return new StateVector(this.x - other.x, this.y - other.y, this.z - other.z, this.vx - other.vx, this.vy - other.vy, this.vz - other.vz, Astronomy.verifyIdenticalTimes(this.t, other.t));
    }

    @NotNull
    public final StateVector div(double denom) {
        return new StateVector(this.x / denom, this.y / denom, this.z / denom, this.vx / denom, this.vy / denom, this.vz / denom, this.t);
    }

    @NotNull
    public final StateVector unaryMinus() {
        return new StateVector(-this.x, -this.y, -this.z, -this.vx, -this.vy, -this.vz, this.t);
    }

    public final double component1() {
        return this.x;
    }

    public final double component2() {
        return this.y;
    }

    public final double component3() {
        return this.z;
    }

    public final double component4() {
        return this.vx;
    }

    public final double component5() {
        return this.vy;
    }

    public final double component6() {
        return this.vz;
    }

    @NotNull
    public final Time component7() {
        return this.t;
    }

    @NotNull
    public final StateVector copy(double x, double y, double z, double vx, double vy, double vz, @NotNull Time t) {
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        return new StateVector(x, y, z, vx, vy, vz, t);
    }

    public static /* synthetic */ StateVector copy$default(StateVector stateVector, double d, double d2, double d3, double d4, double d5, double d6, Time time, int n, Object object) {
        if ((n & 1) != 0) {
            d = stateVector.x;
        }
        if ((n & 2) != 0) {
            d2 = stateVector.y;
        }
        if ((n & 4) != 0) {
            d3 = stateVector.z;
        }
        if ((n & 8) != 0) {
            d4 = stateVector.vx;
        }
        if ((n & 0x10) != 0) {
            d5 = stateVector.vy;
        }
        if ((n & 0x20) != 0) {
            d6 = stateVector.vz;
        }
        if ((n & 0x40) != 0) {
            time = stateVector.t;
        }
        return stateVector.copy(d, d2, d3, d4, d5, d6, time);
    }

    @NotNull
    public String toString() {
        return "StateVector(x=" + this.x + ", y=" + this.y + ", z=" + this.z + ", vx=" + this.vx + ", vy=" + this.vy + ", vz=" + this.vz + ", t=" + this.t + ")";
    }

    public int hashCode() {
        int result = Double.hashCode(this.x);
        result = result * 31 + Double.hashCode(this.y);
        result = result * 31 + Double.hashCode(this.z);
        result = result * 31 + Double.hashCode(this.vx);
        result = result * 31 + Double.hashCode(this.vy);
        result = result * 31 + Double.hashCode(this.vz);
        result = result * 31 + this.t.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof StateVector)) {
            return false;
        }
        StateVector stateVector = (StateVector)other;
        if (Double.compare(this.x, stateVector.x) != 0) {
            return false;
        }
        if (Double.compare(this.y, stateVector.y) != 0) {
            return false;
        }
        if (Double.compare(this.z, stateVector.z) != 0) {
            return false;
        }
        if (Double.compare(this.vx, stateVector.vx) != 0) {
            return false;
        }
        if (Double.compare(this.vy, stateVector.vy) != 0) {
            return false;
        }
        if (Double.compare(this.vz, stateVector.vz) != 0) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.t, (Object)stateVector.t);
    }
}

