/*
 * Decompiled with CFR 0.152.
 */
package io.github.cosinekitty.astronomy;

import io.github.cosinekitty.astronomy.Aberration;
import io.github.cosinekitty.astronomy.Astronomy;
import io.github.cosinekitty.astronomy.Body;
import io.github.cosinekitty.astronomy.PositionFunction;
import io.github.cosinekitty.astronomy.Time;
import io.github.cosinekitty.astronomy.Vector;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0015"}, d2={"Lio/github/cosinekitty/astronomy/BodyPosition;", "Lio/github/cosinekitty/astronomy/PositionFunction;", "observerBody", "Lio/github/cosinekitty/astronomy/Body;", "targetBody", "aberration", "Lio/github/cosinekitty/astronomy/Aberration;", "observerPos", "Lio/github/cosinekitty/astronomy/Vector;", "<init>", "(Lio/github/cosinekitty/astronomy/Body;Lio/github/cosinekitty/astronomy/Body;Lio/github/cosinekitty/astronomy/Aberration;Lio/github/cosinekitty/astronomy/Vector;)V", "getObserverBody", "()Lio/github/cosinekitty/astronomy/Body;", "getTargetBody", "getAberration", "()Lio/github/cosinekitty/astronomy/Aberration;", "getObserverPos", "()Lio/github/cosinekitty/astronomy/Vector;", "position", "time", "Lio/github/cosinekitty/astronomy/Time;", "OsmAnd-shared"})
public final class BodyPosition
implements PositionFunction {
    @NotNull
    private final Body observerBody;
    @NotNull
    private final Body targetBody;
    @NotNull
    private final Aberration aberration;
    @NotNull
    private final Vector observerPos;

    public BodyPosition(@NotNull Body observerBody, @NotNull Body targetBody, @NotNull Aberration aberration, @NotNull Vector observerPos) {
        Intrinsics.checkNotNullParameter((Object)((Object)observerBody), (String)"observerBody");
        Intrinsics.checkNotNullParameter((Object)((Object)targetBody), (String)"targetBody");
        Intrinsics.checkNotNullParameter((Object)((Object)aberration), (String)"aberration");
        Intrinsics.checkNotNullParameter((Object)observerPos, (String)"observerPos");
        this.observerBody = observerBody;
        this.targetBody = targetBody;
        this.aberration = aberration;
        this.observerPos = observerPos;
    }

    @NotNull
    public final Body getObserverBody() {
        return this.observerBody;
    }

    @NotNull
    public final Body getTargetBody() {
        return this.targetBody;
    }

    @NotNull
    public final Aberration getAberration() {
        return this.aberration;
    }

    @NotNull
    public final Vector getObserverPos() {
        return this.observerPos;
    }

    @Override
    @NotNull
    public Vector position(@NotNull Time time) {
        Intrinsics.checkNotNullParameter((Object)time, (String)"time");
        Vector opos = switch (WhenMappings.$EnumSwitchMapping$0[this.aberration.ordinal()]) {
            case 1 -> this.observerPos.withTime(time);
            case 2 -> Astronomy.helioVector(this.observerBody, time);
            default -> throw new NoWhenBranchMatchedException();
        };
        return Astronomy.helioVector(this.targetBody, time).minus(opos);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Aberration.values().length];
            try {
                nArray[Aberration.None.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Aberration.Corrected.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

