/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.listener.reference;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.xwiki.rendering.listener.reference.ResourceType;
import org.xwiki.text.XWikiToStringStyle;

public class ResourceReference
implements Cloneable {
    private boolean isTyped = true;
    private String reference;
    private List<String> baseReferences;
    private ResourceType type;
    private Map<String, String> parameters = new LinkedHashMap<String, String>();

    public ResourceReference(String reference, ResourceType type) {
        this.setReference(reference);
        this.setType(type);
    }

    public void setTyped(boolean isTyped) {
        this.isTyped = isTyped;
    }

    public boolean isTyped() {
        return this.isTyped;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public String getReference() {
        return this.reference;
    }

    public void addBaseReference(String baseReference) {
        if (this.baseReferences == null) {
            this.baseReferences = new ArrayList<String>();
        }
        this.baseReferences.add(baseReference);
    }

    public void addBaseReferences(List<String> baseReferences) {
        for (String baseReference : baseReferences) {
            this.addBaseReference(baseReference);
        }
    }

    public List<String> getBaseReferences() {
        List<String> result = this.baseReferences == null ? Collections.emptyList() : Collections.unmodifiableList(this.baseReferences);
        return result;
    }

    public ResourceType getType() {
        return this.type;
    }

    public void setType(ResourceType type) {
        this.type = type;
    }

    public void setParameter(String name, String value) {
        this.parameters.put(name, value);
    }

    public void setParameters(Map<String, String> parameters) {
        this.parameters.putAll(parameters);
    }

    public void removeParameter(String name) {
        this.parameters.remove(name);
    }

    public String getParameter(String name) {
        return this.parameters.get(name);
    }

    public Map<String, String> getParameters() {
        return Collections.unmodifiableMap(this.parameters);
    }

    public String toString() {
        Map<String, String> params;
        XWikiToStringStyle style = new XWikiToStringStyle();
        style.setSeparator("");
        ToStringBuilder builder = new ToStringBuilder((Object)this, (ToStringStyle)style);
        builder = builder.append("Typed", this.isTyped()).append("Type", (Object)this.getType().getScheme());
        if (this.getReference() != null) {
            builder = builder.append("Reference", (Object)this.getReference());
        }
        if (!this.getBaseReferences().isEmpty()) {
            builder = builder.append("Base References", this.getBaseReferences());
        }
        if (!(params = this.getParameters()).isEmpty()) {
            builder = builder.append("Parameters", params);
        }
        return builder.toString();
    }

    public ResourceReference clone() {
        ResourceReference clone;
        try {
            clone = (ResourceReference)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Failed to clone object", e);
        }
        return clone;
    }

    public int hashCode() {
        return new HashCodeBuilder(1, 9).append((Object)this.getType()).append(this.isTyped()).append((Object)this.getReference()).append(this.getBaseReferences()).append(this.getParameters()).toHashCode();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        ResourceReference rhs = (ResourceReference)object;
        return new EqualsBuilder().append((Object)this.getType(), (Object)rhs.getType()).append(this.isTyped(), rhs.isTyped()).append((Object)this.getReference(), (Object)rhs.getReference()).append(this.getBaseReferences(), rhs.getBaseReferences()).append(this.getParameters(), rhs.getParameters()).isEquals();
    }
}

