/*
 * Decompiled with CFR 0.152.
 */
package info.bliki.htmlcleaner;

import info.bliki.htmlcleaner.BaseToken;
import info.bliki.htmlcleaner.CommentToken;
import info.bliki.htmlcleaner.ContentToken;
import info.bliki.htmlcleaner.DoctypeToken;
import info.bliki.htmlcleaner.EndTagToken;
import info.bliki.htmlcleaner.HtmlCleaner;
import info.bliki.htmlcleaner.TagNode;
import info.bliki.htmlcleaner.TagToken;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class HtmlTokenizer {
    private static final int WORKING_BUFFER_SIZE = 1024;
    private BufferedReader _reader;
    private char[] _working = new char[1024];
    private transient int _pos = 0;
    private transient int _len = -1;
    private transient StringBuffer _saved = new StringBuffer(512);
    private transient boolean _isLateForDoctype = false;
    private transient TagToken _currentTagToken = null;
    private transient List<BaseToken> _tokenList = new ArrayList<BaseToken>();
    private boolean _asExpected = true;
    private boolean _isScriptContext = false;
    private boolean _isStyleContext = false;
    private HtmlCleaner cleaner;

    public HtmlTokenizer(HtmlCleaner cleaner) throws IOException {
        this._reader = new BufferedReader(cleaner.getReader());
        this.cleaner = cleaner;
    }

    private void addToken(BaseToken token) {
        this._tokenList.add(token);
        this.cleaner.makeTree(this._tokenList, this._tokenList.listIterator(this._tokenList.size() - 1));
    }

    private void readIfNeeded(int neededChars) throws IOException {
        if (this._len == -1 && this._pos + neededChars >= 1024) {
            int numToCopy = 1024 - this._pos;
            System.arraycopy(this._working, this._pos, this._working, 0, numToCopy);
            this._pos = 0;
            int size = this._reader.read(this._working, numToCopy, 1024 - numToCopy);
            if (size < 1024 - numToCopy) {
                this._len = size == -1 && numToCopy == 0 ? 0 : size + numToCopy;
            } else if (size == -1) {
                this._len = numToCopy;
            }
        }
    }

    List<BaseToken> getTokenList() {
        return this._tokenList;
    }

    private void go() throws IOException {
        ++this._pos;
        this.readIfNeeded(0);
    }

    private void go(int step) throws IOException {
        this._pos += step;
        this.readIfNeeded(step - 1);
    }

    private boolean startsWith(String value) throws IOException {
        int valueLen = value.length();
        this.readIfNeeded(valueLen);
        if (this._len >= 0 && this._pos + valueLen > this._len) {
            return false;
        }
        for (int i = 0; i < valueLen; ++i) {
            char ch2;
            char ch1 = Character.toLowerCase(value.charAt(i));
            if (ch1 == (ch2 = Character.toLowerCase(this._working[this._pos + i]))) continue;
            return false;
        }
        return true;
    }

    private boolean isWhitespace(int position) {
        if (this._len >= 0 && position >= this._len) {
            return false;
        }
        return Character.isWhitespace(this._working[position]);
    }

    private boolean isWhitespace() {
        return this.isWhitespace(this._pos);
    }

    private boolean isChar(int position, char ch) {
        if (this._len >= 0 && position >= this._len) {
            return false;
        }
        return Character.toLowerCase(ch) == Character.toLowerCase(this._working[position]);
    }

    private boolean isChar(char ch) {
        return this.isChar(this._pos, ch);
    }

    private boolean isIdentifierStartChar(int position) {
        if (this._len >= 0 && position >= this._len) {
            return false;
        }
        char ch = this._working[position];
        return Character.isUnicodeIdentifierStart(ch) || ':' == ch;
    }

    private boolean isIdentifierStartChar() {
        return this.isIdentifierStartChar(this._pos);
    }

    private boolean isIdentifierChar() {
        if (this._len >= 0 && this._pos >= this._len) {
            return false;
        }
        char ch = this._working[this._pos];
        return Character.isUnicodeIdentifierStart(ch) || Character.isDigit(ch) || ':' == ch || '.' == ch || '-' == ch;
    }

    private boolean isAllRead() {
        return this._len >= 0 && this._pos >= this._len;
    }

    private void save(char ch) {
        this._saved.append(ch);
    }

    private void saveCurrent() {
        if (!this.isAllRead()) {
            this.save(this._working[this._pos]);
        }
    }

    private void saveCurrent(int size) throws IOException {
        this.readIfNeeded(size);
        int pos = this._pos;
        while (!this.isAllRead() && size > 0) {
            this.save(this._working[pos]);
            ++pos;
            --size;
        }
    }

    private void skipWhitespaces() throws IOException {
        while (!this.isAllRead() && this.isWhitespace()) {
            this.saveCurrent();
            this.go();
        }
    }

    private void addSavedAsContent() {
        if (this._saved.length() > 0) {
            this.addToken(new ContentToken(this._saved.toString()));
            this._saved.delete(0, this._saved.length());
        }
    }

    void start() throws IOException {
        this._currentTagToken = null;
        this._tokenList.clear();
        this._asExpected = true;
        this._isScriptContext = false;
        this._isStyleContext = false;
        this._isLateForDoctype = false;
        this._pos = 1024;
        this.readIfNeeded(0);
        block0: while (!this.isAllRead()) {
            this._saved.delete(0, this._saved.length());
            this._currentTagToken = null;
            this._asExpected = true;
            this.readIfNeeded(10);
            if (this._isScriptContext) {
                if (this.startsWith("</script") && (this.isWhitespace(this._pos + 8) || this.isChar(this._pos + 8, '>'))) {
                    this.tagEnd();
                    continue;
                }
                this.content();
                continue;
            }
            if (this._isStyleContext) {
                if (this.startsWith("</style") && (this.isWhitespace(this._pos + 7) || this.isChar(this._pos + 7, '>'))) {
                    this.tagEnd();
                    continue;
                }
                this.content();
                continue;
            }
            if (this.startsWith("<!doctype")) {
                if (!this._isLateForDoctype) {
                    this.doctype();
                    this._isLateForDoctype = true;
                    continue;
                }
                this.ignore();
                continue;
            }
            if (this.startsWith("</") && this.isIdentifierStartChar(this._pos + 2)) {
                this._isLateForDoctype = true;
                this.tagEnd();
                continue;
            }
            if (this.startsWith("<!--")) {
                this.comment();
                continue;
            }
            if (this.startsWith("<") && this.isIdentifierStartChar(this._pos + 1)) {
                this._isLateForDoctype = true;
                this.tagStart();
                continue;
            }
            if (this.startsWith("<![")) {
                this._isLateForDoctype = true;
                while (!this.isAllRead()) {
                    this.go();
                    if (!this.isChar(']')) continue;
                    this.go();
                    if (!this.isChar('>')) continue;
                    this.go();
                    continue block0;
                }
                continue;
            }
            this.content();
        }
        this._reader.close();
    }

    private void tagStart() throws IOException {
        this.saveCurrent();
        this.go();
        if (this.isAllRead()) {
            return;
        }
        String tagName = this.identifier();
        this._currentTagToken = new TagNode(tagName);
        if (this._asExpected) {
            this.skipWhitespaces();
            this.tagAttributes();
            String originalSource = this._saved.toString();
            this.addToken(this._currentTagToken);
            if (this.isChar('>')) {
                this.go();
                if ("script".equalsIgnoreCase(tagName)) {
                    this._isScriptContext = true;
                } else if ("style".equalsIgnoreCase(tagName)) {
                    this._isStyleContext = true;
                }
                originalSource = originalSource + ">";
            } else if (this.startsWith("/>")) {
                this.go(2);
                this.addToken(new EndTagToken(tagName));
                originalSource = originalSource + "/>";
            }
            this._currentTagToken.setOriginalSource(originalSource);
            this._currentTagToken = null;
        } else {
            this.addSavedAsContent();
        }
    }

    private void tagEnd() throws IOException {
        this.saveCurrent(2);
        this.go(2);
        if (this.isAllRead()) {
            return;
        }
        String tagName = this.identifier();
        this._currentTagToken = new EndTagToken(tagName);
        if (this._asExpected) {
            this.skipWhitespaces();
            this.tagAttributes();
            String originalSource = this._saved.toString();
            this.addToken(this._currentTagToken);
            if (this.isChar('>')) {
                this.go();
                originalSource = originalSource + ">";
            }
            if ("script".equalsIgnoreCase(tagName)) {
                this._isScriptContext = false;
            } else if ("style".equalsIgnoreCase(tagName)) {
                this._isStyleContext = false;
            }
            this._currentTagToken.setOriginalSource(originalSource);
            this._currentTagToken = null;
        } else {
            this.addSavedAsContent();
        }
    }

    private String identifier() throws IOException {
        this._asExpected = true;
        if (!this.isIdentifierStartChar()) {
            this._asExpected = false;
            return null;
        }
        StringBuffer tagName = new StringBuffer(16);
        while (!this.isAllRead() && this.isIdentifierChar()) {
            this.saveCurrent();
            tagName.append(this._working[this._pos]);
            this.go();
        }
        return tagName.toString();
    }

    private void tagAttributes() throws IOException {
        while (!this.isAllRead() && this._asExpected && !this.isChar('>') && !this.startsWith("/>")) {
            this.skipWhitespaces();
            String attName = this.identifier();
            if (!this._asExpected) {
                if (!(this.isChar('<') || this.isChar('>') || this.startsWith("/>"))) {
                    this.saveCurrent();
                    this.go();
                }
                if (this.isChar('<')) continue;
                this._asExpected = true;
                continue;
            }
            String attValue = attName;
            this.skipWhitespaces();
            if (this.isChar('=')) {
                this.saveCurrent();
                this.go();
                attValue = this.attributeValue();
            }
            if (!this._asExpected) continue;
            this._currentTagToken.addAttribute(attName, attValue, false);
        }
    }

    private String attributeValue() throws IOException {
        this.skipWhitespaces();
        if (this.isChar('<') || this.isChar('>') || this.startsWith("/>")) {
            return "";
        }
        boolean isQuoteMode = false;
        boolean isAposMode = false;
        StringBuffer result = new StringBuffer();
        if (this.isChar('\'')) {
            isAposMode = true;
            this.saveCurrent();
            this.go();
        } else if (this.isChar('\"')) {
            isQuoteMode = true;
            this.saveCurrent();
            this.go();
        }
        while (!(this.isAllRead() || !(isAposMode && !this.isChar('\'') || isQuoteMode && !this.isChar('\"')) && (isAposMode || isQuoteMode || this.isWhitespace() || this.isChar('>') || this.startsWith("/>")))) {
            result.append(this._working[this._pos]);
            this.saveCurrent();
            this.go();
        }
        if (this.isChar('\'') && isAposMode) {
            this.saveCurrent();
            this.go();
        } else if (this.isChar('\"') && isQuoteMode) {
            this.saveCurrent();
            this.go();
        }
        return result.toString();
    }

    private void content() throws IOException {
        while (!this.isAllRead()) {
            this.saveCurrent();
            this.go();
            if (!this.isChar('<')) continue;
        }
        if (this._saved.length() > 0) {
            String trimmed = this._saved.toString().trim();
            if (trimmed.length() == 0) {
                this._saved.delete(0, this._saved.length());
                this._saved.append(' ');
            }
            this.addSavedAsContent();
        }
    }

    private void ignore() throws IOException {
        while (!this.isAllRead()) {
            this.go();
            if (!this.isChar('<')) continue;
            break;
        }
    }

    private void comment() throws IOException {
        this.go(4);
        while (!this.isAllRead() && !this.startsWith("-->")) {
            this.saveCurrent();
            this.go();
        }
        if (this.startsWith("-->")) {
            this.go(3);
        }
        if (this._saved.length() > 0) {
            if (!this.cleaner.isOmitComments()) {
                int len;
                String hyphenRepl = this.cleaner.getHyphenReplacementInComment();
                String comment = this._saved.toString().replaceAll("--", hyphenRepl + hyphenRepl);
                if (comment.length() > 0 && comment.charAt(0) == '-') {
                    comment = hyphenRepl + comment.substring(1);
                }
                if ((len = comment.length()) > 0 && comment.charAt(len - 1) == '-') {
                    comment = comment.substring(0, len - 1) + hyphenRepl;
                }
                this.addToken(new CommentToken(comment));
            }
            this._saved.delete(0, this._saved.length());
        }
    }

    private void doctype() throws IOException {
        this.go(9);
        this.skipWhitespaces();
        String part1 = this.identifier();
        this.skipWhitespaces();
        String part2 = this.identifier();
        this.skipWhitespaces();
        String part3 = this.attributeValue();
        this.skipWhitespaces();
        String part4 = this.attributeValue();
        this.ignore();
        DoctypeToken _docType = new DoctypeToken(part1, part2, part3, part4);
        if (_docType.isValid()) {
            this.cleaner.setDoctype(_docType);
        }
    }
}

