/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.swing;

import gnu.trove.set.hash.TLongHashSet;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Queue;
import javax.swing.AbstractAction;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import net.osmand.NativeLibrary;
import net.osmand.binary.BinaryMapIndexReader;
import net.osmand.binary.RouteDataObject;
import net.osmand.data.DataTileManager;
import net.osmand.data.LatLon;
import net.osmand.osm.edit.Entity;
import net.osmand.osm.edit.Node;
import net.osmand.osm.edit.Way;
import net.osmand.router.BinaryRoutePlanner;
import net.osmand.router.RoutePlannerFrontEnd;
import net.osmand.router.RouteSegmentResult;
import net.osmand.router.RoutingConfiguration;
import net.osmand.router.RoutingContext;
import net.osmand.swing.DataExtractionSettings;
import net.osmand.swing.MapPanel;
import net.osmand.swing.MapPanelLayer;
import net.osmand.swing.NativeSwingRendering;
import net.osmand.util.MapUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MapClusterLayer
implements MapPanelLayer {
    private static int SIZE_OF_ROUTES_TO_ANIMATE = 5;
    private Log log = LogFactory.getLog(MapClusterLayer.class);
    private MapPanel map;

    @Override
    public void destroyLayer() {
    }

    @Override
    public void initLayer(MapPanel map) {
        this.map = map;
    }

    @Override
    public void fillPopupMenuWithActions(JPopupMenu menu) {
        AbstractAction clustering = new AbstractAction("Clustering roads"){
            private static final long serialVersionUID = 444678942490247133L;

            @Override
            public void actionPerformed(ActionEvent e) {
                MapClusterLayer.this.clusteringRoadActions();
            }
        };
        menu.add(clustering);
    }

    private void clusteringRoadActions() {
        Point popupMenuPoint = this.map.getPopupMenuPoint();
        double fy = ((double)popupMenuPoint.y - this.map.getCenterPointY()) / this.map.getTileSize();
        double fx = ((double)popupMenuPoint.x - this.map.getCenterPointX()) / this.map.getTileSize();
        final double latitude = MapUtils.getLatitudeFromTile((float)this.map.getZoom(), (double)(this.map.getYTile() + fy));
        final double longitude = MapUtils.getLongitudeFromTile((double)this.map.getZoom(), (double)(this.map.getXTile() + fx));
        final ClusteringContext clusterCtx = new ClusteringContext();
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    DataTileManager points = new DataTileManager(11);
                    List<BinaryRoutePlanner.RouteSegment> ways = MapClusterLayer.this.clustering(clusterCtx, latitude, longitude, (DataTileManager<Entity>)points);
                    for (BinaryRoutePlanner.RouteSegment s : ways) {
                        int end;
                        Way w = new Way(-1L);
                        int st = s.getSegmentStart();
                        if (st <= (end = s.getSegmentStart())) continue;
                        int t = st;
                        st = end;
                        end = t;
                        for (int i = st; i <= end; ++i) {
                            Node n = new Node(MapUtils.get31LatitudeY((int)s.getRoad().getPoint31YTile(i)), MapUtils.get31LongitudeX((int)s.getRoad().getPoint31XTile(i)), -1L);
                            w.addNode(n);
                        }
                        LatLon n = w.getLatLon();
                        points.registerObject(n.getLatitude(), n.getLongitude(), (Object)w);
                    }
                    MapClusterLayer.this.map.setPoints((DataTileManager<Entity>)points);
                    MapClusterLayer.this.map.repaint();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }).start();
    }

    private List<BinaryRoutePlanner.RouteSegment> clustering(final ClusteringContext clusterCtx, double lat, double lon, final DataTileManager<Entity> points) throws IOException {
        RoutingConfiguration.RoutingMemoryLimits memoryLimit;
        ArrayList<BinaryMapIndexReader> rs = new ArrayList<BinaryMapIndexReader>();
        for (File f : new File(DataExtractionSettings.getSettings().getBinaryFilesDir()).listFiles()) {
            if (!f.getName().endsWith(".obf")) continue;
            RandomAccessFile raf = new RandomAccessFile(f, "r");
            rs.add(new BinaryMapIndexReader(raf, f));
        }
        RoutePlannerFrontEnd router = new RoutePlannerFrontEnd();
        RoutingConfiguration.Builder builder = RoutingConfiguration.getDefault();
        RoutingConfiguration config = builder.build("car", memoryLimit = new RoutingConfiguration.RoutingMemoryLimits(90, 256));
        RoutingContext ctx = router.buildRoutingContext(config, (NativeLibrary)NativeSwingRendering.getDefaultFromSettings(), rs.toArray(new BinaryMapIndexReader[rs.size()]), clusterCtx.BASEMAP_CLUSTERING ? RoutePlannerFrontEnd.RouteCalculationMode.BASE : RoutePlannerFrontEnd.RouteCalculationMode.NORMAL);
        BinaryRoutePlanner.RouteSegmentPoint st = router.findRouteSegment(lat, lon, ctx, null);
        if (st != null) {
            RouteDataObject road = st.getRoad();
            String highway = MapClusterLayer.getHighway(road);
            this.log.info((Object)("ROAD TO START " + highway + " " + road.id));
        }
        this.map.setPoints(points);
        ctx.setVisitor(new BinaryRoutePlanner.RouteSegmentVisitor(){
            private List<BinaryRoutePlanner.RouteSegment> cache = new ArrayList<BinaryRoutePlanner.RouteSegment>();

            public void visitSegment(BinaryRoutePlanner.RouteSegment s, int endSegment, boolean poll) {
                if (!clusterCtx.ANIMATE_CLUSTERING) {
                    return;
                }
                this.cache.add(s);
                if (this.cache.size() < SIZE_OF_ROUTES_TO_ANIMATE) {
                    return;
                }
                for (BinaryRoutePlanner.RouteSegment segment : this.cache) {
                    Way way = new Way(-1L);
                    for (int i = 0; i < segment.getRoad().getPointsLength(); ++i) {
                        Node n = new Node(MapUtils.get31LatitudeY((int)segment.getRoad().getPoint31YTile(i)), MapUtils.get31LongitudeX((int)segment.getRoad().getPoint31XTile(i)), -1L);
                        way.addNode(n);
                    }
                    way.putTag("color", "white");
                    LatLon n = way.getLatLon();
                    points.registerObject(n.getLatitude(), n.getLongitude(), (Object)way);
                }
                this.cache.clear();
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            MapClusterLayer.this.map.prepareImage();
                        }
                    });
                }
                catch (InterruptedException interruptedException) {
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
            }

            public void visitApproximatedSegments(List<RouteSegmentResult> segment, RoutePlannerFrontEnd.GpxPoint start, RoutePlannerFrontEnd.GpxPoint target) {
            }
        });
        List<BinaryRoutePlanner.RouteSegment> results = this.searchCluster(clusterCtx, ctx, (BinaryRoutePlanner.RouteSegment)st);
        return results;
    }

    private long calculateId(BinaryRoutePlanner.RouteSegment r) {
        return r.getRoad().getId();
    }

    private List<BinaryRoutePlanner.RouteSegment> searchCluster(ClusteringContext cCtx, RoutingContext ctx, BinaryRoutePlanner.RouteSegment st) throws IOException {
        ArrayList<BinaryRoutePlanner.RouteSegment> result = new ArrayList<BinaryRoutePlanner.RouteSegment>();
        TLongHashSet visitedIds = new TLongHashSet();
        RouteDataObject startRoad = st.getRoad();
        final int stx = startRoad.getPoint31XTile((int)st.getSegmentStart());
        final int sty = startRoad.getPoint31YTile((int)st.getSegmentStart());
        int tileX = startRoad.getPoint31XTile((int)st.getSegmentStart()) >> cCtx.zm;
        int tileY = startRoad.getPoint31YTile((int)st.getSegmentStart()) >> cCtx.zm;
        PriorityQueue<BinaryRoutePlanner.RouteSegment> queue = new PriorityQueue<BinaryRoutePlanner.RouteSegment>(50, new Comparator<BinaryRoutePlanner.RouteSegment>(){

            @Override
            public int compare(BinaryRoutePlanner.RouteSegment o1, BinaryRoutePlanner.RouteSegment o2) {
                double d1 = MapUtils.squareDist31TileMetric((int)stx, (int)sty, (int)o1.getRoad().getPoint31XTile((int)o1.getSegmentStart()), (int)o1.getRoad().getPoint31YTile((int)o1.getSegmentStart()));
                double d2 = MapUtils.squareDist31TileMetric((int)stx, (int)sty, (int)o2.getRoad().getPoint31XTile((int)o2.getSegmentStart()), (int)o2.getRoad().getPoint31YTile((int)o2.getSegmentStart()));
                return Double.compare(d1, d2);
            }
        });
        queue.add(st);
        while (!queue.isEmpty()) {
            float ratio;
            BinaryRoutePlanner.RouteSegment segment = (BinaryRoutePlanner.RouteSegment)queue.poll();
            if (visitedIds.contains(this.calculateId(segment))) continue;
            visitedIds.add(this.calculateId(segment));
            if (ctx.getVisitor() != null) {
                ctx.getVisitor().visitSegment(segment, -1, true);
            }
            ++cCtx.roadProcessed;
            if (cCtx.roadProcessed > 50 && (ratio = (float)(queue.size() + cCtx.outOfTile + cCtx.outOfDistance) / (float)cCtx.segmentsProcessed) < cCtx.minRatio) {
                cCtx.minRatio = ratio;
                cCtx.roadMinProcessed = cCtx.roadProcessed;
            }
            this.processSegment(cCtx, ctx, segment, queue, result, tileX, tileY, true);
            this.processSegment(cCtx, ctx, segment, queue, result, tileX, tileY, false);
        }
        System.out.println("Current ratio " + (float)(queue.size() + cCtx.outOfTile + cCtx.outOfDistance) / (float)cCtx.segmentsProcessed + " min ratio " + cCtx.minRatio + " min segments procesed " + cCtx.roadMinProcessed);
        String res = "Processed " + cCtx.roadProcessed + " / " + cCtx.segmentsProcessed + " and borders are " + (cCtx.outOfTile + cCtx.outOfDistance) + " out because of distance " + cCtx.outOfDistance;
        this.log.info((Object)res);
        return result;
    }

    private void addSegmentResult(List<BinaryRoutePlanner.RouteSegment> result, BinaryRoutePlanner.RouteSegment sgm, int segmentSt, int segmentEnd) {
        BinaryRoutePlanner.RouteSegment r = new BinaryRoutePlanner.RouteSegment(sgm.getRoad(), segmentSt);
        result.add(r);
    }

    private void processSegment(ClusteringContext cCtx, RoutingContext ctx, BinaryRoutePlanner.RouteSegment segment, Queue<BinaryRoutePlanner.RouteSegment> queue, List<BinaryRoutePlanner.RouteSegment> result, int tileX, int tileY, boolean direction) {
        int d = 1;
        boolean directionAllowed = true;
        int prev = segment.getSegmentStart();
        while (directionAllowed) {
            int segmentEnd = segment.getSegmentStart() + (direction ? d : -d);
            ++d;
            if (segmentEnd < 0 || segmentEnd >= segment.getRoad().getPointsLength()) {
                directionAllowed = false;
                continue;
            }
            int x = segment.getRoad().getPoint31XTile(segmentEnd);
            int y = segment.getRoad().getPoint31YTile(segmentEnd);
            int tX = x >> cCtx.zm;
            int tY = y >> cCtx.zm;
            ++cCtx.segmentsProcessed;
            if (this.notClusterAtAll(cCtx, segment.getRoad())) {
                ++cCtx.outOfTile;
                this.addSegmentResult(result, segment, prev, segmentEnd);
                return;
            }
            if (Math.abs(tX - tileX) > cCtx.LOCAL_TILE_BOUNDARIES || Math.abs(tY - tileY) > cCtx.LOCAL_TILE_BOUNDARIES) {
                ++cCtx.outOfDistance;
                this.addSegmentResult(result, segment, prev, segmentEnd);
                return;
            }
            for (BinaryRoutePlanner.RouteSegment next = ctx.loadRouteSegment(x, y, 0L); next != null; next = next.getNext()) {
                queue.add(next);
            }
            prev = segmentEnd;
        }
    }

    public boolean notClusterAtAll(ClusteringContext clusterCtx, RouteDataObject obj) {
        return false;
    }

    public boolean isMajorHighway(ClusteringContext clusterCtx, String h) {
        if (h == null) {
            return false;
        }
        if (clusterCtx.BASEMAP_CLUSTERING) {
            return h.equals("motorway") || h.equals("trunk");
        }
        return h.equals("primary") || h.equals("secondary");
    }

    @Override
    public void prepareToDraw() {
    }

    @Override
    public void paintLayer(Graphics2D g) {
    }

    @Override
    public void applySettings() {
    }

    public static String getHighway(RouteDataObject road) {
        return road.getHighway();
    }

    private class ClusteringContext {
        boolean ANIMATE_CLUSTERING = false;
        boolean BASEMAP_CLUSTERING = true;
        int ZOOM_LIMIT = this.BASEMAP_CLUSTERING ? 11 : 15;
        int LOCAL_TILE_BOUNDARIES = this.BASEMAP_CLUSTERING ? 4 : 4;
        int zm = 31 - this.ZOOM_LIMIT;
        int outOfTile = 0;
        int outOfDistance = 0;
        int roadProcessed = 0;
        int segmentsProcessed = 0;
        float minRatio = 1.0f;
        int roadMinProcessed = 0;

        private ClusteringContext() {
        }
    }
}

