/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.sparta;

import com.hp.hpl.sparta.EncodingMismatchException;
import com.hp.hpl.sparta.ParseCharStream;
import com.hp.hpl.sparta.ParseException;
import com.hp.hpl.sparta.ParseHandler;
import com.hp.hpl.sparta.ParseLog;
import com.hp.hpl.sparta.ParseSource;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;

class ParseByteStream
implements ParseSource {
    private ParseCharStream parseSource_;

    public ParseByteStream(String systemId, InputStream istream, ParseLog log, String guessedEncoding, ParseHandler handler) throws ParseException, IOException {
        if (log == null) {
            log = DEFAULT_LOG;
        }
        if (!istream.markSupported()) {
            throw new Error("Precondition violation: the InputStream passed to ParseByteStream must support mark");
        }
        istream.mark(MAXLOOKAHEAD);
        byte[] start = new byte[4];
        int n = istream.read(start);
        if (guessedEncoding == null) {
            guessedEncoding = ParseByteStream.guessEncoding(systemId, start, n, log);
        }
        try {
            istream.reset();
            InputStreamReader reader = new InputStreamReader(istream, ParseByteStream.fixEncoding(guessedEncoding));
            try {
                this.parseSource_ = new ParseCharStream(systemId, reader, log, guessedEncoding, handler);
            }
            catch (IOException e) {
                String secondGuessEncoding = "euc-jp";
                log.note("Problem reading with assumed encoding of " + guessedEncoding + " so restarting with " + secondGuessEncoding, systemId, 1);
                istream.reset();
                try {
                    reader = new InputStreamReader(istream, ParseByteStream.fixEncoding(secondGuessEncoding));
                }
                catch (UnsupportedEncodingException ee) {
                    throw new ParseException(log, systemId, 1, 0, secondGuessEncoding, "\"" + secondGuessEncoding + "\" is not a supported encoding");
                }
                this.parseSource_ = new ParseCharStream(systemId, reader, log, null, handler);
            }
        }
        catch (EncodingMismatchException e) {
            InputStreamReader reader;
            String declaredEncoding = e.getDeclaredEncoding();
            log.note("Encoding declaration of " + declaredEncoding + " is different that assumed " + guessedEncoding + " so restarting the parsing with the new encoding", systemId, 1);
            istream.reset();
            try {
                reader = new InputStreamReader(istream, ParseByteStream.fixEncoding(declaredEncoding));
            }
            catch (UnsupportedEncodingException ee) {
                throw new ParseException(log, systemId, 1, 0, declaredEncoding, "\"" + declaredEncoding + "\" is not a supported encoding");
            }
            this.parseSource_ = new ParseCharStream(systemId, reader, log, null, handler);
        }
    }

    @Override
    public String toString() {
        return this.parseSource_.toString();
    }

    @Override
    public String getSystemId() {
        return this.parseSource_.getSystemId();
    }

    @Override
    public int getLineNumber() {
        return this.parseSource_.getLineNumber();
    }

    private static String guessEncoding(String systemId, byte[] start, int n, ParseLog log) throws IOException {
        String encoding;
        if (n != 4) {
            String msg = n <= 0 ? "no characters in input" : "less than 4 characters in input: \"" + new String(start, 0, n) + "\"";
            log.error(msg, systemId, 1);
            encoding = "UTF-8";
        } else {
            encoding = ParseByteStream.equals(start, 65279) || ParseByteStream.equals(start, -131072) || ParseByteStream.equals(start, 65534) || ParseByteStream.equals(start, -16842752) || ParseByteStream.equals(start, 60) || ParseByteStream.equals(start, 0x3C000000) || ParseByteStream.equals(start, 15360) || ParseByteStream.equals(start, 0x3C0000) ? "UCS-4" : (ParseByteStream.equals(start, 3932223) ? "UTF-16BE" : (ParseByteStream.equals(start, 1006649088) ? "UTF-16LE" : (ParseByteStream.equals(start, 1010792557) ? "UTF-8" : (ParseByteStream.equals(start, 1282385812) ? "EBCDIC" : (ParseByteStream.equals(start, (short)-2) || ParseByteStream.equals(start, (short)-257) ? "UTF-16" : "UTF-8")))));
        }
        if (!encoding.equals("UTF-8")) {
            log.note("From start " + ParseByteStream.hex(start[0]) + " " + ParseByteStream.hex(start[1]) + " " + ParseByteStream.hex(start[2]) + " " + ParseByteStream.hex(start[3]) + " deduced encoding = " + encoding, systemId, 1);
        }
        return encoding;
    }

    private static String hex(byte b) {
        String s = Integer.toHexString(b);
        switch (s.length()) {
            case 1: {
                return "0" + s;
            }
            case 2: {
                return s;
            }
        }
        return s.substring(s.length() - 2);
    }

    private static boolean equals(byte[] bytes, int integer) {
        return bytes[0] == (byte)(integer >>> 24) && bytes[1] == (byte)(integer >>> 16 & 0xFF) && bytes[2] == (byte)(integer >>> 8 & 0xFF) && bytes[3] == (byte)(integer & 0xFF);
    }

    private static boolean equals(byte[] bytes, short integer) {
        return bytes[0] == (byte)(integer >>> 8) && bytes[1] == (byte)(integer & 0xFF);
    }

    private static String fixEncoding(String encoding) {
        return encoding.toLowerCase().equals("utf8") ? "UTF-8" : encoding;
    }
}

