/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.internal.handlers;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.auth.signer.AwsSignerExecutionAttribute;
import software.amazon.awssdk.awscore.AwsExecutionAttribute;
import software.amazon.awssdk.core.interceptor.Context;
import software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import software.amazon.awssdk.core.interceptor.ExecutionInterceptor;
import software.amazon.awssdk.core.interceptor.SdkExecutionAttribute;
import software.amazon.awssdk.http.SdkHttpRequest;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.s3.S3Configuration;
import software.amazon.awssdk.services.s3.internal.ConfiguredS3SdkHttpRequest;
import software.amazon.awssdk.services.s3.internal.S3EndpointUtils;

@SdkInternalApi
public final class EndpointAddressInterceptor
implements ExecutionInterceptor {
    public SdkHttpRequest modifyHttpRequest(Context.ModifyHttpRequest context, ExecutionAttributes executionAttributes) {
        ConfiguredS3SdkHttpRequest configuredRequest = S3EndpointUtils.applyEndpointConfiguration(context.httpRequest(), context.request(), (Region)executionAttributes.getAttribute(AwsExecutionAttribute.AWS_REGION), (S3Configuration)executionAttributes.getAttribute(AwsSignerExecutionAttribute.SERVICE_CONFIG), Boolean.TRUE.equals(executionAttributes.getAttribute(SdkExecutionAttribute.ENDPOINT_OVERRIDDEN)));
        configuredRequest.signingRegionModification().ifPresent(region -> executionAttributes.putAttribute(AwsSignerExecutionAttribute.SIGNING_REGION, region));
        configuredRequest.signingServiceModification().ifPresent(name -> executionAttributes.putAttribute(AwsSignerExecutionAttribute.SERVICE_SIGNING_NAME, name));
        return configuredRequest.sdkHttpRequest();
    }
}

