/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.shared.util;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.osmand.shared.util.Logger;
import net.osmand.shared.util.LoggerFactory;
import net.osmand.shared.util.StringBundle;
import net.osmand.shared.util.StringBundleWriter;
import net.osmand.shared.xml.XmlSerializer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001c\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\rH\u0014J\b\u0010\u000e\u001a\u00020\tH\u0016J\u001c\u0010\u000f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\rH\u0002R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lnet/osmand/shared/util/StringBundleXmlWriter;", "Lnet/osmand/shared/util/StringBundleWriter;", "bundle", "Lnet/osmand/shared/util/StringBundle;", "serializer", "Lnet/osmand/shared/xml/XmlSerializer;", "<init>", "(Lnet/osmand/shared/util/StringBundle;Lnet/osmand/shared/xml/XmlSerializer;)V", "writeItem", "", "name", "", "item", "Lnet/osmand/shared/util/StringBundle$Item;", "writeBundle", "writeItemImpl", "Companion", "OsmAnd-shared"})
@SourceDebugExtension(value={"SMAP\nStringBundleXmlWriter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StringBundleXmlWriter.kt\nnet/osmand/shared/util/StringBundleXmlWriter\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,85:1\n216#2,2:86\n216#2,2:88\n*S KotlinDebug\n*F\n+ 1 StringBundleXmlWriter.kt\nnet/osmand/shared/util/StringBundleXmlWriter\n*L\n69#1:86,2\n74#1:88,2\n*E\n"})
public final class StringBundleXmlWriter
extends StringBundleWriter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final XmlSerializer serializer;
    @NotNull
    private static final Logger log = LoggerFactory.INSTANCE.getLogger("StringBundleXmlWriter");

    public StringBundleXmlWriter(@NotNull StringBundle bundle, @Nullable XmlSerializer serializer2) {
        Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
        super(bundle);
        this.serializer = serializer2;
    }

    @Override
    protected void writeItem(@NotNull String name, @NotNull StringBundle.Item<?> item) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(item, (String)"item");
        if (this.serializer != null) {
            try {
                this.writeItemImpl(name, item);
            }
            catch (Exception e) {
                log.error("Error writing string bundle as xml", e);
            }
        }
    }

    @Override
    public void writeBundle() {
        if (this.serializer != null) {
            super.writeBundle();
            try {
                this.serializer.flush();
            }
            catch (Exception e) {
                log.error("Error writing string bundle as xml", e);
            }
        }
    }

    private final void writeItemImpl(String name, StringBundle.Item<?> item) {
        if (this.serializer != null) {
            switch (WhenMappings.$EnumSwitchMapping$0[item.getType().ordinal()]) {
                case 1: {
                    Intrinsics.checkNotNull(item, (String)"null cannot be cast to non-null type net.osmand.shared.util.StringBundle.StringItem");
                    StringBundle.StringItem stringItem = (StringBundle.StringItem)item;
                    if (stringItem.getValue() != null) {
                        this.serializer.attribute(null, name, (String)stringItem.getValue());
                    }
                    Object object = Unit.INSTANCE;
                    break;
                }
                case 2: {
                    Intrinsics.checkNotNull(item, (String)"null cannot be cast to non-null type net.osmand.shared.util.StringBundle.StringListItem");
                    StringBundle.StringListItem listItem = (StringBundle.StringListItem)item;
                    this.serializer.startTag(null, name);
                    List list = (List)listItem.getValue();
                    if (list != null) {
                        for (StringBundle.Item i : list) {
                            if (i.getType() != StringBundle.ItemType.STRING) continue;
                            this.writeItemImpl(i.getName(), i);
                        }
                    }
                    if (list != null) {
                        for (StringBundle.Item i : list) {
                            if (i.getType() == StringBundle.ItemType.STRING) continue;
                            this.writeItemImpl(i.getName(), i);
                        }
                    }
                    Object object = this.serializer.endTag(null, name);
                    break;
                }
                case 3: {
                    StringBundle.Item value;
                    String key;
                    Map.Entry entry;
                    Map.Entry element$iv;
                    Iterator iterator;
                    boolean $i$f$forEach;
                    Map $this$forEach$iv;
                    Intrinsics.checkNotNull(item, (String)"null cannot be cast to non-null type net.osmand.shared.util.StringBundle.StringMapItem");
                    StringBundle.StringMapItem mapItem = (StringBundle.StringMapItem)item;
                    this.serializer.startTag(null, name);
                    Map map = (Map)mapItem.getValue();
                    if (map != null) {
                        $this$forEach$iv = map;
                        $i$f$forEach = false;
                        iterator = $this$forEach$iv.entrySet().iterator();
                        while (iterator.hasNext()) {
                            entry = element$iv = iterator.next();
                            boolean bl = false;
                            key = (String)entry.getKey();
                            value = (StringBundle.Item)entry.getValue();
                            if (value.getType() != StringBundle.ItemType.STRING) continue;
                            this.writeItemImpl(key, value);
                        }
                    }
                    Map map2 = (Map)mapItem.getValue();
                    if (map2 != null) {
                        $this$forEach$iv = map2;
                        $i$f$forEach = false;
                        iterator = $this$forEach$iv.entrySet().iterator();
                        while (iterator.hasNext()) {
                            entry = element$iv = iterator.next();
                            boolean bl = false;
                            key = (String)entry.getKey();
                            value = (StringBundle.Item)entry.getValue();
                            if (value.getType() == StringBundle.ItemType.STRING) continue;
                            this.writeItemImpl(key, value);
                        }
                    }
                    Object object = this.serializer.endTag(null, name);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lnet/osmand/shared/util/StringBundleXmlWriter$Companion;", "", "<init>", "()V", "log", "Lnet/osmand/shared/util/Logger;", "OsmAnd-shared"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[StringBundle.ItemType.values().length];
            try {
                nArray[StringBundle.ItemType.STRING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StringBundle.ItemType.LIST.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StringBundle.ItemType.MAP.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

